Ext.ux.suncode.PasteSpecialWindow = function( config ) {
  var viewSize = Ext.getBody().getViewSize();

  config = Ext.apply({
    modal : true,
    autoWidth : true,
    autoHeight : true,
    title : getTranslation('Wklej specjalnie'),
    disableCloseValidation: true,
    items : [ {
      xtype : 'panel',
      frame : false,
      border: false,
      bodyCssClass: 'x-Module-container-padding',
      buttonAlign : 'center',
      ref : 'pasteSpecialPanel',
      items : [ {
        xtype: 'textarea',
        anchor: '100%',
        width : viewSize.width * 0.3,
        height: viewSize.height * 0.2,
        ref: 'pasteSpecialitem'
      } ],
      buttons : [ {
        text : getTranslation('Wklej'),
        cls : 'x-btn-text-icon',
        handler : this.pasteSpecial,
        scope : this
      } ]
    } ]
  }, config);

  Ext.ux.suncode.PasteSpecialWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.PasteSpecialWindow, Ext.Window, {
  initComponent : function() {
    Ext.ux.suncode.PasteSpecialWindow.superclass.initComponent.call(this);
  },
  pasteSpecial: function() {
    var value = this.pasteSpecialPanel.pasteSpecialitem.getValue();

    if ( Ext.isEmpty( value ) ) {
      showWarn( getTranslation( 'Wklej wartość.' ) );
      return;
    }

    try {
      var message = Ext.util.JSON.decode(value);
      var messageType = this.initialConfig.messageType;

      if (message.type !== messageType || Ext.isEmpty(message.body)) {
        showWarn(getTranslation('Niepoprawna wartość.'));
        return;
      }

      var pasteSpecialFunction = this.initialConfig.pasteSpecialFunction;
      var pasteSpecialScope = this.initialConfig.pasteSpecialScope;

      if (Ext.isFunction(pasteSpecialFunction)) {
        pasteSpecialScope = !Ext.isEmpty(pasteSpecialScope) ? pasteSpecialScope
            : window;

        pasteSpecialFunction.apply(pasteSpecialScope, [message.body]);
        this.close();
      }
    } catch ( e ) {
      logError( e );
      showWarn( getTranslation( 'Niepoprawna wartość.' ) );
    }
  }
});