/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.userconfig.builder;

import com.suncode.plugin.pwe.model.userconfig.UserConfig;
import com.suncode.plugin.pwe.web.support.dto.userconfig.UserConfigDto;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UserConfigDtoBuilder {
    private static final String DEFAULT_COLOR = "#f99b0c";
    private static final Integer DEFAULT_COMPATIBILITY_MODE = 2;
    private static final Integer DEFAULT_GRID_SIZE = 10;
    private static final String DEFAULT_XPDL_TRANSLATION_LANGUAGE = "none";

    public UserConfigDto build(UserConfig config) {
        UserConfigDto dto = new UserConfigDto();
        dto.setAdvancedView(BooleanUtils.isTrue((Boolean)config.getAdvancedView()));
        dto.setAnimationsOn(BooleanUtils.isTrue((Boolean)config.getAnimationsOn()));
        dto.setCompatibilityMode(this.resolveCompatibilityMode(config.getCompatibilityMode()));
        dto.setDistinctionColor(this.resolveColor(config.getDistinctionColor()));
        dto.setDocumentationView(BooleanUtils.isTrue((Boolean)config.getDocumentationView()));
        dto.setExperimentalView(BooleanUtils.isTrue((Boolean)config.getExperimentalView()));
        dto.setExportJs(BooleanUtils.isTrue((Boolean)config.getExportJs()));
        dto.setExportJavaCode(BooleanUtils.isTrue((Boolean)config.getExportJavaCode()));
        dto.setHoverColor(this.resolveColor(config.getHoverColor()));
        dto.setIncomingTransitionColor(this.resolveColor(config.getIncomingTransitionColor()));
        dto.setOutgoingTransitionColor(this.resolveColor(config.getOutgoingTransitionColor()));
        dto.setShowDeprecatedComponents(BooleanUtils.isTrue((Boolean)config.getShowDeprecatedComponents()));
        dto.setSnapToGrid(BooleanUtils.isTrue((Boolean)config.getSnapToGrid()));
        dto.setShowGrid(BooleanUtils.isTrue((Boolean)config.getShowGrid()));
        dto.setGridSize(this.resolveGridSize(config.getGridSize()));
        dto.setShowTooltips(BooleanUtils.isTrue((Boolean)config.getShowTooltips()));
        dto.setUseExternalClipboard(BooleanUtils.isTrue((Boolean)config.getUseExternalClipboard()));
        dto.setXpdlTranslationLanguage(this.resolveXpdlTranslationLanguage(config.getXpdlTranslationLanguage()));
        return dto;
    }

    private String resolveColor(String color) {
        if (StringUtils.isNotBlank((CharSequence)color)) {
            return color;
        }
        return DEFAULT_COLOR;
    }

    private Integer resolveCompatibilityMode(Integer compatibilityMode) {
        if (compatibilityMode != null) {
            return compatibilityMode;
        }
        return DEFAULT_COMPATIBILITY_MODE;
    }

    private Integer resolveGridSize(Integer gridSize) {
        if (gridSize != null) {
            return gridSize;
        }
        return DEFAULT_GRID_SIZE;
    }

    private String resolveXpdlTranslationLanguage(String xpdlTranslationLanguage) {
        if (StringUtils.isNotBlank((CharSequence)xpdlTranslationLanguage)) {
            return xpdlTranslationLanguage;
        }
        return DEFAULT_XPDL_TRANSLATION_LANGUAGE;
    }

    public UserConfigDto build() {
        UserConfigDto dto = new UserConfigDto();
        dto.setCompatibilityMode(DEFAULT_COMPATIBILITY_MODE);
        dto.setDistinctionColor(DEFAULT_COLOR);
        dto.setHoverColor(DEFAULT_COLOR);
        dto.setIncomingTransitionColor(DEFAULT_COLOR);
        dto.setOutgoingTransitionColor(DEFAULT_COLOR);
        dto.setShowTooltips(true);
        dto.setXpdlTranslationLanguage(DEFAULT_XPDL_TRANSLATION_LANGUAGE);
        return dto;
    }

    public UserConfig extract(String userId, UserConfigDto dto) {
        UserConfig config = new UserConfig();
        config.setAdvancedView(dto.getAdvancedView());
        config.setAnimationsOn(dto.getAnimationsOn());
        config.setCompatibilityMode(dto.getCompatibilityMode());
        config.setDistinctionColor(dto.getDistinctionColor());
        config.setDocumentationView(dto.getDocumentationView());
        config.setExperimentalView(dto.getExperimentalView());
        config.setExportJs(dto.getExportJs());
        config.setExportJavaCode(dto.getExportJavaCode());
        config.setGridSize(dto.getGridSize());
        config.setHoverColor(dto.getHoverColor());
        config.setIncomingTransitionColor(dto.getIncomingTransitionColor());
        config.setOutgoingTransitionColor(dto.getOutgoingTransitionColor());
        config.setShowDeprecatedComponents(dto.getShowDeprecatedComponents());
        config.setShowGrid(dto.getShowGrid());
        config.setShowTooltips(dto.getShowTooltips());
        config.setSnapToGrid(dto.getSnapToGrid());
        config.setUserId(userId);
        config.setXpdlTranslationLanguage(dto.getXpdlTranslationLanguage());
        return config;
    }
}

