/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.module;

import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.web.support.dto.module.ScriptDto;
import com.suncode.plugin.pwe.web.support.dto.module.builder.ScriptDtoBuilder;
import com.suncode.pwfl.web.ui.WebScripts;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ScriptService {
    private static final String PROGRAM_LIB_RESOURCES_LOCATION_PATTERN = "/resources/scripts/program/lib/*/*.js";
    private static final String ACE_RESOURCES_LOCATION_PATTERN = "/resources/scripts/program/ace/ace.js*";
    private static final String EXT_LANGUAGE_TOOLS_RESOURCES_LOCATION_PATTERN = "/resources/scripts/program/ace/ext-language_tools.js*";
    private static final String PROGRAM_MODULE_RESOURCES_LOCATION_PATTERN = "/resources/scripts/program/module/*/*.js";
    private static final String ADMINISTRATION_LIB_RESOURCES_LOCATION_PATTERN = "/resources/scripts/administration/lib/*/*.js";
    private static final String ADMINISTRATION_MODULE_RESOURCES_LOCATION_PATTERN = "/resources/scripts/administration/module/*/*.js";
    private static final String SLASH = "/";
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ScriptDtoBuilder scriptDtoBuilder;

    public List<ScriptDto> getAllForProgram() {
        ArrayList<ScriptDto> dtos = new ArrayList<ScriptDto>();
        dtos.addAll(this.getProgramLibScripts());
        dtos.addAll(this.getAceScripts());
        dtos.addAll(this.getProgramModuleScripts());
        return dtos;
    }

    public List<ScriptDto> getAllForAdministration() {
        ArrayList<ScriptDto> dtos = new ArrayList<ScriptDto>();
        dtos.addAll(this.getAdministrationLibScripts());
        dtos.addAll(this.getAdministrationModuleScripts());
        return dtos;
    }

    private List<ScriptDto> getProgramLibScripts() {
        return this.getScripts(PROGRAM_LIB_RESOURCES_LOCATION_PATTERN);
    }

    private List<ScriptDto> getAceScripts() {
        ArrayList<ScriptDto> dtos = new ArrayList<ScriptDto>();
        dtos.addAll(this.getScripts(ACE_RESOURCES_LOCATION_PATTERN));
        dtos.addAll(this.getScripts(EXT_LANGUAGE_TOOLS_RESOURCES_LOCATION_PATTERN));
        return dtos;
    }

    private List<ScriptDto> getProgramModuleScripts() {
        return this.getScripts(PROGRAM_MODULE_RESOURCES_LOCATION_PATTERN);
    }

    private List<ScriptDto> getAdministrationLibScripts() {
        return this.getScripts(ADMINISTRATION_LIB_RESOURCES_LOCATION_PATTERN);
    }

    private List<ScriptDto> getAdministrationModuleScripts() {
        return this.getScripts(ADMINISTRATION_MODULE_RESOURCES_LOCATION_PATTERN);
    }

    private List<ScriptDto> getScripts(String locationPattern) {
        Resource[] resources = this.pluginService.getResources(locationPattern);
        return this.scriptDtoBuilder.build(resources);
    }

    public ScriptDto getInjectedScript(boolean devMode) {
        String location = WebScripts.Link.fragment((String)"pwe", (boolean)devMode);
        if (StringUtils.startsWith((CharSequence)location, (CharSequence)SLASH)) {
            location = StringUtils.substringAfter((String)location, (String)SLASH);
        }
        return this.scriptDtoBuilder.build(location);
    }
}

