/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.help;

import com.suncode.plugin.pwe.util.PweUtils;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class HelpService {
    public static Logger log = Logger.getLogger(HelpService.class);
    private static final String HELP_FILES_BASE_PATH = "/help";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHelpFileBytes(String section) {
        String path = this.buildHelpFilePath(section);
        InputStream inputStream = this.getHelpFileInputStream(path);
        try {
            byte[] bytes;
            byte[] byArray = bytes = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    private String buildHelpFilePath(String section) {
        StringBuilder location = new StringBuilder();
        location.append(HELP_FILES_BASE_PATH);
        location.append("/");
        location.append(PweUtils.getLanguage());
        location.append(section);
        location.append(".pdf");
        return location.toString();
    }

    private InputStream getHelpFileInputStream(String path) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(path);
    }
}

