/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.customobject;

import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.web.support.dto.customobject.CustomObjectDto;
import com.suncode.plugin.pwe.web.support.dto.customobject.builder.CustomObjectDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.CustomObjectForm;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomObjectService {
    public static Logger log = Logger.getLogger(CustomObjectService.class);
    private static final String DEFINITION_ID = "defId";
    @Autowired
    private CustomObjectDtoBuilder customObjectDtoBuilder;

    public PageResult<CustomObjectDto> get(CustomObjectForm form, String query, int offset, int limit) {
        ArrayList<CustomObjectDto> list = new ArrayList<CustomObjectDto>();
        JSONObject allObjects = null;
        String filterKey = form.getFilterKey();
        String keyToVerify = form.getKeyToVerify();
        String valueToVerify = form.getValueToVerify();
        boolean doFiltering = StringUtils.isNotBlank((CharSequence)filterKey) && StringUtils.isNotBlank((CharSequence)query);
        try {
            allObjects = new JSONObject(form.getAllObjects());
        }
        catch (JSONException exception) {
            log.info((Object)"Brak dodatkowych obiektow");
            allObjects = new JSONObject();
        }
        Iterator<String> defIds = this.getSortedKeys(allObjects);
        while (defIds.hasNext()) {
            try {
                String defId = defIds.next();
                if (StringUtils.isBlank((CharSequence)keyToVerify)) {
                    JSONObject object = allObjects.getJSONObject(defId);
                    if (doFiltering && object.has(filterKey) && StringUtils.contains((CharSequence)object.getString(filterKey).toLowerCase(), (CharSequence)query.toLowerCase())) {
                        list.add(this.build(object, defId));
                        continue;
                    }
                    if (doFiltering) continue;
                    list.add(this.build(object, defId));
                    continue;
                }
                JSONObject obj = allObjects.getJSONObject(defId);
                if ((!StringUtils.equals((CharSequence)keyToVerify, (CharSequence)DEFINITION_ID) || !StringUtils.equals((CharSequence)defId, (CharSequence)valueToVerify)) && (!obj.has(keyToVerify) || !StringUtils.equals((CharSequence)obj.getString(keyToVerify), (CharSequence)valueToVerify))) continue;
                JSONObject object = allObjects.getJSONObject(defId);
                list.add(this.build(object, defId));
                break;
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        long total = list.size();
        if (StringUtils.isBlank((CharSequence)keyToVerify)) {
            return new PageResult<CustomObjectDto>(list.subList(offset, Math.min(list.size(), offset + limit)), total);
        }
        return new PageResult<CustomObjectDto>(list, total);
    }

    private Iterator<String> getSortedKeys(JSONObject allObjects) {
        ArrayList<String> sortedKeys = new ArrayList<String>();
        Iterator keys = allObjects.keys();
        while (keys.hasNext()) {
            sortedKeys.add((String)keys.next());
        }
        return sortedKeys.stream().sorted().iterator();
    }

    private CustomObjectDto build(JSONObject object, String defId) {
        return this.customObjectDtoBuilder.build(object, defId);
    }
}

