/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.configuration;

import com.plusmpm.util.HistoryVariable;
import com.suncode.plugin.pwe.web.support.dto.configuration.PweConfigurationDto;
import com.suncode.plugin.pwe.web.support.dto.configuration.builder.PweConfigurationDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.PweConfigurationForm;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PweConfigurationService {
    @Autowired
    private PweConfigurationDtoBuilder pweConfigurationDtoBuilder;

    public PweConfigurationDto build(String userId, PweConfigurationForm form) {
        if (this.isCurrentActivityMapMode(form)) {
            return this.buildCurrentActivityMapModeConfiguration(userId, form);
        }
        if (this.isSimulationMode(form)) {
            return this.buildSimulationModeConfiguration(userId, form);
        }
        if (this.isProcessPreviewMode(form)) {
            return this.buildProcessPreviewModeConfiguration(userId, form);
        }
        return this.buildEditionModeConfiguration();
    }

    private boolean isCurrentActivityMapMode(PweConfigurationForm form) {
        return BooleanUtils.isTrue((Boolean)form.getCurrentActivityMapMode());
    }

    private boolean isSimulationMode(PweConfigurationForm form) {
        return BooleanUtils.isTrue((Boolean)form.getSimulationMode());
    }

    private boolean isProcessPreviewMode(PweConfigurationForm form) {
        return BooleanUtils.isTrue((Boolean)form.getProcessPreviewMode());
    }

    private PweConfigurationDto buildCurrentActivityMapModeConfiguration(String userId, PweConfigurationForm form) {
        HistoryVariable[] historyVariables = HistoryVariable.getProcessHistory((String)form.getProcessId());
        return this.pweConfigurationDtoBuilder.buildForCurrentActivityMapMode(form.getProcessDefId(), form.getProcessId(), form.getActivityDefId(), historyVariables);
    }

    private PweConfigurationDto buildSimulationModeConfiguration(String userId, PweConfigurationForm form) {
        HistoryVariable[] historyVariables = HistoryVariable.getProcessHistory((String)form.getProcessId());
        return this.pweConfigurationDtoBuilder.buildForSimulationMode(form.getProcessDefId(), form.getProcessId(), historyVariables);
    }

    private PweConfigurationDto buildProcessPreviewModeConfiguration(String userId, PweConfigurationForm form) {
        return this.pweConfigurationDtoBuilder.buildForProcessPreviewMode(form.getProcessDefId());
    }

    private PweConfigurationDto buildEditionModeConfiguration() {
        return this.pweConfigurationDtoBuilder.buildForEditionMode();
    }
}

