/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.color;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.web.support.dto.color.ColorDto;
import com.suncode.plugin.pwe.web.support.dto.color.builder.ColorDtoBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ColorService {
    @Autowired
    private ColorDtoBuilder colorDtoBuilder;

    public PageResult<ColorDto> getSystemColors(String colors, String query, int offset, int limit) {
        List<String> systemColors = ColorService.getFilteredSystemColors(colors, query);
        List<String> colorsOnPage = systemColors.subList(offset, Math.min(systemColors.size(), offset + limit));
        long total = systemColors.size();
        return new PageResult<ColorDto>(this.colorDtoBuilder.build(colorsOnPage), total);
    }

    private static List<String> getFilteredSystemColors(String colors, String query) {
        List systemColors = (List)new Gson().fromJson(colors, new TypeToken<List<String>>(){}.getType());
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return systemColors.stream().filter(color -> color.contains(query)).collect(Collectors.toList());
        }
        return systemColors;
    }
}

