/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.generator.excel;

import com.suncode.plugin.pwe.util.CellData;
import com.suncode.plugin.pwe.util.FileData;
import com.suncode.plugin.pwe.util.RowData;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelGenerator {
    public Workbook generate(FileData fileData) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        CellStyle headerStyle = this.buildHeaderStyle((Workbook)workbook);
        this.fillHeaders(sheet, headerStyle, fileData.getHeader());
        this.fillRows(sheet, fileData.getRows());
        return workbook;
    }

    private CellStyle buildHeaderStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.DARK_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFont(this.buildHeaderFont(workbook));
        return style;
    }

    private Font buildHeaderFont(Workbook workbook) {
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setBold(true);
        return font;
    }

    private void fillHeaders(Sheet sheet, CellStyle style, RowData header) {
        this.fillRow(sheet, 0, style, header.getCells());
    }

    private void fillRow(Sheet sheet, int rowNo, CellStyle style, List<CellData> cells) {
        Row row = sheet.createRow(rowNo);
        int counter = 0;
        for (CellData cell : cells) {
            this.buildCell(row, counter, cell.getValue(), style);
            ++counter;
        }
    }

    private void buildCell(Row row, int columnNo, String text, CellStyle style) {
        Cell cell = row.createCell(columnNo);
        cell.setCellValue(text);
        cell.setCellStyle(style);
    }

    private void fillRows(Sheet sheet, List<RowData> rows) {
        int rowNo = 1;
        for (RowData row : rows) {
            this.fillRow(sheet, rowNo, null, row.getCells());
            ++rowNo;
        }
    }
}

