/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.object.TextPart;
import com.suncode.plugin.pwe.documentation.object.builder.IntegrationComponentParameterValueBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.workflow.component.ContextVariable;
import com.suncode.pwfl.workflow.component.declaration.FunctionDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterValue;
import com.suncode.pwfl.workflow.variable.Variable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegrationComponentParameterValuePartBuilder {
    private static final String INTEGER_FORMAT = "#,###";
    private static final String FLOAT_FORMAT = "#,###.##########";
    private static final char DECIMAL_SEPARATOR = ',';
    private static final char THOUSAND_SEPARATOR = ' ';
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private IntegrationComponentParameterValueBuilder integrationComponentParameterValueBuilder;

    public List<TextPart> build(WorkflowProcess process, List<ContextVariable<?>> contextVariables, ParameterValue value) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        if (value.getValue() != null) {
            Type type = value.getType();
            if (type.isInstance(String.class)) {
                parts.add(this.buildStringValue(value));
            } else if (type.isInstance(Integer.class)) {
                parts.add(this.buildIntegerValue(value));
            } else if (type.isInstance(Float.class)) {
                parts.add(this.buildFloatValue(value));
            } else if (type.isInstance(Boolean.class)) {
                parts.add(this.buildBooleanValue(value));
            } else if (type.isInstance(LocalDate.class)) {
                parts.add(this.buildDateValue(value));
            } else if (type.isInstance(LocalDateTime.class)) {
                parts.add(this.buildDateTimeValue(value));
            } else if (type.isInstance(Variable.class)) {
                parts.add(this.buildVariableValue(process, contextVariables, value));
            } else if (type.isInstance(FunctionCall.class)) {
                parts.addAll(this.buildFunctionValue(process, contextVariables, value));
            }
        }
        return parts;
    }

    private TextPart buildStringValue(ParameterValue value) {
        String stringValue = this.getStringValue(value);
        return this.buildBasic(stringValue);
    }

    private TextPart buildIntegerValue(ParameterValue value) {
        Number numberValue = this.getNumberValue(value);
        String formattedValue = this.buildFormattedNumberValue(numberValue, INTEGER_FORMAT);
        return this.buildBasic(formattedValue);
    }

    private TextPart buildFloatValue(ParameterValue value) {
        Number numberValue = this.getNumberValue(value);
        String formattedValue = this.buildFormattedNumberValue(numberValue, FLOAT_FORMAT);
        return this.buildBasic(formattedValue);
    }

    private String buildFormattedNumberValue(Number numberValue, String format) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(',');
        decimalFormatSymbols.setGroupingSeparator(' ');
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return decimalFormat.format(numberValue);
    }

    private TextPart buildBooleanValue(ParameterValue value) {
        Boolean booleanValue = this.getBooleanValue(value);
        String formattedValue = this.buildFormattedBooleanValue(booleanValue);
        return this.buildBasic(formattedValue);
    }

    private String buildFormattedBooleanValue(Boolean booleanValue) {
        return BooleanUtils.isTrue((Boolean)booleanValue) ? this.buildYes() : this.buildNo();
    }

    private String buildYes() {
        return this.translatorService.translateMessage(YES);
    }

    private String buildNo() {
        return this.translatorService.translateMessage(NO);
    }

    private TextPart buildDateValue(ParameterValue value) {
        LocalDate date = this.getDateValue(value);
        if (date != null) {
            return this.buildFormattedDateValue(date.toDate(), "yyyy-MM-dd");
        }
        return this.buildEmpty();
    }

    private TextPart buildDateTimeValue(ParameterValue value) {
        LocalDateTime dateTime = this.getDateTimeValue(value);
        if (dateTime != null) {
            return this.buildFormattedDateValue(dateTime.toDate(), "yyyy-MM-dd HH:mm:ss");
        }
        return this.buildEmpty();
    }

    private TextPart buildFormattedDateValue(Date date, String format) {
        String stringValue = this.formatDate(date, format);
        return this.buildBasic(stringValue);
    }

    private TextPart buildVariableValue(WorkflowProcess process, List<ContextVariable<?>> contextVariables, ParameterValue value) {
        String id = this.getStringValue(value);
        if (StringUtils.startsWith((CharSequence)id, (CharSequence)"context:")) {
            return this.buildContextVariableValue(contextVariables, id);
        }
        if (process.getDataFields().containsElement(id)) {
            DataField dataField = process.getDataField(id);
            return this.buildVariableValue(dataField);
        }
        if (process.getFormalParameters().containsElement(id)) {
            FormalParameter formalParameter = process.getFormalParameter(id);
            return this.buildVariableValue(formalParameter);
        }
        return this.buildVariableValue(id);
    }

    private TextPart buildContextVariableValue(List<ContextVariable<?>> contextVariables, String id) {
        ContextVariable<?> contextVariable = this.findContextVariable(contextVariables, id);
        if (contextVariable != null) {
            return this.buildContextVariableValue(contextVariable);
        }
        return this.buildVariableValue(id);
    }

    private ContextVariable<?> findContextVariable(List<ContextVariable<?>> contextVariables, String id) {
        if (CollectionUtils.isNotEmpty(contextVariables)) {
            for (ContextVariable<?> contextVariable : contextVariables) {
                if (!StringUtils.equals((CharSequence)id, (CharSequence)contextVariable.getId())) continue;
                return contextVariable;
            }
        }
        return null;
    }

    private TextPart buildContextVariableValue(ContextVariable<?> contextVariable) {
        TextPart part = new TextPart();
        part.setText(contextVariable.getName());
        return part;
    }

    private TextPart buildVariableValue(DataField dataField) {
        TextPart part = new TextPart();
        part.setBookmarked(true);
        part.setBookmarkName(this.buildVariableBookmarkName(dataField));
        part.setText(dataField.getName());
        return part;
    }

    private TextPart buildVariableValue(FormalParameter formalParameter) {
        TextPart part = new TextPart();
        part.setText(formalParameter.getId());
        return part;
    }

    private TextPart buildVariableValue(String id) {
        TextPart part = new TextPart();
        part.setText(id);
        return part;
    }

    private List<TextPart> buildFunctionValue(WorkflowProcess process, List<ContextVariable<?>> contextVariables, ParameterValue value) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        FunctionDeclaration functionValue = this.getFunctionValue(value);
        if (functionValue != null) {
            parts.addAll(this.buildFunctionValue(process, contextVariables, functionValue));
        }
        return parts;
    }

    private List<TextPart> buildFunctionValue(WorkflowProcess process, List<ContextVariable<?>> contextVariables, FunctionDeclaration functionValue) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        parts.add(this.buildBasic(functionValue.getName()));
        parts.add(this.buildBasic("("));
        List parameterDeclarations = functionValue.getParameters();
        if (CollectionUtils.isNotEmpty((Collection)parameterDeclarations)) {
            Counter counter = new Counter(1);
            for (ParameterDeclaration parameterDeclaration : parameterDeclarations) {
                parts.addAll(this.buildFunctionParameterValue(process, contextVariables, parameterDeclaration));
                if (counter.getCountAndIncrement() >= CollectionUtils.size((Object)parameterDeclarations)) continue;
                parts.add(this.buildBasic(","));
            }
        }
        parts.add(this.buildBasic(")"));
        return parts;
    }

    private List<TextPart> buildFunctionParameterValue(WorkflowProcess process, List<ContextVariable<?>> contextVariables, ParameterDeclaration parameterDeclaration) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        List<ParameterValue> parameterValues = this.buildParameterValues(parameterDeclaration);
        if (CollectionUtils.isNotEmpty(parameterValues)) {
            Counter counter = new Counter(1);
            for (ParameterValue parameterValue : parameterValues) {
                parts.addAll(this.build(process, contextVariables, parameterValue));
                if (counter.getCountAndIncrement() >= CollectionUtils.size(parameterValues)) continue;
                parts.add(this.buildBasic(","));
            }
        }
        return parts;
    }

    private List<ParameterValue> buildParameterValues(ParameterDeclaration parameterDeclaration) {
        return this.integrationComponentParameterValueBuilder.build(parameterDeclaration);
    }

    private String getStringValue(ParameterValue value) {
        return value.getValue() instanceof String ? (String)value.getValue() : null;
    }

    private Number getNumberValue(ParameterValue value) {
        return value.getValue() instanceof Number ? (Number)((Number)value.getValue()) : (Number)null;
    }

    private Boolean getBooleanValue(ParameterValue value) {
        return value.getValue() instanceof Boolean ? (Boolean)value.getValue() : false;
    }

    private LocalDate getDateValue(ParameterValue value) {
        return value.getValue() instanceof LocalDate ? (LocalDate)value.getValue() : null;
    }

    private LocalDateTime getDateTimeValue(ParameterValue value) {
        return value.getValue() instanceof LocalDateTime ? (LocalDateTime)value.getValue() : null;
    }

    private FunctionDeclaration getFunctionValue(ParameterValue value) {
        return value.getValue() instanceof FunctionDeclaration ? (FunctionDeclaration)value.getValue() : null;
    }

    private String formatDate(Date date, String format) {
        return PweUtils.buildFormattedDate(date, format);
    }

    private TextPart buildBasic(String text) {
        TextPart part = new TextPart();
        part.setText(text);
        return part;
    }

    private TextPart buildEmpty() {
        return this.buildBasic("");
    }

    private String buildVariableBookmarkName(DataField dataField) {
        return BookmarkNameUtils.getNameForProcessVariable(dataField.getId());
    }
}

