/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityAutomaticTransitionsPointBuilder")
public class ActivityAutomaticTransitionsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.automatictransitions";
    private static final String NEXT_ACTIVITY_EXT_ATTR_NAME = "NEXT_ACTIVITY";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        NumberedPoints points = this.buildNumberedPoints(process, activity);
        this.buildPoint(documentation, points);
    }

    private NumberedPoints buildNumberedPoints(WorkflowProcess process, Activity activity) {
        NumberedPoints points = new NumberedPoints();
        points.addPoint(this.buildNumberedPoint(process, activity));
        return points;
    }

    private NumberedPoint buildNumberedPoint(WorkflowProcess process, Activity activity) {
        NumberedPoint point = new NumberedPoint();
        point.setTitle(this.translatorService.translateMessage(POINT_TITLE));
        point.setSubPoints(this.buildSubPoints(process, activity));
        return point;
    }

    private List<ParagraphContents> buildSubPoints(WorkflowProcess process, Activity activity) {
        ArrayList<ParagraphContents> subPoints = new ArrayList<ParagraphContents>();
        ExtendedAttributes extAttrs = activity.getExtendedAttributes();
        String nextActivity = ExtAttrUtils.getExtAttrValue(extAttrs, NEXT_ACTIVITY_EXT_ATTR_NAME);
        if (StringUtils.isNotBlank((CharSequence)nextActivity)) {
            subPoints.addAll(this.buildSubPoints(process, nextActivity));
        } else {
            subPoints.addAll(this.buildSubPoints(activity));
        }
        return subPoints;
    }

    private List<ParagraphContents> buildSubPoints(WorkflowProcess process, String nextActivity) {
        ArrayList<ParagraphContents> subPoints = new ArrayList<ParagraphContents>();
        for (String activityDefId : nextActivity.split("\n")) {
            Activity activity = process.getActivity(activityDefId);
            if (activity == null) continue;
            subPoints.add(this.buildSubPoint(activity));
        }
        return subPoints;
    }

    private List<ParagraphContents> buildSubPoints(Activity activity) {
        ArrayList<ParagraphContents> subPoints = new ArrayList<ParagraphContents>();
        ArrayList transitions = activity.getNonExceptionalOutgoingTransitions();
        if (CollectionUtils.isNotEmpty((Collection)transitions)) {
            for (int i = 0; i < transitions.size(); ++i) {
                Transition transition = (Transition)transitions.get(i);
                subPoints.add(this.buildSubPoint(transition.getToActivity()));
            }
        }
        return subPoints;
    }

    private ParagraphContents buildSubPoint(Activity activity) {
        String text = activity.getName();
        String bookmarkName = this.buildBookmarkName(activity);
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private String buildBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private void buildPoint(Documentation documentation, NumberedPoints points) {
        this.subchapterBuilder.build(documentation, points);
    }
}

