Ext.ux.suncode.XpdlErrors = {
    errors: new Array(),
    reset: function() {
        clearArray( this.errors );
    },
    addError: function( error ) {
        this.errors.push( error );
    },
    hasErrors: function() {
        return !Ext.isEmpty( this.errors );
    },
    getErrors: function() {
        return this.errors;
    }
};

Ext.ux.suncode.XpdlErrorsWindow = function() {
    var config = new Object();
    var windowWidth = Ext.getBody().getViewSize().width * 0.95;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Wyeliminowane błędy w mapie pakietu' ),
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveErrors,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } ),
        items: new Ext.ux.suncode.XpdlErrorsGrid()
    }, config );

    Ext.ux.suncode.XpdlErrorsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.XpdlErrorsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.XpdlErrorsWindow.superclass.initComponent.call( this );
    },
    saveErrors: function() {
        this.xpdlErrorsGrid.saveErrors();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.XpdlErrorsGrid = function() {
    var config = new Object();

    config = Ext.apply( {
        height: 400,
        ref: 'xpdlErrorsGrid',
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        store: new Ext.data.Store( {
            data: Ext.ux.suncode.XpdlErrors.getErrors(),
            reader: new Ext.data.JsonReader( {
                fields: Ext.data.Record.create( [ {
                    name: 'object',
                    type: 'string'
                }, {
                    name: 'processDefId',
                    type: 'string'
                }, {
                    name: 'activityDefId',
                    type: 'string'
                }, {
                    name: 'descr',
                    type: 'string'
                }, {
                    name: 'correction',
                    type: 'string'
                } ] )
            } )
        } ),
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                header: getTranslation( 'Obiekt' ),
                dataIndex: 'object',
                align: 'left',
                renderer: escapeHtmlRenderer
            }, {
                header: getTranslation( 'Identyfikator definicji procesu' ),
                dataIndex: 'processDefId',
                align: 'left'
            }, {
                header: getTranslation( 'Identyfikator definicji zadania' ),
                dataIndex: 'activityDefId',
                align: 'left'
            }, {
                header: getTranslation( 'Opis błędu' ),
                dataIndex: 'descr',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                header: getTranslation( 'Korekta' ),
                dataIndex: 'correction',
                align: 'left',
                renderer: wrapColumnValue
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak błędów w mapie pakietu' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } )
    }, config );

    Ext.ux.suncode.XpdlErrorsGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.XpdlErrorsGrid, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.XpdlErrorsGrid.superclass.initComponent.call( this );
    },
    saveErrors: function() {
    	var mainPanel = Ext.getCmp( 'main_panel' );
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var cm = this.getColumnModel();
        var store = this.getStore();
        var headers = new Object();
        var errors = new Array();

        Ext.each( cm.config, function( column, index, columns ) {
            var dataIndex = cm.getDataIndex( index );
            var header = cm.getColumnHeader( index );
            headers[dataIndex] = header;
        } );

        store.each( function( record ) {
            errors.push( record.data );
        } );
        
        var form = jQuery( '<form/>', { action: 'api/xpdl/saveErrors', method:'post' } );
        form.append( jQuery( '<input>', { type: 'text', name: Suncode.getCsrfParameterName(), value: Suncode.getCsrfToken() } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'packageId', value: packageNode.attributes.packageId } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'headers', value: Ext.util.JSON.encode( headers ) } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'errors', value: Ext.util.JSON.encode( errors ) } ) );
        
        var iframe = jQuery( '#download-frame' );
        iframe.empty();
        iframe.append( form );
        
        mainPanel.setCheckSavedOnUnload( false );
        
        form.submit();
        
        var task = new Ext.util.DelayedTask( function() {
            mainPanel.setCheckSavedOnUnload( true );
        }, this );
        task.delay( 1000 );
    }
} );