Ext.ux.suncode.HelpWindow = function( config ) {
    var size = Ext.getBody().getViewSize();

    config = Ext.apply( {
        width: size.width * 0.9,
        height: size.height * 0.9,
        modal: false,
        title: getTranslation( 'Pomoc' ),
        closable: true,
        layout: 'border',
        defaults: {
            split: true
        },
        items: [ {
            xtype: 'treepanel',
            title: getTranslation( 'Spis treści' ),
            iconCls: 'x-Module-helpPanel',
            region: 'west',
            layout: 'fit',
            ref: 'contentsPanel',
            collapsible: true,
            titleCollapse: true,
            width: 350,
            useArrows: true,
            autoScroll: true,
            animate: true,
            containerScroll: true,
            frame: false,
            border: false,
            style: 'border-right-width: 1px;',
            bodyCssClass: 'x-Module-whiteBody',
            root: new Ext.tree.AsyncTreeNode( {
                section: 'pdf',
                text: getTranslation( 'Spis treści' ),
                icon: getPluginImgPath( 'contents' ),
                expanded: true,
                leaf: false,
                children: [ {
                    section: 'MainMenu',
                    text: '1. ' + getTranslation( 'Menu główne' ),
                    icon: getPluginImgPath( 'help_section' ),
                    expanded: true,
                    leaf: false,
                    children: [ {
                        section: 'FileMenu',
                        text: '1.1 ' + getTranslation( 'Menu "Plik"' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'PackageMenu',
                        text: '1.2 ' + getTranslation( 'Menu "Pakiet"' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ArchiveMenu',
                        text: '1.3 ' + getTranslation( 'Menu "Archiwum"' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'SettingsMenu',
                        text: '1.4 ' + getTranslation( 'Menu "Ustawienia"' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'HelpMenu',
                        text: '1.5 ' + getTranslation( 'Menu "Pomoc"' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    } ]
                }, {
                    section: 'Modeling',
                    text: '2. ' + getTranslation( 'Modelowanie' ),
                    icon: getPluginImgPath( 'help_section' ),
                    expanded: true,
                    leaf: false,
                    children: [ {
                        section: 'ModelingOrder',
                        text: '2.1 ' + getTranslation( 'Fazy modelowania' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ModelingRoles',
                        text: '2.2 ' + getTranslation( 'Miejsca realizacji procesu' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ModelingRoutes',
                        text: '2.3 ' + getTranslation( 'Przekierowania' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ModelingActivities',
                        text: '2.4 ' + getTranslation( 'Zadania' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ModelingTools',
                        text: '2.5 ' + getTranslation( 'Narzędzia' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ModelingSubflows',
                        text: '2.6 ' + getTranslation( 'Podprocesy' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ModelingTransitions',
                        text: '2.7 ' + getTranslation( 'Połączenia' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    } ]
                }, {
                    section: 'Process',
                    text: '3. ' + getTranslation( 'Proces' ),
                    icon: getPluginImgPath( 'help_section' ),
                    expanded: true,
                    leaf: false,
                    children: [ {
                        section: 'ProcessDefinition',
                        text: '3.1 ' + getTranslation( 'Definicja procesu' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ProcessFormalParameters',
                        text: '3.2 ' + getTranslation( 'Parametry formalne' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ProcessVariables',
                        text: '3.3 ' + getTranslation( 'Zmienne procesu' ),
                        icon: getPluginImgPath( 'help_section' ),
                        expanded: true,
                        leaf: false,
                        children: [ {
                            section: 'ProcessVariablesTypes',
                            text: '3.3.1 ' + getTranslation( 'Typy zmiennych' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessVariablesExtendedTypes',
                            text: '3.3.2 ' + getTranslation( 'Rozszerzone typy zmiennych' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessVariablesDTParams',
                            text: '3.3.3 ' + getTranslation( 'Parametry w tabeli dynamicznej' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        } ]
                    }, {
                        section: 'ProcessVariablesCollation',
                        text: '3.4 ' + getTranslation( 'Zestawienie zmiennych' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ProcessApplications',
                        text: '3.5 ' + getTranslation( 'Aplikacje' ),
                        icon: getPluginImgPath( 'help_section' ),
                        expanded: true,
                        leaf: false,
                        children: [ {
                            section: 'ProcessApplicationsUtilization',
                            text: '3.5.1 ' + getTranslation( 'Wykorzystanie' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessApplicationsTypes',
                            text: '3.5.2 ' + getTranslation( 'Typy aplikacji' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessApplicationsParameters',
                            text: '3.5.3 ' + getTranslation( 'Parametry aplikacji' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        } ]
                    }, {
                        section: 'ProcessSpecification',
                        text: '3.6 ' + getTranslation( 'Specyfikacja procesu' ),
                        icon: getPluginImgPath( 'help_section' ),
                        expanded: true,
                        leaf: false,
                        children: [ {
                            section: 'ProcessSpecificationAssumptionsAndScope',
                            text: '3.6.1 ' + getTranslation( 'Założenia i zakres wdrożenia' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessSpecificationDatabaseTables',
                            text: '3.6.2 ' + getTranslation( 'Tabele baz danych' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessSpecificationIntegrations',
                            text: '3.6.3 ' + getTranslation( 'Integracje' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessSpecificationProgrammingTasks',
                            text: '3.6.4 ' + getTranslation( 'Zadania programistyczne' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ProcessSpecificationScheduledTasks',
                            text: '3.6.5 ' + getTranslation( 'Zadania zaplanowane' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        } ]
                    } ]
                }, {
                    section: 'Activity',
                    text: '4. ' + getTranslation( 'Zadanie' ),
                    icon: getPluginImgPath( 'help_section' ),
                    expanded: true,
                    leaf: false,
                    children: [ {
                        section: 'ActivityDefinition',
                        text: '4.1 ' + getTranslation( 'Definicja zadania' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ActivityForm',
                        text: '4.2 ' + getTranslation( 'Formularz' ),
                        icon: getPluginImgPath( 'help_section' ),
                        expanded: true,
                        leaf: false,
                        children: [ {
                            section: 'ActivityFormDesign',
                            text: '4.2.1 ' + getTranslation( 'Projektowanie formularza' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityFormVariables',
                            text: '4.2.2 ' + getTranslation( 'Zmienne formularza' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityFormGrid',
                            text: '4.2.3 ' + getTranslation( 'Tabela dynamiczna' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityHttpLink',
                            text: '4.2.4 ' + getTranslation( 'Przycisk formularza' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityAcceptButton',
                            text: '4.2.5 ' + getTranslation( 'Przycisk akceptacji' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityGeneratePDFButton',
                            text: '4.2.6 ' + getTranslation( 'Przycisk generowania PDF' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityAddFileButton',
                            text: '4.2.7 ' + getTranslation( 'Przycisk podłączania pliku' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        }, {
                            section: 'ActivityBarcodePrintButton',
                            text: '4.2.8 ' + getTranslation( 'Przycisk drukowania kodu kreskowego' ),
                            icon: getPluginImgPath( 'pdf' ),
                            leaf: true
                        } ]
                    }, {
                        section: 'ActivityTransitions',
                        text: '4.3 ' + getTranslation( 'Połączenia' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ActivityApplications',
                        text: '4.4 ' + getTranslation( 'Aplikacje' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ActivityDeadlines',
                        text: '4.5 ' + getTranslation( 'Terminy ostateczne' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ActivityAcceptances',
                        text: '4.6 ' + getTranslation( 'Akceptacje' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ActivityAdditionals',
                        text: '4.7 ' + getTranslation( 'Dodatki' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    }, {
                        section: 'ActivitySpecification',
                        text: '4.8 ' + getTranslation( 'Specyfikacja zadania' ),
                        icon: getPluginImgPath( 'pdf' ),
                        leaf: true
                    } ]
                }, {
                    section: 'Hotkeys',
                    text: getTranslation( 'Skróty klawiszowe' ),
                    icon: getPluginImgPath( 'pdf' ),
                    leaf: true
                } ]
            } ),
            listeners: {
                scope: this,
                click: function( node, e ) {
                    this.showHelpPdf( node );
                }
            }
        }, {
            xtype: 'panel',
            layout: 'fit',
            region: 'center',
            ref: 'pdfPanel',
            border: false,
            bodyCssClass: 'x-Module-whiteBody',
            bodyCfg: {
                tag: 'iframe',
                src: ''
            }
        } ]

    }, config );

    Ext.ux.suncode.HelpWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.HelpWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.HelpWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function( w ) {
        var pdf = this.initialConfig.pdf;

        if ( pdf ) {
            var contentsPanel = this.contentsPanel;
            var rootNode = contentsPanel.getRootNode();
            var node = rootNode.findChild( 'section', pdf, true );
            contentsPanel.fireEvent( 'click', node );
        }
    },
    showHelpPdf: function( node ) {
        if ( node.isLeaf() ) {
            var section = node.getPath( 'section' );
            this.pdfPanel.body.dom.src = 'api/help/get?section=' + section;
        }
    }
} );