Ext.ux.suncode.GlobalMenu = function( config ) {
    var AV = Ext.getCmp( 'main_panel' ).getAdvancedView();
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
    var clickListener = {
        scope: this,
        click: this.useValue
    };
    var items = new Array();

    if ( !config.blockPackage ) {
        var submenu = new Array();
        submenu.push( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'package' ),
            text: getTranslation( 'Identyfikator' ),
            menuValue: packageNode.attributes.packageId,
            listeners: clickListener
        } );

        items.push( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'package' ),
            text: getTranslation( 'Pakiet' ),
            menu: submenu
        } );
    }

    if ( !config.blockProcesses ) {
        var submenu = new Array();

        if ( packageNode.hasChildNodes() ) {
            packageNode.eachChild( function( processNode ) {
                var processDefId = processNode.attributes.processDefId;
                var processName = processNode.attributes.processName;
                var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
                var processSubmenu = new Array();
                processSubmenu.push( {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'process' ),
                    text: getTranslation( 'Identyfikator' ),
                    menuValue: processDefId,
                    listeners: clickListener
                } );

                if ( !config.blockFormalParameters && AV ) {
                    var formalParametersSubmenu = new Array();
                    var formalParameters = processNode.attributes.formalParameters;

                    if ( !Ext.isEmpty( formalParameters ) ) {
                        for ( var i = 0; i < formalParameters.length; i++ ) {
                            var formalParameter = formalParameters[i];

                            formalParametersSubmenu.push( {
                                xtype: 'menuitem',
                                cls: 'x-btn-text-icon',
                                icon: getPluginImgPath( 'variable' ),
                                text: formalParameter.name,
                                menuValue: formalParameter.id,
                                listeners: clickListener
                            } );
                        }
                    } else {
                        formalParametersSubmenu.push( {
                            xtype: 'menuitem',
                            cls: 'x-btn-text',
                            text: getTranslation( 'Pusta lista' ),
                            disabled: true
                        } );
                    }

                    processSubmenu.push( {
                        xtype: 'menuitem',
                        cls: 'x-btn-text-icon',
                        icon: getPluginImgPath( 'variable' ),
                        text: getTranslation( 'Parametry formalne' ),
                        menu: formalParametersSubmenu
                    } );
                }

                if ( !config.blockProcessParticipants ) {
                    var participantsSubmenu = new Array();
                    var participants = processNode.attributes.participants;

                    if ( !Ext.isEmpty( participants ) ) {
                        for ( var i = 0; i < participants.length; i++ ) {
                            var participant = participants[i];

                            var icon = '';

                            switch ( participant.roleType ) {
                                case 'ROLE':
                                    icon = getPluginImgPath( 'role' );
                                    break;
                                case 'SYSTEM':
                                    icon = getPluginImgPath( 'system' );
                                    break;
                                case 'RESOURCE':
                                    icon = getPluginImgPath( 'buffer' );
                                    break;
                                default:
                                    break;
                            }

                            participantsSubmenu.push( {
                                xtype: 'menuitem',
                                cls: 'x-btn-text-icon',
                                icon: icon,
                                text: participant.roleName,
                                menuValue: participant.roleId,
                                listeners: clickListener
                            } );
                        }
                    } else {
                        participantsSubmenu.push( {
                            xtype: 'menuitem',
                            cls: 'x-btn-text',
                            text: getTranslation( 'Pusta lista' ),
                            disabled: true
                        } );
                    }

                    processSubmenu.push( {
                        xtype: 'menuitem',
                        cls: 'x-btn-text-icon',
                        icon: getPluginImgPath( 'participant' ),
                        text: getTranslation( 'Uczestnicy' ),
                        menu: participantsSubmenu
                    } );
                }

                if ( !config.blockActivities ) {
                    var activitiesSubmenu = new Array();

                    if ( processNode.hasChildNodes() ) {
                        processNode.eachChild( function( activityNode ) {
                            var icon = '';

                            switch ( activityNode.attributes.activityType ) {
                                case Ext.ux.suncode.Constants.ROUTE:
                                    icon = getPluginImgPath( 'route_small' );
                                    break;
                                case Ext.ux.suncode.Constants.ACTIVITY:
                                    icon = getPluginImgPath( 'activity_small' );
                                    break;
                                case Ext.ux.suncode.Constants.TOOL:
                                    icon = getPluginImgPath( 'tool_small' );
                                    break;
                                case Ext.ux.suncode.Constants.SUBFLOW:
                                    icon = getPluginImgPath( 'subflow_small' );
                                    break;
                                default:
                                    break;
                            }

                            activitiesSubmenu.push( {
                                xtype: 'menuitem',
                                cls: 'x-btn-text-icon',
                                icon: icon,
                                text: activityNode.attributes.activityName,
                                menuValue: activityNode.attributes.activityDefId,
                                listeners: clickListener
                            } );
                        } );
                    } else {
                        activitiesSubmenu.push( {
                            xtype: 'menuitem',
                            cls: 'x-btn-text',
                            text: getTranslation( 'Pusta lista' ),
                            disabled: true
                        } );
                    }

                    processSubmenu.push( {
                        xtype: 'menuitem',
                        cls: 'x-btn-text-icon',
                        icon: getPluginImgPath( 'activity_small' ),
                        text: getTranslation( 'Zadania' ),
                        menu: activitiesSubmenu
                    } );
                }

                if ( !config.blockProcessVariables ) {
                    var processVariablesSubmenu = new Array();
                    var variables = processNode.attributes.variables;

                    processVariablesSubmenu.push( {
                        xtype: 'menuitem',
                        cls: 'x-btn-text-icon',
                        icon: getPluginImgPath( 'table' ),
                        text: getTranslation( 'Tabela dynamiczna' ),
                        menuValue: 'variable_set_0',
                        listeners: clickListener
                    } );

                    if ( !Ext.isEmpty( variables ) ) {
                        processVariablesSubmenu.push( {
                            xtype: 'menuseparator'
                        } );

                        for ( var i = 0; i < variables.length; i++ ) {
                            var variable = variables[i];

                            processVariablesSubmenu.push( {
                                xtype: 'menuitem',
                                cls: 'x-btn-text-icon',
                                icon: getPluginImgPath( 'variable' ),
                                text: variable.name,
                                menuValue: variable.id,
                                listeners: clickListener
                            } );
                        }
                    }

                    processSubmenu.push( {
                        xtype: 'menuitem',
                        cls: 'x-btn-text-icon',
                        icon: getPluginImgPath( 'variable' ),
                        text: getTranslation( 'Zmienne procesu' ),
                        menu: processVariablesSubmenu
                    } );
                }

                submenu.push( {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'process' ),
                    text: processNameTranslation,
                    menu: processSubmenu
                } );
            } );
        } else {
            submenu.push( {
                xtype: 'menuitem',
                cls: 'x-btn-text',
                text: getTranslation( 'Pusta lista' ),
                disabled: true
            } );
        }

        items.push( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'process' ),
            text: getTranslation( 'Procesy' ),
            menu: submenu
        } );
    }

    if ( !config.blockGlobalParticipants ) {
        var submenu = new Array();
        var participants = packageNode.attributes.participants;

        if ( !Ext.isEmpty( participants ) ) {
            for ( var i = 0; i < participants.length; i++ ) {
                var participant = participants[i];

                var icon = '';

                switch ( participant.roleType ) {
                    case 'ROLE':
                        icon = getPluginImgPath( 'role' );
                        break;
                    case 'SYSTEM':
                        icon = getPluginImgPath( 'system' );
                        break;
                    case 'RESOURCE':
                        icon = getPluginImgPath( 'buffer' );
                        break;
                    default:
                        break;
                }

                submenu.push( {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: icon,
                    text: participant.roleName,
                    menuValue: participant.roleId,
                    listeners: clickListener
                } );
            }
        } else {
            submenu.push( {
                xtype: 'menuitem',
                cls: 'x-btn-text',
                text: getTranslation( 'Pusta lista' ),
                disabled: true
            } );
        }

        items.push( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'participant' ),
            text: getTranslation( 'Uczestnicy pakietowi' ),
            menu: submenu
        } );
    }

    config = Ext.apply( {
        items: items
    }, config );

    Ext.ux.suncode.GlobalMenu.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.GlobalMenu, Ext.menu.Menu, {
    initComponent: function() {
        Ext.ux.suncode.GlobalMenu.superclass.initComponent.call( this );
    },
    useValue: function( item, e ) {
        this.hide();

        var valueUser = this.initialConfig.valueUser;

        if ( valueUser && Ext.isFunction( valueUser.handleGlobalMenuValue ) ) {
            valueUser.handleGlobalMenuValue( item.menuValue );
        }
    }
} );