Ext.ux.suncode.ApplicationDefWindow = function( config ) {
    var nodeName = config.nodeName;
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var application = config.application;
    var items = new Array();

    var winTitle = application ? getTranslation( 'Definicja aplikacji' ) + ' ' + application.name : getTranslation( 'Kreator aplikacji' );

    config = Ext.apply( {
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    }, config );

    if ( config.integrationComponent ) {
    	items.push( new Ext.ux.suncode.IntegrationComponentApplicationDefPanel( config ) );
    } else {
    	switch ( nodeName ) {
        case 'package':
        case 'process':
            items.push( new Ext.ux.suncode.PackageProcessApplicationDefPanel( config ) );
            break;
        case 'activity':
            items.push( new Ext.ux.suncode.ActivityApplicationDefPanel( config ) );
            break;
        default:
            break;
    }
    }

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: winTitle,
        items: items,
        closable: true,
        shadow: false,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this,
                ref: 'saveBtn'
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this,
                ref: 'closeBtn'
            } ]
        } )
    }, config );

    Ext.ux.suncode.ApplicationDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ApplicationDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ApplicationDefWindow.superclass.initComponent.call( this );

        this.on( 'show', windowUp, this );
    },
    saveForm: function() {
        this.appDefPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.IntegrationComponentApplicationDefPanel = function( config ) {
	var application = config.application;
	var extraItems = new Array();

    if ( config.nodeName == 'process' ) {
        var processNode = config.node;
        var specification = Ext.ux.suncode.DocumentationService.getApplicationSpecification( processNode, application.id );
        
        extraItems.push( new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            description: specification.description
        } ) );
    }
	
    config = Ext.apply( {
        autoHeight: true,
        labelWidth: 250,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'appDefPanel',
        layout: 'form',
        items: [ {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Identyfikator aplikacji' ),
            anchor: '100%',
            hidden: !config.AV,
            value: application.id
        }, {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Nazwa aplikacji' ),
            anchor: '100%',
            value: application.name
        }, {
            xtype: 'fieldset',
            height: 150,
            autoWidth: true,
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                inputType: 'text',
                fieldLabel: '',
                value: application.descr,
                ref: '../descrItem'
            } ]
        }, extraItems ]
    }, config );

    Ext.ux.suncode.IntegrationComponentApplicationDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentApplicationDefPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentApplicationDefPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var application = this.initialConfig.application;
        var node = this.initialConfig.node;
        var nodeName = this.initialConfig.nodeName;

        node.updateApplicationDescription( application.id, this.descrItem.getValue() );

        if ( nodeName == 'process' ) {
            var specification = this.readSpecification();
            Ext.ux.suncode.DocumentationService.editApplicationSpecification( node, application.id, application.id, specification );
        }

        this.ownerCt.closeWindow();
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.PackageProcessApplicationDefPanel = function( config ) {
    var application = config.application;
    var idItemValue = '';
    var nameItemValue = '';
    var appTypeItemValue = '';
    var descrItemValue = '';

    var appTypesLabel = addTooltipToField( getTranslation( 'Typ aplikacji' ), null, 'ProcessApplicationsTypes' );
    var appParamsLabel = addTooltipToField( getTranslation( 'Parametry aplikacji' ), null, 'ProcessApplicationsParameters' );

    var paramsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'mode',
                type: 'string'
            }, {
                name: 'type',
                type: 'string'
            }, {
                name: 'descr',
                type: 'string'
            } ] )
        } )
    } );

    if ( application ) {
        idItemValue = application.id;
        nameItemValue = application.name;
        agentItemValue = application.agent;
        appTypeItemValue = application.appType;
        descrItemValue = application.descr;

        if ( !Ext.isEmpty( application.parameters ) ) {
            paramsStore.loadData( application.parameters );
            paramsStore.commitChanges();
        }
    }

    var modesChooser = new Ext.ux.suncode.ModesChooser( {} );
    var typesChooser = new Ext.ux.suncode.TypesChooser( {
        utilization: 'simple'
    } );

    var extraItems = new Array();

    if ( config.nodeName == 'process' ) {
        var processNode = config.node;
        var specification = application ? Ext.ux.suncode.DocumentationService.getApplicationSpecification( processNode, application.id )
                        : new Object();
        extraItems.push( new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            description: specification.description
        } ) );
    }

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        autoHeight: true,
        labelWidth: 250,
        border: false,
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'appDefPanel',
        loadAppDef: true,
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Identyfikator aplikacji' ),
            allowBlank: true,
            value: idItemValue,
            ref: 'idItem',
            hidden: !config.AV,
            idChanged: !Ext.isEmpty( application )
        } ), {
            xtype: 'textfield',
            fieldLabel: getTranslation( 'Nazwa aplikacji' ),
            anchor: '100%',
            ref: 'nameItem',
            value: nameItemValue,
            listeners: {
                blur: function( field ) {
                    if ( !application ) {
                        var appId = generateId( field.getValue() );
                        field.ownerCt.idItem.setValue( appId );
                    }
                }
            }
        }, new Ext.ux.suncode.ApplicationTypesChooser( {
            appTypeItemValue: appTypeItemValue,
            scope: this,
            fireSelect: true,
            label: appTypesLabel
        } ), {
            xtype: 'editorgrid',
            title: appParamsLabel,
            store: paramsStore,
            height: 250,
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            frame: false,
            ref: 'paramsItem',
            anchor: '100%',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true,
                    css: 'vertical-align:middle;'
                },
                columns: [ new Ext.grid.RowNumberer(), {
                    id: 'id',
                    header: getTranslation( 'Identyfikator' ),
                    dataIndex: 'id',
                    align: 'left',
                    editor: {
                        xtype: 'textfield'
                    }
                }, {
                    id: 'mode',
                    header: getTranslation( 'Tryb' ),
                    dataIndex: 'mode',
                    align: 'left',
                    editor: modesChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( modesChooser )
                }, {
                    id: 'type',
                    header: getTranslation( 'Typ' ),
                    dataIndex: 'type',
                    align: 'left',
                    editor: typesChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( typesChooser )
                }, {
                    id: 'descr',
                    header: getTranslation( 'Opis' ),
                    dataIndex: 'descr',
                    align: 'left',
                    editor: {
                        xtype: 'textarea'
                    }
                } ]
            } ),
            viewConfig: new Ext.grid.GridView( {
                forceFit: true
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            id: grid.generateId(),
                            mode: '',
                            type: '',
                            descr: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.startEditing( store.getCount() - 1, 0 );
                        grid.updateTitle();
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    cancel: false,
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz parametr do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                        grid.updateTitle();
                    }
                } ]
            } ),
            generateId: function() {
                var store = this.getStore();
                var counter = 0;
                var idx = 1;

                while ( idx != -1 ) {
                    counter++;
                    idx = store.findExact( 'id', 'fp' + counter );
                }

                return 'fp' + counter;
            },
            updateTitle: function() {
                var tbar = this.getTopToolbar();
                var txtInfo = tbar.items.first();
                var txt = '<font ><b>' + getTranslation( 'Ilość parametrów' );
                txt = txt + ': ' + this.getStore().getCount() + '</b></font>';
                txtInfo.setText( txt );
            },
            listeners: {
                afterrender: function( grid ) {
                    var tbar = grid.getTopToolbar();
                    var txt = '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość parametrów' );
                    txt = txt + ': ' + this.getStore().getCount() + '</b></font>';
                    tbar.insert( 0, txt );
                },
                afteredit: function( e ) {
                    var record = e.record;
                    if ( e.field == 'id' ) {
                        record.set( 'id', generateId( e.value ) );
                    }
                    record.commit();
                }
            }
        }, {
            xtype: 'fieldset',
            height: 150,
            autoWidth: true,
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                inputType: 'text',
                fieldLabel: '',
                value: descrItemValue,
                ref: '../descrItem'
            } ]
        }, extraItems ]
    }, config );

    Ext.ux.suncode.PackageProcessApplicationDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageProcessApplicationDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackageProcessApplicationDefPanel.superclass.initComponent.call( this );
    },
    onAppTypeSelect: function( combo, record, index ) {
        var appType = combo.getValue();
        if ( !combo.isValid() || Ext.isEmpty( appType ) ) {
            return;
        }

        var application = this.initialConfig.application;
        var agentItemValue = '';
        var modeValue = '';

        if ( application && this.loadAppDef ) {
            agentItemValue = application.realization.agent;
            modeValue = application.realization.mode;
        }

        this.removeAdditionals();
        if ( appType == 'org.enhydra.shark.toolagent.JavaClassToolAgent' || appType == 'org.enhydra.shark.toolagent.JavaClassTransToolAgent' ) {
        	var mainPanel = Ext.getCmp( 'main_panel' );
            var compatibilityMode = mainPanel.getCompatibilityMode();
        	var items = new Array();
            items.push( {
                xtype: 'textfield',
                inputType: 'text',
                flex: 1,
                value: agentItemValue,
                maskRe: /[a-zA-Z0-9._$]/
            } );
            
            if ( this.initialConfig.AV && compatibilityMode.showJavaCodeWindow( mainPanel.getExportJavaCode() ) ) {
            	items.push( {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'java_code' ),
                    tooltip: getTranslation( 'Przygotuj kod źródłowy' ),
                    handler: this.showJavaCodingWindow,
                    scope: this
                } );
            }
            
        	this.insert( 3, {
                xtype: 'compositefield',
                additional: true,
                anchor: '100%',
                ref: 'agentItem',
                fieldLabel: getTranslation( 'Ścieżka do klasy' ),
                items: items
            } );
        } else if ( appType == 'org.enhydra.shark.toolagent.SOAPToolAgent' ) {
            this.insert( 3, {
                xtype: 'compositefield',
                additional: true,
                anchor: '100%',
                ref: 'agentItem',
                fieldLabel: getTranslation( 'Lokalizacja usługi sieciowej' ),
                items: [ {
                    xtype: 'textfield',
                    inputType: 'text',
                    flex: 1,
                    value: agentItemValue
                } ]
            } );
        } else if ( appType == 'org.enhydra.shark.toolagent.JavaScriptToolAgent' ) {
            this.insert( 3, {
                xtype: 'compositefield',
                additional: true,
                anchor: '100%',
                ref: 'agentItem',
                fieldLabel: getTranslation( 'Skrypt' ),
                items: [ {
                    xtype: 'textarea',
                    inputType: 'text',
                    height: 200,
                    flex: 1,
                    value: agentItemValue
                } ]
            } );
        } else if ( appType == 'org.enhydra.shark.toolagent.RuntimeApplicationToolAgent' ) {
            this.insert( 3, {
                xtype: 'compositefield',
                additional: true,
                anchor: '100%',
                ref: 'agentItem',
                fieldLabel: getTranslation( 'Ścieżka do aplikacji' ),
                items: [ {
                    xtype: 'textfield',
                    inputType: 'text',
                    flex: 1,
                    value: agentItemValue
                } ]
            } );
            this.insert( 3, {
                xtype: 'combo',
                additional: true,
                fieldLabel: getTranslation( 'Tryb aplikacji' ),
                anchor: '100%',
                ref: 'appModeItem',
                triggerAction: 'all',
                mode: 'local',
                store: new Ext.data.ArrayStore( {
                    fields: [ 'mode', 'modeName' ],
                    data: [ [ '0', getTranslation( 'Oczekiwanie na zakończenie aplikacji' ) ],
                                    [ '1', getTranslation( 'Automatyczne zakończenie aplikacji' ) ] ]
                } ),
                valueField: 'mode',
                displayField: 'modeName',
                forceSelection: true,
                editable: false,
                value: modeValue
            } );
        }

        this.doLayout();
        this.loadAppDef = false;
    },
    removeAdditionals: function() {
        var itemsToRemove = new Array();
        var items = this.items.items;

        Ext.each( items, function( item, index, items ) {
            if ( item.additional ) {
                itemsToRemove.push( item );
            }
        } );
        Ext.each( itemsToRemove, function( item, index, items ) {
            this.remove( item );
        }, this );

        this.doLayout();
    },
    showJavaCodingWindow: function() {
        var paramsStore = this.paramsItem.getStore();
        var qualifiedName = this.agentItem.items.first().getValue();

        if ( Ext.isEmpty( qualifiedName ) ) {
            showWarn( getTranslation( 'Podaj ścieżkę do klasy.' ) );
            return;
        } else if ( paramsStore.getCount() == 0 ) {
            showWarn( getTranslation( 'Aplikacja musi posiadać przynajmniej jeden parametr.' ) );
            return;
        }

        var parameters = new Array();
        for ( var i = 0; i < paramsStore.getCount(); i++ ) {
            parameters.push( 'AppParameter arg' + i );
        }

        var win = new Ext.ux.suncode.JavaCodingWindow( {
            winTitle: getTranslation( 'Kod źródłowy aplikacji' ),
            sourceCodeType: 'JAVA_APPLICATION',
            qualifiedName: qualifiedName,
            options: {
                parameters: parameters
            }
        } );
        win.show();
    },
    saveForm: function() {
        var id = this.idItem.getValue();
        var name = this.nameItem.getValue();
        var appType = this.appTypeItem.getValue();
        var paramsStore = this.paramsItem.getStore();
        var saveToObj = this.initialConfig.saveTo;
        var appRecord = this.initialConfig.appRecord;
        var setToObj = this.initialConfig.setToObj;
        var application = this.initialConfig.application;
        var node = this.initialConfig.node;
        var nodeName = this.initialConfig.nodeName;
        var parameters = new Array();

        if ( Ext.isEmpty( id ) || Ext.isEmpty( name ) ) {
            showWarn( getTranslation( 'Podaj nazwę aplikacji.' ) );
            return;
        } else if ( Ext.isEmpty( appType ) ) {
            showWarn( getTranslation( 'Podaj typ aplikacji.' ) );
            return;
        } else if ( !application && node.findApplication( id ) ) {
            showWarn( getTranslation( 'Aplikacja już istnieje.' ) );
            return;
        } else if ( application && application.id != id && node.findApplication( id ) ) {
            showWarn( getTranslation( 'Aplikacja już istnieje.' ) );
            return;
        } else if ( paramsStore.getCount() == 0 ) {
            showWarn( getTranslation( 'Aplikacja musi posiadać przynajmniej jeden parametr.' ) );
            return;
        }

        var exists = false;
        if ( nodeName == 'package' && ( !application || application.id != id ) ) {
            node.eachChild( function( processNode ) {
                if ( processNode.findApplication( id ) ) {
                    exists = true;
                    var processDefId = processNode.attributes.processDefId;
                    var processName = processNode.attributes.processName;
                    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
                    showWarn( getTranslation( 'Aplikacja już istnieje w procesie o nazwie' ) + ' ' + processNameTranslation + '.' );
                    return false;
                }
            } );
        } else if ( nodeName == 'process' && ( !application || application.id != id ) ) {
            if ( node.parentNode.findApplication( id ) ) {
                exists = true;
                showWarn( getTranslation( 'Aplikacja już istnieje w pakiecie.' ) );
            }
        }

        if ( exists ) {
            return;
        }

        var appMode = '';
        if ( this.appModeItem ) {
            appMode = this.appModeItem.getValue();

            if ( Ext.isEmpty( appMode ) ) {
                showWarn( getTranslation( 'Podaj tryb aplikacji.' ) );
                return;
            }
        }

        var agent = this.agentItem.items.first().getValue();
        if ( Ext.isEmpty( agent ) ) {
            if ( appType == 'org.enhydra.shark.toolagent.JavaClassToolAgent' || appType == 'org.enhydra.shark.toolagent.JavaClassTransToolAgent' ) {
                showWarn( getTranslation( 'Podaj ścieżkę do klasy.' ) );
            } else if ( appType == 'org.enhydra.shark.toolagent.SOAPToolAgent' ) {
                showWarn( getTranslation( 'Podaj lokalizację usługi sieciowej.' ) );
            } else if ( appType == 'org.enhydra.shark.toolagent.JavaScriptToolAgent' ) {
                showWarn( getTranslation( 'Podaj skrypt.' ) );
            } else if ( appType == 'org.enhydra.shark.toolagent.RuntimeApplicationToolAgent' ) {
                showWarn( getTranslation( 'Podaj ścieżkę do aplikacji.' ) );
            }
            return;
        }

        for ( var i = 0; i < paramsStore.getCount(); i++ ) {
            var param = paramsStore.getAt( i );
            var paramId = param.get( 'id' );
            var mode = param.get( 'mode' );
            var type = param.get( 'type' );

            if ( Ext.isEmpty( paramId ) || Ext.isEmpty( mode ) || Ext.isEmpty( type ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie tabelę parametrów aplikacji.' ) );
                return;
            }

            parameters.push( {
                id: paramId,
                mode: mode,
                type: type,
                descr: param.get( 'descr' )
            } );
        }

        if ( saveToObj && appRecord ) {
            if ( application ) {
                appRecord.set( 'name', name );
                appRecord.set( 'appType', appType );
                appRecord.set( 'id', id );
                appRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new appRecord( {
                    id: id,
                    name: name,
                    appType: appType
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        var app = new Object();
        app = Ext.apply( {
            id: id,
            name: name,
            appType: appType,
            realization: {
                agent: agent,
                mode: appMode
            },
            parameters: parameters,
            descr: this.descrItem.getValue()
        }, app );

        if ( application ) {
            node.updateApplication( application.id, app );

            if ( nodeName == 'process' ) {
                var specification = this.readSpecification();
                Ext.ux.suncode.DocumentationService.editApplicationSpecification( node, application.id, id, specification );
            }
        } else {
            node.addApplication( app );

            if ( nodeName == 'process' ) {
                var specification = this.readSpecification();
                Ext.ux.suncode.DocumentationService.addApplicationSpecification( node, id, specification );
            }
        }

        if ( setToObj ) {
            setToObj.setValue( id );
            setToObj.fireEvent( 'select', setToObj );
        }

        this.ownerCt.closeWindow();
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.ActivityApplicationDefPanel = function( config ) {
    var application = config.application;
    var appAgent = '';
    var actualParamsItem = null;

    if ( application ) {
        var processNode = config.node.parentNode;
        var app = Ext.ux.suncode.Utils.Application.get( processNode, application.id );
        appAgent = app.realization.agent;
        
        actualParamsItem = new Ext.ux.suncode.ActivityApplicationActualParametersGrid( {
            ref: 'actualParamsPanel',
            processNode: config.node.parentNode,
            application: application
        } );
    } else {
        actualParamsItem = new Ext.ux.suncode.ActivityApplicationActualParametersGrid( {
            ref: 'actualParamsPanel',
            processNode: config.node.parentNode
        } );
    }

    config = Ext.apply( {
        labelWidth: 250,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'appDefPanel',
        layout: 'form',
        items: [ {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'nameItem',
            fieldLabel: getTranslation( 'Nazwa aplikacji' ),
            items: [ new Ext.ux.suncode.PackageProcessApplicationsChooser( {
                packageNode: config.node.parentNode.parentNode,
                processNode: config.node.parentNode,
                value: application ? application.id : '',
                listeners: {
                    scope: this,
                    select: function( combo, record, index ) {
                        var appId = combo.getValue();
                        if ( !combo.isValid() || appId == '' ) {
                            return;
                        }

                        var processNode = this.initialConfig.node.parentNode;
                        var app = Ext.ux.suncode.Utils.Application.get( processNode, appId );
                        var store = this.actualParamsPanel.getStore();
                        var a = store.recordType;
                        var params = new Array();

                        Ext.each( app.parameters, function( parameter, index, parameters ) {
                            var rec = new a( {
                                id: parameter.id,
                                mode: parameter.mode,
                                type: parameter.type
                            } );
                            params.push( rec );
                        } );

                        store.removeAll();
                        store.add( params );
                        store.commitChanges();
                        this.appTypeItem.setValue( Ext.ux.suncode.Utils.Application.translateType( app.appType ) );
                        this.appAgentItem.setFieldLabel( Ext.ux.suncode.Utils.Application.getLabelForType( app.appType ) );
                        this.appAgentItem.setValue( app.realization.agent );
                    }
                }
            } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'application_add' ),
                tooltip: getTranslation( 'Dodaj aplikację' ),
                flex: 0,
                handler: this.addNewApplication,
                scope: this
            } ]
        }, {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Typ aplikacji' ),
            anchor: '100%',
            ref: 'appTypeItem',
            value: application ? Ext.ux.suncode.Utils.Application.translateType( application.appType ) : ''
        }, {
            xtype: 'displayfield',
            fieldLabel: application ? Ext.ux.suncode.Utils.Application.getLabelForType( application.appType ) : getTranslation( 'Wykonanie' ),
            anchor: '100%',
            ref: 'appAgentItem',
            value: appAgent
        }, actualParamsItem ]
    }, config );

    Ext.ux.suncode.ActivityApplicationDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityApplicationDefPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityApplicationDefPanel.superclass.initComponent.call( this );
    },
    addNewApplication: function() {
        var appChooser = this.nameItem.items.first();
        var record = appChooser.getStore().recordType;

        var applicationDefWin = new Ext.ux.suncode.ApplicationDefWindow( {
            nodeName: 'process',
            node: this.initialConfig.node.parentNode,
            appRecord: record,
            saveTo: appChooser,
            setToObj: appChooser
        } );
        applicationDefWin.show();
    },
    saveForm: function() {
        var id = this.nameItem.items.first().getValue();
        var saveToObj = this.initialConfig.saveTo;
        var appRecord = this.initialConfig.appRecord;
        var application = this.initialConfig.application;
        var processNode = this.initialConfig.node.parentNode;
        var activityNode = this.initialConfig.node;
        var parameters = this.actualParamsPanel.getParameters();

        if ( Ext.isEmpty( id ) ) {
            showWarn( getTranslation( 'Wybierz aplikację.' ) );
            return;
        } else if ( parameters == null ) {
            return;
        }

        var appDef = processNode.findApplication( id );
        if ( !appDef ) {
            appDef = processNode.parentNode.findApplication( id );
        }

        if ( saveToObj && appRecord ) {
            if ( application ) {
                appRecord.set( 'name', appDef.name );
                appRecord.set( 'id', id );
                appRecord.set( 'appType', appDef.appType );
                appRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new appRecord( {
                    id: id,
                    name: appDef.name,
                    appType: appDef.appType
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        var app = new Object();
        app = Ext.apply( {
            id: id,
            name: appDef.name,
            appType: appDef.appType,
            parameters: parameters
        }, app );

        if ( application ) {
            activityNode.updateApplicationByIndex( this.initialConfig.index, app );
        } else {
            activityNode.addApplication( app );
        }

        this.ownerCt.closeWindow();
    },
    getCustomFormValuesAsParameter: function() {
        var values = this.actualParamsPanel.getParametersValues();

        if ( values ) {
            var parameters = new Array();
            parameters.push( {
                varId: Ext.util.JSON.encode( values )
            } );

            var processNode = this.initialConfig.node.parentNode;
            var application = this.initialConfig.application;
            var app = Ext.ux.suncode.Utils.Application.get( processNode, application.id );

            if ( parameters.length !== app.parameters.length ) {
                showWarn( getTranslation( 'Niepoprawna definicja aplikacji.' ) );
                return null;
            }

            return parameters;
        } else {
            return null;
        }
    }
} );

Ext.ux.suncode.PackageProcessApplicationsChooser = function( config ) {
    var packageApplications = config.packageNode.attributes.applications;
    var processApplications = config.processNode.attributes.applications;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'name',
                type: 'string'
            } ] )
        } )
    } );

    var rec = store.recordType;
    if ( packageApplications && packageApplications.length != 0 ) {
        Ext.each( packageApplications, function( app, index, apps ) {
            var a = new rec( {
                id: app.id,
                name: app.name
            } );
            store.add( a );
        } );

        store.commitChanges();
    }
    if ( processApplications && processApplications.length != 0 ) {
        Ext.each( processApplications, function( app, index, apps ) {
        	if ( !app.integrationComponent ) {
        		var a = new rec( {
                    id: app.id,
                    name: app.name
                } );
                store.add( a );
        	}
        } );

        store.commitChanges();
    }

    if ( store.getCount() > 0 ) {
        store.sort( 'name', 'ASC' );
    }

    var appsTpl = new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font ' + getTemplateStyle() + '><b>'
                    + getTranslation( 'Nazwa aplikacji' ) + ': ' + '</b></font><span>{name}</span></div></div>',
                    '<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '', '</tpl>' );
    appsTpl = appsTpl.compile();

    config = Ext.apply( {
        anchor: '100%',
        ref: 'packageProcessApplicationsChooser',
        triggerAction: 'all',
        mode: 'local',
        store: store,
        valueField: 'id',
        displayField: 'name',
        forceSelection: true,
        resizable: true,
        tpl: appsTpl,
        itemSelector: 'div.x-Module-comboTemplateItem',
        flex: 1,
        listeners: config.listeners
    }, config );

    Ext.ux.suncode.PackageProcessApplicationsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageProcessApplicationsChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.PackageProcessApplicationsChooser.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        this.compileTemplate();
    },
    compileTemplate: function() {
        this.initialConfig.tpl.compile();
    }
} );

Ext.ux.suncode.ActivityApplicationActualParametersGrid = function( config ) {
    var processNode = config.processNode;
    var application = config.application;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'mode',
                type: 'string'
            }, {
                name: 'type',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'varId',
                type: 'string'
            } ] )
        } )
    } );

    if ( application ) {
        var app = Ext.ux.suncode.Utils.Application.get( processNode, application.id );
        var appActualParams = new Array();
        var appParams = application.parameters;
        var processAppParams = app.parameters;

        for ( var i = 0; i < processAppParams.length; i++ ) {
            var varId = appParams[i] ? appParams[i].varId : '';

            appActualParams.push( {
                id: processAppParams[i].id,
                mode: processAppParams[i].mode,
                type: processAppParams[i].type,
                varId: varId
            } );
        }

        store.loadData( appActualParams );
        store.commitChanges();
    }

    var modesChooser = new Ext.ux.suncode.ModesChooser( {} );
    var typesChooser = new Ext.ux.suncode.TypesChooser( {
        utilization: 'simple'
    } );
    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: processNode.attributes.variables,
        formalParameters: processNode.attributes.formalParameters,
        comboForceSelection: false
    } );

    config = Ext.apply( {
        store: store,
        height: 350,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        frame: false,
        title: getTranslation( 'Parametry aplikacji' ),
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'id',
                header: getTranslation( 'Identyfikator' ),
                dataIndex: 'id',
                align: 'left',
                editable: false
            }, {
                id: 'mode',
                header: getTranslation( 'Tryb' ),
                dataIndex: 'mode',
                align: 'left',
                editable: false,
                editor: modesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( modesChooser )
            }, {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                editable: false,
                editor: typesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( typesChooser )
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'center',
                width: 50,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    metaData.attr = 'ext:qtip="' + value + '"';
                    return '<img src=\"' + getPluginImgPath( 'info' ) + '\" width="12" height="12">';
                }
            }, {
                id: 'varId',
                header: getTranslation( 'Aktualny parametr' ),
                dataIndex: 'varId',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
            scope: this,
            afteredit: this.onAfterEdit
        }
    }, config );

    Ext.ux.suncode.ActivityApplicationActualParametersGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityApplicationActualParametersGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityApplicationActualParametersGrid.superclass.initComponent.call( this );
    },
    onAfterEdit: function( e ) {
        var record = e.record;
        var processNode = this.initialConfig.processNode;
        var formalParam = processNode.findFormalParam( record.get( 'varId' ) );

        if ( formalParam && formalParam.id.toLowerCase() == 'transaction' ) {
            if ( record.get( 'mode' ) != 'IN' ) {
                showWarn( getTranslation( 'Transakcja silnika Shark musi być parametrem o trybie wejściowym.' ) );
                record.set( 'varId', e.originalValue );
            }
        }

        var store = this.getStore();
        store.commitChanges();
    },
    getParameters: function() {
        var parameters = new Array();
        var store = this.getStore();

        for ( var i = 0; i < store.getCount(); i++ ) {
            var record = store.getAt( i );
            var varId = record.get( 'varId' );

            if ( Ext.isEmpty( varId ) ) {
                showWarn( getTranslation( 'Podaj wszystkie aktualne parametry.' ) );
                return null;
            }

            parameters.push( {
                varId: varId
            } );
        }

        return parameters;
    }
} );

Ext.ux.suncode.ApplicationsPanel = function( config ) {
    var nodeName = config.nodeName;
    var node = config.node;

    var record = Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
    }, {
        name: 'translatedName',
        type: 'string'
    }, {
        name: 'description',
        type: 'string'
    }, {
        name: 'appType',
        type: 'string'
    }, {
        name: 'inactive',
        type: 'boolean'
    }, {
        name: 'id',
        type: 'string'
    }, {
        name: 'integrationComponent',
        type: 'boolean'
    } ] );

    var applicationsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: record
        } )
    } );

    var applications = node.attributes.applications;
    if ( applications && applications.length != 0 ) {
        var rec = applicationsStore.recordType;

        Ext.each( applications, function( app, index, apps ) {
        	var description = '';
        	var translatedName = '';
            
            if ( app.integrationComponent ) {
            	var categories = Ext.getCmp( 'main_panel' ).getApplicationsIntegrationComponentCategories();
                var component = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories, app.id );
                
                if ( !Ext.isEmpty( component ) ) {
                  translatedName = component.name;
                	description = component.description;
                }
            }
            
            var a = new rec( {
                name: app.name,
                translatedName: translatedName,
                appType: app.appType,
                id: app.id,
                description: this.buildDescription( description, app.customDescription ),
                integrationComponent: app.integrationComponent,
                inactive: app.inactive
            } );
            applicationsStore.add( a );
        }, this );

        applicationsStore.commitChanges();
    }

    var toolbarInfo = new Ext.Toolbar( {
        applicationsChoosen: function() {
            var grid = this.ownerCt;
            var selModel = grid.getSelectionModel();
            var apps = selModel.getSelections();
            if ( Ext.isEmpty( apps ) ) {
                showWarn( getTranslation( 'Wybierz aplikacje.' ) );
                return null;
            }
            return apps;
        }
    } );
    toolbarInfo.add( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość aplikacji' ) + ': ' + applicationsStore.getCount() + '</b></font>' );
    toolbarInfo.addFill();

    var appTypesChooser = new Ext.ux.suncode.ApplicationTypesChooser( {
    	forceSelection: false
    } );

    var addIntegrationComponentButton = new Ext.Button( {
    	cls: 'x-btn-icon',
        icon: getPluginImgPath( 'config' ),
        tooltip: getTranslation( 'Dodaj komponent integracyjny' ),
        hidden: nodeName != 'activity',
        menu: new Ext.ux.suncode.IntegrationComponentMenu( {
            categories: Ext.getCmp( 'main_panel' ).getApplicationsIntegrationComponentCategories(),
            saveFunction: function( componentDef ) {
            	var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
                    title: getTranslation( 'Parametry aplikacji' ) + ': ' + componentDef.name,
                    component: componentDef,
                    processNode: node.parentNode,
                    conditionalExecutionEnabled: Ext.ux.suncode.IntegrationComponentService
                    .isApplicationWithConditionalExecution( componentDef.id ),
                    inactiveEnabled: true,
                    errorHandlingEnabled: true,
                    systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
                    saveFunction: function( condition, values, extraConfig ) {
                    	Ext.ux.suncode.IntegrationComponentService.
                			addApplicationFromIntegrationComponent( node.parentNode, node, componentDef, condition, values, extraConfig );
                    	var store = this.getStore();
                    	var appRecord = store.recordType;
                    	store.add( new appRecord( {
                    		id: componentDef.id,
                            name: componentDef.name,
                            description: this.buildDescription( componentDef.description, extraConfig.customDescription ),
                            appType: componentDef.toolAgent,
                            integrationComponent: true
                        } ) );
                    	store.commitChanges();
                        this.updateTitle();
                    },
                    saveScope: this,
                    getComponentRegistrationFunction: function( id ) {
                    	return Ext.ux.suncode.IntegrationComponentService.getApplicationRegistration( id );
                    },
                    getComponentRegistrationScope: this
                } );
                win.show();
            },
            saveScope: this
        } )
    } );
    var addButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj aplikację' ),
        handler: function() {
            var applicationDefWin = new Ext.ux.suncode.ApplicationDefWindow( {
                nodeName: nodeName,
                node: node,
                saveTo: this,
                appRecord: record
            } );
            applicationDefWin.show();
        },
        scope: this
    } );
    var editButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj aplikację' ),
        handler: function() {
            var apps = this.ownerCt.applicationsChoosen();
            if ( !apps ) {
                return;
            }

            if ( apps.length > 1 ) {
              showWarn( getTranslation( 'Wybierz tylko jedną aplikację.' ) );
              return;
            }
            
            var application = null;
            var index = null;
            var app = apps[0];

            switch ( nodeName ) {
                case 'package':
                case 'process':
                    var appId = app.get( 'id' );
                    application = node.findApplication( appId );
                    break;
                case 'activity':
                    var store = this.ownerCt.ownerCt.getStore();
                    index = store.indexOf( app );
                    application = node.getApplicationByIndex( index );
                    break;
                default:
                    return;
            }

            var integrationComponent = app.get( 'integrationComponent' );
            if ( nodeName == 'activity' && integrationComponent ) {
            	var categories = Ext.getCmp( 'main_panel' ).getApplicationsIntegrationComponentCategories();
                var component = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories, application.id );
                		
                if ( !Ext.isEmpty( component ) ) {
                	var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
                        title: getTranslation( 'Parametry aplikacji' ) + ': ' + component.name,
                        component: component,
                        customDescription: application.customDescription,
                        creationDate: application.creationDate,
                        modificationDate: application.modificationDate,
                        condition: application.condition,
                        errorHandling: application.errorHandling,
                        inactive: application.inactive,
                        parameters: application.parameters,
                        processNode: node.parentNode,
                        conditionalExecutionEnabled: Ext.ux.suncode.IntegrationComponentService
                        .isApplicationWithConditionalExecution( component.id ),
                        inactiveEnabled: true,
                        errorHandlingEnabled: true,
                        systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
                        saveFunction: function( condition, values, extraConfig ) {
                        	node.updateApplicationByIndex( index, {
                        		id: application.id,
                                name: application.name,
                                appType: application.appType,
                                customDescription: extraConfig.customDescription,
                                modificationDate: extraConfig.modificationDate,
                                errorHandling: extraConfig.errorHandling,
                                condition: condition,
                                inactive: extraConfig.inactive,
                                parameters: values,
                                integrationComponent: true
                        	} );
                        	app.set( 'description', this.buildDescription( component.description, extraConfig.customDescription ) );
                        	app.set( 'inactive', extraConfig.inactive );
                        	app.commit();
                        },
                        saveScope: this.ownerCt.ownerCt,
                        getComponentRegistrationFunction: function( id ) {
                        	return Ext.ux.suncode.IntegrationComponentService.getApplicationRegistration( id );
                        },
                        getComponentRegistrationScope: this.ownerCt.ownerCt
                    } );
                    win.show();
                } else {
                	showWarn( getTranslation( 'Komponent nie istnieje.' ) );
                }
            } else {
            	var applicationDefWin = new Ext.ux.suncode.ApplicationDefWindow( {
                    application: application,
                    nodeName: nodeName,
                    node: node,
                    saveTo: this,
                    appRecord: app,
                    index: index,
                    integrationComponent: integrationComponent
                } );
                applicationDefWin.show();
            }
        }
    } );
    var deleteButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń aplikację' ),
        handler: function() {
            var apps = this.ownerCt.applicationsChoosen();
            if ( !apps ) {
                return;
            }

            var grid = this.ownerCt.ownerCt;

          Ext.each( apps, function( app, idx, allAppls ) {
            switch ( nodeName ) {
              case 'package':
              case 'process':

                var appId = app.get( 'id' );
                node.removeApplication( appId );
                break;
              case 'activity':
                var store = grid.getStore();
                var index = store.indexOf( app );
                application = node.removeApplicationByIndex( index );
                break;
              default:
                return;
            }

            removeRowAndMarkNext( grid, app );
            grid.updateTitle();
          }, this );
        }
    } );

    toolbarInfo.addButton( addIntegrationComponentButton );
    toolbarInfo.addButton( addButton );
    toolbarInfo.addButton( editButton );
    toolbarInfo.addButton( deleteButton );

    config = Ext.apply( {
        title: getTranslation( 'Aplikacje' ),
        store: applicationsStore,
        height: config.panelHeight,
        enableDragDrop: true,
        ddGroup: 'dd_application',
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: false,
                css: 'vertical-align:middle;'
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa aplikacji' ),
                dataIndex: 'name',
                align: 'left',
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  var translatedName = record.get( 'translatedName' );

                  if ( !Ext.isEmpty( translatedName ) ) {
                    return translatedName;
                  } else {
                    return value;
                  }
                }
            }, {
                id: 'descr',
                header: getTranslation( 'Opis' ),
                dataIndex: 'descr',
                align: 'left',
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    if ( !Ext.isEmpty( value ) ) {
                        metaData.attr = 'ext:qtip="' + value + '"';
                        return wrapColumnValue( value.ellipse( 100 ) );
                    } else {
                        return '';
                    }
                }
            }, {
                id: 'appType',
                header: getTranslation( 'Typ aplikacji' ),
                dataIndex: 'appType',
                align: 'left',
                editor: appTypesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( appTypesChooser )
            }, {
                id: 'inactive',
                header: getTranslation( 'Aktywny' ),
                dataIndex: 'inactive',
                align: 'center',
                editable: false,
                width: 60,
                hidden: nodeName !== 'activity',
                hideable: nodeName === 'activity',
                renderer: {
                  fn: function( value, metaData, record, rowIndex, colIndex, store ) {
                    return tickCrossValue( !value, metaData, record, rowIndex, colIndex, store );
                  }
                }
            }, {
                id: 'id',
                header: 'id',
                dataIndex: 'id',
                align: 'left',
                hidden: true,
                hideable: false
            }, {
                id: 'integrationComponent',
                header: 'integrationComponent',
                dataIndex: 'integrationComponent',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak aplikacji' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'name' ) + '</b>';
                }
            }
        } ),
        tbar: toolbarInfo,
        listeners: {
        	scope: this,
            render: function( grid ) {
            	if ( nodeName == 'activity' ) {
            		new Ext.dd.DropTarget( grid.container, {
                        ddGroup: 'dd_application',
                        copy: false,
                        grid: grid,
                        notifyOver: notifyOverGrid,
                        notifyDrop: function( dd, e, data ) {
                            notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                              dd.grid.onMoveApplication( sindex, dindex );
                            } );
                        }
                    } );
            	}
            },
            cellclick: this.onCellClick,
            rowdblclick: function( grid, rowIndex, e ) {
                editButton.handler.call( editButton, e );
            },
            containercontextmenu: this.onContainerContextMenu,
            rowcontextmenu: this.onRowContextMenu
        }
    }, config );

    Ext.ux.suncode.ApplicationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ApplicationsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ApplicationsPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość aplikacji' ) + ': ' + this.getStore().getCount()
                        + '</b></font>' );
    },
    onMoveApplication: function( sindex, dindex ) {
    	if ( sindex != dindex ) {
            this.initialConfig.node.moveApplication( sindex, dindex );
        }
    },
    buildDescription: function( description, customDescription ) {
		if ( !Ext.isEmpty( customDescription ) ) {
			return Ext.util.Format.htmlEncode( customDescription );
		} else {
			return Ext.util.Format.htmlEncode( description );
    	}
    },
    onCellClick: function( grid, rowIndex, columnIndex, e ) {
        var colId = grid.getColumnModel().getColumnId( columnIndex );

        if ( colId == 'inactive' ) {
        	var store = grid.getStore();
        	var rec = store.getAt( rowIndex );
        	
        	if ( rec.get( 'integrationComponent' ) ) {
        		var newInactive = !rec.get( 'inactive' );
                rec.set( 'inactive', newInactive );
                store.commitChanges();
                
                var index = store.indexOf( rec );
                var node = this.initialConfig.node;
                node.updateApplicationInactiveByIndex( index, newInactive );
        	} else {
        		showWarn( getTranslation( 'Ustawienie nie może być zmienione.' ) );
        	}
        }
    },
    onContainerContextMenu: function( grid, e ) {
      if ( this.shouldShowCopyComponentsMenu() ) {
        if ( this.initialConfig.nodeName == 'activity' ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentApplications(
              function ( applications ) {
                var menu = this.buildCopyPasteContextMenu( applications );
                showMenu( menu, e );
              }, this);
        } else {
          Ext.ux.suncode.Clipboard.getApplications( function ( applications ) {
            var menu = this.buildCopyPasteContextMenu( applications );
            showMenu (menu, e );
          }, this );
        }
      }
    },
    onRowContextMenu: function( grid, rowIndex, e ) {
      if ( this.shouldShowCopyComponentsMenu() ) {
        var selModel = this.getSelectionModel();
        selModel.selectRow( rowIndex, true );

        if ( this.initialConfig.nodeName == 'activity' ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentApplications(
              function ( applications ) {
                var menu = this.buildCopyPasteContextMenu( applications );
                showMenu( menu, e );
              }, this );
        } else {
          Ext.ux.suncode.Clipboard.getApplications( function ( applications ) {
            var menu = this.buildCopyPasteContextMenu( applications );
            showMenu( menu, e );
          }, this );
        }
      }
    },
    shouldShowCopyComponentsMenu: function() {
      var nodeName = this.initialConfig.nodeName;

      return nodeName == 'activity' || nodeName == 'process';
    },
    buildCopyPasteContextMenu: function( clipboardApplications ) {
      var selModel = this.getSelectionModel();
      var rows = selModel.getSelections();
      var items = new Array();
      items.push( {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'copy' ),
        text: getTranslation( 'Kopiuj aplikacje' ),
        disabled: Ext.isEmpty( rows ),
        listeners: {
          scope: this,
          click: this.onCopyComponents
        }
      } );
      items.push( {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej aplikacje' ),
        clipboardApplications: clipboardApplications,
        disabled: Ext.isEmpty( clipboardApplications ),
        listeners: {
          scope: this,
          click: this.onPasteComponents
        }
      } );

      if ( this.initialConfig.nodeName == 'activity' ) {
        items.push( {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'paste' ),
          text: getTranslation( 'Wklej specjalnie' ),
          listeners: {
            scope: this,
            click: this.onPasteSpecial
          }
        } );
      }

      return new Ext.menu.Menu( {
        items: items
      } );
    },
    onCopyComponents: function( menuItem, e ) {
    	  var selModel = this.getSelectionModel();
        var rows = selModel.getSelections();
        var applications = new Array();
        var doCopy = true;

        if ( this.initialConfig.nodeName == 'activity' ) {
          Ext.each( rows, function( record, index, records ) {
            if ( !record.get( 'integrationComponent' ) ) {
              doCopy = false;
              return false;
            } else {
              applications.push( this.readComponent( record ) );
            }
          }, this );

          if ( doCopy ) {
            this.executeCopyComponents( applications );
          } else {
            showWarn( getTranslation( 'Tylko komponenty integracyjne mogą być kopiowane.' ) );
          }
        } else {
          Ext.each( rows, function( record, index, records ) {
            if ( record.get( 'integrationComponent' ) ) {
              doCopy = false;
              return false;
            } else {
              applications.push( this.readApplication( record ) );
            }
          }, this );

          if ( doCopy ) {
            this.executeCopyComponents( applications );
          } else {
            showWarn( getTranslation( 'Komponenty integracyjne nie mogą być kopiowane.' ) );
          }
        }
    },
    executeCopyComponents: function( components ) {
      if ( this.initialConfig.nodeName == 'activity' ) {
        Ext.ux.suncode.Clipboard.setIntegrationComponentApplications( components );
      } else {
        Ext.ux.suncode.Clipboard.setApplications( components );
      }
    },
    onPasteComponents: function( menuItem, e ) {
      this.executePasteComponents( menuItem.clipboardApplications );
    },
    executePasteComponents: function( applications ) {
      if ( this.initialConfig.nodeName == 'activity' ) {
        var categories = Ext.getCmp( 'main_panel' ).getApplicationsIntegrationComponentCategories();
        var activityNode = this.initialConfig.node;
        var processNode = activityNode.parentNode;
        var validationResult = Ext.ux.suncode.IntegrationComponentService.validateComponentsPaste( categories, applications, processNode );

        if ( validationResult.isAnyValid() ) {
          var store = this.getStore();

          Ext.each( validationResult.getValid(), function( component, index, allComponents ) {
            var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories, component.id );
            Ext.ux.suncode.IntegrationComponentService.
            addApplicationFromIntegrationComponent( processNode, activityNode, componentDef, component.condition,
                component.parameters, {
                  customDescription: component.customDescription,
                  errorHandling: component.errorHandling,
                  inactive: component.inactive
                } );
            var appRecord = store.recordType;
            store.add( new appRecord( {
              id: componentDef.id,
              name: componentDef.name,
              appType: componentDef.toolAgent,
              integrationComponent: true,
              inactive: component.inactive
            } ) );
          } );

          store.commitChanges();
          this.updateTitle();
        }

        if ( validationResult.isAnyInvalid() ) {
          showWarn( validationResult.getInvalidMessage() );
        }
      } else {
        var node = this.initialConfig.node;
        var store = this.getStore();
        var valid = new Array();
        var duplicatedApps = new Array();
        var specificationWarnApps = new Array();

        Ext.each( applications, function( application, index, allApplications ) {
          var sameApp = node.findApplication( application.id );

          if ( !Ext.isEmpty( sameApp ) ) {
            duplicatedApps.push( application.name );
          } else {
            valid.push( application );

            if ( shouldWarnAboutSpecificationDescription( node, application.specification.description ) ) {
              specificationWarnApps.push( application.name );
            }
          }
        } );

        if ( !Ext.isEmpty( valid ) ) {
          Ext.each( valid, function( application, index, allApplications ) {
            var specification = deepObjectCopy( application.specification );
            delete application.specification;
            node.addApplication( application );
            Ext.ux.suncode.DocumentationService.addApplicationSpecification( node, application.id, specification );

            var appRecord = store.recordType;
            store.add( new appRecord( {
              id: application.id,
              name: application.name,
              descr: application.descr,
              appType: application.appType,
              integrationComponent: false
            } ) );
          } );

          store.commitChanges();
          this.updateTitle();
        }

        if ( !Ext.isEmpty( duplicatedApps ) || !Ext.isEmpty( specificationWarnApps ) ) {
          var msg = '';

          if ( !Ext.isEmpty( duplicatedApps ) ) {
            msg += getTranslation( 'Wymienione aplikacje już istnieją' );
            msg += ':';

            Ext.each( duplicatedApps, function( duplicatedApp, index, allDuplicatedApp ) {
              msg += '<br>- ';
              msg += duplicatedApp;
            } );
          }

          if ( !Ext.isEmpty( specificationWarnApps ) ) {
            if ( !Ext.isEmpty( msg ) ) {
              msg += '<br><br>';
            }

            msg += getTranslation( 'Sprawdź opisy specyfikacyjne następujących aplikacji' );
            msg += ':';

            Ext.each( specificationWarnApps, function( specificationWarnApp, index, allSpecificationWarnApps ) {
              msg += '<br>- ';
              msg += specificationWarnApp;
            } );
          }

          showWarn( msg );
        }
      }
    },
    onPasteSpecial: function() {
      var win = new Ext.ux.suncode.PasteSpecialWindow( {
        pasteSpecialFunction: function( components ) {
          this.executePasteComponents( components );
        },
        pasteSpecialScope: this,
        messageType: Ext.ux.suncode.Clipboard.integrationComponentApplicationsMessageType
      } );
      win.show();
    },
    readComponent: function( app ) {
      var store = this.getStore();
      var index = store.indexOf( app );
      var node = this.initialConfig.node;
      var application = node.getApplicationByIndex( index );

      return {
        id: application.id,
        customDescription: application.customDescription,
        condition: application.condition,
        errorHandling: application.errorHandling,
        inactive: application.inactive,
        parameters: application.parameters
      };
    },
    readApplication: function( app ) {
      var appId = app.get( 'id' );
      var node = this.initialConfig.node;
      var application = node.findApplication( appId );
      var specification = Ext.ux.suncode.DocumentationService.getApplicationSpecification( node, appId );

      return {
        id: application.id,
        name: application.name,
        appType: application.appType,
        realization: application.realization,
        parameters: application.parameters,
        descr: application.descr,
        specification: specification
      };
    }
} );