Ext.ux.suncode.UtilService = {
  DEFAULT_TYPE_ABBREVIATION: 'T',
  TYPE_ABBREVIATION_POSTFIX: '_TYPE_ABBREVIATION',
  DIVANTE_ICON_PREFIX: 'DIVANTE_ICON_',
  DIVANTE_ICON_CSS_CLASS_PREFIX: 'dvnt-icon-',
  DIVANTE_FORM_BUTTON_COLOR_CSS_CLASS_PREFIX: 'dvnt-pwe-form-button-',
  DIVANTE_DT_BUTTON_COLOR_CSS_CLASS_PREFIX: 'dvnt-pwe-dt-button-',
  getTypeAbbreviation: function( type ) {
    return getTranslation( type.toUpperCase() + this.TYPE_ABBREVIATION_POSTFIX );
  },
  resolveIconCls: function( icon ) {
    if ( !Ext.isEmpty( icon ) ) {
      return icon.replaceAll( this.DIVANTE_ICON_PREFIX, this.DIVANTE_ICON_CSS_CLASS_PREFIX );
    } else {
      return '';
    }
  },
  resolveFormButtonColor: function (item, color) {
    var itemClasses = item.el.dom.className.split(' '),
        classToRemove = itemClasses.find((itemClass) => itemClass.startsWith(this.DIVANTE_FORM_BUTTON_COLOR_CSS_CLASS_PREFIX));
    if (classToRemove)
      item.removeClass(classToRemove);
    item.addClass(this.resolveFormButtonColorCls(color));
  },
  resolveFormButtonColorCls: function (color) {
    if (!Ext.isEmpty(color)) {
      return this.DIVANTE_FORM_BUTTON_COLOR_CSS_CLASS_PREFIX + color;
    } else {
      return '';
    }
  },
  resolveDtButtonColorCls: function (color) {
    if (!Ext.isEmpty(color)) {
      return this.DIVANTE_DT_BUTTON_COLOR_CSS_CLASS_PREFIX + color;
    } else {
      return '';
    }
  }
};