Ext.ux.suncode.Menu = function(itemsConfig) {
	var config = new Object();
	var items = new Array();

	Ext.each(itemsConfig, function(item, index, itemsConfig) {
		if (item.id == 'separator') {
			items.push(new Ext.menu.Separator());
		} else {
			items.push(new Ext.ux.suncode.MenuItem(item));
		}
	});

	config = Ext.apply({
		items : items
	}, config);

	Ext.ux.suncode.Menu.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.Menu, Ext.menu.Menu, {
	initComponent : function() {
		Ext.ux.suncode.Menu.superclass.initComponent.call(this);

		this.on('afterrender', this.onAfterRender, this);
	},
	onAfterRender : function() {
		Ext.getCmp('main_panel').menus.push(this);
	}
});

Ext.ux.suncode.MenuItem = function(config) {
	if (config.submenu) {
		config = Ext.apply({
			menu : config.submenu
		}, config);
	}

	Ext.ux.suncode.MenuItem.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.MenuItem, Ext.menu.Item, {
	initComponent : function() {
		Ext.ux.suncode.MenuItem.superclass.initComponent.call(this);

		this.on('click', function() {
			if (!this.functionName) {
				return;
			}

			if (Ext.isDefined(this.functionArg)) {
				window[this.functionName](this.functionArg);
			} else {
				window[this.functionName]({});
			}
		}, this);
	}
});

Ext.ux.suncode.StandardGridView = function(config) {
	config = Ext.apply({
		forceFit : true,
		emptyText : '<bold>' + config.emptyText + '</bold>',
		columnsText : getTranslation('Kolumny'),
		sortAscText : getTranslation('Sortuj rosnąco'),
		sortDescText : getTranslation('Sortuj malejąco')
	}, config);

	Ext.ux.suncode.StandardGridView.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.StandardGridView, Ext.grid.GridView, {
	initComponent : function() {
		Ext.ux.suncode.StandardGridView.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.StandardPagingToolbar = function(config) {
	config = Ext.apply({
		firstText : getTranslation('Pierwsza strona'),
		prevText : getTranslation('Poprzednia strona'),
		nextText : getTranslation('Następna strona'),
		lastText : getTranslation('Ostatnia strona'),
		refreshText : getTranslation('Odśwież'),
		beforePageText : getTranslation('Strona'),
		afterPageText : getTranslation('z') + ' {0}',
		displayInfo : true,
		displayMsg : '<bold>' + config.contentName + ' {0} - {1} ' + getTranslation('z') + ' {2}</bold>'
	}, config);

	Ext.ux.suncode.StandardPagingToolbar.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.StandardPagingToolbar, Ext.PagingToolbar, {
	initComponent : function() {
		Ext.ux.suncode.StandardPagingToolbar.superclass.initComponent.call(this);
	}
});

Ext.util.Format.ComboBoxRenderer = function(combo) {
	return function(value) {
		var record = combo.findRecord(combo.valueField, value);
		var wrongValue = '';

		if (!Ext.isEmpty(value)) {
			wrongValue = '###';
		}

		if (combo.forceSelection) {
			return record ? record.get(combo.displayField) : wrongValue;
		} else {
			return record ? record.get(combo.displayField) : value;
		}
	};
};

Ext.ux.suncode.ModesChooser = function(config) {
	var modeItemValue = '';
	var modes = [ [ 'IN', getTranslation('Wejściowy') ], [ 'OUT', getTranslation('Wyjściowy') ],
			[ 'INOUT', getTranslation('Wejściowo/Wyjściowy') ] ];

	if (config.modeItemValue) {
		modeItemValue = config.modeItemValue;
	}

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Tryb'),
		mode : 'local',
		ref : 'modesChooser',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'mode', 'modeName' ],
			data : modes
		}),
		valueField : 'mode',
		displayField : 'modeName',
		forceSelection : true,
		editable : false,
		value : modeItemValue
	}, config);

	Ext.ux.suncode.ModesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ModesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ModesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.TypesChooser = function(config) {
	var label = getTranslation('Typ');
	var listeners = new Object();
	var typeItemValue = '';
	var types = null;
	var forbiddenTypes = config.forbiddenTypes;
	var utilization = config.utilization;

	switch (utilization) {
	case 'simple':
		types = [ [ 'STRING', getTranslation('Tekstowy') ], [ 'DATETIME', getTranslation('Data i czas') ],
				[ 'INTEGER', getTranslation('Całkowity') ], [ 'FLOAT', getTranslation('Zmiennoprzecinkowy') ],
				[ 'BOOLEAN', getTranslation('Logiczny') ] ];
		break;
	case 'extended':
		types = [ [ 'STRING', getTranslation('Tekstowy') ], [ 'TEXTAREA', getTranslation('Pole tekstowe') ],
				[ 'DATETIME', getTranslation('Data i czas') ], [ 'DATE', getTranslation('Datowy') ],
				[ 'INTEGER', getTranslation('Całkowity') ], [ 'FLOAT', getTranslation('Zmiennoprzecinkowy') ],
				[ 'BOOLEAN', getTranslation('Logiczny') ], [ 'AMOUNT', getTranslation('Kwotowy') ],
				[ 'RADIOBUTTON', getTranslation('Przycisk jednokrotnego wyboru') ],
				[ 'CHECKBOX', getTranslation('Przycisk wyboru (checkbox)') ],
				[ 'LISTBOX', getTranslation('Lista wartości') ],
				[ 'USERLIST', getTranslation('Tabela użytkowników systemu') ],
				[ 'USERLISTLISTBOX', getTranslation('Lista użytkowników systemu') ],
				[ 'ROLEUSERS', getTranslation('Filtrowana lista użytkowników o roli') ],
				[ 'ROLEUSERS_NO_FILTER', getTranslation('Lista użytkowników o roli') ],
				[ 'DATA_CHOOSER', getTranslation('Dynamiczna lista') ] ];
		break;
	case 'form':
		types = [ [ 'STRING', getTranslation('Tekstowy') ], [ 'TEXTAREA', getTranslation('Pole tekstowe') ],
				[ 'DATETIME', getTranslation('Data i czas') ], [ 'DATE', getTranslation('Datowy') ],
				[ 'INTEGER', getTranslation('Całkowity') ], [ 'FLOAT', getTranslation('Zmiennoprzecinkowy') ],
				[ 'BOOLEAN', getTranslation('Logiczny') ], [ 'AMOUNT', getTranslation('Kwotowy') ],
				[ 'RADIOBUTTON', getTranslation('Przycisk jednokrotnego wyboru') ],
				[ 'CHECKBOX', getTranslation('Przycisk wyboru (checkbox)') ],
				[ 'LISTBOX', getTranslation('Filtrowana lista wartości') ],
				[ 'LISTBOX_EDIT', getTranslation('Edytowalna filtrowana lista wartości') ],
				[ 'LISTBOX_NO_FILTER', getTranslation('Lista wartości') ],
				[ 'LISTBOX_EDIT_NO_FILTER', getTranslation('Edytowalna lista wartości') ],
				[ 'LISTBOX_NO_LAZY', getTranslation('Zainicjowana filtrowana lista wartości') ],
				[ 'LISTBOX_NO_FILTER_NO_LAZY', getTranslation('Zainicjowana lista wartości') ],
				[ 'USERLIST', getTranslation('Tabela użytkowników systemu') ],
				[ 'USERLISTLISTBOX', getTranslation('Lista użytkowników systemu') ],
				[ 'ROLEUSERS', getTranslation('Filtrowana lista użytkowników o roli') ],
				[ 'ROLEUSERS_NO_FILTER', getTranslation('Lista użytkowników o roli') ],
				[ 'DATA_CHOOSER', getTranslation('Dynamiczna lista') ],
				[ 'VARIABLE_SET', getTranslation('Tabela dynamiczna') ] ];
		break;
	case 'httpLink':
		types = [ [ 'UrlLink', getTranslation('URL') ], [ 'JavaScriptLink', getTranslation('Funkcja JavaScript') ],
				[ 'ActionLink', getTranslation('Link do akcji') ], [ 'WindowConf', getTranslation('Konfigurowalne okno') ],
				[ 'Actions', getTranslation('Akcje / Zdarzenia') ] ];
		break;
	default:
		break;
	}

	if (config.label) {
		label = config.label;
	}
	if (config.typeItemValue) {
		typeItemValue = config.typeItemValue;
		
		if ( utilization === 'extended' &&
				( typeItemValue == 'LISTBOX_EDIT'
					|| typeItemValue == 'LISTBOX_NO_FILTER'
					|| typeItemValue == 'LISTBOX_EDIT_NO_FILTER'
					|| typeItemValue == 'LISTBOX_NO_LAZY'
					|| typeItemValue == 'LISTBOX_NO_FILTER_NO_LAZY' ) ) {
			typeItemValue = 'LISTBOX';
		}
	}
	if (config.listeners) {
		listeners = config.listeners;
	}
	if (!Ext.isEmpty(forbiddenTypes)) {
		types = types.filter(function(item, pos) {
			return forbiddenTypes.indexOf(item[0]) == -1;
		});
	}

	var store = new Ext.data.ArrayStore({
		fields : [ 'type', 'typeName' ],
		data : types
	});
	store.sort('typeName', 'ASC');

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : label,
		mode : 'local',
		ref : 'typeItem',
		anchor : '100%',
		store : store,
		valueField : 'type',
		displayField : 'typeName',
		forceSelection : true,
		resizable : true,
		maxHeight : 400,
		value : typeItemValue,
		listeners : listeners
	}, config);

	Ext.ux.suncode.TypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.TypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.TypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.RoleTypesChooser = function(config) {
	var typeItemValue = '';
	var simpleTypes = [ [ 'ROLE', getTranslation('Użytkownik') ], [ 'SYSTEM', getTranslation('System') ],
			[ 'RESOURCE', getTranslation('Bufor') ] ];

	if (config.typeItemValue) {
		typeItemValue = config.typeItemValue;
	}

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Typ uczestnika'),
		mode : 'local',
		ref : 'typeItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'type', 'typeName' ],
			data : simpleTypes
		}),
		valueField : 'type',
		displayField : 'typeName',
		forceSelection : true,
		editable : false,
		value : typeItemValue
	}, config);

	Ext.ux.suncode.RoleTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.RoleTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.RoleTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.ApplicationTypesChooser = function(config) {
	var appTypeItemValue = '';
	var chooserScope = this;
	var appTypeLabel = getTranslation('Typ aplikacji');
  var mainPanel = Ext.getCmp( 'main_panel' );
  var compatibilityMode = mainPanel.getCompatibilityMode();

	var appTypes = new Array();
  appTypes.push( [ 'org.enhydra.shark.toolagent.JavaScriptToolAgent', getTranslation('Aplikacja JavaScript'), false ] );
  appTypes.push( [ 'org.enhydra.shark.toolagent.JavaClassToolAgent', getTranslation('Aplikacja Java'), false ] );
  appTypes.push( [ 'org.enhydra.shark.toolagent.JavaClassTransToolAgent', getTranslation('Aplikacja Java z transakcją'), false ] );
  appTypes.push( [ 'org.enhydra.shark.toolagent.RuntimeApplicationToolAgent', getTranslation('Aplikacja systemowa'), false ] );

  if ( compatibilityMode.showWebServiceApplicationType( config.appTypeItemValue ) ) {
    appTypes.push( [ 'org.enhydra.shark.toolagent.SOAPToolAgent', getTranslation('Aplikacja WebService'), true ] );
  }

	if (config.appTypeItemValue) {
		appTypeItemValue = config.appTypeItemValue;
	}
	if (config.scope) {
		chooserScope = config.scope;
	}
	if (config.label) {
		appTypeLabel = config.label;
	}

  var appTypeTpl = new Ext.XTemplate('<tpl for=".">', '<div class="x-combo-list-item">',
      '<tpl if="isDeprecated === true">', '<div><span class="x-Module-warning">'
      + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>', '</tpl>',
      '<span>{appTypeName}</span></div>', '<tpl if="isDeprecated === true">',
      '</div>', '</tpl>', '</tpl>');
  appTypeTpl = appTypeTpl.compile();

	config = Ext.apply({
		fieldLabel : appTypeLabel,
		anchor : '100%',
		ref : 'appTypeItem',
		triggerAction : 'all',
		mode : 'local',
		store : new Ext.data.ArrayStore({
			fields : [ 'appType', 'appTypeName', 'isDeprecated' ],
			data : appTypes
		}),
		valueField : 'appType',
		displayField : 'appTypeName',
		forceSelection : true,
		editable : false,
    itemSelector : 'div.x-combo-list-item',
    tpl : appTypeTpl,
		value : appTypeItemValue,
		listeners : {
			scope : chooserScope,
			afterrender : function(combo) {
				combo.fireEvent('select', combo);
			},
			select : function(combo, record, index) {
				if (config.fireSelect) {
					this.onAppTypeSelect(combo, record, index);
				}
			}
		}
	}, config);

	Ext.ux.suncode.ApplicationTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ApplicationTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ApplicationTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.ValuesChooser = function(config) {
	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Wartość'),
		mode : 'local',
		ref : 'valuesChooser',
		anchor : '100%',
		store : new Ext.data.Store({
			data : !Ext.isEmpty(config.values) ? config.values : [],
			reader : new Ext.data.JsonReader({
				fields : Ext.data.Record.create([ {
					name : 'value'
				} ])
			})
		}),
		valueField : 'value',
		displayField : 'value',
		forceSelection : false
	}, config);

	Ext.ux.suncode.ValuesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ValuesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ValuesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.SystemIconsChooser = function(config) {
	config = config ? config : new Object();
	var record = Ext.data.Record.create([ {
		name : 'name',
		type : 'string'
	}, {
    name : 'cls',
    type : 'string'
  }, {
    name : 'icon',
    type : 'string'
  } ]);

	var store = new Ext.data.JsonStore({
		proxy : new Ext.data.HttpProxy({
			method : 'GET',
			url : 'api/icon/getSystemIcons',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
		}),
		reader : new Ext.data.JsonReader({
			fields : record
		}),
		autoDestroy : true,
		batch : true,
		fields : record,
		root : 'data',
		baseParams : {
			start : 0,
			limit : 20
		}
	});

	var iconsTpl = new Ext.XTemplate('<tpl for=".">', '<div class="x-Module-comboTemplateItem">',
      '<div><span class="{cls}">'
      + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><span>{name}</span></div></div>',
			'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>');
	iconsTpl = iconsTpl.compile();

	config = Ext.apply({
		ref : 'iconsChooser',
		displayField : 'name',
		valueField : 'icon',
		store : store,
		fieldLabel : getTranslation('Ikona'),
		mode : 'remote',
		triggerAction : 'all',
		minChars : 0,
		pageSize : 20,
		lazyInit : false,
		itemSelector : 'div.x-Module-comboTemplateItem',
		tpl : iconsTpl,
		anchor : '100%',
		resizable : true,
    value: config.icon,
		listeners : {
			afterrender : function(c) {
			  if ( !Ext.isEmpty( config.icon ) ) {
          c.setRawValue( config.icon.replaceAll( 'DIVANTE_ICON_', '' ) );
        }
			},
			beforequery : function(queryEvent) {
				delete queryEvent.combo.lastQuery;
			},
      change: function( c, newValue, oldValue ) {
        var rawValue = c.getRawValue();

        if ( !Ext.isEmpty( rawValue ) && rawValue == newValue ) {
          Ext.apply( c, {
            value: oldValue
          } );
        }
      }
		}
	}, config);

	Ext.ux.suncode.SystemIconsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.SystemIconsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.SystemIconsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.SystemColorsChooser = function(config) {
  config = config ? config : new Object();
  var colors = Ext.util.JSON.encode( Ext.getCmp( 'main_panel' ).getSystemColors() );
  var record = Ext.data.Record.create([ {
    name : 'name',
    type : 'string'
  } ]);

  var store = new Ext.data.JsonStore({
    proxy : new Ext.data.HttpProxy({
      method : 'GET',
      url : 'api/color/getSystemColors',
      listeners: {
        exception: function( proxy, type, action, options, response, arg ) {
          showServerFailure( response );
        }
      }
    }),
    reader : new Ext.data.JsonReader({
      fields : record
    }),
    autoDestroy : true,
    batch : true,
    fields : record,
    root : 'data',
    baseParams : {
      colors: colors,
      start : 0,
      limit : 20
    }
  });

  config = Ext.apply({
    ref : 'colorsChooser',
    displayField : 'name',
    valueField : 'name',
    store : store,
    fieldLabel : getTranslation('Kolor'),
    mode : 'remote',
    triggerAction : 'all',
    minChars : 0,
    pageSize : 20,
    lazyInit : false,
    anchor : '100%',
    resizable : true,
    value: config.color,
    listeners : {
      afterrender : function(c) {
        if ( !Ext.isEmpty( config.color ) ) {
          c.setRawValue( config.color );
        }
      },
      beforequery : function(queryEvent) {
        delete queryEvent.combo.lastQuery;
      }
    }
  }, config);

  Ext.ux.suncode.SystemColorsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.SystemColorsChooser, Ext.form.ComboBox, {
  initComponent : function() {
    Ext.ux.suncode.SystemColorsChooser.superclass.initComponent.call(this);
  }
});

Ext.ux.suncode.OpenXpdlWindow = function() {
	var config = new Object();
	var sources = [ [ 'DISK', getTranslation('Z dysku') ], [ 'SYSTEM', getTranslation('Z systemu') ],
			[ 'SAVED', getTranslation('Zapisane') ] ];

	config = Ext.apply({
		modal : true,
		autoWidth : true,
		autoHeight : true,
		title : getTranslation('Otwórz'),
		disableCloseValidation: true,
		items : [ {
			xtype : 'form',
			fileUpload : true,
			standardSubmit : false,
			width : 450,
			labelWidth : 120,
			frame : false,
			border: false,
			bodyCssClass: 'x-Module-container-padding',
			autoHeight : true,
			buttonAlign : 'center',
			ref : 'xpdlFilePanel',
			items : [ {
				xtype : 'combo',
				hiddenName : 'source',
				triggerAction : 'all',
				fieldLabel : getTranslation('Źródło'),
				mode : 'local',
				ref : 'xpdlSourceChooser',
				anchor : '100%',
				store : new Ext.data.ArrayStore({
					fields : [ 'source', 'sourceName' ],
					data : sources
				}),
				valueField : 'source',
				displayField : 'sourceName',
				allowBlank : false,
				blankText : getTranslation('Wybierz źródło'),
				emptyText : getTranslation('Wybierz źródło'),
				forceSelection : true,
				editable : false,
				listeners : {
					scope : this,
					select : function(combo, record, index) {
						var v = combo.getValue();
						if (Ext.isEmpty(v)) {
							return;
						}

						var xpdlFileItem = this.xpdlFilePanel.xpdlFileItem;
						if (xpdlFileItem) {
							this.xpdlFilePanel.remove(xpdlFileItem);
						}

						var tbspacer = this.xpdlFilePanel.tbspacer;
						if (tbspacer) {
							this.xpdlFilePanel.remove(tbspacer);
						}

						this.xpdlFilePanel.add({
							xtype: 'tbspacer',
							height: 6,
							ref: 'tbspacer'
						});

						switch (v) {
						case 'DISK':
							this.xpdlFilePanel.add({
								xtype : 'fileuploadfield',
								emptyText : getTranslation('Wybierz plik'),
								fieldLabel : getTranslation('Plik'),
								name : 'file',
								buttonText : getTranslation('Wybierz'),
								width : '100%',
								autoWidth : true,
								allowBlank : false,
								height: 42,
								blankText : getTranslation('Wybierz plik'),
								regex : new RegExp('.xpdl$|.zip$', 'i'),
								regexText : getTranslation('Wybrany plik nie jest plikiem xpdl/zip.'),
								ref : 'xpdlFileItem'
							});
							this.xpdlFilePanel.doLayout();
							break;
						case 'SYSTEM':
							this.xpdlFilePanel.add(new Ext.ux.suncode.XpdlServerFilesChooser({
								hiddenName : 'path',
								allowBlank : false,
								blankText : getTranslation('Wybierz plik'),
								xpdlSource : v
							}));
							this.xpdlFilePanel.doLayout();
							break;
						case 'SAVED':
							this.xpdlFilePanel.add(new Ext.ux.suncode.XpdlServerFilesChooser({
								hiddenName : 'path',
								allowBlank : false,
								blankText : getTranslation('Wybierz plik'),
								xpdlSource : v
							}));
							this.xpdlFilePanel.doLayout();
							break;
						default:
							break;
						}

						this.syncShadow();
					}
				}
			} ],
			buttons : [ {
				text : getTranslation('Otwórz'),
				cls : 'x-btn-text-icon',
				handler : this.openXpdl,
				scope : this
			} ]
		} ]
	}, config);

	Ext.ux.suncode.OpenXpdlWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.OpenXpdlWindow, Ext.Window, {
	initComponent : function() {
		Ext.ux.suncode.OpenXpdlWindow.superclass.initComponent.call(this);

		this.on('beforeshow', lockHotkeys);
		this.on('beforeclose', unlockHotkeys);
	},
	openXpdl: function() {
        var form = this.xpdlFilePanel.getForm();

        if ( form.isValid() ) {
            if (Ext.getCmp('main_panel').isSaved()) {
                executeNewXpdl();
                this.executeOpenXpdl();
            } else {
                Ext.Msg.show({
                    title: getTranslation( 'Uwaga' ),
                    msg: getTranslation( 'Plik jest niezapisany. Zapisać przed wykonaniem operacji?' ),
                    buttons: {
                        yes: getTranslation( 'Tak' ),
                        no: getTranslation( 'Nie' ),
                        cancel: getTranslation( 'Anuluj' )
                    },
                    fn: function ( buttonId ) {
                        switch ( buttonId ) {
                            case 'yes':
                                var me = this;
                                saveXpdl( function() {
                                  executeNewXpdl();
                                  me.executeOpenXpdl();
                                } );
                                break;
                            case 'no':
                                resetAutoSaved();
                                executeNewXpdl();
                                this.executeOpenXpdl();
                                break;
                            default:
                                break;
                        }
                    },
                    scope: this,
                    icon: Ext.Msg.QUESTION
                });
            }
        }
	},
	executeOpenXpdl: function() {
		    var form = this.xpdlFilePanel.getForm();
        var url = '';

        switch ( form.getValues().source ) {
            case 'DISK':
                url = 'api/xpdl/openFromDisc';
                break;
            case 'SYSTEM':
                url = 'api/xpdl/openFromSystem';
                break;
            case 'SAVED':
                url = 'api/xpdl/openFromSaved';
                break;
            default:
                break;
        }

        form.submit( {
            url: url,
            waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
            waitTitle: getTranslation( 'Proszę czekać' ),
            method: 'POST',
            timeout: 600,
            scope: this,
            success: function( form, action ) {
							this.onSuccessXpdlOpen( url, action.result.id );
						},
            failure: function( form, action ) {
                showServerFailure( action.response );
            }
        } );
	},
	onSuccessXpdlOpen: function( url, openedXpdlId ) {
		Ext.Ajax.request({
			url: url,
			method: 'GET',
			params: {
				id: openedXpdlId
			},
			timeout: 600000,
			scope: this,
			disableCaching: true,
			success: function( response ) {
				this.onXpdlReceived( Ext.decode( response.responseText ) );
			},
			failure: function( response ) {
				showServerFailure( response );
			}
		})
	},
	onXpdlReceived: function( xpdlOpenDto ) {
		if ( xpdlOpenDto.success ) {
			this.close();
			var mainPanel = Ext.getCmp( 'main_panel' );
			executeOpen( xpdlOpenDto );
			loadRecentFiles();

			if ( Ext.ux.suncode.XpdlErrors.hasErrors() ) {
				var xpdlErrorsWindow = new Ext.ux.suncode.XpdlErrorsWindow();
				xpdlErrorsWindow.show();
			}

			if ( mainPanel.isCurrentXpdlVersionOlder() ) {
				showWarn( getTranslation( 'Mapa pakietu została utworzona w edytorze w wersji' )
					+ ' ' + mainPanel.getCurrentXpdlVersion() + '. '
					+ getTranslation( 'Aktualna wersja edytora to' )
					+ ' ' + mainPanel.getVersion() + '.' );
			}
		} else {
			showWarn( getTranslation( 'Wystąpił błąd.' ) );
		}
	}
});

Ext.ux.suncode.XpdlServerFilesChooser = function(config) {
	var record = Ext.data.Record.create([ {
		name : 'name',
		type : 'string'
	}, {
		name : 'path',
		type : 'string'
	} ]);

	var store = new Ext.data.JsonStore({
		proxy : new Ext.data.HttpProxy({
			method : 'GET',
			url : 'api/xpdl/getFromServer',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
		}),
		reader : new Ext.data.JsonReader({
			fields : record
		}),
		autoDestroy : true,
		batch : true,
		fields : record,
		root : 'data',
		baseParams : {
			source : config.xpdlSource
		}
	});

	config = Ext.apply({
		ref : 'xpdlFileItem',
		displayField : 'name',
		valueField : 'path',
		store : store,
		fieldLabel : getTranslation('Plik'),
		mode : 'remote',
		triggerAction : 'all',
		minChars : 0,
		lazyInit : false,
		forceSelection : true,
		resizable : true,
		anchor : '100%',
		listeners : {
			beforequery : function(queryEvent) {
				delete queryEvent.combo.lastQuery;
			}
		}
	}, config);

	Ext.ux.suncode.XpdlServerFilesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.XpdlServerFilesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.XpdlServerFilesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.XpdlPreviewWindow = function(config) {
	var size = Ext.getBody().getViewSize();

	config = Ext.apply({
		autoWidth : true,
		height : size.height * 0.9,
		modal : true,
		title : getTranslation('Podgląd mapy pakietu'),
		closable : true,
		searchStartPos : 0,
		currentPhrase : '',
		wrapped : false,
		items : [ {
			xtype : 'panel',
			layout : 'form',
			frame : false,
			border: false,
			bodyCssClass: 'x-Module-container-padding',
			hideBorders : true,
			ref : 'previewPanel',
			labelWidth : 200,
			items : [ {
				xtype : 'compositefield',
				anchor : '100%',
				fieldLabel : getTranslation('Fraza'),
				ref : 'searchItem',
				items : [ {
					xtype : 'textfield',
					inputType : 'text',
					flex : 1,
					isFormField : true,
					listeners : {
						scope : this,
						specialkey : function(field, e) {
							if (e.getKey() == e.ENTER) {
								this.searchPhrase();
							}
						}
					}
				}, {
					xtype : 'button',
					cls : 'x-btn-icon',
					icon : getPluginImgPath('zoom'),
					tooltip : getTranslation('Wyszukaj'),
					flex : 0,
					handler : this.searchPhrase,
					scope : this
				} ]
			}, {
				xtype : 'checkbox',
				fieldLabel : getTranslation('Ignoruj wielkość liter'),
				anchor : '100%',
				ref : 'ignoreCaseItem',
				checked : true,
				inputValue : 'true'
			}, {
				xtype : 'panel',
				width : size.width * 0.6,
				height : size.height * 0.75,
				layout : 'fit',
				hideBorders : true,
				ref : 'areaPanel',
				items : [ {
					xtype : 'textarea',
					ref : 'previewItem',
					autoScroll : true,
					value : config.xpdlPreview,
					readOnly : true
				} ]
			} ]
		} ]
	}, config);

	Ext.ux.suncode.XpdlPreviewWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.XpdlPreviewWindow, Ext.Window, {
	initComponent : function() {
		Ext.ux.suncode.XpdlPreviewWindow.superclass.initComponent.call(this);
	},
	searchPhrase : function() {
		var phrase = this.previewPanel.searchItem.items.first().getValue();

		if (!Ext.isEmpty(phrase)) {
			var previewItem = this.previewPanel.areaPanel.previewItem;
			var previewTxt = previewItem.getValue();
			var ignoreCase = this.previewPanel.ignoreCaseItem.getValue();

			if (ignoreCase) {
				phrase = phrase.toLowerCase();
				previewTxt = previewTxt.toLowerCase();
			}

			this.executeSearchPhrase(phrase, previewItem, previewTxt);
		} else {
			showWarn(getTranslation('Podaj frazę.'));
		}
	},
	executeSearchPhrase : function(phrase, previewItem, previewTxt) {
		var phraseIdx = previewTxt.indexOf(phrase, this.searchStartPos);

		if (this.currentPhrase != phrase) {
			this.currentPhrase = phrase;
			this.searchStartPos = 0;
			this.wrapped = false;
		}

		if (phraseIdx != -1) {
			previewItem.selectText(phraseIdx, phraseIdx + phrase.length);
			this.searchStartPos = phraseIdx + phrase.length;
			this.wrapped = false;
		} else {
			if (this.wrapped) {
				this.searchStartPos = 0;
				this.wrapped = false;
				showWarn(getTranslation('Fraza nie została znaleziona.'));
			} else {
				this.searchStartPos = 0;
				this.wrapped = true;
				this.executeSearchPhrase(phrase, previewItem, previewTxt);
			}
		}
	}
});

Ext.ux.suncode.TooltipInfo = function(config) {
	config = Ext.apply({
		html : config.info,
		dismissDelay : 0,
		maxWidth : config.maxWidth ? config.maxWidth : 250,
		remove : this.onRemove
	}, config);

	Ext.ux.suncode.TooltipInfo.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.TooltipInfo, Ext.ToolTip, {
	initComponent : function() {
		Ext.ux.suncode.TooltipInfo.superclass.initComponent.call(this);
	},
	onRemove : function() {
		this.destroy();
	}
});

Ext.ux.suncode.ColorChooser = function(config) {
	var color = config.color;
	var textColor = !Ext.isEmpty( color ) ? this.getPreviewTextColor( color ) : '#000000';
	
	config = Ext.apply({
		id : 'color_chooser',
		width : 300,
		modal : true,
		autoHeight : true,
		resizable : false,
		draggable : false,
		layout : 'fit',
		title : config.title,
		choosenColor : color,
		items : [ {
			xtype : 'panel',
			layout : 'form',
			frame : false,
			border: false,
			bodyCssClass: 'x-Module-container-padding',
			autoHeight : true,
			ref : 'chooserPanel',
			labelSeparator: '',
			labelWidth: 8,
			labelStyle: 'font-weight: bold;',
			items : [ {
				xtype : 'textfield',
				ref : 'colorPreview',
				enableKeyEvents: true,
				stripCharsRe: /\#/g,
				fieldLabel: '#',
				width: 265,
				style : 'background: ' + color + '; color: ' + textColor + '; font-weight: bold;',
				value : !Ext.isEmpty( color ) ? color.substring( 1 ) : '',
				listeners: {
					scope: this,
					keyup: this.onColorPreviewKeyUp
				}
			} ]
		} ],
		tbar : new Ext.Toolbar({
			items : [ {
				xtype : 'button',
				cls : 'x-btn-icon',
        ref: 'saveBtn',
				icon: getPluginImgPath( 'save' ),
				tooltip : getTranslation('Zapisz'),
				handler : this.onSave,
				scope : this
			}, {
				xtype : 'button',
				cls : 'x-btn-icon',
				icon: getPluginImgPath( 'close' ),
				tooltip : getTranslation('Zamknij'),
				handler : this.closeWindow,
				scope : this
			} ]
		}),
		closable : true
	}, config);

	Ext.ux.suncode.ColorChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ColorChooser, Ext.Window, {
	initComponent : function() {
		Ext.ux.suncode.ColorChooser.superclass.initComponent.call(this);

		this.on('beforeshow', this.onBeforeShow, this);
	},
	COLOR_REGEX: new RegExp( '^[0-9a-f]{6}$', 'gi' ),
	COLOR_PICKER: null,
	closeWindow : function() {
		this.close();
	},
	onBeforeShow : function( win ) {
    this.locate( this.initialConfig.e );
    fitWindowToView( win, function( x ) {
      return ( Ext.getBody().getWidth() - win.getWidth() );
    }, function( y ) {
      return ( y - 375 );
    }, null, function() {
      return 350;
    } );
		var initTask = new Ext.util.DelayedTask(this.initColorChooser, this);
		initTask.delay(10);
	},
  locate : function( e ) {
    var xy = e.getXY();
    this.setPosition([ xy[0] + 15, xy[1] - 100 ]);
  },
	initColorChooser : function() {
		var chooserPanel = this.chooserPanel;
		var panelPos = chooserPanel.getPosition();
		var el = document.getElementById(chooserPanel.getId());
		this.COLOR_PICKER = Raphael.colorpicker(panelPos[0], panelPos[1], chooserPanel.getWidth(), this.initialConfig.color, el);
		this.COLOR_PICKER.onchange = this.setColor;
	},
	setColor : function(color) {
		var colorChooser = Ext.getCmp('color_chooser');
		colorChooser.choosenColor = color;
		var colorPreview = colorChooser.chooserPanel.colorPreview;
		var el = colorPreview.getEl();
		el.setStyle('background', color);
		el.setStyle('color', colorChooser.getPreviewTextColor( color ) );
		colorPreview.setValue( color.substring( 1 ) );
	},
	onColorPreviewKeyUp: function( field, e ) {
		var color = field.getValue();
		
		if ( !Ext.isEmpty( color ) && color.startsWith( '#' ) ) {
			color = color.substring( 1 );
		}
		
		if ( !Ext.isEmpty( color ) && this.COLOR_REGEX.test( color ) ) {
			var colorWithHash = '#' + color;
			var colorChooser = Ext.getCmp('color_chooser');
			colorChooser.choosenColor = colorWithHash;
			var el = field.getEl();
			el.setStyle('background', colorWithHash);
			el.setStyle('color', this.getPreviewTextColor( colorWithHash ) );
			this.COLOR_PICKER.color( colorWithHash );
		}
	},
	onSave : function() {
		this.closeWindow();
		
		var saveFunction = this.initialConfig.saveFunction;
		
		if ( Ext.isFunction( saveFunction ) ) {
			saveFunction( this.choosenColor );
		}
	},
	getPreviewTextColor: function( color ) {
		var luminance = this.getLuminance( color );
		
		return luminance > 120 ? '#000000' : '#FFFFFF';
	},
	getLuminance: function( color ) {
	    var rgb = Raphael.getRGB( color );
	    
	    return 0.2126 * rgb.r + 0.7152 * rgb.g + 0.0722 * rgb.b;
	}
});

Ext.ux.suncode.ProcessNameMasksChooser = function(config) {
	var masks = [ [ 'NAME', getTranslation('Nazwa procesu') ], [ 'VER', getTranslation('Wersjonowanie') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Maska nazwy procesu'),
		mode : 'local',
		store : new Ext.data.ArrayStore({
			fields : [ 'mask', 'maskName' ],
			data : masks
		}),
		valueField : 'mask',
		displayField : 'maskName'
	}, config);

	Ext.ux.suncode.ProcessNameMasksChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ProcessNameMasksChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ProcessNameMasksChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.OperatorsChooser = function( config ) {
	config = config ? config : new Object();
	var operators = [ [ '==', getTranslation('jest równy') ], [ '!=', getTranslation('jest różny od') ],
			[ '>', getTranslation('jest większy od') ], [ '>=', getTranslation('jest większy równy') ],
			[ '<', getTranslation('jest mniejszy od') ], [ '<=', getTranslation('jest mniejszy równy') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Operator'),
		mode : 'local',
		ref : 'operatorItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'operator', 'operatorName' ],
			data : operators
		}),
		valueField : 'operator',
		displayField : 'operatorName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.OperatorsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.OperatorsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.OperatorsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.SystemDocumentClassesChooser = function(config) {
	var docClassNameItemValue = '';
	var realName = config.realName ? config.realName : '';
	var label = config.label ? config.label : getTranslation('Klasa dokumentów');

	if (config.docClassName) {
		docClassNameItemValue = config.docClassName;
	}

	var record = Ext.data.Record.create([ {
		name : 'docClassName',
		type : 'string'
	} ]);

	var store = new Ext.data.JsonStore({
		proxy : new Ext.data.HttpProxy({
			method : 'GET',
			url : 'api/documentclass/get',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
		}),
		reader : new Ext.data.JsonReader({
			fields : record
		}),
		autoDestroy : true,
		batch : true,
		fields : record,
		root : 'data'
	});

	config = Ext.apply({
		realName : realName,
		ref : 'docClassesChooser',
		displayField : 'docClassName',
		valueField : 'docClassName',
		store : store,
		triggerAction : 'all',
		fieldLabel : label,
		mode : 'remote',
		lazyInit : false,
		forceSelection : false,
		anchor : '100%',
		resizable : true,
		value : docClassNameItemValue
	}, config);

	Ext.ux.suncode.SystemDocumentClassesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.SystemDocumentClassesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.SystemDocumentClassesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DTLocalChooser = function(config) {
	var options = [ [ 'DEFAULT', getTranslation('Domyślnie') ], [ 'FALSE', getTranslation('Nie') ],
			[ 'TRUE', getTranslation('Tak') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		ref : 'localItem',
		store : new Ext.data.ArrayStore({
			fields : [ 'option', 'optionName' ],
			data : options
		}),
		valueField : 'option',
		displayField : 'optionName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.DTLocalChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DTLocalChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DTLocalChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AcceptButtonsChooser = function() {
	var config = new Object();
	var buttons = [ [ 'ACTION_ACCEPT_BUTTON', getTranslation('Akceptacja zadania') ],
			[ 'GENERATE_PDF_BUTTON', getTranslation('Generowanie PDF') ],
			[ 'ADD_FILE_BUTTON', getTranslation('Podłączanie pliku') ],
			[ 'BARCODE_PRINT', getTranslation('Drukowanie kodu kreskowego') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Rodzaj przycisku akceptacji'),
		mode : 'local',
		ref : 'buttonGenreItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'genre', 'genreName' ],
			data : buttons
		}),
		valueField : 'genre',
		displayField : 'genreName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.AcceptButtonsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AcceptButtonsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AcceptButtonsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AlignmentsChooser = function(config) {
	var aligns = [ [ 'center', getTranslation('Wyśrodkowanie') ], [ 'left', getTranslation('Wyrównanie do lewej') ],
			[ 'right', getTranslation('Wyrównanie do prawej') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : config.label,
		mode : 'local',
		ref : config.ref,
		anchor : '100%',
		additional : true,
		store : new Ext.data.ArrayStore({
			fields : [ 'align', 'alignName' ],
			data : aligns
		}),
		hidden : !config.AV,
		valueField : 'align',
		displayField : 'alignName',
		forceSelection : true,
		editable : false,
		value : config.value
	}, config);

	Ext.ux.suncode.AlignmentsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AlignmentsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AlignmentsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DecimalSeparatorsChooser = function(config) {
	var label = addTooltipToField(getTranslation('Separator'),
			getTranslation('Separator liczb dziesiętnych, wartość domyślna: przecinek'));
	var separators = [ [ ',', getTranslation('Przecinek') ], [ '.', getTranslation('Kropka') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : label,
		mode : 'local',
		ref : 'dtDecimalSeparatorItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'separator', 'separatorName' ],
			data : separators
		}),
		valueField : 'separator',
		displayField : 'separatorName',
		forceSelection : true,
		editable : false,
		value : config.value
	}, config);

	Ext.ux.suncode.DecimalSeparatorsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DecimalSeparatorsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DecimalSeparatorsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.ActivityForwardChooser = function(config) {
	var forwardToItemValue = '';
	var activityNode = config.activityNode;
	var buttonDefPanel = config.buttonDefPanel;

	if (config.forwardTo) {
		forwardToItemValue = config.forwardTo;
	}

	config = Ext.apply({
		ref : 'activityForwardChooser',
		displayField : 'activityName',
		valueField : 'transitionId',
		store : getActivityTransitionsStore(activityNode),
		triggerAction : 'all',
		mode : 'local',
		forceSelection : true,
		anchor : '100%',
		resizable : true,
		value : forwardToItemValue,
		editable: false,
		flex : 1,
		listeners : {
			scope : this,
			beforeselect : function(combo, record, index) {
				var actionName = buttonDefPanel.actionNameItem.getValue();
				if (Ext.isEmpty(actionName)) {
					showWarn(getTranslation('Najpierw określ nazwę akcji przycisku.'));
					return false;
				}
			},
			select : function(combo, record, index) {
				var transitionId = combo.getValue();
				if (!combo.isValid() || Ext.isEmpty(transitionId)) {
					return;
				}

				var actionName = buttonDefPanel.actionNameItem.getValue();
				var actionsRootNode = buttonDefPanel.actionsTreePanel.getRootNode();
				var hasAction = false;

				if (actionsRootNode.hasChildNodes()) {
					actionsRootNode.eachChild(function(actionNode) {
						var attributions = actionNode.attributes.action.attributions;
						for (var i = 0; i < attributions.length; i++) {
							var attribution = attributions[i];
							if (attribution.varId == 'Action') {
								hasAction = true;
								return false;
							}
						}
					});
				}

				if (!hasAction) {
					var actionObj = {
						attributions : [ {
							varId : 'Action',
							value : actionName
						} ],
						conditions : []
					};

					actionsRootNode.appendChild({
						text : getActionAcceptButtonActionNodeText(actionObj.attributions, actionObj.conditions),
						icon : getPluginImgPath('action'),
						leaf : true,
						action : actionObj
					});
				}

				this.buttonDefPanel.forwardToReset = false;
			}
		}
	}, config);

	Ext.ux.suncode.ActivityForwardChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ActivityForwardChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ActivityForwardChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AcceptButtonDestinationsChooser = function(config) {
	var destinations = [ [ 'ALL', getTranslation('Wszędzie') ], [ 'TASKFORM', getTranslation('Na formularzu') ],
			[ 'GROUPFORM', getTranslation('W akceptacji grupowej') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		ref : 'destinationItem',
		anchor : '100%',
		flex : 1,
		store : new Ext.data.ArrayStore({
			fields : [ 'destination', 'destinationName' ],
			data : destinations
		}),
		valueField : 'destination',
		displayField : 'destinationName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.AcceptButtonDestinationsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AcceptButtonDestinationsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AcceptButtonDestinationsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.ButtonDestinationsChooser = function(config) {
  var destinations = [ [ 'TASKFORM', getTranslation('Formularz zadania') ], [ 'TASKDETAILS', getTranslation('Szczegóły zadania') ],
     [ 'ALL', getTranslation('Wszędzie') ] ];

  config = Ext.apply({
    fieldLabel: getTranslation( 'Występowanie' ),
    triggerAction : 'all',
    mode : 'local',
    ref : 'destinationItem',
    anchor : '100%',
    store : new Ext.data.ArrayStore({
      fields : [ 'destination', 'destinationName' ],
      data : destinations
    }),
    valueField : 'destination',
    displayField : 'destinationName',
    forceSelection : true,
    editable : false
  }, config);

  Ext.ux.suncode.ButtonDestinationsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ButtonDestinationsChooser, Ext.form.ComboBox, {
  initComponent : function() {
    Ext.ux.suncode.ButtonDestinationsChooser.superclass.initComponent.call(this);
  }
});

Ext.ux.suncode.NextActivityChooser = function(config) {
	var activityNode = config.activityNode;
	var store = new Ext.data.Store({
		data : getNextActivities(activityNode, []),
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'activityDefId',
				type : 'string'
			}, {
				name : 'activityName',
				type : 'string'
			} ])
		})
	});

	config = Ext.apply({
		displayField : 'activityName',
		valueField : 'activityDefId',
		store : store,
		triggerAction : 'all',
		mode : 'local',
		forceSelection : true,
		resizable : true,
		flex : 1
	}, config);

	Ext.ux.suncode.NextActivityChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.NextActivityChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.NextActivityChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AutoUpdateTypesChooser = function(config) {
	var types = [ [ 'Struts' ], [ 'Servlet' ], [ 'RESTful' ], [ 'Applet' ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Typ'),
		mode : 'local',
		ref : 'taskNameTypeItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'type' ],
			data : types
		}),
		valueField : 'type',
		displayField : 'type',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.AutoUpdateTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AutoUpdateTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AutoUpdateTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AutoUpdateEventTypesChooser = function(config) {
	var eventTypes = [ [ 'blur', getTranslation('Wyjście z pola') ],
			[ 'change', getTranslation('Zmiana wartości pola') ],
			[ 'select', getTranslation('Zmiana wartości z listy') ], [ 'applet', getTranslation('Applet') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Typ zdarzenia'),
		mode : 'local',
		ref : 'eventTypeItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'eventType', 'eventTypeName' ],
			data : eventTypes
		}),
		valueField : 'eventType',
		displayField : 'eventTypeName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.AutoUpdateEventTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AutoUpdateEventTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AutoUpdateEventTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DeadlineExecutionsChooser = function(config) {
	var executions = [ [ 'ASYNCHR', getTranslation('Asynchroniczne') ], [ 'SYNCHR', getTranslation('Synchroniczne') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Wykonanie'),
		mode : 'local',
		ref : 'deadlineExecutionItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'execution', 'executionName' ],
			data : executions
		}),
		valueField : 'execution',
		displayField : 'executionName',
		forceSelection : true,
		editable : false,
		value : config.value
	}, config);

	Ext.ux.suncode.DeadlineExecutionsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DeadlineExecutionsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DeadlineExecutionsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DeadlineUnitsChooser = function(config) {
	var units = [ [ 'second', getTranslation('Sekunda') ], [ 'minute', getTranslation('Minuta') ],
			[ 'hour', getTranslation('Godzina') ], [ 'day', getTranslation('Dzień') ],
			[ 'week', getTranslation('Tydzień') ], [ 'month', getTranslation('Miesiąc') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Jednostka'),
		mode : 'local',
		ref : 'deadlineUnitItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'unit', 'unitName' ],
			data : units
		}),
		valueField : 'unit',
		displayField : 'unitName',
		forceSelection : true,
		editable : false,
		value : config.value
	}, config);

	Ext.ux.suncode.DeadlineUnitsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DeadlineUnitsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DeadlineUnitsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AssignmentFilterTypesChooser = function(config) {
	var types = [ [ 'ou', getTranslation('Jednostka organizacyjna po nazwie i podjednostki') ],
			[ 'ou_direct', getTranslation('Jednostka organizacyjna po nazwie') ],
			[ 'ou_symbol', getTranslation('Jednostka organizacyjna po symbolu i podjednostki') ],
			[ 'ou_direct_symbol', getTranslation('Jednostka organizacyjna po symbolu') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'type', 'typeName' ],
			data : types
		}),
		valueField : 'type',
		displayField : 'typeName',
		forceSelection : true,
		editable : false,
		resizable : true
	}, config);

	Ext.ux.suncode.AssignmentFilterTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AssignmentFilterTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AssignmentFilterTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.RoleusersFilterTypesChooser = function(config) {
	var types = [ [ 'role', getTranslation('Rola') ], [ 'ou', getTranslation('Nazwa jednostki organizacyjnej') ],
	              [ 'ou_symbol', getTranslation('Symbol jednostki organizacyjnej') ],
			[ 'group', getTranslation('Grupa') ], [ 'superior', getTranslation('Przełożony') ],
			[ 'subordinate', getTranslation('Podwładny') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'type', 'typeName' ],
			data : types
		}),
		valueField : 'type',
		displayField : 'typeName',
		forceSelection : true,
		editable : false,
		resizable : true
	}, config);

	Ext.ux.suncode.RoleusersFilterTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.RoleusersFilterTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.RoleusersFilterTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AllVariablesChooser = function(config) {
  var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
  var packageId = packageNode.attributes.packageId;
  var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
	var variables = config.variables;
	var formalParameters = config.formalParameters;
	var comboForceSelection = true;
	var startWith = '';

	if (config.startWith) {
		startWith = config.startWith;
	}

	if (config.comboForceSelection != undefined) {
		comboForceSelection = config.comboForceSelection;
	}

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'id',
				type : 'string'
			}, {
				name : 'name',
				type : 'string'
			}, {
				name : 'descr',
				type : 'string'
			} ])
		})
	});

	if ( ( !Ext.isEmpty( config.acceptedTypes ) || !Ext.isEmpty( config.acceptedPlacement )
      || !Ext.isEmpty( config.acceptedVariables ) ) && !Ext.isEmpty( variables ) ) {
        var acceptedTypes = config.acceptedTypes;
        var acceptedPlacement = config.acceptedPlacement;
        var acceptedVariables = config.acceptedVariables;
        var filteredVariables = new Array();

        Ext.each( variables, function( v, index, vs ) {
            if ( ( Ext.isEmpty( acceptedTypes ) || acceptedTypes.indexOf( v.type ) != -1 ) &&
                ( Ext.isEmpty( acceptedVariables ) || acceptedVariables.indexOf( v.id ) != -1 ) &&
                ( Ext.isEmpty( acceptedPlacement ) || Ext.isEmpty( v.placement ) || v.placement == acceptedPlacement ) ) {
                var nameTranslation = getXpdlVariableNameTranslation( packageId, processDefId, v.id, v.name );

                filteredVariables.push( {
                  id: v.id,
                  name: nameTranslation,
                  descr: v.descr
                } );
            }
        } );

        store.loadData( filteredVariables );
        store.commitChanges();
	} else if (!Ext.isEmpty(variables)) {
    var data = new Array();

    Ext.each( variables, function( v, index, vs ) {
      var nameTranslation = getXpdlVariableNameTranslation( packageId, processDefId, v.id, v.name );

      data.push( {
        id: v.id,
        name: nameTranslation,
        descr: v.descr
      } );
    } );

		store.loadData( data );
		store.commitChanges();
	}

	if ( !Ext.isEmpty( formalParameters ) && ( Ext.isEmpty( acceptedPlacement ) || acceptedPlacement == 'form' ) ) {
		if (Ext.getCmp('main_panel').getAdvancedView()) {
			var excludedFormalParams = config.excludedFormalParams;

      Ext.each(formalParameters, function(fp, index, fps) {
        if ( ( Ext.isEmpty( excludedFormalParams ) || excludedFormalParams.indexOf(fp.id) == -1 )
            && ( Ext.isEmpty( config.acceptedTypes ) || acceptedTypes.indexOf( fp.type ) != -1 ) ) {
          store.loadData([ fp ], true);
        }
      });
			
			store.commitChanges();
		} else if (!Ext.isEmpty(config.acceptedFormalParams)) {
			var acceptedFormalParams = config.acceptedFormalParams;

			Ext.each(formalParameters, function(fp, index, fps) {
				if ( acceptedFormalParams.indexOf(fp.id) != -1
            && ( Ext.isEmpty( config.acceptedTypes ) || acceptedTypes.indexOf( fp.type ) != -1 ) ) {
					store.loadData([ fp ], true);
				}
			});
			
			store.commitChanges();
		}
	}

	if (config.additionals) {
		store.loadData(config.additionals, true);
		store.commitChanges();
	}

	if (store.getCount() > 0) {
		store.sort('name', 'ASC');
	}

	var varsTpl = new Ext.XTemplate('<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font '
			+ getTemplateStyle() + '><b>' + getTranslation('Nazwa zmiennej') + ': '
			+ '</b></font><span>{name}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
			+ getTranslation('Opis zmiennej') + ': ' + '</b></font><span>{descr}</span></div></div>',
			'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>');
	varsTpl = varsTpl.compile();

	config = Ext.apply({
		anchor : '100%',
		ref : 'variablesChooser',
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'id',
		displayField : 'name',
		forceSelection : comboForceSelection,
		tpl : varsTpl,
		itemSelector : 'div.x-Module-comboTemplateItem',
		value : startWith,
		flex : 1,
		resizable : true
	}, config);

	Ext.ux.suncode.AllVariablesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AllVariablesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AllVariablesChooser.superclass.initComponent.call(this);
	},
	updateTitle : function() {
		this.compileTemplate();
	},
	compileTemplate : function() {
		this.initialConfig.tpl.compile();
	}
});

Ext.ux.suncode.ListboxVariablesChooser = function(config) {
	var processNode = config.processNode;
	var variables = processNode.attributes.variables;
	var formalParameters = processNode.attributes.formalParameters;

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'id',
				type : 'string'
			}, {
				name : 'name',
				type : 'string'
			}, {
				name : 'descr',
				type : 'string'
			}, {
				name : 'isValue',
				type : 'boolean'
			} ])
		})
	});

	var rec = store.recordType;

	if (!Ext.isEmpty(variables)) {
		Ext.each(variables, function(variable, index, allVariables) {
			store.add(new rec({
				id : '<' + variable.id + '>',
				name : variable.name,
				descr : variable.descr,
				isValue : false
			}));
		});
	}

	if (!Ext.isEmpty(formalParameters)) {
		Ext.each(formalParameters, function(formalParameter, index, allFormalParameters) {
			store.add(new rec({
				id : '<' + formalParameter.id + '>',
				name : formalParameter.name,
				descr : formalParameter.descr,
				isValue : false
			}));
		});
	}

	store.commitChanges();
	store.sort('name', 'ASC');

	var tpl = new Ext.XTemplate('<tpl for=".">', '<div class="x-Module-comboTemplateItem">',
			'<tpl if="isValue === true">', '<div><font ' + getTemplateStyle() + '><b>' + getTranslation('Wartość')
					+ ': ' + '</b></font><span>{name}</span></div>', '</tpl>', '<tpl if="isValue === false">',
			'<div><font ' + getTemplateStyle() + '><b>' + getTranslation('Nazwa zmiennej') + ': '
					+ '</b></font><span>{name}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
					+ getTranslation('Opis zmiennej') + ': ' + '</b></font><span>{descr}</span></div></div>', '</tpl>',
			'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>');

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'id',
		displayField : 'name',
		forceSelection : false,
		tpl : tpl.compile(),
		itemSelector : 'div.x-Module-comboTemplateItem',
		resizable : true
	}, config);

	Ext.ux.suncode.ListboxVariablesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ListboxVariablesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ListboxVariablesChooser.superclass.initComponent.call(this);

		this.on('beforequery', this.removeValue, this);
	},
	removeValue : function() {
		var store = this.getStore();
		var toRemove = new Array();
		store.each(function(record) {
			if (record.get('isValue')) {
				toRemove.push(record);
			}
		});
		store.remove(toRemove);
		store.commitChanges();
	},
	onLoad : function() {
		this.addValue();
		Ext.ux.suncode.ListboxVariablesChooser.superclass.onLoad.call(this);
	},
	addValue : function() {
		var query = this.getRawValue();
		var store = this.getStore();
		var rec = store.recordType;
		store.insert(0, new rec({
			id : query,
			name : query,
			isValue : true
		}));
	},
	assertValue : function() {
		var val = this.getRawValue(), rec;

		if (this.valueField && Ext.isDefined(this.value)) {
			rec = this.findRecord(this.valueField, this.value);
		}
		if (!rec || rec.get(this.displayField) != val) {
			rec = this.findRecord(this.displayField, val);
		}
		if (!rec && this.forceSelection) {
			if (val.length > 0 && val != this.emptyText) {
				this.el.dom.value = Ext.value(this.lastSelectionText, '');
				this.applyEmptyText();
			} else {
				this.clearValue();
			}
		} else {
			if (rec && this.valueField) {
				if (this.value == val || this.value == '<' + val + '>') {
					return;
				}
				val = rec.get(this.valueField || this.displayField);
			}
			this.setValue(val);
		}
	}
});

Ext.ux.suncode.ProcessesChooser = function(config) {
	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'processDefId',
				type : 'string'
			}, {
				name : 'processName',
				type : 'string'
			} ])
		})
	});

	var excluded = config.excluded ? config.excluded : [];
	var packageNode = Ext.getCmp('package_panel').getRootNode();
	var rec = store.recordType;

	packageNode.eachChild(function(node) {
		var processDefId = node.attributes.processDefId;
    var processName = node.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );

		if (excluded.indexOf(processDefId) == -1) {
			var process = new rec({
				processDefId : processDefId,
				processName : processNameTranslation
			});
			store.add(process);
		}
	});

	store.commitChanges();

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'processDefId',
		displayField : 'processName',
		forceSelection : true
	}, config);

	Ext.ux.suncode.ProcessesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ProcessesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ProcessesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.ActivitiesChooser = function(config) {
	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'activityDefId',
				type : 'string'
			}, {
				name : 'activityName',
				type : 'string'
			} ])
		})
	});

	var excluded = config.excluded ? config.excluded : [];
	var acceptedTypes = config.acceptedTypes ? config.acceptedTypes : [];
	var processNode = config.processNode;
	var rec = store.recordType;

	processNode.eachChild(function(node) {
		var activityDefId = node.attributes.activityDefId;
		var activityName = node.attributes.activityName;
		var activityType = node.attributes.activityType;

		if (excluded.indexOf(activityDefId) == -1 && acceptedTypes.indexOf(activityType) != -1) {
			var activity = new rec({
				activityDefId : activityDefId,
				activityName : activityName
			});
			store.add(activity);
		}
	});

	store.commitChanges();

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'activityDefId',
		displayField : 'activityName',
		forceSelection : true
	}, config);

	Ext.ux.suncode.ActivitiesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ActivitiesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ActivitiesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DescriptionToolTip = function(config) {
	config = Ext.apply({
		dismissDelay : 0,
		showDelay : 500
	}, config);

	Ext.ux.suncode.DescriptionToolTip.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DescriptionToolTip, Ext.ToolTip, {
	maxWidth : 500,
	isMouseOverBody : false,
	initComponent : function() {
		this.on('afterrender', function() {
			this.body.on('mouseenter', this.onMouseEnter, this);
			this.body.on('mouseleave', this.onMouseLeave, this);
		}, this);
		Ext.ux.suncode.DescriptionToolTip.superclass.initComponent.call(this);
		this.initClickTarget(this.target);
	},
	onTargetClick : function() {
		if (this.hidden)
			this.show();
	},
	onDocMouseDown : function(e) {
		if (!e.within(this.target.dom) && this.target.dom != e.target)
			Ext.ux.suncode.DescriptionToolTip.superclass.onDocMouseDown.call(this, e);
	},
	onMouseLeave : function(e) {
		this.isMouseOverBody = false;
		this.delayHide();
	},
	onMouseEnter : function(e) {
		this.isMouseOverBody = true;
	},
	hide : function() {
		if (!this.isMouseOverBody) {
			Ext.ux.suncode.DescriptionToolTip.superclass.hide.call(this);
		} else {
			this.hideTimer = null;
		}

	},
	initClickTarget : function(target) {
		var t;
		if ((t = Ext.get(target))) {
			if (this.target) {
				var tg = Ext.get(this.target);
				this.mun(tg, 'click', this.onTargetClick, this);
			}
			this.mon(t, {
				click : this.onTargetClick,
				scope : this
			});

			this.target = t;
		}
	}
});

Ext.ux.suncode.DefaultValuesChooser = function(config) {
	var defaultValues = [ [ '<CURRENTDATE>', getTranslation('Obecna data') ],
			[ '<CURRENTTIME>', getTranslation('Obecna data i czas') ],
			[ '<INITIATOR>', getTranslation('Inicjator procesu: login') ],
			[ '<INITIATORFULLNAME>', getTranslation('Inicjator procesu: imię i nazwisko') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : new Ext.data.ArrayStore({
			fields : [ 'defaultValue', 'defaultValueName' ],
			data : defaultValues
		}),
		valueField : 'defaultValue',
		displayField : 'defaultValueName',
		forceSelection : false
	}, config);

	Ext.ux.suncode.DefaultValuesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DefaultValuesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DefaultValuesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AcceptButtonActionValuesChooser = function() {
	var config = new Object();
	var values = [ [ '<CURRENTDATE>', getTranslation('Obecna data') ],
			[ '<CURRENTTIME>', getTranslation('Obecna data i czas') ],
			[ '<USERNAME>', getTranslation('Login wykonawcy zadania') ],
      [ '<USERFULLNAME>', getTranslation('Inicjator procesu: imię i nazwisko') ],
      [ '<USERFULLNAMEREVERSED>', getTranslation('Nazwisko i imię wykonawcy zadania') ],
			[ '<INITIATOR>', getTranslation('Inicjator procesu: login') ],
			[ '<INITIATORFULLNAME>', getTranslation('Imię i nazwisko wykonawcy zadania') ],
      [ '<INITIATORFULLNAMEREVERSED>', getTranslation('Inicjator procesu: nazwisko i imię') ],
			[ '<NNNN>', getTranslation('Sekwencer') ], [ '<RRRR>', getTranslation('Aktualny rok (np. 2012)') ],
			[ '<RR>', getTranslation('Aktualny rok (np. 12)') ], [ '<MM>', getTranslation('Aktualny miesiąc') ],
			[ '<DD>', getTranslation('Aktualny dzień') ],
			[ '<RRRR>/<NNNN>', getTranslation('Sekwencer w ramach roku') ],
			[ '<ROLEID>', getTranslation('Przypisanie zadania') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : new Ext.data.ArrayStore({
			fields : [ 'valueId', 'valueName' ],
			data : values
		}),
		valueField : 'valueId',
		displayField : 'valueName',
		forceSelection : false
	}, config);

	Ext.ux.suncode.AcceptButtonActionValuesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AcceptButtonActionValuesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AcceptButtonActionValuesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.ActivityAcceptButtonsChooser = function(config) {
	var activityNode = config.activityNode;

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'actionName',
				type : 'string'
			}, {
				name : 'buttonName',
				type : 'string'
			} ])
		})
	});

	if (activityNode.attributes.form.buttons.length > 0) {
		var rec = store.recordType;

		Ext.each(activityNode.attributes.form.buttons, function(button, index, buttons) {
			if (button.genre == 'ACTION_ACCEPT_BUTTON') {
				var btn = new rec({
					actionName : button.actionName,
					buttonName : button.buttonName
				});
				store.add(btn);
			}
		});

		store.commitChanges();
	}

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'actionName',
		displayField : 'buttonName',
		forceSelection : true
	}, config);

	Ext.ux.suncode.ActivityAcceptButtonsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ActivityAcceptButtonsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ActivityAcceptButtonsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.LabelAlignmentsChooser = function(config) {
	var alignments = [ [ 'left', getTranslation('Lewo') ],
    [ 'right', getTranslation('Prawo') ], [ 'top', getTranslation('Góra') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		fieldLabel : getTranslation('Wyrównanie etykiety'),
		mode : 'local',
		anchor : '100%',
    emptyText: getTranslation( 'Domyślny' ),
		store : new Ext.data.ArrayStore({
			fields : [ 'alignment', 'alignmentName' ],
			data : alignments
		}),
		valueField : 'alignment',
		displayField : 'alignmentName',
		forceSelection : true
	}, config);

	Ext.ux.suncode.LabelAlignmentsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.LabelAlignmentsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.LabelAlignmentsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.SortDirectionsChooser = function(config) {
	var directions = [ [ 'ASC', getTranslation('Sortuj rosnąco') ], [ 'DESC', getTranslation('Sortuj malejąco') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		ref : 'sortDirectionsItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'direction', 'directionName' ],
			data : directions
		}),
		valueField : 'direction',
		displayField : 'directionName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.SortDirectionsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.SortDirectionsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.SortDirectionsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.VariableSetColumnsChooser = function(config) {
	var columns = config.columns;
	var processNode = config.processNode;

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'columnId',
				type : 'string'
			}, {
				name : 'columnName',
				type : 'string'
			} ])
		})
	});

	if (!Ext.isEmpty(columns)) {
		var r = store.recordType;

		Ext.each(columns, function(col, index, cols) {
			var columnId = col.get('varId');
			var variable = processNode.findVariable(columnId);

			var c = new r({
				columnId : columnId,
				columnName : variable.name
			});
			store.add(c);
		});

		store.commitChanges();
	}

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		ref : 'columnItem',
		anchor : '100%',
		store : store,
		valueField : 'columnId',
		displayField : 'columnName',
		forceSelection : true
	}, config);

	Ext.ux.suncode.VariableSetColumnsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.VariableSetColumnsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.VariableSetColumnsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DocumentsViewLocationsChooser = function(config) {
	var locations = [ [ 'right', getTranslation('Z prawej') ], [ 'left', getTranslation('Z lewej') ] ];

	config = Ext.apply({
		fieldLabel : getTranslation('Lokalizacja podglądu dokumentów'),
		triggerAction : 'all',
		mode : 'local',
		ref : 'documentsViewLocationItem',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'location', 'locationName' ],
			data : locations
		}),
		valueField : 'location',
		displayField : 'locationName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.DocumentsViewLocationsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DocumentsViewLocationsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DocumentsViewLocationsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.TextDecorationsChooser = function(config) {
	var decorations = [
      [ 'none', getTranslation('Brak') ], [ 'underline', getTranslation('Podkreślenie dolne') ],
			[ 'overline', getTranslation('Podkreślenie górne') ], [ 'line-through', getTranslation('Przekreślenie') ] ];

	config = Ext.apply({
		fieldLabel : getTranslation('Dekoracja tekstu'),
		triggerAction : 'all',
		mode : 'local',
		anchor : '100%',
    emptyText: getTranslation( 'Domyślny' ),
		store : new Ext.data.ArrayStore({
			fields : [ 'decoration', 'decorationName' ],
			data : decorations
		}),
		valueField : 'decoration',
		displayField : 'decorationName',
		forceSelection : true
	}, config);

	Ext.ux.suncode.TextDecorationsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.TextDecorationsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.TextDecorationsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.DTActionsParams = {
	DT_EVENT_STORE_add : 'store,records,index,eOpts',
	DT_EVENT_STORE_beforeload : 'store,operation,eOpts',
	DT_EVENT_STORE_beforeprefetch : 'store,operation,eOpts',
	DT_EVENT_STORE_beforesync : 'options,eOpts',
	DT_EVENT_STORE_bulkremove : 'store,records,indexes,isMove,eOpts',
	DT_EVENT_STORE_clear : 'store,eOpts',
	DT_EVENT_STORE_datachanged : 'store,eOpts',
	DT_EVENT_STORE_filterchange : 'store,filters,eOpts',
	DT_EVENT_STORE_groupchange : 'store,groupers,eOpts',
	DT_EVENT_STORE_load : 'store,records,successful,eOpts',
	DT_EVENT_STORE_metachange : 'store,meta,eOpts',
	DT_EVENT_STORE_prefetch : 'store,records,successful,operation,eOpts',
	DT_EVENT_STORE_refresh : 'store,eOpts',
	DT_EVENT_STORE_remove : 'store,record,index,isMove,eOpts',
	DT_EVENT_STORE_update : 'store,record,operation,modifiedFieldNames,eOpts',
	DT_EVENT_STORE_write : 'store,operation,eOpts',
	DT_EVENT_GRID_activate : 'grid,eOpts',
	DT_EVENT_GRID_add : 'grid,component,index,eOpts',
	DT_EVENT_GRID_added : 'grid,container,pos,eOpts',
	DT_EVENT_GRID_afterlayout : 'grid,layout,eOpts',
	DT_EVENT_GRID_afterrender : 'grid,eOpts',
	DT_EVENT_GRID_beforeactivate : 'grid,eOpts',
	DT_EVENT_GRID_beforeadd : 'grid,component,index,eOpts',
	DT_EVENT_GRID_beforecellclick : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_beforecellcontextmenu : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_beforecelldblclick : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_beforecellkeydown : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_beforecellmousedown : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_beforecellmouseup : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_beforeclose : 'grid,eOpts',
	DT_EVENT_GRID_beforecollapse : 'grid,direction,animate,eOpts',
	DT_EVENT_GRID_beforecontainerclick : 'view,e,eOpts',
	DT_EVENT_GRID_beforecontainercontextmenu : 'view,e,eOpts',
	DT_EVENT_GRID_beforecontainerdblclick : 'view,e,eOpts',
	DT_EVENT_GRID_beforecontainermousedown : 'view,e,eOpts',
	DT_EVENT_GRID_beforecontainermouseout : 'view,e,eOpts',
	DT_EVENT_GRID_beforecontainermouseover : 'view,e,eOpts',
	DT_EVENT_GRID_beforecontainermouseup : 'view,e,eOpts',
	DT_EVENT_GRID_beforedeactivate : 'grid,eOpts',
	DT_EVENT_GRID_beforedeselect : 'rowModel,record,index,eOpts',
	DT_EVENT_GRID_beforedestroy : 'grid,eOpts',
	DT_EVENT_GRID_beforeedit : 'editor,e,eOpts',
	DT_EVENT_GRID_beforeexpand : 'grid,animate,eOpts',
	DT_EVENT_GRID_beforehide : 'grid,eOpts',
	DT_EVENT_GRID_beforeitemclick : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforeitemcontextmenu : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforeitemdblclick : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforeitemmousedown : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforeitemmouseenter : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforeitemmouseleave : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforeitemmouseup : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_beforereconfigure : 'grid,store,columns,oldStore,The,eOpts',
	DT_EVENT_GRID_beforeremove : 'grid,component,eOpts',
	DT_EVENT_GRID_beforerender : 'grid,eOpts',
	DT_EVENT_GRID_beforeselect : 'rowModel,record,index,eOpts',
	DT_EVENT_GRID_beforeshow : 'grid,eOpts',
	DT_EVENT_GRID_beforestaterestore : 'stateful,state,eOpts',
	DT_EVENT_GRID_beforestatesave : 'stateful,state,eOpts',
	DT_EVENT_GRID_blur : 'grid,The,eOpts',
	DT_EVENT_GRID_boxready : 'grid,width,height,eOpts',
	DT_EVENT_GRID_cellclick : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts ',
	DT_EVENT_GRID_cellcontextmenu : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_celldblclick : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_cellkeydown : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_cellmousedown : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_cellmouseup : 'gridView,td,cellIndex,record,tr,rowIndex,e,eOpts',
	DT_EVENT_GRID_close : 'grid,eOpts',
	DT_EVENT_GRID_collapse : 'grid,eOpts',
	DT_EVENT_GRID_columnhide : 'ct,column,eOpts',
	DT_EVENT_GRID_columnmove : 'ct,column,fromIdx,toIdx,eOpts',
	DT_EVENT_GRID_columnresize : 'ct,column,width,eOpts',
	DT_EVENT_GRID_columnschanged : 'ct,eOpts',
	DT_EVENT_GRID_columnshow : 'ct,column,eOpts',
	DT_EVENT_GRID_containerclick : 'view,e,eOpts',
	DT_EVENT_GRID_containercontextmenu : 'view,e,eOpts',
	DT_EVENT_GRID_containerdblclick : 'view,e,eOpts',
	DT_EVENT_GRID_containermouseout : 'view,e,eOpts',
	DT_EVENT_GRID_containermouseover : 'view,e,eOpts',
	DT_EVENT_GRID_containermouseup : 'view,e,eOpts',
	DT_EVENT_GRID_deactivate : 'grid,eOpts',
	DT_EVENT_GRID_deselect : 'rowModel,record,index,eOpts',
	DT_EVENT_GRID_destroy : 'grid,eOpts',
	DT_EVENT_GRID_disable : 'grid,eOpts',
	DT_EVENT_GRID_dockedadd : 'grid,component,index,eOpts',
	DT_EVENT_GRID_dockedremove : 'grid,component,eOpts',
	DT_EVENT_GRID_enable : 'grid,eOpts',
	DT_EVENT_GRID_expand : 'grid,eOpts',
	DT_EVENT_GRID_filterchange : 'store,filters,eOpts',
	DT_EVENT_GRID_float : 'eOpts',
	DT_EVENT_GRID_focus : 'grid,The,eOpts',
	DT_EVENT_GRID_glyphchange : 'grid,newGlyph,oldGlyph,eOpts',
	DT_EVENT_GRID_headerclick : 'ct,column,e,t,eOpts',
	DT_EVENT_GRID_headercontextmenu : 'ct,column,e,t,eOpts',
	DT_EVENT_GRID_headertriggerclick : 'ct,column,e,t,eOpts',
	DT_EVENT_GRID_hide : 'grid,eOpts',
	DT_EVENT_GRID_iconchange : 'grid,newIcon,oldIcon,eOpts',
	DT_EVENT_GRID_iconclschange : 'grid,newIconCls,oldIconCls,eOpts',
	DT_EVENT_GRID_itemclick : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_itemcontextmenu : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_itemdblclick : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_itemmousedown : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_itemmouseenter : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_itemmouseleave : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_itemmouseup : 'view,record,item,index,e,eOpts',
	DT_EVENT_GRID_lockcolumn : 'grid,column,eOpts',
	DT_EVENT_GRID_move : 'grid,x,y,eOpts',
	DT_EVENT_GRID_processcolumns : 'lockedColumns,normalColumns,eOpts',
	DT_EVENT_GRID_reconfigure : 'grid,store,columns,oldStore,The,eOpts',
	DT_EVENT_GRID_remove : 'grid,component,eOpts',
	DT_EVENT_GRID_removed : 'grid,ownerCt,eOpts',
	DT_EVENT_GRID_render : 'grid,eOpts',
	DT_EVENT_GRID_resize : 'grid,width,height,oldWidth,oldHeight,eOpts',
	DT_EVENT_GRID_select : 'rowModel,record,index,eOpts',
	DT_EVENT_GRID_selectionchange : 'selModel,selected,eOpts',
	DT_EVENT_GRID_show : 'grid,eOpts',
	DT_EVENT_GRID_sortchange : 'ct,column,direction,eOpts',
	DT_EVENT_GRID_staterestore : 'stateful,state,eOpts',
	DT_EVENT_GRID_statesave : 'stateful,state,eOpts',
	DT_EVENT_GRID_titlechange : 'grid,newTitle,oldTitle,eOpts',
	DT_EVENT_GRID_unfloat : 'eOpts',
	DT_EVENT_GRID_unlockcolumn : 'grid,column,eOpts',
	DT_EVENT_GRID_validateedit : 'editor,e,eOpts',
	DT_EVENT_GRID_viewready : 'table,eOpts',
	DT_EVENT_SM_focuschange : 'sm,oldFocused,newFocused,eOpts',
	DT_EVENT_SM_selectionchange : 'sm,selected,eOpts',
	getActionParamsAsTable : function(source) {
		return this[source] ? this[source].split(',') : [];
	}
};

Ext.ux.suncode.AboutWindow = function() {
	var config = new Object();

	config = Ext.apply({
		modal : true,
		shadow : false,
		autoWidth : true,
		autoHeight : true,
		title : getTranslation('O programie'),
		bodyCssClass : 'x-Module-whiteBody',
		layout : 'fit',
		items : [ {
			xtype : 'panel',
			border : false,
			width : 800,
			height : 300,
			autoLoad : {
				url : 'api/about'
			}
		} ]
	}, config);

	Ext.ux.suncode.AboutWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AboutWindow, Ext.Window, {
	initComponent : function() {
		Ext.ux.suncode.AboutWindow.superclass.initComponent.call(this);

		this.on('beforeshow', lockHotkeys);
		this.on('beforeclose', unlockHotkeys);
	}
});

Ext.ux.suncode.FormVariableChooser = function(config) {
	var drawingPanel = Ext.getCmp('drawing_panel');
	var processNode = drawingPanel.activityNode.parentNode;

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'id',
				type : 'string'
			}, {
				name : 'name',
				type : 'string'
			} ])
		})
	});

	var r = store.recordType;
	drawingPanel.items.each(function(item) {
		item.items.each(function(subitem) {
			var objectDef = subitem.definition.objectDef;

			if (subitem.idAssigned && objectDef.genre == 'VARIABLE') {
				var v = new r({
					name : objectDef.name,
					id : objectDef.varId
				});
				store.add(v);
			} else if (config.acceptVariableSets && subitem.idAssigned && objectDef.genre == 'VARIABLE_SET') {
				Ext.each(objectDef.columns, function(column, index, columns) {
					var variable = processNode.findVariable(column.varId);
					var v = new r({
						name : variable.name,
						id : column.varId
					});
					store.add(v);
				});
			}
		});
	});

	config = Ext.apply({
		anchor : '100%',
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'id',
		displayField : 'name',
		flex : 1
	}, config);

	Ext.ux.suncode.FormVariableChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.FormVariableChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.FormVariableChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.CopyFromActivityWindow = function(config) {
	var activityNode = config.activityNode;
	var processNode = activityNode.parentNode;

	config = Ext.apply({
		modal : true,
		autoWidth : true,
		autoHeight : true,
		title : getTranslation('Wybór zadania'),
		items : [ {
			xtype : 'panel',
			border : false,
			frame : false,
			buttonAlign : 'center',
			ref : 'activitiesPanel',
			bodyCssClass: 'x-Module-container-padding',
			items : [ new Ext.ux.suncode.ActivitiesChooser({
				processNode : processNode,
				excluded : [ activityNode.attributes.activityDefId ],
				acceptedTypes : [ Ext.ux.suncode.Constants.ACTIVITY, Ext.ux.suncode.Constants.ROUTE,
						Ext.ux.suncode.Constants.TOOL, Ext.ux.suncode.Constants.SUBFLOW ],
				ref : 'activitiesChooser',
				width: 400
			}) ],
			buttons : [ {
				text : getTranslation('Kopiuj'),
				cls : 'x-btn-text-icon',
				scope : this,
				handler : this.copy
			} ]
		} ]
	}, config);

	Ext.ux.suncode.CopyFromActivityWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.CopyFromActivityWindow, Ext.Window, {
	initComponent : function() {
		Ext.ux.suncode.CopyFromActivityWindow.superclass.initComponent.call(this);
	},
	copy : function() {
		var choosenActivityNode = this.getChoosenActivityNode();
		if (!choosenActivityNode) {
			return;
		}
		
		var maskId = 'copy_mask';

        try {
            showLoadingMask( maskId, getTranslation( 'Trwa kopiowanie...' ) );

            var copyFunction = this.initialConfig.copyFunction;
            
            if ( Ext.isFunction( copyFunction ) ) {
            	var copyScope = !Ext.isEmpty( this.initialConfig.copyScope ) ? this.initialConfig.copyScope : window;
            	copyFunction.apply( copyScope, [ choosenActivityNode ] );
            }
            
    		this.close();
        }
        finally {
            removeLoadingMask( maskId );
        }
	},
	getChoosenActivityNode : function() {
		var activityDefId = this.activitiesPanel.activitiesChooser.getValue();

		if (Ext.isEmpty(activityDefId)) {
			showWarn(getTranslation('Wybierz zadanie.'));
			return null;
		}

		var activityNode = this.initialConfig.activityNode;
		var processNode = activityNode.parentNode;
		var processDefId = processNode.attributes.processDefId;

		return Ext.getCmp('package_panel').findActivity(processDefId, activityDefId);
	}
});

Ext.ux.suncode.RunnableTask = function(config) {
	var handler = Ext.isFunction(config.handler) ? config.handler : Ext.emptyFn;
	var scope = !Ext.isEmpty(config.scope) ? config.scope : window;
	var args = Ext.isArray(config.args) ? config.args : [];

	this.run = function() {
		handler.apply(scope, args);
	};
};

Ext.ux.suncode.TreeNodeInternalDropConfig = function() {
	return {
		onNodeOver : function(n, dd, e, data) {
			var pt = this.getDropPoint(e, n, dd);
			var node = n.node;

			if (!this.expandProcId && pt == 'append' && node.hasChildNodes() && !n.node.isExpanded()) {
				this.queueExpand(node);
			} else if (pt != 'append') {
				this.cancelExpand();
			}

			var returnCls = this.dropNotAllowed;

			if (data.node.parentNode.id == n.node.id)
				if (this.isValidDropPoint(n, pt, dd, e, data)) {
					if (pt) {
						var el = n.ddel;
						var cls;
						if (pt != 'above' && pt != 'below') {
							returnCls = 'x-tree-drop-ok-append';
							cls = 'x-tree-drag-append';
						}
						if (this.lastInsertClass != cls) {
							Ext.fly(el).replaceClass(this.lastInsertClass, cls);
							this.lastInsertClass = cls;
						}
					}
				}

			if (data.node.parentNode.id == n.node.parentNode.id) {
				if (this.isValidDropPoint(n, pt, dd, e, data)) {
					if (pt) {
						var el = n.ddel;
						var cls;
						if (pt == 'above') {
							returnCls = n.node.isFirst() ? 'x-tree-drop-ok-above' : 'x-tree-drop-ok-between';
							cls = 'x-tree-drag-insert-above';
						} else if (pt == 'below') {
							returnCls = n.node.isLast() ? 'x-tree-drop-ok-below' : 'x-tree-drop-ok-between';
							cls = 'x-tree-drag-insert-below';
						} else {
							returnCls = 'x-tree-drop-ok-append';
							cls = 'x-tree-drag-append';
						}
						if (this.lastInsertClass != cls) {
							Ext.fly(el).replaceClass(this.lastInsertClass, cls);
							this.lastInsertClass = cls;
						}
					}
				}
			}

			return returnCls;
		},
		onNodeDrop : function(n, dd, e, data) {
			var point = this.getDropPoint(e, n, dd);
			var targetNode = n.node;
			targetNode.ui.startDrop();

			if (!this.isValidDropPoint(n, point, dd, e, data)) {
				targetNode.ui.endDrop();
				return false;
			}
			if (data.node.parentNode.id != n.node.parentNode.id && data.node.parentNode.id != n.node.id) {
				return false;
			}

			var dropNode = data.node || (dd.getTreeNode ? dd.getTreeNode(data, targetNode, point, e) : null);
			var dropEvent = {
				tree : this.tree,
				target : targetNode,
				data : data,
				point : point,
				source : dd,
				rawEvent : e,
				dropNode : dropNode,
				cancel : !dropNode
			};

			var retval = this.tree.fireEvent('beforenodedrop', dropEvent);
			if (retval === false || dropEvent.cancel === true || !dropEvent.dropNode) {
				targetNode.ui.endDrop();
				return false;
			}

			targetNode = dropEvent.target;
			if (point == 'append' && !targetNode.isExpanded()) {
				targetNode.expand(false, null, function() {
					this.completeDrop(dropEvent);
				}.createDelegate(this));
			} else {
				this.completeDrop(dropEvent);
			}

			dropNode.ui.removeClass('x-tree-node-over');

			return true;
		}
	};
};

Ext.ux.suncode.IdField = function(config) {
	config = Ext.apply({
		allowBlank : false,
    blankText : getTranslation('Pole jest wymagane'),
    msgTarget: 'under',
    invalidClass: 'x-Module-warningField'
	}, config);

	Ext.ux.suncode.IdField.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.IdField, Ext.form.TextField, {
	initComponent : function() {
		Ext.ux.suncode.IdField.superclass.initComponent.call(this);
		
		this.on( 'blur', this.onIdFieldBlur, this );
	},
	onIdFieldBlur : function(field) {
    var oldId = this.originalValue;
		var newId = generateId(this.getValue(), this.initialConfig.idMaxLength);
		this.setValue(newId);

		if (!areIdsTheSame(oldId, newId)) {
			this.onChangeId(oldId, newId);

			if (this.initialConfig.idChanged) {
        this.markInvalid(getTranslation('Identyfikator zostanie zmieniony po zapisaniu okna definicji.'));
			}
    } else {
      this.clearInvalid();
    }
	},
	onChangeId : function(oldId, newId) {
		var afterSetIdFunction = this.initialConfig.afterSetIdFunction;

		if (Ext.isFunction(afterSetIdFunction)) {
			var afterSetIdScope = !Ext.isEmpty(this.initialConfig.afterSetIdScope) ? this.initialConfig.afterSetIdScope
					: window;
			afterSetIdFunction.apply(afterSetIdScope, [ oldId, newId ]);
		}
	}
});

Ext.ux.suncode.VariableSetAvailableColumnChooser = function(config) {
	var globalDefinition = config.globalDefinition;
	var processNode = config.processNode;
	var variables = processNode.attributes.variables;

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'id',
				type : 'string'
			}, {
				name : 'name',
				type : 'string'
			}, {
				name : 'descr',
				type : 'string'
			} ])
		})
	});

	var forbiddenTypes = [ 'RADIOBUTTON', 'BOOLEAN', 'DATETIME' ];
	var usedIds = new Array();

	if ( globalDefinition ) {
	  Ext.each( processNode.attributes.tables, function( table, tableIndex, allTables ) {
	    Ext.each( table.columns, function( column, columnIndex, allColumns ) {
        usedIds.push( column.varId );
      } );
    } );
  } else {
    var drawingPanel = Ext.getCmp('drawing_panel');
    drawingPanel.items.each(function(item) {
      item.items.each(function(subitem) {
        var objectDef = subitem.definition.objectDef;

        if (subitem.idAssigned) {
          if (objectDef.genre == 'VARIABLE') {
            usedIds.push(objectDef.varId);
          } else if (objectDef.genre == 'VARIABLE_SET') {
            Ext.each(objectDef.columns, function(column, index, columns) {
              usedIds.push(column.varId);
            });
          }
        }
      });
    });
  }

	if (!Ext.isEmpty(variables)) {
		var filteredVariables = new Array();

		Ext.each(variables, function(v, index, vs) {
			if (usedIds.indexOf(v.id) == -1 && forbiddenTypes.indexOf(v.type) == -1 &&
					(Ext.isEmpty(v.placement) || v.placement=='table')) {
				filteredVariables.push(v);
			}
		});

		store.loadData(filteredVariables);
		store.commitChanges();
		store.sort('name', 'ASC');
	}

	var varsTpl = new Ext.XTemplate('<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font '
			+ getTemplateStyle() + '><b>' + getTranslation('Nazwa zmiennej') + ': '
			+ '</b></font><span>{name}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
			+ getTranslation('Opis zmiennej') + ': ' + '</b></font><span>{descr}</span></div></div>',
			'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>');
	varsTpl = varsTpl.compile();

	config = Ext.apply({
		anchor : '100%',
		triggerAction : 'all',
		mode : 'local',
    forceSelection : true,
		store : store,
		valueField : 'id',
		displayField : 'name',
		tpl : varsTpl,
		itemSelector : 'div.x-Module-comboTemplateItem',
		flex : 1,
		resizable : true
	}, config);

	Ext.ux.suncode.VariableSetAvailableColumnChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.VariableSetAvailableColumnChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.VariableSetAvailableColumnChooser.superclass.initComponent.call(this);
	},
	updateTitle : function() {
		this.compileTemplate();
	},
	compileTemplate : function() {
		this.initialConfig.tpl.compile();
	}
});

Ext.ux.suncode.ActionAcceptButtonOverrideSettingChooser = function(config) {
	var settings = [ [ '', getTranslation('Korzystaj z konfiguracji zadania') ], [ 'true', getTranslation('Tak') ],
			[ 'false', getTranslation('Nie') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		anchor : '100%',
		store : new Ext.data.ArrayStore({
			fields : [ 'setting', 'settingName' ],
			data : settings
		}),
		valueField : 'setting',
		displayField : 'settingName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.ActionAcceptButtonOverrideSettingChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ActionAcceptButtonOverrideSettingChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.ActionAcceptButtonOverrideSettingChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AcceptedNextActivitiesGrid = function( config ) {
	var activityNode = config.activityNode;
	var nextActivityChooser = new Ext.ux.suncode.NextActivityChooser( {
        activityNode: activityNode
    } );
	
	var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'activityDefId',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( config.acceptedNextActivities ) ) {
    	store.loadData( config.acceptedNextActivities );
    	store.commitChanges();
    }
	
    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        height: 230,
        frame: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ {
                id: 'activityDefId',
                header: getTranslation( 'Zadanie' ),
                dataIndex: 'activityDefId',
                align: 'left',
                editor: nextActivityChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( nextActivityChooser )
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var a = store.recordType;
                    var rec = new a( {
                        activityDefId: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz zadanie do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.AcceptedNextActivitiesGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AcceptedNextActivitiesGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.AcceptedNextActivitiesGrid.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.CloseWindowButton = function( config ) {
    config = Ext.apply( {
    	cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow
    }, config );

    Ext.ux.suncode.CloseWindowButton.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CloseWindowButton, Ext.Button, {
    initComponent: function() {
        Ext.ux.suncode.CloseWindowButton.superclass.initComponent.call( this );
    },
    closeWindow: function() {
    	var win = this.initialConfig.win;
    	win.close();
    }
} );

Ext.ux.suncode.ServerErrorWindow = function(config) {
	var viewSize = Ext.getBody().getViewSize();
	var windowWidth = viewSize.width * 0.9;
	
	config = Ext.apply({
		modal : true,
		width: windowWidth,
		autoHeight : true,
		title : getTranslation('Błąd serwera'),
		items : [ {
			xtype : 'panel',
			border : false,
			frame : false,
			layout: 'form',
			bodyCssClass: 'x-Module-container-padding',
			items : [ {
	            xtype: 'displayfield',
	            fieldLabel: getTranslation( 'Komunikat błędu' ),
	            anchor: '100%',
	            value: config.message
	        }, {
	            xtype: 'textarea',
	            fieldLabel: getTranslation( 'Ścieżka błędu' ),
	            height: viewSize.height * 0.7,
	            anchor: '100%',
	            readOnly: true,
	            value: config.stackTrace
	        } ]
		} ],
		tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveError,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
	}, config);

	Ext.ux.suncode.ServerErrorWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ServerErrorWindow, Ext.Window, {
	initComponent : function() {
		Ext.ux.suncode.ServerErrorWindow.superclass.initComponent.call(this);
	},
	saveError: function() {
    	var mainPanel = Ext.getCmp( 'main_panel' );

        var form = jQuery( '<form/>', { action: 'api/servererror/save', method:'post' } );
				form.append( jQuery( '<input>', { type: 'text', name: Suncode.getCsrfParameterName(), value: Suncode.getCsrfToken() } ) );
				form.append( jQuery( '<input>', { type: 'text', name: 'message', value: this.initialConfig.message } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'stackTrace', value: this.initialConfig.stackTrace } ) );
        
        var iframe = jQuery( '#download-frame' );
        iframe.empty();
        iframe.append( form );
        
        mainPanel.setCheckSavedOnUnload( false );
        
        form.submit();
        
        var task = new Ext.util.DelayedTask( function() {
            mainPanel.setCheckSavedOnUnload( true );
        }, this );
        task.delay( 1000 );
    },
    closeWindow: function() {
        this.close();
    }
});

Ext.ux.suncode.DTButtonTypesChooser = function(config) {
	var options = [ [ 'HANDLER', getTranslation('Funkcja zdarzenia') ], [ 'FORM_ACTIONS', getTranslation('Akcje') ] ];

	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : new Ext.data.ArrayStore({
			fields : [ 'type', 'typeName' ],
			data : options
		}),
		valueField : 'type',
		displayField : 'typeName',
		forceSelection : true,
		editable : false
	}, config);

	Ext.ux.suncode.DTButtonTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.DTButtonTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.DTButtonTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.AllLabelsChooser = function(config) {
	var labels = config.labels;

	var store = new Ext.data.Store({
		reader : new Ext.data.JsonReader({
			fields : Ext.data.Record.create([ {
				name : 'id',
				type : 'string'
			}, {
				name : 'name',
				type : 'string'
			} ])
		})
	});

	store.loadData( labels );
    store.commitChanges();

	if (store.getCount() > 0) {
		store.sort('name', 'ASC');
	}

	config = Ext.apply({
		anchor : '100%',
		ref : 'labelsChooser',
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'id',
		displayField : 'name',
		flex : 1,
		resizable : true
	}, config);

	Ext.ux.suncode.AllLabelsChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.AllLabelsChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.AllLabelsChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.VariablesCollactionActivityTypesChooser = function(config) {
	config = config ? config : new Object();
	
	config = Ext.apply({
		triggerAction : 'all',
		mode : 'local',
		store : new Ext.data.Store({
			data: [ {
				type: 'ALL',
				typeName: getTranslation( 'Wszystkie' )
			}, {
				type: Ext.ux.suncode.Constants.ACTIVITY,
				typeName: getTranslation( 'Zadanie' )
			}, {
				type: Ext.ux.suncode.Constants.TOOL,
				typeName: getTranslation( 'Narzędzie' )
			}, {
				type: Ext.ux.suncode.Constants.SUBFLOW,
				typeName: getTranslation( 'Podproces' )
			} ],
			reader : new Ext.data.JsonReader({
				fields : Ext.data.Record.create([ {
					name : 'type',
					type : 'string'
				}, {
					name : 'typeName',
					type : 'string'
				} ])
			})
		}),
		valueField : 'type',
		displayField : 'typeName',
		forceSelection: true,
        editable: false,
		resizable : true
	}, config);

	Ext.ux.suncode.VariablesCollactionActivityTypesChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.VariablesCollactionActivityTypesChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.VariablesCollactionActivityTypesChooser.superclass.initComponent.call(this);
	}
});

Ext.ux.suncode.YesNoChooser = function( config ) {
  var options = [ [ true, getTranslation( 'Tak' ) ], [ false, getTranslation( 'Nie' ) ] ];

  config = Ext.apply({
    triggerAction : 'all',
    mode : 'local',
    emptyText: getTranslation( 'Domyślny' ),
    store : new Ext.data.ArrayStore({
      fields : [ {
        name: 'option',
        type: 'boolean'
      }, {
        name: 'optionName',
        type: 'string'
      } ],
      data : options
    }),
    valueField : 'option',
    displayField : 'optionName',
    forceSelection : true
  }, config);

  Ext.ux.suncode.YesNoChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.YesNoChooser, Ext.form.ComboBox, {
  initComponent : function() {
    Ext.ux.suncode.YesNoChooser.superclass.initComponent.call(this);
  }
});

Ext.ux.suncode.ClicksToEditChooser = function( config ) {
  var options = [ [ 1, getTranslation( '1' ) ], [ 2, getTranslation( '2' ) ] ];

  config = Ext.apply({
    fieldLabel: getTranslation( 'Ilość kliknięć dla edycji' ),
    triggerAction : 'all',
    mode : 'local',
    store : new Ext.data.ArrayStore({
      fields : [ {
        name: 'option',
        type: 'integer'
      }, {
        name: 'optionName',
        type: 'string'
      } ],
      data : options
    }),
    valueField : 'option',
    displayField : 'optionName',
    forceSelection : true
  }, config);

  Ext.ux.suncode.ClicksToEditChooser.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.suncode.ClicksToEditChooser, Ext.form.ComboBox, {
  initComponent : function() {
    Ext.ux.suncode.ClicksToEditChooser.superclass.initComponent.call(this);
  }
});

Ext.ux.suncode.DeprecatedApplicationsWindow = function( config ) {
  var windowWidth = Ext.getBody().getViewSize().width * 0.5;

  config = Ext.apply( {
    modal: true,
    width: windowWidth,
    autoHeight: true,
    title: getTranslation( 'Przestarzałe aplikacje' ),
    tbar: new Ext.Toolbar( {
      buttons: [ {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this
      } ]
    } ),
    items: [ new Ext.ux.suncode.DeprecatedApplicationsPanel( config ) ]
  }, config );

  Ext.ux.suncode.DeprecatedApplicationsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeprecatedApplicationsWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.DeprecatedApplicationsWindow.superclass.initComponent.call( this );
  },
  closeWindow: function() {
    this.close();
  }
} );

Ext.ux.suncode.DeprecatedApplicationsPanel = function( config ) {
  config = Ext.apply( {
    height: 400,
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    store: new Ext.data.Store( {
      data: config.deprecatedApplications,
      reader: new Ext.data.JsonReader( {
        fields: Ext.data.Record.create( [ {
          name: 'processName',
          type: 'string'
        }, {
          name: 'applicationName',
          type: 'string'
        } ] )
      } )
    } ),
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        header: getTranslation( 'Nazwa procesu' ),
        dataIndex: 'processName',
        align: 'left'
      }, {
        header: getTranslation( 'Nazwa aplikacji' ),
        dataIndex: 'applicationName',
        align: 'left'
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak przestarzałych aplikacji' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } )
  }, config );

  Ext.ux.suncode.DeprecatedApplicationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeprecatedApplicationsPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.DeprecatedApplicationsPanel.superclass.initComponent.call( this );
  }
} );