var labelItems = null;

function readFormTemplates( formTemplates ) {
  var packagePanel = Ext.getCmp( 'package_panel' );
  labelItems = new HashMap();

  for ( var i = 0; i < formTemplates.length; i++ ) {
    readFormTemplate( packagePanel, formTemplates[i].FormTemplate );
  }
}

function readFormTemplate( packagePanel, formTemplate ) {
  labelItems.clear();
  var processDefId = '';
  var activityDefId = '';
  var template = new Object();
  var formStyles = {
    showLines: null
  };
  var formSettings = {
    showProcessAndActivityNames: true,
    showComments: true,
    documentsViewLocation: 'right',
    hideSaveButton: false
  };

  for ( var i = 0; i < formTemplate.length; i++ ) {
    var formTemplateEl = formTemplate[i];

    if ( formTemplateEl.processDefId ) {
      processDefId = formTemplate[i].processDefId;
    } else if ( formTemplateEl.activityDefId ) {
      activityDefId = formTemplate[i].activityDefId;
    } else if ( formTemplateEl.Styles ) {
      formStyles = readFormTemplateFormStyles( formStyles, formTemplateEl.Styles );
    } else if ( formTemplateEl.Settings ) {
      formSettings = readFormTemplateFormSettings( formSettings, formTemplateEl.Settings );
    } else if ( formTemplateEl.Rows ) {
      template = Ext.apply( {
        rows: readFormTemplateRows( formTemplateEl.Rows )
      }, template );
    }
  }

  try {
    var processNode = packagePanel.findProcess( processDefId );

    labelItems.each( function( key, value ) {
      var label = processNode.findLabel( key );

      if ( Ext.isEmpty( label ) ) {
        processNode.addLabel( {
          id: key,
          name: value.text
        } );
      }
    } );

    if ( !Ext.isEmpty( template.rows ) ) {
      Ext.each( template.rows, function( row, outerIndex, rows ) {
        if ( !Ext.isEmpty( row.items ) ) {
          Ext.each( row.items, function( item, innerIndex, items ) {
            if ( item.type == 'FLOAT' ) {
              var variable = processNode.findVariable( item.id );

              if ( !Ext.isEmpty( variable ) && variable.type != item.type ) {
                item.type = variable.type;
              }
            }
          } );
        }
      } );
    }

    var activityNode = packagePanel.findActivity( processDefId, activityDefId );
    activityNode.setFormStyles( formStyles );
    activityNode.setFormSettings( formSettings );
    activityNode.loadFormTemplate( template );
  }
  catch ( e ) {
    logFormTemplateReaderError( processDefId, activityDefId );
  }
}

function readFormTemplateFormStyles( formStyles, styles ) {
  for ( var i = 0; i < styles.length; i++ ) {
    var style = styles[i];

    if ( style.ShowLines ) {
      formStyles.showLines = parseBoolean( style.ShowLines[0].value );
    }
  }

  return formStyles;
}

function readFormTemplateFormSettings( formSettings, settings ) {
  for ( var i = 0; i < settings.length; i++ ) {
    var setting = settings[i];

    if ( setting.DocumentsViewLocation ) {
      formSettings.documentsViewLocation = setting.DocumentsViewLocation[0].value;
    } else if ( setting.ShowProcessAndActivityNames ) {
      formSettings.showProcessAndActivityNames = parseBoolean( setting.ShowProcessAndActivityNames[0].value );
    } else if ( setting.ShowComments ) {
      formSettings.showComments = parseBoolean( setting.ShowComments[0].value );
    } else if ( setting.HideSaveButton ) {
      formSettings.hideSaveButton = parseBoolean( setting.HideSaveButton[0].value );
    }
  }

  return formSettings;
}

function readFormTemplateRows( formTemplateRows ) {
  var rows = new Array();

  for ( var i = 0; i < formTemplateRows.length; i++ ) {
    if ( formTemplateRows[i].Row ) {
      rows.push( readFormTemplateRow( formTemplateRows[i].Row ) );
    }
  }

  return rows;
}

function readFormTemplateRow( formTemplateRow ) {
  var row = new Object();
  var items = new Array();

  for ( var i = 0; i < formTemplateRow.length; i++ ) {
    if ( formTemplateRow[i].Item ) {
      items.push( readFormTemplateRowItem( formTemplateRow[i].Item ) );
    } else if ( formTemplateRow[i].pack ) {
      row = Ext.apply( {
        layoutPack: formTemplateRow[i].pack
      }, row );
    }
  }

  row = Ext.apply( {
    items: items
  }, row );

  return row;
}

function readFormTemplateRowItem( formTemplateItem ) {
  var item = new Object();

  for ( var i = 0; i < formTemplateItem.length; i++ ) {
    if ( formTemplateItem[i].id ) {
      item = Ext.apply( item, {
        id: formTemplateItem[i].id
      } );
    } else if ( formTemplateItem[i].type ) {
      var type = formTemplateItem[i].type;

      item = Ext.apply( item, {
        type: type == 'FORMAMOUNT' ? 'AMOUNT' : type
      } );
    } else if ( formTemplateItem[i].Size ) {
      var size = formTemplateItem[i].Size;

      for ( var j = 0; j < size.length; j++ ) {
        if ( size[j].Width ) {
          item = Ext.apply( item, {
            width: parseInt( size[j].Width[0].value )
          } );
        } else if ( size[j].Height ) {
          item = Ext.apply( item, {
            height: parseInt( size[j].Height[0].value )
          } );
        }
      }
    } else if ( formTemplateItem[i].Label ) {
      var label = formTemplateItem[i].Label;

      for ( var j = 0; j < label.length; j++ ) {
        if ( !Ext.isEmpty( label[j].Align ) ) {
          item = Ext.apply( item, {
            labelAlign: label[j].Align[0].value
          } );
        } else if ( !Ext.isEmpty( label[j].Width ) ) {
          item = Ext.apply( item, {
            labelWidth: parseInt( label[j].Width[0].value )
          } );
        } else if ( !Ext.isEmpty( label[j].Separator ) ) {
          item = Ext.apply( item, {
            labelSeparator: label[j].Separator[0].value
          } );
        } else if ( !Ext.isEmpty( label[j].FontSize ) ) {
          item = Ext.apply( item, {
            labelFontSize: label[j].FontSize[0].value
          } );
        } else if ( !Ext.isEmpty( label[j].Color ) ) {
          item = Ext.apply( item, {
            labelColor: label[j].Color[0].value
          } );
        } else if ( !Ext.isEmpty( label[j].TextDecoration ) ) {
          item = Ext.apply( item, {
            textDecoration: label[j].TextDecoration[0].value
          } );
        } else if ( !Ext.isEmpty( label[j].Hidden ) ) {
          item = Ext.apply( item, {
            hideLabel: parseBoolean( label[j].Hidden[0].value )
          } );
        }
      }
    } else if ( formTemplateItem[i].LookAndFeel ) {
      var lookAndFeel = formTemplateItem[i].LookAndFeel;

      for ( var j = 0; j < lookAndFeel.length; j++ ) {
        if ( !Ext.isEmpty( lookAndFeel[j].MarginTop ) ) {
          item = Ext.apply( item, {
            marginTop: lookAndFeel[j].MarginTop[0].value
          } );
        } else if ( !Ext.isEmpty( lookAndFeel[j].MarginRight ) ) {
          item = Ext.apply( item, {
            marginRight: parseInt( lookAndFeel[j].MarginRight[0].value )
          } );
        } else if ( !Ext.isEmpty( lookAndFeel[j].MarginBottom ) ) {
          item = Ext.apply( item, {
            marginBottom: lookAndFeel[j].MarginBottom[0].value
          } );
        } else if ( !Ext.isEmpty( lookAndFeel[j].MarginLeft ) ) {
          item = Ext.apply( item, {
            marginLeft: lookAndFeel[j].MarginLeft[0].value
          } );
        }
      }
    } else if ( formTemplateItem[i].Text ) {
      var text = formTemplateItem[i].Text;

      item = Ext.apply( item, {
        text: decodeTextFromXpdl( text[0].value )
      } );
    } else if ( formTemplateItem[i].Styles ) {
      var styles = formTemplateItem[i].Styles;

      for ( var j = 0; j < styles.length; j++ ) {
        if ( !Ext.isEmpty( styles[j].FontSize ) ) {
          item = Ext.apply( item, {
            fontSize: styles[j].FontSize[0].value
          } );
        } else if ( !Ext.isEmpty( styles[j].Color ) ) {
          item = Ext.apply( item, {
            color: styles[j].Color[0].value
          } );
        } else if ( !Ext.isEmpty( styles[j].Icon ) ) {
          item = Ext.apply( item, {
            icon: styles[j].Icon[0].value
          } );
        }
      }
    } else if ( formTemplateItem[i].Font ) {
      var font = formTemplateItem[i].Font;

      for ( var j = 0; j < font.length; j++ ) {
        if ( font[j].HeaderFontSize ) {
          item = Ext.apply( item, {
            headerFontSize: font[j].HeaderFontSize[0].value
          } );
        } else if ( font[j].CellFontSize ) {
          item = Ext.apply( item, {
            cellFontSize: font[j].CellFontSize[0].value
          } );
        }
      }
    }
  }

  if ( item.type === 'VARIABLE_SET' ) {
    item = Ext.apply( {
      headerFontSize: null,
      cellFontSize: null
    }, item );
  } else if ( item.type === 'LABEL' ) {
    labelItems.put( item.id, item );
  } else if ( !( item.type == 'GENERATE_PDF_BUTTON' || item.type == 'ACTION_ACCEPT_BUTTON'
      || item.type == 'ADD_FILE_BUTTON' || item.type == 'BARCODE_PRINT'
      || item.type == 'HTTP_LINK' ) ) {
    item = Ext.apply( {
      labelAlign: '',
      labelWidth: null,
      labelSeparator: '',
      labelFontSize: null,
      labelColor: '',
      textDecoration: '',
      hideLabel: false,
      width: null
    }, item );

    if ( item.type == 'TEXTAREA' ) {
      item = Ext.apply( {
        height: 100
      }, item );
    }
  }

  return item;
}