Ext.ux.suncode.LabelDefPanel = function( config ) {
    var component = config.component;
    var objectDef = component.definition.objectDef;
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var labels = processNode.attributes.labels;
    var drawingPanel = Ext.getCmp( 'drawing_panel' );
    var mainPanel = Ext.getCmp( 'main_panel' );
    var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();
    
    var labelChooserContainerItems = new Array();
    labelChooserContainerItems.push( new Ext.ux.suncode.AllLabelsChooser( {
    	labels: labels,
        value: component.idAssigned ? objectDef.id : '',
        readOnly: component.isLabel
    } ) );

    if ( !component.isLabel ) {
    	labelChooserContainerItems.push( {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'label_add' ),
            tooltip: getTranslation( 'Dodaj etykietę' ),
            flex: 0,
            handler: this.addProcessLabel,
            scope: this
        } );
    }

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 250,
        autoHeight: true,
        ref: 'labelPanel',
        items: [ {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'labelChooserContainer',
            fieldLabel: getTranslation( 'Tekst' ),
            items: labelChooserContainerItems
        }, {
            xtype: 'numberfield',
            fieldLabel: getTranslation( 'Rozmiar czcionki' ),
            anchor: '100%',
            ref: 'fontSizeItem',
            allowDecimals: false,
            allowNegative: false,
            value: objectDef.fontSize
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'colorItem',
            fieldLabel: getTranslation( 'Kolor' ),
            items: [ {
                xtype: 'textfield',
                flex: 1,
                isFormField: true,
                style: 'background: ' + objectDef.color + ';',
                color: objectDef.color,
                readOnly: true
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'color_wheel' ),
                tooltip: getTranslation( 'Wybierz kolor' ),
                flex: 0,
                handler: this.chooseLabelColor,
                scope: this
            } ]
        }, {
          xtype: 'numberfield',
          fieldLabel: getTranslation( 'Margines górny' ),
          allowDecimals: false,
          allowNegative: false,
          anchor: '100%',
          ref: 'marginTopItem',
          emptyText: getTranslation( 'Domyślna' ),
          value: objectDef.marginTop
        }, {
          xtype: 'numberfield',
          fieldLabel: getTranslation( 'Margines prawy' ),
          allowDecimals: false,
          allowNegative: false,
          anchor: '100%',
          ref: 'marginRightItem',
          emptyText: getTranslation( 'Domyślna' ),
          value: objectDef.marginRight
        }, {
          xtype: 'numberfield',
          fieldLabel: getTranslation( 'Margines dolny' ),
          allowDecimals: false,
          allowNegative: false,
          anchor: '100%',
          ref: 'marginBottomItem',
          emptyText: getTranslation( 'Domyślna' ),
          value: objectDef.marginBottom
        }, {
          xtype: 'numberfield',
          fieldLabel: getTranslation( 'Margines lewy' ),
          allowDecimals: false,
          allowNegative: false,
          anchor: '100%',
          ref: 'marginLeftItem',
          emptyText: getTranslation( 'Domyślna' ),
          value: objectDef.marginLeft
        }, new Ext.ux.suncode.IntegrationComponentTable( {
            ref: 'formActionsGrid',
            title: getTranslation( 'Akcje formularza' ),
            height: 250,
            frame: false,
            components: objectDef.formActions,
            filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
                formActionsCategories, Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION, false ),
            allCategories: formActionsCategories,
            processNode: processNode,
            pasteComponentsValidation: {
                func: function( variableId ) {
                    var presentVariableIds = this.getPresentVariableIds();

                    return presentVariableIds.includes( variableId );
                },
                scope: drawingPanel,
                invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
            },
            enableCopyPasteMenu: true,
            conditionalExecutionEnabled: true,
            inactiveEnabled: true,
            parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
            availableVariables: config.availableVariables,
            missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: config.missingVariablesValidatorScope,
            systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
            getBindToFunction: function( component ) {
                var labelDestination = Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION;
                var destination = Ext.ux.suncode.IntegrationComponentService.getDestination( component, labelDestination );

                return !Ext.isEmpty( destination ) ? {
                    id: destination.bindTo,
                    value: this.labelChooserContainer.items.first().getValue()
                } : null;
            },
            getBindToScope: this,
            getComponentRegistrationFunction: function( id ) {
            	return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
            },
            getComponentRegistrationScope: this,
            copyComponentsFunction: function( components ) {
            	Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( components );
            },
            copyComponentsScope: this,
            handleCopiedComponentsFunction: function( func, scope ) {
              Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
                if ( Ext.isFunction( func ) ) {
                  var components = new Array();

                  if ( !Ext.isEmpty( formActions ) ) {
                    var service = Ext.ux.suncode.IntegrationComponentService;
                    var categories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();

                    Ext.each( formActions, function( component, index, allComponents ) {
                      var componentDef = service.getIntegrationComponent( categories, component.id );

                      if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.LABEL_DESTINATION, false ) ) {
                        components.push( component );
                      }
                    } );
                  }

                  scope = !Ext.isEmpty( scope ) ? scope : window;
                  func.apply( scope, [ components ] );
                }
              }, this );
            },
            handleCopiedComponentsScope: this,
            pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
            validateFieldFunction: config.validateIntegrationComponentFieldFunction,
            validateFieldScope: config.validateIntegrationComponentFieldScope,
            validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
            validateRowScope: drawingPanel,
            destinationType: Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION,
            modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
              var labelChooser = this.labelChooserContainer.items.first();
              var labelId = labelChooser.getValue();
              var formActionUpdate = {
                customDescription: extraConfig.customDescription,
                condition: condition,
                inactive: extraConfig.inactive,
                modificationDate: extraConfig.customDescription,
                parameters: values
              };

              Ext.each( objectDef.formActions, function( formAction, index, formActions ) {
                if ( formAction.globalId == globalId ) {
                  Ext.apply( formAction, formActionUpdate );
                }
              } );

              processNode.updateLabelFormAction( labelId, globalId, formActionUpdate );
            },
            modifyGlobalDefinitionScope: this
        } ) ]
    }, config );

    Ext.ux.suncode.LabelDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.LabelDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.LabelDefPanel.superclass.initComponent.call( this );
    },
    addProcessLabel: function() {
    	var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var labelChooser = this.labelChooserContainer.items.first();
        var record = labelChooser.getStore().recordType;

        var win = new Ext.ux.suncode.LabelDefWindow( {
            processNode: processNode,
            saveTo: labelChooser,
            labelRecord: record,
            setToObj: labelChooser
        } );
        win.show();
    },
    chooseLabelColor: function( button, e ) {
        closeColorChooser();

        var me = this;
        var labelColorField = this.colorItem.items.first();
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor etykiety' ),
            e: e,
            color: labelColorField.color,
            saveFunction: function( choosenColor ) {
                labelColorField.getEl().setStyle( 'background', choosenColor );
                labelColorField.color = choosenColor;
                me.storeParentWindowAsUnsaved();
            }
        } );
        colorChooser.show();
    },
    editLabel: function() {
        var labelDef = this.readDef();
        if ( !labelDef ) {
            return;
        }

        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var processVariablesCopy = [].concat( processNode.attributes.variables );
        var component = this.initialConfig.component;
        var drawingPanel = Ext.getCmp( 'drawing_panel' );
        var label = processNode.findLabel( labelDef.id );
        var labelsTree = drawingPanel.ownerCt.labelsTree;
        labelsTree.markAsUsed( label );

        var item = new Object();
        item = Ext.apply( {
          id: labelDef.id,
          type: component.type,
          text: labelDef.text,
          fontSize: labelDef.fontSize,
          color: labelDef.color,
          marginTop: labelDef.marginTop,
          marginRight: labelDef.marginRight,
          marginBottom: labelDef.marginBottom,
          marginLeft: labelDef.marginLeft
        }, item );

        var newComponent = {
          processVariables: processVariablesCopy,
          item: item
        };

        var componentContainer = component.ownerCt;
        var index = componentContainer.items.indexOf( component );
        componentContainer.suspendEvents();
        componentContainer.remove( component );
        componentContainer.resumeEvents();
        componentContainer.insert( index, drawingPanel.createFormVariable( newComponent, false, false, false, true, labelDef ) );
        componentContainer.doLayout();
        componentContainer.ownerCt.doLayout();
        this.ownerCt.closeDefWindow();
    },
    readDef: function() {
        var labelDef = new Object();
        var labelChooser = this.labelChooserContainer.items.first();
        var id = labelChooser.getValue();
        var text = labelChooser.getRawValue();
        var fontSize = this.fontSizeItem.getValue();

        if ( Ext.isEmpty( id ) ) {
            showWarn( getTranslation( 'Wybierz etykietę.' ) );
            return null;
        } else if ( Ext.isEmpty( fontSize ) ) {
          showWarn( getTranslation( 'Podaj rozmiar czcionki.' ) );
          return null;
        }

        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var label = processNode.findLabel( id );
        var addLabel = false;

        if ( Ext.isEmpty( label ) ) {
          id = 'label_' + Ext.id();

          while ( processNode.findLabel( id ) ) {
            id = 'label_' + Ext.id();
          }

          addLabel = true;
        }

        if ( this.checkDuplication( id ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return null;
        }

        if ( addLabel ) {
          processNode.addLabel( {
            id: id,
            name: text
          } );
        }

        labelDef = Ext.apply( {
            id: id,
            text: text,
            fontSize: fontSize,
            color: this.colorItem.items.first().color,
            marginTop: this.marginTopItem.getValue(),
            marginRight: this.marginRightItem.getValue(),
            marginBottom: this.marginBottomItem.getValue(),
            marginLeft: this.marginLeftItem.getValue(),
            formActions: this.formActionsGrid.readComponents(),
            genre: 'LABEL'
        }, labelDef );

        return labelDef;
    },
    checkDuplication: function( id ) {
        var component = this.initialConfig.component;

        if ( component.idAssigned && component.definition.objectDef.id == id ) {
            return false;
        } else {
            var drawingPanel = Ext.getCmp( 'drawing_panel' );
            var isDuplicated = false;

            drawingPanel.items.each( function( item ) {
                item.items.each( function( subitem ) {
                    var definition = subitem.definition;
                    var objectDef = definition.objectDef;

                    switch ( objectDef.genre ) {
                        case 'VARIABLE':
                            if ( subitem.idAssigned && objectDef.varId == id ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'VARIABLE_SET':
                            if ( subitem.idAssigned ) {
                                if ( objectDef.varId == id ) {
                                    isDuplicated = true;
                                    return false;
                                } else {
                                	var columns = objectDef.columns;

                                    for ( var i = 0; i < columns.length; i++ ) {
                                        var column = columns[i];

                                        if ( column.varId == id ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                    
                                    var dtButtons = objectDef.DTButtons;

                                    for ( var i = 0; i < dtButtons.length; i++ ) {
                                        var dtButton = dtButtons[i];

                                        if ( dtButton.buttonId == id ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                }
                            }
                            break;
                        case 'LABEL':
                            if ( subitem.idAssigned && objectDef.id == id ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            if ( subitem.idAssigned &&
                            		( objectDef.actionName == id || objectDef.actionName + '_button' == id ) ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        default:
                            break;
                    }
                } );

                if ( isDuplicated ) {
                    return false;
                }
            } );

            return isDuplicated;
        }
    }
} );