Ext.ux.suncode.GeneratedDocumentSpecificationsPanel = function( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );

    var store = new Ext.data.Store( {
        data: config.generatedDocuments ? config.generatedDocuments : [],
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        title: config.title ? config.title : getTranslation( 'Generowane dokumenty' ),
        height: 150,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        enableColumnMove: true,
        ref: config.ref ? config.ref : 'generatedDocumentsPanel',
        hidden: !mainPanel.getDocumentationView(),
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                editor: {
                    xtype: 'textfield'
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak dokumentów' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj dokument' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        name: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń dokument' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz dokument do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            validateedit: function( e ) {
                var grid = e.grid;
                var store = grid.getStore();
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var value = e.value;

                if ( cm.getColumnId( colIndex ) == 'name' && !Ext.isEmpty( value ) && store.findExact( 'name', value ) != -1 ) {
                    showWarn( getTranslation( 'Dokument został już dodany.' ) );
                    return false;
                }
            },
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.GeneratedDocumentSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.GeneratedDocumentSpecificationsPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.GeneratedDocumentSpecificationsPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        var valid = true;
        var store = this.getStore();

        store.each( function( rec ) {
            var name = rec.get( 'name' );

            if ( Ext.isEmpty( name ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie tabelę generowanych dokumentów.' ) );
                valid = false;
                return false;
            }
        } );

        return valid;
    },
    readGeneratedDocuments: function() {
        var documents = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            documents.push( {
                name: rec.get( 'name' )
            } );
        } );

        return documents;
    }
} );