/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.json.JsonConverter;
import com.suncode.plugin.pwe.util.FormPreviewProcessDataSets;
import com.suncode.plugin.pwe.util.ProcessGlobalSettings;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlOpenDto;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class XpdlOpenDtoBuilder {
    @Autowired
    @Qualifier(value="processSpecificationJsonConverter")
    private JsonConverter<ProcessSpecification> processSpecificationJsonConverter;
    @Autowired
    @Qualifier(value="formPreviewProcessDataSetJsonConverter")
    private JsonConverter<FormPreviewProcessDataSets> formPreviewProcessDataSetJsonConverter;
    @Autowired
    @Qualifier(value="processGlobalSettingsJsonConverter")
    private JsonConverter<ProcessGlobalSettings> processGlobalSettingsJsonConverter;

    public XpdlOpenDto buildSuccess(JSONObject xpdl) {
        XpdlOpenDto dto = new XpdlOpenDto();
        dto.setSuccess(true);
        dto.setXpdl(xpdl.toString());
        return dto;
    }

    public XpdlOpenDto buildSuccess(JSONObject xpdl, String xpdlTranslations) {
        XpdlOpenDto dto = this.buildSuccess(xpdl);
        dto.setXpdlTranslations(xpdlTranslations);
        return dto;
    }

    public XpdlOpenDto buildSuccess(JSONObject xpdl, JSONArray formTemplates, List<ProcessSpecification> processSpecifications, List<FormPreviewProcessDataSets> formPreviewProcessDataSets, List<ProcessGlobalSettings> processGlobalSettings, String xpdlTranslations, boolean additionalsMissing) {
        XpdlOpenDto dto = this.buildSuccess(xpdl, xpdlTranslations);
        dto.setFormTemplates(formTemplates.toString());
        dto.setProcessSpecifications(this.processSpecificationJsonConverter.convertFromList(processSpecifications));
        dto.setFormPreviewProcessDataSets(this.formPreviewProcessDataSetJsonConverter.convertFromList(formPreviewProcessDataSets));
        dto.setProcessGlobalSettings(this.processGlobalSettingsJsonConverter.convertFromList(processGlobalSettings));
        dto.setAdditionalsMissing(additionalsMissing);
        return dto;
    }

    public XpdlOpenDto buildError() {
        XpdlOpenDto dto = new XpdlOpenDto();
        dto.setSuccess(false);
        return dto;
    }
}

