/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ServerXpdlDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.stereotype.Component;

@Component
public class ServerXpdlDtoBuilder {
    public List<ServerXpdlDto> build(List<Package> packages) {
        ArrayList<ServerXpdlDto> dtos = new ArrayList<ServerXpdlDto>();
        if (CollectionUtils.isNotEmpty(packages)) {
            for (Package pack : packages) {
                dtos.add(this.build(pack));
            }
        }
        return dtos;
    }

    public ServerXpdlDto build(Package pack) {
        ServerXpdlDto dto = new ServerXpdlDto();
        dto.setName(pack.getName());
        dto.setPath(pack.getId());
        return dto;
    }

    public ServerXpdlDto build(PluginStoreResource xpdl) {
        ServerXpdlDto dto = new ServerXpdlDto();
        dto.setName(this.buildName(xpdl));
        dto.setPath(xpdl.getPath());
        return dto;
    }

    private String buildName(PluginStoreResource xpdl) {
        return FilenameUtils.getBaseName((String)xpdl.getPath());
    }
}

