/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageLoadDto;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.stereotype.Component;

@Component
public class PackageLoadDtoBuilder {
    private static final String DETAILED_ERROR_TEXT_SIZE = "size=2";

    public PackageLoadDto buildSuccess() {
        PackageLoadDto dto = new PackageLoadDto();
        dto.setLoaded(true);
        return dto;
    }

    public PackageLoadDto buildForLoadError(String loadError) {
        PackageLoadDto dto = new PackageLoadDto();
        dto.setLoaded(false);
        dto.setShouldRefresh(false);
        dto.setLoadError(loadError);
        return dto;
    }

    public PackageLoadDto buildForLoadError(String loadError, String detailedError) {
        PackageLoadDto dto = this.buildForLoadError(loadError);
        dto.setDetailedError(this.formatDetailedError(detailedError));
        return dto;
    }

    private String formatDetailedError(String detailedError) {
        String formattedDetailedError = new String(detailedError);
        formattedDetailedError = StringUtils.replace((String)formattedDetailedError, (String)"size=6", (String)DETAILED_ERROR_TEXT_SIZE);
        formattedDetailedError = StringUtils.replace((String)formattedDetailedError, (String)"size=5", (String)DETAILED_ERROR_TEXT_SIZE);
        formattedDetailedError = StringUtils.replace((String)formattedDetailedError, (String)"size=4", (String)DETAILED_ERROR_TEXT_SIZE);
        return formattedDetailedError;
    }

    public PackageLoadDto buildForRefresh(Package pack) {
        PackageLoadDto dto = new PackageLoadDto();
        dto.setLoaded(false);
        dto.setShouldRefresh(true);
        dto.setCurrentVersion(pack.getInternalVersion());
        return dto;
    }
}

