/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util;

import com.suncode.plugin.pwe.util.PweUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PweClassLoader
extends ClassLoader {
    public static Logger log = Logger.getLogger(PweClassLoader.class);

    public PweClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String classesRepositoryPath, String qualifiedName) {
        InputStream inputStream = null;
        try {
            if (PweUtils.doesClassExistInClasspath(qualifiedName)) {
                String path = this.buildPath(classesRepositoryPath, qualifiedName);
                File file = new File(path);
                URL url = file.toURI().toURL();
                URLConnection connection = url.openConnection();
                inputStream = connection.getInputStream();
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                Class<?> clazz = super.defineClass(qualifiedName, bytes, 0, bytes.length);
                IOUtils.closeQuietly((InputStream)inputStream);
                return clazz;
            }
            Class<?> path = super.loadClass(qualifiedName);
            return path;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private String buildPath(String classesRepositoryPath, String qualifiedName) {
        StringBuilder path = new StringBuilder();
        path.append(classesRepositoryPath);
        path.append(File.separator);
        path.append(StringUtils.replace((String)qualifiedName, (String)".", (String)File.separator));
        path.append(".class");
        return path.toString();
    }
}

