/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.upgrader;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.pwe.configuration.PluginSpringContext;
import com.suncode.plugin.pwe.service.formtemplate.FormTemplateService;
import com.suncode.plugin.pwe.upgrader.UpgraderUtils;
import com.suncode.plugin.pwe.util.FormTemplateUtils;
import com.suncode.plugin.pwe.util.constant.DefaultStyles;
import com.suncode.plugin.pwe.util.exception.UpgraderException;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetDefaultStylesOnFormsChange
implements CustomTaskChange {
    public static Logger log = Logger.getLogger(SetDefaultStylesOnFormsChange.class);
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final String STYLES_NODE_NAME = "Styles";
    private static final String SHOW_LINES_NODE_NAME = "ShowLines";
    private static final String ITEM_EXP = "Rows/Row/Item";
    private static final String SIZE_NODE_NAME = "Size";
    private static final String SIZE_WIDTH_NODE_NAME = "Width";
    private static final String SIZE_HEIGHT_NODE_NAME = "Height";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String LABEL_NODE_NAME = "Label";
    private static final String LABEL_ALIGN_NODE_NAME = "Align";
    private static final String LABEL_WIDTH_NODE_NAME = "Width";
    private static final String LABEL_SEPARATOR_NODE_NAME = "Separator";
    private static final String LABEL_FONT_SIZE_NODE_NAME = "FontSize";
    private static final String LABEL_COLOR_NODE_NAME = "Color";
    private static final String LABEL_TEXT_DECORATION_NODE_NAME = "TextDecoration";
    private static final String FONT_NODE_NAME = "Font";
    private static final String FONT_HEADER_SIZE_NODE_NAME = "HeaderFontSize";
    private static final String FONT_CELL_SIZE_NODE_NAME = "CellFontSize";

    public void execute(Database database) throws CustomChangeException {
        FormTemplateService formTemplateService = PluginSpringContext.getBean(FormTemplateService.class);
        SetDefaultStylesOnFormsChange.setDefaultStylesOnFormsForLoadedToSystem(formTemplateService);
        SetDefaultStylesOnFormsChange.setDefaultStylesOnFormsForStored(formTemplateService, "xpdl/saved");
        SetDefaultStylesOnFormsChange.setDefaultStylesOnFormsForStored(formTemplateService, "xpdl/autosaved");
        SetDefaultStylesOnFormsChange.setDefaultStylesOnFormsForStored(formTemplateService, "xpdl/uploaded");
    }

    private static void setDefaultStylesOnFormsForLoadedToSystem(FormTemplateService formTemplateService) {
        XpdlPackageManager.getInstance().getPackageIds().forEach(packageId -> SetDefaultStylesOnFormsChange.setDefaultStylesOnFormsForLoadedToSystem(formTemplateService, packageId));
    }

    private static void setDefaultStylesOnFormsForLoadedToSystem(FormTemplateService formTemplateService, String packageId) {
        XpdlPackageManager.getInstance().getPackageVersions(packageId).stream().map(String::valueOf).map(packageVersion -> formTemplateService.getFormTemplates(packageId, (String)packageVersion)).flatMap(Collection::stream).forEach(SetDefaultStylesOnFormsChange::setDefaultStylesOnForms);
    }

    private static void setDefaultStylesOnFormsForStored(FormTemplateService formTemplateService, String locationPrefix) {
        formTemplateService.getFormTemplatesFromStored(locationPrefix).forEach(SetDefaultStylesOnFormsChange::setDefaultStylesOnForms);
    }

    private static void setDefaultStylesOnForms(File file) {
        block4: {
            try {
                log.info((Object)("Analizowany plik: " + file.getAbsolutePath()));
                if (file.exists()) {
                    Document document = FormTemplateUtils.getAsXml(file);
                    Element root = document.getDocumentElement();
                    SetDefaultStylesOnFormsChange.analyzeStyles(root);
                    SetDefaultStylesOnFormsChange.analyzeItemsStyle(root);
                    FormTemplateUtils.saveAsXml(file, document);
                } else {
                    log.info((Object)("Plik nie istnieje w lokalizacji: " + file.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                if (!UpgraderUtils.shouldStopMigration(exception)) break block4;
                throw new UpgraderException(exception);
            }
        }
    }

    private static void analyzeStyles(Element element) throws XPathExpressionException {
        Node node = (Node)XPATH.evaluate(STYLES_NODE_NAME, element, XPathConstants.NODE);
        if (FormTemplateUtils.isElement(node)) {
            Element nodeElement = (Element)node;
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, SHOW_LINES_NODE_NAME, "true");
            FormTemplateUtils.clearElement(nodeElement);
            if (!nodeElement.hasChildNodes()) {
                element.removeChild(node);
            }
        }
    }

    private static void analyzeItemsStyle(Element element) throws XPathExpressionException {
        NodeList itemsList = (NodeList)XPATH.evaluate(ITEM_EXP, element, XPathConstants.NODESET);
        FormTemplateUtils.convertToElementsList(itemsList).forEach(SetDefaultStylesOnFormsChange::analyzeItemStyle);
    }

    private static void analyzeItemStyle(Element element) {
        block2: {
            try {
                SetDefaultStylesOnFormsChange.analyzeItemSizeStyle(element);
                SetDefaultStylesOnFormsChange.analyzeItemLabelStyle(element);
                SetDefaultStylesOnFormsChange.analyzeItemFontStyle(element);
                FormTemplateUtils.clearElement(element);
            }
            catch (XPathExpressionException exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                if (!UpgraderUtils.shouldStopMigration(exception)) break block2;
                throw new UpgraderException(exception);
            }
        }
    }

    private static void analyzeItemSizeStyle(Element element) throws XPathExpressionException {
        Node node = (Node)XPATH.evaluate(SIZE_NODE_NAME, element, XPathConstants.NODE);
        if (FormTemplateUtils.isElement(node)) {
            Element nodeElement = (Element)node;
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, "Width", "200");
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, SIZE_HEIGHT_NODE_NAME, "100");
            FormTemplateUtils.clearElement(nodeElement);
            if (!nodeElement.hasChildNodes()) {
                element.removeChild(node);
            }
        }
    }

    private static void analyzeItemLabelStyle(Element element) throws XPathExpressionException {
        Node node = (Node)XPATH.evaluate(LABEL_NODE_NAME, element, XPathConstants.NODE);
        if (FormTemplateUtils.isElement(node)) {
            Element nodeElement = (Element)node;
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, LABEL_ALIGN_NODE_NAME, "left");
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, "Width", "200");
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, LABEL_SEPARATOR_NODE_NAME, "");
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, LABEL_FONT_SIZE_NODE_NAME, DefaultStyles.LABEL_FONT_SIZE_VALUES);
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, LABEL_COLOR_NODE_NAME, "#333333");
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, LABEL_TEXT_DECORATION_NODE_NAME, "none");
            FormTemplateUtils.clearElement(nodeElement);
            if (!nodeElement.hasChildNodes()) {
                element.removeChild(node);
            }
        }
    }

    private static void analyzeItemFontStyle(Element element) throws XPathExpressionException {
        Node node = (Node)XPATH.evaluate(FONT_NODE_NAME, element, XPathConstants.NODE);
        if (FormTemplateUtils.isElement(node)) {
            Element nodeElement = (Element)node;
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, FONT_HEADER_SIZE_NODE_NAME, "13");
            SetDefaultStylesOnFormsChange.analyzeStyle(nodeElement, FONT_CELL_SIZE_NODE_NAME, "13");
            FormTemplateUtils.clearElement(nodeElement);
            if (!nodeElement.hasChildNodes()) {
                element.removeChild(node);
            }
        }
    }

    private static void analyzeStyle(Element element, String nodeName, String defaultAttValue) throws XPathExpressionException {
        SetDefaultStylesOnFormsChange.analyzeStyle(element, nodeName, Collections.singletonList(defaultAttValue));
    }

    private static void analyzeStyle(Element element, String nodeName, List<String> defaultAttValues) throws XPathExpressionException {
        Element nodeElement;
        String valueAttr;
        Node node = (Node)XPATH.evaluate(nodeName, element, XPathConstants.NODE);
        if (FormTemplateUtils.isElement(node) && SetDefaultStylesOnFormsChange.isEqualToDefaultValue(valueAttr = (nodeElement = (Element)node).getAttribute(VALUE_ATTR_NAME), defaultAttValues)) {
            element.removeChild(node);
        }
    }

    private static boolean isEqualToDefaultValue(String value, List<String> defaultValues) {
        return defaultValues.stream().anyMatch(defaultValue -> StringUtils.equals((CharSequence)value, (CharSequence)defaultValue));
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

