/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.xpdl;

import com.lutris.appserver.server.sql.DBTransaction;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.workflowData.XpdlTools;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.divante.DivanteTransformer;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.supplier.SpecificationSupplier;
import com.suncode.plugin.pwe.json.JsonConverter;
import com.suncode.plugin.pwe.service.documentation.DocumentationService;
import com.suncode.plugin.pwe.service.formtemplate.FormTemplateService;
import com.suncode.plugin.pwe.service.i18n.InternalXpdlTranslationService;
import com.suncode.plugin.pwe.service.javacode.JavaCodeService;
import com.suncode.plugin.pwe.service.jscode.JsCodeService;
import com.suncode.plugin.pwe.service.packageinfo.PackageInfoService;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.service.processfile.ProcessFileService;
import com.suncode.plugin.pwe.service.recentfile.RecentFileService;
import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.util.ExtendedXpdlHistoryQuery;
import com.suncode.plugin.pwe.util.ForbiddenVariableId;
import com.suncode.plugin.pwe.util.FormPreviewProcessDataSets;
import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.util.ProcessGlobalSettings;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.util.RecentFileLocationName;
import com.suncode.plugin.pwe.util.ServerXpdlSource;
import com.suncode.plugin.pwe.util.VariableType;
import com.suncode.plugin.pwe.util.comparator.PackageNodeDtoComparator;
import com.suncode.plugin.pwe.util.comparator.PackageVersionNodeDtoComparator;
import com.suncode.plugin.pwe.util.comparator.ServerXpdlDtoComparator;
import com.suncode.plugin.pwe.util.exception.LoadXpdlTranslationsException;
import com.suncode.plugin.pwe.util.exception.ValidateVariableTypeException;
import com.suncode.plugin.pwe.util.exception.XmlAsStringGenerationException;
import com.suncode.plugin.pwe.util.exception.XpdlValidationException;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.PackageInfoDto;
import com.suncode.plugin.pwe.web.support.dto.recentfile.RecentFileDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ExportZipDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageLoadDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageNodeDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageTranslationImportDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageVersionInfoDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageVersionNodeDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ProcessDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ProcessVersionDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ServerXpdlDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.VariableIdValidationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.VariableTypeValidationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlHistoryDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlOpenDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlValidationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.ExportZipDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.PackageDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.PackageLoadDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.PackageNodeDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.PackageVersionInfoDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.PackageVersionNodeDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.ProcessDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.ProcessVersionDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.ServerXpdlDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.XpdlHistoryDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.XpdlOpenDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.xpdl.builder.XpdlValidationErrorDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.DecompressedPackageLoadForm;
import com.suncode.plugin.pwe.web.support.form.ExportTranslationsForm;
import com.suncode.plugin.pwe.web.support.form.ImportTranslationsForm;
import com.suncode.plugin.pwe.web.support.form.OpenForm;
import com.suncode.plugin.pwe.web.support.form.PackageLoadForm;
import com.suncode.plugin.pwe.web.support.form.SaveForm;
import com.suncode.plugin.pwe.web.support.form.SaveXpdlErrorsForm;
import com.suncode.plugin.pwe.web.support.form.ValidateVariableTypeForm;
import com.suncode.plugin.pwe.web.support.form.ZipForm;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.license.exceptions.TooManyProcessesException;
import com.suncode.pwfl.license.exceptions.WrongProcessesException;
import com.suncode.pwfl.util.LzStringUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.xpdl.XpdlService;
import com.suncode.pwfl.xpdl.exception.XpdlPackageValidationException;
import com.suncode.pwfl.xpdl.packages.PackageDetails;
import com.suncode.pwfl.xpdl.util.validation.ForbiddenWords;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.dods.DODS;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ExternalPackageInvalid;
import org.enhydra.shark.api.client.wfservice.PackageAdministration;
import org.enhydra.shark.api.client.wfservice.PackageInvalid;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryDO;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;

@Service
public class InternalXpdlService {
    public static Logger log = Logger.getLogger(InternalXpdlService.class);
    private static final String XPDL_PREFIX = "XPDL";
    private static final long NO_XPDLS = 0L;
    private static final String[] ERROR_FIELDS = new String[]{"object", "processDefId", "activityDefId", "descr", "correction"};
    private static final String ENTER = System.getProperty("line.separator");
    private static final String FIRST_PACKAGE_VERSION = "1";
    @Autowired
    private XmlService xmlService;
    @Autowired
    private XpdlValidationErrorDtoBuilder xpdlValidationErrorDtoBuilder;
    @Autowired
    private PackageNodeDtoBuilder packageNodeDtoBuilder;
    @Autowired
    private PackageVersionNodeDtoBuilder packageVersionNodeDtoBuilder;
    @Autowired
    private PackageInfoService packageInfoService;
    @Autowired
    private PackageDtoBuilder packageDtoBuilder;
    @Autowired
    private PackageVersionInfoDtoBuilder packageVersionInfoDtoBuilder;
    @Autowired
    private XpdlHistoryDtoBuilder xpdlHistoryDtoBuilder;
    @Autowired
    private ProcessDtoBuilder processDtoBuilder;
    @Autowired
    private ProcessVersionDtoBuilder processVersionDtoBuilder;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ServerXpdlDtoBuilder serverXpdlDtoBuilder;
    @Autowired
    private FormTemplateService formTemplateService;
    @Autowired
    @Qualifier(value="processSpecificationService")
    private ProcessFileService<ProcessSpecification> processSpecificationService;
    @Autowired
    @Qualifier(value="formPreviewProcessDataSetsService")
    private ProcessFileService<FormPreviewProcessDataSets> formPreviewProcessDataSetsService;
    @Autowired
    @Qualifier(value="processGlobalSettingsService")
    private ProcessFileService<ProcessGlobalSettings> processGlobalSettingsService;
    @Autowired
    private InternalXpdlTranslationService internalXpdlTranslationService;
    @Autowired
    private RecentFileService recentFileService;
    @Autowired
    private JavaCodeService javaCodeService;
    @Autowired
    private JsCodeService jsCodeService;
    @Autowired
    private ZipService zipService;
    @Autowired
    private PackageLoadDtoBuilder packageLoadDtoBuilder;
    @Autowired
    private XpdlOpenDtoBuilder xpdlOpenDtoBuilder;
    @Autowired
    @Qualifier(value="dtButtonSpecificationSupplier")
    private SpecificationSupplier dtButtonSpecificationSupplier;
    @Autowired
    @Qualifier(value="processSpecificationJsonConverter")
    private JsonConverter<ProcessSpecification> processSpecificationJsonConverter;
    @Autowired
    @Qualifier(value="formPreviewProcessDataSetJsonConverter")
    private JsonConverter<FormPreviewProcessDataSets> formPreviewProcessDataSetJsonConverter;
    @Autowired
    @Qualifier(value="processGlobalSettingsJsonConverter")
    private JsonConverter<ProcessGlobalSettings> processGlobalSettingsJsonConverter;
    @Autowired
    private ExportZipDtoBuilder exportZipDtoBuilder;
    @Autowired
    private DivanteTransformer divanteTransformer;
    @Autowired
    private DocumentationService documentationService;

    public String getPreview(String xpdl) {
        try {
            return this.getAsXmlString(LzStringUtils.decompressFromBase64((String)xpdl));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new XmlAsStringGenerationException(exception);
        }
    }

    private String getAsXmlString(String xpdl) {
        return this.xmlService.getAsString(xpdl, "xpdl", true);
    }

    public String getPreview(String packageId, String packageVersion) {
        try {
            return this.getAsXmlString(packageId, packageVersion);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new XmlAsStringGenerationException(exception);
        }
    }

    private String getAsXmlString(String packageId, String packageVersion) throws Exception {
        PackageAdministration packageAdministration = Shark.getInstance().getAdminInterface().getPackageAdministration();
        byte[] bytes = packageAdministration.getPackageContent(packageId, packageVersion);
        return new String(bytes, "UTF-8");
    }

    public XpdlValidationDto validate(String xpdl) {
        XpdlValidationDto dto = new XpdlValidationDto();
        try {
            Document document = this.getXpdlDocument(LzStringUtils.decompressFromBase64((String)xpdl));
            XpdlService xpdlService = (XpdlService)SpringContext.getBean(XpdlService.class);
            xpdlService.validate(document);
            dto.setCorrect(true);
        }
        catch (XpdlPackageValidationException exception) {
            log.warn((Object)exception.getMessage());
            dto.setCorrect(false);
            dto.setValidationError(this.xpdlValidationErrorDtoBuilder.build(exception));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new XpdlValidationException(exception);
        }
        return dto;
    }

    private Document getXpdlDocument(String xpdl) throws ParserConfigurationException, JSONException {
        Document document = this.xmlService.write(xpdl, "xpdl");
        document.normalize();
        return document;
    }

    public List<PackageNodeDto> getPackageNodes() {
        XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
        return xpdlPackageManager.getPackageIds().stream().map(arg_0 -> ((XpdlPackageManager)xpdlPackageManager).getPackage(arg_0)).map(this.packageNodeDtoBuilder::build).sorted(new PackageNodeDtoComparator()).collect(Collectors.toList());
    }

    public List<PackageVersionNodeDto> getPackageVersionNodes(String packageId) {
        Iterable allPackageVersions = XpdlPackageManager.getInstance().getAllPackageVersionsIterable(packageId);
        ArrayList<PackageVersionNodeDto> packageVersionNodeDtos = new ArrayList<PackageVersionNodeDto>();
        for (Package packageObj : allPackageVersions) {
            PackageVersionNodeDto packageVersionNodeDto = this.packageVersionNodeDtoBuilder.build(packageObj);
            packageVersionNodeDtos.add(packageVersionNodeDto);
        }
        packageVersionNodeDtos.sort(new PackageVersionNodeDtoComparator());
        return packageVersionNodeDtos;
    }

    public PackageVersionInfoDto getPackageVersionInfo(String packageId, String packageVersion) {
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId, packageVersion);
        List<PackageDetails> packagesDetails = this.getAllPackagesDetails(packageId);
        List<PackageDto> previousPackages = this.getPreviousPackages(packageId, packageVersion, packagesDetails);
        Map<String, PackageInfoDto> packageInfoDtos = this.getPackageInfos(packageId);
        return this.packageVersionInfoDtoBuilder.build(pack, previousPackages, packageInfoDtos);
    }

    private List<PackageDetails> getAllPackagesDetails(String packageId) {
        return XpdlPackageManager.getInstance().getAllPackagesDetails(packageId).stream().collect(Collectors.toList());
    }

    private List<PackageDto> getPreviousPackages(String packageId, String stringPackageVersion, List<PackageDetails> packagesDetails) {
        int packageVersion = Integer.valueOf(stringPackageVersion);
        List<PackageDto> allLoadedPackages = this.packageDtoBuilder.build(packagesDetails);
        List<PackageDto> historyPackages = this.getHistoryPackages(packageId);
        return Stream.concat(allLoadedPackages.stream(), historyPackages.stream()).filter(p -> Integer.valueOf(p.getVersion()) < packageVersion).sorted((p1, p2) -> Integer.valueOf(p2.getVersion()) - Integer.valueOf(p1.getVersion())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PackageDto> getHistoryPackages(String packageId) {
        List<PackageDto> dtos = new ArrayList<PackageDto>();
        DBTransaction transaction = null;
        try {
            transaction = DODS.getDatabaseManager().createTransaction();
            ExtendedXpdlHistoryQuery pageQuery = new ExtendedXpdlHistoryQuery(transaction);
            pageQuery.setQueryXPDLId(packageId);
            XPDLHistoryDO[] xpdlsHistory = pageQuery.getDOArray();
            dtos = this.packageDtoBuilder.build(xpdlsHistory);
            transaction.commit();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (SQLException sqlException) {
                log.error((Object)sqlException.getMessage(), (Throwable)sqlException);
            }
        }
        finally {
            if (transaction != null) {
                transaction.release();
            }
        }
        return dtos;
    }

    private Map<String, PackageInfoDto> getPackageInfos(String packageId) {
        return this.packageInfoService.getForPackage(packageId).stream().collect(Collectors.toMap(PackageInfoDto::getPackageVersion, p -> p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<XpdlHistoryDto> getHistory(int offset, int limit, String sort, String direction) {
        List<Object> dtos = new ArrayList();
        long total = NO_XPDLS;
        DBTransaction transaction = null;
        try {
            transaction = DODS.getDatabaseManager().createTransaction();
            ExtendedXpdlHistoryQuery countQuery = new ExtendedXpdlHistoryQuery(transaction);
            total = countQuery.getCount();
            ExtendedXpdlHistoryQuery pageQuery = new ExtendedXpdlHistoryQuery(transaction);
            pageQuery.addOrderBy(this.buildHistoryOrderByProperty(sort), direction);
            pageQuery.setReadSkip(offset);
            pageQuery.setDatabaseLimit(limit);
            XPDLHistoryDO[] xpdlsHistory = pageQuery.getDOArray();
            dtos = this.xpdlHistoryDtoBuilder.build(xpdlsHistory);
            transaction.commit();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (SQLException sqlException) {
                log.error((Object)sqlException.getMessage(), (Throwable)sqlException);
            }
        }
        finally {
            if (transaction != null) {
                transaction.release();
            }
        }
        return new PageResult<XpdlHistoryDto>(dtos, total);
    }

    private String buildHistoryOrderByProperty(String sort) {
        StringBuilder property = new StringBuilder();
        property.append(XPDL_PREFIX);
        property.append(StringUtils.capitalize((String)sort));
        return property.toString();
    }

    public List<ProcessDto> getProcesses(String packageId, String packageVersion) {
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId, packageVersion);
        if (pack != null) {
            WorkflowProcesses processes = pack.getWorkflowProcesses();
            return this.processDtoBuilder.build(processes);
        }
        return new ArrayList<ProcessDto>();
    }

    public List<ProcessVersionDto> getProcessVersions(String packageId, String processDefId) {
        List<File> specificationFiles = this.getSpecificationFiles(packageId);
        return this.processVersionDtoBuilder.build(processDefId, specificationFiles);
    }

    private List<File> getSpecificationFiles(String packageId) {
        String packageFolderPath = this.buildPackageFolderPath(packageId);
        File packageFolder = new File(packageFolderPath);
        if (packageFolder.exists() && packageFolder.isDirectory()) {
            return (List)FileUtils.listFiles((File)packageFolder, (String[])new String[]{"spec"}, (boolean)true);
        }
        return new ArrayList<File>();
    }

    private String buildPackageFolderPath(String packageId) {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(packageId);
        return path.toString();
    }

    public List<ServerXpdlDto> getFromServer(String userId, String source, String query) {
        ArrayList<ServerXpdlDto> dtos = new ArrayList<ServerXpdlDto>();
        switch (ServerXpdlSource.getByName(source)) {
            case SYSTEM: {
                dtos.addAll(this.getSystemXpdls(query));
                break;
            }
            case SAVED: {
                dtos.addAll(this.getSavedXpdls(userId, query));
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(dtos)) {
            Collections.sort(dtos, new ServerXpdlDtoComparator());
        }
        return dtos;
    }

    private List<ServerXpdlDto> getSystemXpdls(String query) {
        List<Package> packages = XpdlPackageManager.getInstance().getPackages().stream().filter(pack -> StringUtils.containsIgnoreCase((CharSequence)pack.getName(), (CharSequence)query)).collect(Collectors.toList());
        return this.serverXpdlDtoBuilder.build(packages);
    }

    private List<ServerXpdlDto> getSavedXpdls(String userId, String query) {
        ArrayList<ServerXpdlDto> dtos = new ArrayList<ServerXpdlDto>();
        Map<String, PluginStoreResource> xpdls = this.pluginService.getSavedResources();
        if (MapUtils.isNotEmpty(xpdls)) {
            Pattern pattern = this.buildSavedXpdlsLocationPattern(userId, query);
            for (String location : xpdls.keySet()) {
                if (!this.doesXpdlLocationMatchPattern(pattern, location)) continue;
                PluginStoreResource xpdl = xpdls.get(location);
                dtos.add(this.serverXpdlDtoBuilder.build(xpdl));
            }
        }
        return dtos;
    }

    private Pattern buildSavedXpdlsLocationPattern(String userId, String query) {
        StringBuilder regex = new StringBuilder();
        regex.append(this.buildSavedXpdlFolderLocation(userId));
        regex.append("/");
        regex.append(".*(?i)");
        regex.append(PweUtils.buildSafePatternValue(query));
        regex.append(".*[.]xpdl");
        return Pattern.compile(regex.toString());
    }

    private boolean doesXpdlLocationMatchPattern(Pattern pattern, String location) {
        Matcher matcher = pattern.matcher(location);
        return matcher.matches();
    }

    public boolean save(String userId, SaveForm form) {
        Date started = new Date();
        String fileName = form.getFileName();
        String xpdlFolderLocation = this.buildSavedXpdlFolderLocation(userId);
        String xpdlLocation = this.buildXpdlLocation(xpdlFolderLocation, fileName);
        try {
            this.executeSave(userId, form, fileName, xpdlFolderLocation);
            this.resetAutoSaved(userId, form.getModuleStartTime());
            if (StringUtils.isNotBlank((CharSequence)form.getOpenedAutoSavedPath())) {
                this.deleteAutoSaved(form.getOpenedAutoSavedPath());
            }
            this.recentFileService.setForSaved(userId, xpdlLocation);
            this.logPackageSaveAudit(userId, started, true, fileName + ".xpdl");
            return true;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logPackageSaveAudit(userId, started, false, fileName + ".xpdl");
            return false;
        }
    }

    private void logPackageSaveAudit(String userId, Date started, boolean success, String fileName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.save.param.filename", fileName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_SAVE_PACKAGE.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private String buildSavedXpdlFolderLocation(String userId) {
        StringBuilder location = new StringBuilder();
        location.append("xpdl/saved");
        location.append("/");
        location.append(userId);
        return location.toString();
    }

    private void executeSave(String userId, SaveForm form, String fileName, String xpdlFolderLocation) throws Exception {
        String additionalsFolderLocation = this.buildAdditionalsFolderLocation(xpdlFolderLocation, fileName);
        String xpdlLocation = this.buildXpdlLocation(xpdlFolderLocation, fileName);
        String xpdlContent = this.getAsXmlString(LzStringUtils.decompressFromBase64((String)form.getXpdl()));
        String formTemplates = LzStringUtils.decompressFromBase64((String)form.getFormTemplates());
        String processSpecifications = LzStringUtils.decompressFromBase64((String)form.getProcessSpecifications());
        String formPreviewProcessDataSets = LzStringUtils.decompressFromBase64((String)form.getFormPreviewProcessDataSets());
        String processGlobalSettings = LzStringUtils.decompressFromBase64((String)form.getProcessGlobalSettings());
        String xpdlTranslations = LzStringUtils.decompressFromBase64((String)form.getXpdlTranslations());
        this.pluginService.delete(additionalsFolderLocation);
        this.pluginService.save(xpdlLocation, xpdlContent);
        this.formTemplateService.save(formTemplates, additionalsFolderLocation);
        this.processSpecificationService.save(processSpecifications, additionalsFolderLocation);
        this.formPreviewProcessDataSetsService.save(formPreviewProcessDataSets, additionalsFolderLocation);
        this.processGlobalSettingsService.save(processGlobalSettings, additionalsFolderLocation);
        this.internalXpdlTranslationService.save(xpdlTranslations, additionalsFolderLocation);
        this.documentationService.saveAttachments(userId, form.getAttachmentDirectories(), additionalsFolderLocation);
    }

    private String buildAdditionalsFolderLocation(String xpdlFolderLocation, String fileName) {
        StringBuilder location = new StringBuilder();
        location.append(xpdlFolderLocation);
        location.append("/");
        location.append(fileName);
        return location.toString();
    }

    private String buildXpdlLocation(String xpdlFolderLocation, String fileName) {
        StringBuilder location = new StringBuilder();
        location.append(xpdlFolderLocation);
        location.append("/");
        location.append(fileName);
        location.append(".xpdl");
        return location.toString();
    }

    public boolean autoSave(String userId, SaveForm form) {
        String fileName = this.buildAutoSavedXpdlFileName(form);
        String xpdlFolderLocation = this.buildAutoSavedXpdlFolderLocation(userId, form.getModuleStartTime());
        try {
            this.resetAutoSaved(userId, form.getModuleStartTime());
            this.executeSave(userId, form, fileName, xpdlFolderLocation);
            return true;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private String buildAutoSavedXpdlFileName(SaveForm form) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(form.getFileName());
        fileName.append(" ");
        fileName.append(PweUtils.buildFormattedDate(System.currentTimeMillis(), "yyyy-MM-dd HH_mm_ss"));
        return fileName.toString();
    }

    private String buildAutoSavedXpdlFolderLocation(String userId, String moduleStartTime) {
        StringBuilder location = new StringBuilder();
        location.append(this.buildAutoSavedXpdlFolderLocation(userId));
        location.append("/");
        location.append(moduleStartTime);
        return location.toString();
    }

    public List<ServerXpdlDto> getAutoSaved(String userId) {
        ArrayList<ServerXpdlDto> dtos = new ArrayList<ServerXpdlDto>();
        Map<String, PluginStoreResource> xpdls = this.pluginService.getSavedResources();
        if (MapUtils.isNotEmpty(xpdls)) {
            Pattern pattern = this.buildAutoSavedXpdlsLocationPattern(userId);
            for (String location : xpdls.keySet()) {
                if (!this.doesXpdlLocationMatchPattern(pattern, location)) continue;
                PluginStoreResource xpdl = xpdls.get(location);
                dtos.add(this.serverXpdlDtoBuilder.build(xpdl));
            }
        }
        if (CollectionUtils.isNotEmpty(dtos)) {
            Collections.sort(dtos, new ServerXpdlDtoComparator());
        }
        return dtos;
    }

    private Pattern buildAutoSavedXpdlsLocationPattern(String userId) {
        StringBuilder regex = new StringBuilder();
        regex.append(this.buildAutoSavedXpdlFolderLocation(userId));
        regex.append("/.*/.*[.]xpdl");
        return Pattern.compile(regex.toString());
    }

    private String buildAutoSavedXpdlFolderLocation(String userId) {
        StringBuilder location = new StringBuilder();
        location.append("xpdl/autosaved");
        location.append("/");
        location.append(userId);
        return location.toString();
    }

    public byte[] generate(String userId, String fileName, String xpdl) {
        Date started = new Date();
        try {
            String body = this.getAsXmlString(LzStringUtils.decompressFromBase64((String)xpdl));
            byte[] bytes = body.getBytes(Charset.forName("UTF-8"));
            this.logGenerateXpdlAudit(userId, started, true, fileName);
            return bytes;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logGenerateXpdlAudit(userId, started, false, fileName);
            return new byte[0];
        }
    }

    public byte[] generate(String xpdl) throws Exception {
        String body = this.getAsXmlString(LzStringUtils.decompressFromBase64((String)xpdl));
        return body.getBytes(Charset.forName("UTF-8"));
    }

    private void logGenerateXpdlAudit(String userId, Date started, boolean success, String fileName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.xpdl.param.filename", fileName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_XPDL.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    public byte[] generateFromHistory(String fileName, String packageId, String packageVersion) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)bufferedOutputStream, Charset.forName("UTF-8"));
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId, packageVersion);
        try {
            String xpdlFileName = this.buildXpdlFileName(fileName);
            byte[] xpdlBytes = this.getPackageBytes(packageId, packageVersion);
            String additionalsFolderPath = this.buildAdditionalsFolderPath(pack);
            List<File> formTemplates = this.formTemplateService.getFormTemplates(packageId, packageVersion);
            List<ProcessSpecification> processSpecifications = this.processSpecificationService.openFromSystem(additionalsFolderPath);
            List<FormPreviewProcessDataSets> formPreviewProcessDataSets = this.formPreviewProcessDataSetsService.openFromSystem(additionalsFolderPath);
            List<ProcessGlobalSettings> processGlobalSettings = this.processGlobalSettingsService.openFromSystem(additionalsFolderPath);
            String xpdlTranslations = this.internalXpdlTranslationService.openFromSystem(pack.getId());
            this.zipService.addToZip(zipOutputStream, xpdlFileName, xpdlBytes);
            this.formTemplateService.addToZip(zipOutputStream, formTemplates);
            this.processSpecificationService.addToZip(zipOutputStream, processSpecifications);
            this.formPreviewProcessDataSetsService.addToZip(zipOutputStream, formPreviewProcessDataSets);
            this.processGlobalSettingsService.addToZip(zipOutputStream, processGlobalSettings);
            this.internalXpdlTranslationService.addToZip(zipOutputStream, xpdlTranslations);
            zipOutputStream.finish();
            zipOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return new byte[0];
        }
    }

    private byte[] getPackageBytes(String packageId) throws BaseException {
        PackageAdministration packageAdministration = Shark.getInstance().getAdminInterface().getPackageAdministration();
        return packageAdministration.getPackageContent(packageId);
    }

    private byte[] getPackageBytes(String packageId, String packageVersion) throws BaseException {
        PackageAdministration packageAdministration = Shark.getInstance().getAdminInterface().getPackageAdministration();
        return packageAdministration.getPackageContent(packageId, packageVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateZip(String userId, ZipForm form, String fileName) {
        Date started = new Date();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)bufferedOutputStream, Charset.forName("UTF-8"));
        try {
            this.addXpdlToZip(form, zipOutputStream);
            this.addFormTemplatesToZip(form, zipOutputStream);
            this.addProcessSpecificationsToZip(form, zipOutputStream);
            this.addFormPreviewProcessDataSetsToZip(form, zipOutputStream);
            this.addProcessGlobalSettingsToZip(form, zipOutputStream);
            this.addXpdlTranslationsToZip(form, zipOutputStream);
            this.addJavaClassesToZip(userId, form, zipOutputStream);
            this.addCustomJsToZip(form, zipOutputStream);
            this.addAttachmentsToZip(userId, form, zipOutputStream);
            zipOutputStream.finish();
            zipOutputStream.flush();
            this.logGenerateZipArchiveAudit(userId, started, true, fileName);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logGenerateZipArchiveAudit(userId, started, false, fileName);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
    }

    private void logGenerateZipArchiveAudit(String userId, Date started, boolean success, String fileName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.ziparchive.param.filename", fileName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_ZIP_ARCHIVE.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private void addXpdlToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        String fileName = this.buildXpdlFileName(form);
        byte[] bytes = this.generate(form.getXpdl());
        this.zipService.addToZip(zipOutputStream, fileName, bytes);
    }

    private String buildXpdlFileName(ZipForm form) {
        return this.buildXpdlFileName(form.getFileName());
    }

    private String buildXpdlFileName(String name) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(name);
        fileName.append(".xpdl");
        return fileName.toString();
    }

    private void addFormTemplatesToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.formTemplateService.addToZip(zipOutputStream, LzStringUtils.decompressFromBase64((String)form.getFormTemplates()));
    }

    private void addProcessSpecificationsToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.processSpecificationService.addToZip(zipOutputStream, LzStringUtils.decompressFromBase64((String)form.getProcessSpecifications()));
    }

    private void addFormPreviewProcessDataSetsToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.formPreviewProcessDataSetsService.addToZip(zipOutputStream, LzStringUtils.decompressFromBase64((String)form.getFormPreviewProcessDataSets()));
    }

    private void addProcessGlobalSettingsToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.processGlobalSettingsService.addToZip(zipOutputStream, LzStringUtils.decompressFromBase64((String)form.getProcessGlobalSettings()));
    }

    private void addXpdlTranslationsToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.internalXpdlTranslationService.addToZip(zipOutputStream, LzStringUtils.decompressFromBase64((String)form.getXpdlTranslations()));
    }

    private void addJavaClassesToZip(String userId, ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.javaCodeService.addToZip(zipOutputStream, userId, LzStringUtils.decompressFromBase64((String)form.getJavaClasses()));
    }

    private void addCustomJsToZip(ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.jsCodeService.addToZip(zipOutputStream, form.getPackageId(), LzStringUtils.decompressFromBase64((String)form.getCustomJs()));
    }

    private void addAttachmentsToZip(String userId, ZipForm form, ZipOutputStream zipOutputStream) throws Exception {
        this.documentationService.addAttachmentsToZip(zipOutputStream, userId, form.getAttachmentDirectories());
    }

    public PackageLoadDto export(String userId, PackageLoadForm form) {
        Date started = new Date();
        String packageId = form.getPackageId();
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId);
        if (pack == null) {
            try {
                return this.doExport(userId, started, this.buildDecompressedForm(form));
            }
            catch (Exception exception) {
                this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
                return this.buildPackageLoadResultForLoadError("Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142adowania pakietu.");
            }
        }
        return this.buildPackageLoadResultForRefresh(pack);
    }

    private DecompressedPackageLoadForm buildDecompressedForm(PackageLoadForm form) throws Exception {
        DecompressedPackageLoadForm decompressedForm = new DecompressedPackageLoadForm();
        decompressedForm.setPackageId(form.getPackageId());
        decompressedForm.setPackageVersion(form.getPackageVersion());
        decompressedForm.setFileName(form.getFileName());
        decompressedForm.setPackageInfo(LzStringUtils.decompressFromBase64((String)form.getPackageInfo()));
        decompressedForm.setXpdlAsXml(false);
        decompressedForm.setXpdl(LzStringUtils.decompressFromBase64((String)form.getXpdl()));
        decompressedForm.setFormTemplates(LzStringUtils.decompressFromBase64((String)form.getFormTemplates()));
        decompressedForm.setProcessSpecifications(LzStringUtils.decompressFromBase64((String)form.getProcessSpecifications()));
        decompressedForm.setFormPreviewProcessDataSets(LzStringUtils.decompressFromBase64((String)form.getFormPreviewProcessDataSets()));
        decompressedForm.setProcessGlobalSettings(LzStringUtils.decompressFromBase64((String)form.getProcessGlobalSettings()));
        decompressedForm.setXpdlTranslations(LzStringUtils.decompressFromBase64((String)form.getXpdlTranslations()));
        decompressedForm.setAutoJs(LzStringUtils.decompressFromBase64((String)form.getAutoJs()));
        decompressedForm.setJavaClasses(LzStringUtils.decompressFromBase64((String)form.getJavaClasses()));
        decompressedForm.setCustomJs(LzStringUtils.decompressFromBase64((String)form.getCustomJs()));
        decompressedForm.setModuleStartTime(form.getModuleStartTime());
        decompressedForm.setOpenedAutoSavedPath(form.getOpenedAutoSavedPath());
        decompressedForm.setAttachmentDirectories(form.getAttachmentDirectories());
        return decompressedForm;
    }

    private PackageLoadDto doExport(String userId, Date started, DecompressedPackageLoadForm form) {
        String xpdlRepositoryPath = this.buildXpdlRepositoryPath(form);
        String packageId = form.getPackageId();
        try {
            String xpdl = form.getXpdl();
            Map<Locale, Map<String, String>> translationsForLanguages = this.internalXpdlTranslationService.buildTranslationsForLanguages(form.getXpdlTranslations());
            if (form.isXpdlAsXml()) {
                this.generateXpdlFileFromXml(xpdl, xpdlRepositoryPath);
            } else {
                this.generateXpdlFileFromJson(xpdl, xpdlRepositoryPath);
            }
            XpdlPackageManager.getInstance().loadPackage(xpdlRepositoryPath, translationsForLanguages);
        }
        catch (PackageInvalid exception) {
            log.warn((Object)exception.getXPDLValidationErrors());
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("Nie mo\u017cna za\u0142adowa\u0107 pakietu. Pakiet jest niepoprawny.", exception.getXPDLValidationErrors());
        }
        catch (ExternalPackageInvalid exception) {
            log.warn((Object)exception.getXPDLValidationErrors());
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("Nie mo\u017cna za\u0142adowa\u0107 pakietu. Pakiet jest niepoprawny.", exception.getXPDLValidationErrors());
        }
        catch (TooManyProcessesException exception) {
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("Wgranie pakietu spowoduje przekroczenie limitu licencji.");
        }
        catch (WrongProcessesException exception) {
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("W pakiecie zosta\u0142y wykryte procesy niezgodne z licencj\u0105.");
        }
        catch (XpdlPackageValidationException exception) {
            Locale locale = LocaleContextHolder.getLocale();
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("Wyst\u0105pi\u0142 b\u0142\u0105d walidacji pakietu.", exception.getTranslatedMessage(locale));
        }
        catch (Exception exception) {
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("Wyst\u0105pi\u0142 b\u0142\u0105d podczas od\u015bwie\u017cania pakietu.", exception.getMessage());
        }
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId);
        try {
            return this.executeAfterPackageLoadActions(userId, started, form, pack);
        }
        catch (Exception exception) {
            this.logExportPackageAudit(userId, started, false, packageId, FIRST_PACKAGE_VERSION);
            return this.buildPackageLoadResultForLoadError("Pakiet za\u0142adowano. Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142adowania pozosta\u0142ych komponent\u00f3w.");
        }
    }

    private String buildXpdlRepositoryPath(PackageLoadForm form) {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(form.getFileName());
        path.append(".xpdl");
        return path.toString();
    }

    private void generateXpdlFileFromJson(String xpdl, String xpdlRepositoryPath) throws IOException {
        String content = this.getAsXmlString(xpdl);
        this.generateXpdlFileFromXml(content, xpdlRepositoryPath);
    }

    private void generateXpdlFileFromXml(String xpdl, String xpdlRepositoryPath) throws IOException {
        FileUtils.writeStringToFile((File)new File(xpdlRepositoryPath), (String)xpdl, (String)"UTF-8");
    }

    private void generateXpdlFile(String packageId, String packageVersion, String xpdlRepositoryPath) throws IOException, BaseException {
        byte[] bytes = this.getPackageBytes(packageId, packageVersion);
        FileUtils.writeByteArrayToFile((File)new File(xpdlRepositoryPath), (byte[])bytes);
    }

    private PackageLoadDto executeAfterPackageLoadActions(String userId, Date started, DecompressedPackageLoadForm form, Package pack) throws Exception {
        String packageInfo = StringUtils.defaultString((String)form.getPackageInfo());
        String packageId = pack.getId();
        String packageVersion = pack.getInternalVersion();
        this.packageInfoService.set(userId, packageId, packageVersion, packageInfo);
        String additionalsFolderPath = this.buildAdditionalsFolderPath(pack);
        String formTemplates = form.getFormTemplates();
        String processSpecifications = form.getProcessSpecifications();
        String formPreviewProcessDataSets = form.getFormPreviewProcessDataSets();
        String processGlobalSettings = form.getProcessGlobalSettings();
        this.deleteAdditionalsFolder(additionalsFolderPath);
        this.formTemplateService.loadToSystem(formTemplates, additionalsFolderPath);
        this.processSpecificationService.loadToSystem(processSpecifications, additionalsFolderPath);
        this.formPreviewProcessDataSetsService.loadToSystem(formPreviewProcessDataSets, additionalsFolderPath);
        this.processGlobalSettingsService.loadToSystem(processGlobalSettings, additionalsFolderPath);
        this.documentationService.loadAttachmentsToSystem(userId, form.getAttachmentDirectories(), additionalsFolderPath);
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            this.resetAutoSaved(userId, form.getModuleStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)form.getOpenedAutoSavedPath())) {
            this.deleteAutoSaved(form.getOpenedAutoSavedPath());
        }
        this.logExportPackageAudit(userId, started, true, form.getPackageId(), form.getPackageVersion());
        return this.buildPackageLoadResultSuccess();
    }

    private void logExportPackageAudit(String userId, Date started, boolean success, String packageId, String packageVersion) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.export.param.packageid", packageId);
        params.put("pwe.audit.package.export.param.packageversion", packageVersion);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_EXPORT_PACKAGE.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private String buildAdditionalsFolderPath(Package pack) {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(pack.getId());
        path.append(File.separator);
        path.append("v");
        path.append(pack.getInternalVersion());
        return path.toString();
    }

    private void deleteAdditionalsFolder(String additionalsFolderPath) {
        File additionalsFolder = new File(additionalsFolderPath);
        if (additionalsFolder.exists() && additionalsFolder.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)additionalsFolder);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private PackageLoadDto buildPackageLoadResultForLoadError(String loadError, String detailedError) {
        return this.packageLoadDtoBuilder.buildForLoadError(loadError, detailedError);
    }

    private PackageLoadDto buildPackageLoadResultForLoadError(String loadError) {
        return this.packageLoadDtoBuilder.buildForLoadError(loadError);
    }

    private PackageLoadDto buildPackageLoadResultSuccess() {
        return this.packageLoadDtoBuilder.buildSuccess();
    }

    private PackageLoadDto buildPackageLoadResultForRefresh(Package pack) {
        return this.packageLoadDtoBuilder.buildForRefresh(pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportZipDto exportZip(InputStream inputStream, String packageInfo) {
        ExportZipDto exportZipDto;
        PackageLoadDto packageLoadDto;
        ZipInputStream zipInputStream;
        String packageVersion;
        String packageId;
        Date started;
        block20: {
            started = new Date();
            packageId = "n/a";
            packageVersion = "n/a";
            zipInputStream = null;
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry entry = null;
            String xpdl = "";
            JSONArray formTemplates = new JSONArray();
            ArrayList<ProcessSpecification> processSpecifications = new ArrayList<ProcessSpecification>();
            ArrayList<FormPreviewProcessDataSets> formPreviewProcessDataSets = new ArrayList<FormPreviewProcessDataSets>();
            ArrayList<ProcessGlobalSettings> processGlobalSettings = new ArrayList<ProcessGlobalSettings>();
            String xpdlTranslations = new JSONArray().toString();
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"xpdl")) {
                    entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    xpdl = new String(entryBytes, Charset.forName("UTF-8"));
                } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"xml")) {
                    entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    JSONObject template = this.formTemplateService.openFromDisc(entryBytes);
                    JSONObject formTemplate = new JSONObject();
                    formTemplate.put("Template", (Object)template);
                    formTemplate.put("ProcessDefId", (Object)this.getValueFromTemplate(template, "processDefId"));
                    formTemplate.put("ActivityDefId", (Object)this.getValueFromTemplate(template, "activityDefId"));
                    formTemplates.put((Object)formTemplate);
                } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"spec")) {
                    entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    processSpecifications.add(this.processSpecificationService.openFromDisc(entryBytes));
                } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"fpds")) {
                    entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    formPreviewProcessDataSets.add(this.formPreviewProcessDataSetsService.openFromDisc(entryBytes));
                } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"gsett")) {
                    entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    processGlobalSettings.add(this.processGlobalSettingsService.openFromDisc(entryBytes));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)entry.getName(), (CharSequence)"xpdlTranslations.i18n")) {
                    entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    xpdlTranslations = this.internalXpdlTranslationService.openFromDisc(entryBytes, false);
                }
                zipInputStream.closeEntry();
            }
            Package packFromXpdl = PweUtils.getPackage(xpdl, true);
            if (this.dtButtonSpecificationSupplier.shouldSupply(processSpecifications)) {
                this.dtButtonSpecificationSupplier.supply(packFromXpdl, processSpecifications);
            }
            packageId = packFromXpdl.getId();
            DecompressedPackageLoadForm decompressedForm = new DecompressedPackageLoadForm();
            decompressedForm.setFileName(packFromXpdl.getName());
            decompressedForm.setPackageId(packageId);
            decompressedForm.setXpdlAsXml(true);
            decompressedForm.setXpdl(xpdl);
            decompressedForm.setFormTemplates(formTemplates.toString());
            decompressedForm.setPackageInfo(packageInfo);
            decompressedForm.setProcessSpecifications(this.processSpecificationJsonConverter.convertFromList(processSpecifications));
            decompressedForm.setFormPreviewProcessDataSets(this.formPreviewProcessDataSetJsonConverter.convertFromList(formPreviewProcessDataSets));
            decompressedForm.setProcessGlobalSettings(this.processGlobalSettingsJsonConverter.convertFromList(processGlobalSettings));
            decompressedForm.setXpdlTranslations(xpdlTranslations);
            Package pack = XpdlPackageManager.getInstance().getPackage(packageId);
            packageLoadDto = null;
            if (pack == null) {
                packageLoadDto = this.doExport(null, started, decompressedForm);
            } else {
                packageVersion = pack.getInternalVersion();
                decompressedForm.setPackageVersion(packageVersion);
                packageLoadDto = this.doRefresh(null, started, pack, decompressedForm);
            }
            if (!BooleanUtils.isTrue((Boolean)packageLoadDto.getLoaded())) break block20;
            ExportZipDto exportZipDto2 = this.exportZipDtoBuilder.buildSuccess();
            IOUtils.closeQuietly((InputStream)zipInputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return exportZipDto2;
        }
        try {
            exportZipDto = this.exportZipDtoBuilder.buildFailure(packageLoadDto.getLoadError(), packageLoadDto.getDetailedError());
        }
        catch (Exception exception) {
            ExportZipDto exportZipDto3;
            try {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                this.logExportPackageAudit(null, started, false, packageId, packageVersion);
                exportZipDto3 = this.exportZipDtoBuilder.buildFailure("Wyst\u0105pi\u0142 b\u0142\u0105d podczas eksportu do systemu.", exception.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipInputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)zipInputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return exportZipDto3;
        }
        IOUtils.closeQuietly((InputStream)zipInputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return exportZipDto;
    }

    private String getValueFromTemplate(JSONObject template, String key) throws JSONException {
        JSONArray array = template.getJSONArray("FormTemplate");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            Iterator objectKeys = object.keys();
            while (objectKeys.hasNext()) {
                String objectKey = (String)objectKeys.next();
                if (!StringUtils.equals((CharSequence)objectKey, (CharSequence)key)) continue;
                return object.getString(key);
            }
        }
        throw new JSONException(key + " nie znaleziony w obiekcie");
    }

    public PackageLoadDto refresh(String userId, PackageLoadForm form) {
        Date started = new Date();
        Package pack = XpdlPackageManager.getInstance().getPackage(form.getPackageId(), form.getPackageVersion());
        try {
            return this.doRefresh(userId, started, pack, this.buildDecompressedForm(form));
        }
        catch (Exception exception) {
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Wyst\u0105pi\u0142 b\u0142\u0105d podczas od\u015bwie\u017cania pakietu.", exception.getMessage());
        }
    }

    private PackageLoadDto doRefresh(String userId, Date started, Package pack, DecompressedPackageLoadForm form) {
        try {
            String xpdlRepositoryPath = this.buildXpdlRepositoryPath(pack);
            String xpdl = form.getXpdl();
            this.backupXpdl(xpdlRepositoryPath, pack);
            if (StringUtils.isNotBlank((CharSequence)xpdl)) {
                if (form.isXpdlAsXml()) {
                    this.generateXpdlFileFromXml(xpdl, xpdlRepositoryPath);
                } else {
                    this.generateXpdlFileFromJson(xpdl, xpdlRepositoryPath);
                }
            } else {
                this.generateXpdlFile(form.getPackageId(), form.getPackageVersion(), xpdlRepositoryPath);
            }
            String xpdlName = FilenameUtils.getName((String)xpdlRepositoryPath);
            Map<Locale, Map<String, String>> translationsForLanguages = this.internalXpdlTranslationService.buildTranslationsForLanguages(form.getXpdlTranslations());
            XpdlPackageManager.getInstance().updatePackage(pack.getId(), xpdlName, true, translationsForLanguages);
            pack = XpdlPackageManager.getInstance().getPackage(pack.getId());
        }
        catch (PackageInvalid exception) {
            log.warn((Object)exception.getXPDLValidationErrors());
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Nie mo\u017cna od\u015bwie\u017cy\u0107 pakietu. Pakiet jest niepoprawny.", exception.getXPDLValidationErrors());
        }
        catch (ExternalPackageInvalid exception) {
            log.warn((Object)exception.getXPDLValidationErrors());
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Nie mo\u017cna od\u015bwie\u017cy\u0107 pakietu. Pakiet jest niepoprawny.", exception.getXPDLValidationErrors());
        }
        catch (TooManyProcessesException exception) {
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Wgranie pakietu spowoduje przekroczenie limitu licencji.");
        }
        catch (WrongProcessesException exception) {
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("W pakiecie zosta\u0142y wykryte procesy niezgodne z licencj\u0105.");
        }
        catch (XpdlPackageValidationException exception) {
            Locale locale = LocaleContextHolder.getLocale();
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Wyst\u0105pi\u0142 b\u0142\u0105d walidacji pakietu.", exception.getTranslatedMessage(locale));
        }
        catch (Exception exception) {
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Wyst\u0105pi\u0142 b\u0142\u0105d podczas od\u015bwie\u017cania pakietu.", exception.getMessage());
        }
        try {
            return this.executeAfterPackageLoadActions(userId, started, form, pack);
        }
        catch (Exception exception) {
            this.logExportPackageAudit(userId, started, false, form.getPackageId(), form.getPackageVersion());
            return this.buildPackageLoadResultForLoadError("Pakiet od\u015bwie\u017cono. Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142adowania pozosta\u0142ych komponent\u00f3w.");
        }
    }

    private String buildXpdlRepositoryPath(Package pack) throws Exception {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(this.getXpdlNameByPackageId(pack));
        return path.toString();
    }

    private String getXpdlNameByPackageId(Package pack) throws Exception {
        String name = XpdlPackageManager.getInstance().getFileNameByPackageId(pack.getId());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name;
        }
        return this.buildXpdlFileName(pack);
    }

    private String buildXpdlFileName(Package pack) {
        StringBuilder name = new StringBuilder();
        name.append(pack.getName());
        name.append(".xpdl");
        return name.toString();
    }

    private void backupXpdl(String xpdlRepositoryPath, Package pack) throws IOException {
        File srcFile = new File(xpdlRepositoryPath);
        File destFile = new File(this.buildXpdlBackupFilePath(xpdlRepositoryPath, pack));
        FileUtils.copyFile((File)srcFile, (File)destFile);
    }

    private String buildXpdlBackupFilePath(String xpdlRepositoryPath, Package pack) {
        StringBuilder name = new StringBuilder();
        name.append(xpdlRepositoryPath);
        name.append(".v");
        name.append(pack.getInternalVersion());
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XpdlOpenDto openFromDisc(String userId, OpenForm form) {
        Date started = new Date();
        MultipartFile file = form.getFile();
        String originalFilename = file.getOriginalFilename();
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logOpenPackageFromDiscAudit(userId, started, false, originalFilename);
            return this.buildOpenXpdlError();
        }
        String xpdlFolderLocation = this.buildUploadedXpdlFolderLocation(userId);
        String xpdlLocation = this.buildXpdlLocation(xpdlFolderLocation, file);
        if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)originalFilename), (String)"xpdl")) {
            try {
                this.pluginService.save(xpdlLocation, bytes);
                JSONObject xpdl = this.transform(this.xmlService.read(bytes));
                this.recentFileService.setForDisc(userId, xpdlLocation);
                this.logOpenPackageFromDiscAudit(userId, started, true, originalFilename);
                return this.buildOpenXpdlSuccess(xpdl);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                this.logOpenPackageFromDiscAudit(userId, started, false, originalFilename);
                return this.buildOpenXpdlError();
            }
        }
        if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)originalFilename), (String)"zip")) {
            XpdlOpenDto xpdlOpenDto;
            ByteArrayInputStream inputStream = null;
            ZipInputStream zipInputStream = null;
            try {
                inputStream = new ByteArrayInputStream(bytes);
                zipInputStream = new ZipInputStream(inputStream);
                String additionalsFolderLocation = this.buildAdditionalsFolderLocation(xpdlLocation);
                ZipEntry entry = null;
                JSONObject xpdl = new JSONObject();
                String xpdlText = "";
                JSONArray formTemplates = new JSONArray();
                ArrayList<ProcessSpecification> processSpecifications = new ArrayList<ProcessSpecification>();
                ArrayList<FormPreviewProcessDataSets> formPreviewProcessDataSets = new ArrayList<FormPreviewProcessDataSets>();
                ArrayList<ProcessGlobalSettings> processGlobalSettings = new ArrayList<ProcessGlobalSettings>();
                String xpdlTranslations = new JSONArray().toString();
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    if (StringUtils.startsWith((CharSequence)entry.getName(), (CharSequence)"__attachment")) {
                        this.documentationService.openAttachmentFromDisc(userId, entry.getName(), additionalsFolderLocation, zipInputStream);
                    }
                    if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"xpdl")) {
                        byte[] entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        xpdlText = new String(entryBytes, Charset.forName("UTF-8"));
                        this.pluginService.save(xpdlLocation, entryBytes);
                        xpdl = this.transform(this.xmlService.read(entryBytes));
                    } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"xml")) {
                        entryLocation = this.buildAdditionalsFileLocation(additionalsFolderLocation, entry);
                        entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        this.pluginService.save(entryLocation, entryBytes);
                        formTemplates.put((Object)this.formTemplateService.openFromDisc(entryBytes));
                    } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"spec")) {
                        entryLocation = this.buildAdditionalsFileLocation(additionalsFolderLocation, entry);
                        entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        this.pluginService.save(entryLocation, entryBytes);
                        processSpecifications.add(this.processSpecificationService.openFromDisc(entryBytes));
                    } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"fpds")) {
                        entryLocation = this.buildAdditionalsFileLocation(additionalsFolderLocation, entry);
                        entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        this.pluginService.save(entryLocation, entryBytes);
                        formPreviewProcessDataSets.add(this.formPreviewProcessDataSetsService.openFromDisc(entryBytes));
                    } else if (FilenameUtils.isExtension((String)StringUtils.lowerCase((String)entry.getName()), (String)"gsett")) {
                        entryLocation = this.buildAdditionalsFileLocation(additionalsFolderLocation, entry);
                        entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        this.pluginService.save(entryLocation, entryBytes);
                        processGlobalSettings.add(this.processGlobalSettingsService.openFromDisc(entryBytes));
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)entry.getName(), (CharSequence)"xpdlTranslations.i18n")) {
                        entryLocation = this.buildAdditionalsFileLocation(additionalsFolderLocation, entry);
                        entryBytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        this.pluginService.save(entryLocation, entryBytes);
                        xpdlTranslations = this.internalXpdlTranslationService.openFromDisc(entryBytes, true);
                    }
                    zipInputStream.closeEntry();
                }
                if (this.dtButtonSpecificationSupplier.shouldSupply(processSpecifications)) {
                    Package pack = PweUtils.getPackage(xpdlText, true);
                    this.dtButtonSpecificationSupplier.supply(pack, processSpecifications);
                }
                this.recentFileService.setForDisc(userId, xpdlLocation);
                this.logOpenPackageFromDiscAudit(userId, started, true, originalFilename);
                xpdlOpenDto = this.buildOpenXpdlSuccess(xpdl, formTemplates, processSpecifications, formPreviewProcessDataSets, processGlobalSettings, xpdlTranslations, false);
            }
            catch (Exception exception) {
                XpdlOpenDto xpdlOpenDto2;
                try {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                    this.logOpenPackageFromDiscAudit(userId, started, false, originalFilename);
                    xpdlOpenDto2 = this.buildOpenXpdlError();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zipInputStream);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)zipInputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                return xpdlOpenDto2;
            }
            IOUtils.closeQuietly((InputStream)zipInputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return xpdlOpenDto;
        }
        this.logOpenPackageFromDiscAudit(userId, started, false, originalFilename);
        return this.buildOpenXpdlError();
    }

    private void logOpenPackageFromDiscAudit(String userId, Date started, boolean success, String fileName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.openfromdisc.param.filename", fileName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_OPEN_PACKAGE_FROM_DISC.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private String buildUploadedXpdlFolderLocation(String userId) {
        StringBuilder location = new StringBuilder();
        location.append("xpdl/uploaded");
        location.append("/");
        location.append(userId);
        return location.toString();
    }

    private String buildXpdlLocation(String xpdlFolderLocation, MultipartFile file) {
        StringBuilder location = new StringBuilder();
        location.append(xpdlFolderLocation);
        location.append("/");
        location.append(FilenameUtils.getBaseName((String)file.getOriginalFilename()));
        location.append(".xpdl");
        return location.toString();
    }

    private String buildAdditionalsFolderLocation(String xpdlLocation) {
        StringBuilder location = new StringBuilder();
        location.append(FilenameUtils.getFullPath((String)xpdlLocation));
        location.append(FilenameUtils.getBaseName((String)xpdlLocation));
        return location.toString();
    }

    private String buildAdditionalsFileLocation(String additionalsFolderLocation, ZipEntry entry) {
        StringBuilder location = new StringBuilder();
        location.append(additionalsFolderLocation);
        location.append("/");
        location.append(entry.getName());
        return location.toString();
    }

    private XpdlOpenDto buildOpenXpdlSuccess(JSONObject xpdl) {
        return this.xpdlOpenDtoBuilder.buildSuccess(xpdl);
    }

    private XpdlOpenDto buildOpenXpdlSuccess(JSONObject xpdl, String xpdlTranslations) {
        return this.xpdlOpenDtoBuilder.buildSuccess(xpdl, xpdlTranslations);
    }

    private XpdlOpenDto buildOpenXpdlSuccess(JSONObject xpdl, JSONArray formTemplates, List<ProcessSpecification> processSpecifications, List<FormPreviewProcessDataSets> formPreviewProcessDataSets, List<ProcessGlobalSettings> processGlobalSettings, String xpdlTranslations, boolean additionalsMissing) {
        return this.xpdlOpenDtoBuilder.buildSuccess(xpdl, formTemplates, processSpecifications, formPreviewProcessDataSets, processGlobalSettings, xpdlTranslations, additionalsMissing);
    }

    private XpdlOpenDto buildOpenXpdlError() {
        return this.xpdlOpenDtoBuilder.buildError();
    }

    public XpdlOpenDto openFromSystem(String userId, OpenForm form) {
        Date started = new Date();
        String packageId = form.getPath();
        try {
            Package pack = XpdlPackageManager.getInstance().getPackage(packageId);
            if (pack != null) {
                byte[] bytes = this.getPackageBytes(packageId);
                JSONObject xpdl = this.transform(this.xmlService.read(bytes));
                String additionalsFolderPath = this.buildAdditionalsFolderPath(pack);
                boolean additionalsMissing = Files.notExists(Paths.get(additionalsFolderPath, new String[0]), new LinkOption[0]);
                JSONArray formTemplates = this.formTemplateService.openFromSystem(additionalsFolderPath);
                List<ProcessSpecification> processSpecifications = this.processSpecificationService.openFromSystem(additionalsFolderPath);
                List<FormPreviewProcessDataSets> formPreviewProcessDataSets = this.formPreviewProcessDataSetsService.openFromSystem(additionalsFolderPath);
                List<ProcessGlobalSettings> processGlobalSettings = this.processGlobalSettingsService.openFromSystem(additionalsFolderPath);
                String xpdlTranslations = this.internalXpdlTranslationService.openFromSystem(packageId);
                this.documentationService.openAttachmentsFromSystem(userId, additionalsFolderPath);
                if (this.dtButtonSpecificationSupplier.shouldSupply(processSpecifications)) {
                    this.dtButtonSpecificationSupplier.supply(pack, processSpecifications);
                }
                this.recentFileService.setForSystem(userId, packageId);
                this.logOpenPackageFromSystemAudit(userId, started, true, packageId);
                return this.buildOpenXpdlSuccess(xpdl, formTemplates, processSpecifications, formPreviewProcessDataSets, processGlobalSettings, xpdlTranslations, additionalsMissing);
            }
            this.recentFileService.deleteForSystem(packageId);
            this.logOpenPackageFromSystemAudit(userId, started, false, packageId);
            return this.buildOpenXpdlError();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logOpenPackageFromSystemAudit(userId, started, false, packageId);
            return this.buildOpenXpdlError();
        }
    }

    private void logOpenPackageFromSystemAudit(String userId, Date started, boolean success, String packageId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.openfromsystem.param.packageid", packageId);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_OPEN_PACKAGE_FROM_SYSTEM.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    public XpdlOpenDto openFromSaved(String userId, OpenForm form) {
        Date started = new Date();
        String xpdlLocation = form.getPath();
        String additionalsLocationPrefix = this.buildAdditionalsLocationPrefix(this.buildSavedXpdlFolderLocation(userId), xpdlLocation);
        XpdlOpenDto xpdlOpenDto = this.openFromStored(userId, xpdlLocation, additionalsLocationPrefix, true);
        this.logOpenPackageFromSavedAudit(userId, started, BooleanUtils.isTrue((Boolean)xpdlOpenDto.getSuccess()), FilenameUtils.getName((String)xpdlLocation));
        return xpdlOpenDto;
    }

    private void logOpenPackageFromSavedAudit(String userId, Date started, boolean success, String fileName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.openfromsaved.param.filename", fileName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_OPEN_PACKAGE_FROM_SAVED.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private String buildAdditionalsLocationPrefix(String subPrefix, String xpdlLocation) {
        StringBuilder prefix = new StringBuilder();
        prefix.append(subPrefix);
        prefix.append("/");
        prefix.append(FilenameUtils.getBaseName((String)xpdlLocation));
        return prefix.toString();
    }

    public XpdlOpenDto openFromAutoSaved(String userId, OpenForm form) {
        String xpdlLocation = form.getPath();
        String additionalsLocationPrefix = this.buildAutoSavedAdditionalsLocationPrefix(xpdlLocation);
        return this.openFromStored(userId, xpdlLocation, additionalsLocationPrefix, false);
    }

    private String buildAutoSavedAdditionalsLocationPrefix(String xpdlLocation) {
        StringBuilder prefix = new StringBuilder();
        prefix.append(FilenameUtils.getFullPath((String)xpdlLocation));
        prefix.append(FilenameUtils.getBaseName((String)xpdlLocation));
        return prefix.toString();
    }

    private XpdlOpenDto openFromStored(String userId, String xpdlLocation, String additionalsLocationPrefix, boolean addRecentFile) {
        try {
            byte[] xpdlBytes = this.readSavedResourceBytes(xpdlLocation);
            JSONObject xpdl = this.transform(this.xmlService.read(xpdlBytes));
            JSONArray formTemplates = this.formTemplateService.openFromSaved(additionalsLocationPrefix);
            List<ProcessSpecification> processSpecifications = this.processSpecificationService.openFromSaved(additionalsLocationPrefix);
            List<FormPreviewProcessDataSets> formPreviewProcessDataSets = this.formPreviewProcessDataSetsService.openFromSaved(additionalsLocationPrefix);
            List<ProcessGlobalSettings> processGlobalSettings = this.processGlobalSettingsService.openFromSaved(additionalsLocationPrefix);
            String xpdlTranslations = this.internalXpdlTranslationService.openFromSaved(additionalsLocationPrefix);
            this.documentationService.openAttachmentsFromSaved(userId, additionalsLocationPrefix);
            if (this.dtButtonSpecificationSupplier.shouldSupply(processSpecifications)) {
                String xpdlText = new String(xpdlBytes, Charset.forName("UTF-8"));
                Package pack = PweUtils.getPackage(xpdlText, true);
                this.dtButtonSpecificationSupplier.supply(pack, processSpecifications);
            }
            if (addRecentFile) {
                this.recentFileService.setForSaved(userId, xpdlLocation);
            }
            return this.buildOpenXpdlSuccess(xpdl, formTemplates, processSpecifications, formPreviewProcessDataSets, processGlobalSettings, xpdlTranslations, false);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return this.buildOpenXpdlError();
        }
    }

    private byte[] readSavedResourceBytes(String location) throws IOException {
        PluginStoreResource resource = this.pluginService.getSavedResource(location);
        try (InputStream inputStream = resource.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    public XpdlOpenDto openRecentFile(String userId, OpenForm form) {
        RecentFileDto dto = this.recentFileService.getForUser(userId, form.getPath());
        if (dto != null) {
            switch (RecentFileLocationName.getByName(dto.getLocationName())) {
                case DISC: {
                    return this.openRecentFileFromDisc(userId, form);
                }
                case SYSTEM: {
                    return this.openFromSystem(userId, form);
                }
                case SAVED: {
                    return this.openFromSaved(userId, form);
                }
            }
            return this.buildOpenXpdlError();
        }
        return this.buildOpenXpdlError();
    }

    private XpdlOpenDto openRecentFileFromDisc(String userId, OpenForm form) {
        Date started = new Date();
        String xpdlLocation = form.getPath();
        String additionalsLocationPrefix = this.buildAdditionalsLocationPrefix(this.buildUploadedXpdlFolderLocation(userId), xpdlLocation);
        XpdlOpenDto xpdlOpenDto = this.openFromStored(userId, xpdlLocation, additionalsLocationPrefix, true);
        this.logOpenPackageFromDiscAudit(userId, started, BooleanUtils.isTrue((Boolean)xpdlOpenDto.getSuccess()), FilenameUtils.getName((String)xpdlLocation));
        return xpdlOpenDto;
    }

    private XpdlOpenDto openFromUploaded(String userId, OpenForm form) {
        String xpdlLocation = form.getPath();
        String additionalsLocationPrefix = this.buildAdditionalsLocationPrefix(this.buildUploadedXpdlFolderLocation(userId), xpdlLocation);
        return this.openFromStored(userId, xpdlLocation, additionalsLocationPrefix, true);
    }

    public XpdlOpenDto openExample(String userId, OpenForm form) {
        Date started = new Date();
        String path = form.getPath();
        try {
            Resource resource = this.pluginService.getResource(path);
            JSONObject xpdl = this.transform(this.xmlService.read(resource.getInputStream()));
            this.logOpenPackageFromExamplesAudit(userId, started, true, FilenameUtils.getBaseName((String)path));
            return this.buildOpenXpdlSuccess(xpdl);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logOpenPackageFromExamplesAudit(userId, started, false, FilenameUtils.getBaseName((String)path));
            return this.buildOpenXpdlError();
        }
    }

    private void logOpenPackageFromExamplesAudit(String userId, Date started, boolean success, String exampleName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.openfromexamples.param.examplename", exampleName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_OPEN_PACKAGE_FROM_EXAMPLES.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    public XpdlOpenDto openPackageVersion(String userId, OpenForm form) {
        Date started = new Date();
        String packageId = form.getPackageId();
        String packageVersion = form.getPackageVersion();
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId, packageVersion);
        try {
            byte[] bytes = this.getPackageBytes(pack.getId(), pack.getInternalVersion());
            JSONObject xpdl = this.transform(this.xmlService.read(bytes));
            String additionalsFolderPath = this.buildAdditionalsFolderPath(pack);
            boolean additionalsMissing = Files.notExists(Paths.get(additionalsFolderPath, new String[0]), new LinkOption[0]);
            JSONArray formTemplates = this.formTemplateService.openFromSystem(additionalsFolderPath);
            List<ProcessSpecification> processSpecifications = this.processSpecificationService.openFromSystem(additionalsFolderPath);
            List<FormPreviewProcessDataSets> formPreviewProcessDataSets = this.formPreviewProcessDataSetsService.openFromSystem(additionalsFolderPath);
            List<ProcessGlobalSettings> processGlobalSettings = this.processGlobalSettingsService.openFromSystem(additionalsFolderPath);
            String xpdlTranslations = this.internalXpdlTranslationService.openFromSystem(pack.getId());
            this.documentationService.openAttachmentsFromSystem(userId, additionalsFolderPath);
            if (this.dtButtonSpecificationSupplier.shouldSupply(processSpecifications)) {
                this.dtButtonSpecificationSupplier.supply(pack, processSpecifications);
            }
            this.logOpenPackageVersionAudit(userId, started, true, packageId, packageVersion);
            return this.buildOpenXpdlSuccess(xpdl, formTemplates, processSpecifications, formPreviewProcessDataSets, processGlobalSettings, xpdlTranslations, additionalsMissing);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logOpenPackageVersionAudit(userId, started, false, packageId, packageVersion);
            return this.buildOpenXpdlError();
        }
    }

    private void logOpenPackageVersionAudit(String userId, Date started, boolean success, String packageId, String packageVersion) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.package.openversion.param.packageid", packageId);
        params.put("pwe.audit.package.openversion.param.packageversion", packageVersion);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_OPEN_PACKAGE_VERSION.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    public XpdlOpenDto openProcess(OpenForm form) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(form.getProcessDefId());
        try {
            byte[] bytes = this.getPackageBytes(pack.getId(), pack.getInternalVersion());
            JSONObject xpdl = this.transform(this.xmlService.read(bytes));
            String xpdlTranslations = this.internalXpdlTranslationService.openFromSystem(pack.getId());
            return this.buildOpenXpdlSuccess(xpdl, xpdlTranslations);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return this.buildOpenXpdlError();
        }
    }

    public byte[] generateErrorsTextFileContent(SaveXpdlErrorsForm form) {
        StringBuffer content = new StringBuffer();
        if (CollectionUtils.isNotEmpty(form.getErrors())) {
            Map<String, String> headers = form.getHeaders();
            for (Map<String, String> error : form.getErrors()) {
                for (String fieldId : ERROR_FIELDS) {
                    content.append(headers.get(fieldId));
                    content.append(": ");
                    content.append(error.get(fieldId));
                    content.append(ENTER);
                }
                content.append(ENTER);
            }
        }
        return content.toString().getBytes(Charset.forName("UTF-8"));
    }

    public VariableTypeValidationDto validateVariableType(ValidateVariableTypeForm form) {
        VariableTypeValidationDto dto = new VariableTypeValidationDto();
        SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        try {
            String processDefId = form.getProcessDefId();
            String tableName = XpdlTools.getTableName((String)processDefId);
            String variableId = form.getVariableId();
            if (this.shouldCheckVariableTypeChange(tableName, variableId, session)) {
                String variableType = form.getVariableType();
                String placement = form.getPlacement();
                String variableClassName = VariableType.getType(variableType, placement).getClassTypeName();
                String currentColumnClassName = XpdlTools.getColumnClassName((String)tableName, (String)variableId, (Session)session);
                dto.setCorrect(XpdlTools.isPmidxClassCompatibleWithClass((String)currentColumnClassName, (String)variableClassName));
            } else {
                dto.setCorrect(true);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            transaction.rollback();
            throw new ValidateVariableTypeException(exception);
        }
        finally {
            if (session.isOpen()) {
                session.close();
            }
        }
        return dto;
    }

    private boolean shouldCheckVariableTypeChange(String tableName, String variableId, Session session) {
        return XpdlTools.checkTableExists((String)tableName, (Session)session) && XpdlTools.checkColumnExists((String)tableName, (String)variableId, (Session)session) && !XpdlTools.isTableEmpty((String)tableName, (Session)session);
    }

    public VariableIdValidationDto validateVariableId(String variableId, String previousVariableId) {
        VariableIdValidationDto dto = new VariableIdValidationDto();
        dto.setCorrect(InternalXpdlService.isVariableIdCorrect(variableId, previousVariableId));
        return dto;
    }

    private static boolean isVariableIdCorrect(String variableId, String previousVariableId) {
        boolean externallyCorrect = !ForbiddenWords.isForbidden((String)variableId);
        boolean internallyCorrect = false;
        internallyCorrect = StringUtils.isBlank((CharSequence)previousVariableId) ? !ForbiddenVariableId.isForbidden(variableId) : StringUtils.equals((CharSequence)variableId, (CharSequence)previousVariableId) || !ForbiddenVariableId.isForbidden(variableId);
        return externallyCorrect && internallyCorrect;
    }

    public boolean resetAutoSaved(String userId, String moduleStartTime) {
        this.deleteAutoSaved(userId, moduleStartTime);
        return true;
    }

    public void deleteAutoSaved(String userId, String moduleStartTime) {
        String xpdlFolderLocation = this.buildAutoSavedXpdlFolderLocation(userId, moduleStartTime);
        this.pluginService.delete(xpdlFolderLocation);
    }

    public boolean deleteAutoSaved(String path) {
        String xpdlFolderLocation = FilenameUtils.getFullPath((String)path);
        this.pluginService.delete(xpdlFolderLocation);
        return true;
    }

    public boolean deleteAllAutoSaved(String userId) {
        String xpdlFolderLocation = this.buildAutoSavedXpdlFolderLocation(userId);
        this.pluginService.delete(xpdlFolderLocation);
        return true;
    }

    public byte[] exportTranslationsToExcel(String userId, ExportTranslationsForm form) {
        return this.internalXpdlTranslationService.exportToExcel(userId, form.getTranslations());
    }

    public PackageTranslationImportDto importTranslationsFromExcel(String userId, ImportTranslationsForm form) {
        return this.internalXpdlTranslationService.importFromExcel(userId, form.getFile());
    }

    public void loadTranslationsToSystem(String userId, String xpdlTranslations) {
        Date started = new Date();
        try {
            this.internalXpdlTranslationService.loadToSystem(xpdlTranslations);
            this.logLoadTranslationsAudit(userId, started, true);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logLoadTranslationsAudit(userId, started, false);
            throw new LoadXpdlTranslationsException(exception);
        }
    }

    private void logLoadTranslationsAudit(String userId, Date started, boolean success) {
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_LOAD_TRANSLATIONS.getValue()).username(userId).success(success).params(new LinkedHashMap()).started(started).stopped(new Date()).build().log();
    }

    private JSONObject transform(JSONObject xpdl) {
        return this.divanteTransformer.transformXpdl(xpdl);
    }
}

