/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.i18n;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.generator.excel.ExcelGenerator;
import com.suncode.plugin.pwe.json.JsonConverter;
import com.suncode.plugin.pwe.reader.excel.ExcelReader;
import com.suncode.plugin.pwe.service.language.LanguageService;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.util.CellData;
import com.suncode.plugin.pwe.util.FileData;
import com.suncode.plugin.pwe.util.MapOfMaps;
import com.suncode.plugin.pwe.util.RowData;
import com.suncode.plugin.pwe.web.support.dto.xpdl.KeyTranslationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageTranslationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageTranslationImportDto;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.util.LzStringUtils;
import com.suncode.pwfl.xpdl.XpdlTranslationService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InternalXpdlTranslationService {
    public static Logger log = Logger.getLogger(InternalXpdlTranslationService.class);
    private static final String TRANSLATIONS_FILE_EXTENSION = "i18n";
    public static final String TRANSLATIONS_FILE_NAME = "xpdlTranslations.i18n";
    private static final String EMPTY_TRANSLATIONS = new JSONArray().toString();
    private static final String LT = "<";
    private static final String ENCODED_LT = "@PWE_LT@";
    private static final String GT = ">";
    private static final String ENCODED_GT = "@PWE_GT@";
    private static final String KEY_HEADER = "pwe.xpdltranslation.header.key";
    private static final String KEY_TYPE_HEADER = "pwe.xpdltranslation.header.keytype";
    private static final String DEFAULT_VALUE_HEADER = "pwe.xpdltranslation.header.defaultvalue";
    private static final String KEY_FIELD_NAME = "key";
    private static final String KEY_TYPE_FIELD_NAME = "keyType";
    private static final String DEFAULT_VALUE_FIELD_NAME = "defaultValue";
    private static final int FIRST_LANGUAGE_CELL_INDEX = 3;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ZipService zipService;
    @Autowired
    private XpdlTranslationService xpdlTranslationService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    @Qualifier(value="translationsJsonConverter")
    private JsonConverter<Map<String, String>> translationsJsonConverter;
    @Autowired
    private ExcelGenerator excelGenerator;
    @Autowired
    private ExcelReader excelReader;
    @Autowired
    private TranslatorService translatorService;

    public void save(String xpdlTranslations, String additionalsFolderLocation) throws IOException {
        String fileLocation = this.buildTranslationsFileLocation(additionalsFolderLocation);
        this.pluginService.save(fileLocation, xpdlTranslations);
    }

    private String buildTranslationsFileLocation(String additionalsFolderLocation) {
        StringBuilder location = new StringBuilder();
        location.append(additionalsFolderLocation);
        location.append("/");
        location.append(TRANSLATIONS_FILE_NAME);
        return location.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToZip(ZipOutputStream zipOutputStream, String xpdlTranslations) throws IOException {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            this.write(xpdlTranslations, outputStream);
            this.zipService.addToZip(zipOutputStream, TRANSLATIONS_FILE_NAME, outputStream.toByteArray());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private void write(String xpdlTranslations, OutputStream outputStream) throws IOException {
        IOUtils.write((String)xpdlTranslations, (OutputStream)outputStream, (Charset)Charset.forName("UTF-8"));
    }

    public Map<Locale, Map<String, String>> buildTranslationsForLanguages(String xpdlTranslations) {
        List<String> supportedLanguages = this.languageService.getSupportedLanguages();
        Map<String, Map<String, String>> translationsForLanguages = this.initTranslationsForLanguages(supportedLanguages);
        MapOfMaps keyTranslationsMap = (MapOfMaps)new Gson().fromJson(xpdlTranslations, new TypeToken<MapOfMaps<String, String, String>>(){}.getType());
        for (String key : keyTranslationsMap.keySet()) {
            Map translations = (Map)keyTranslationsMap.get(key);
            for (String supportedLanguage : supportedLanguages) {
                String translation = (String)translations.get(supportedLanguage);
                Map<String, String> properties = translationsForLanguages.get(supportedLanguage);
                properties.put(key, translation);
                translationsForLanguages.put(supportedLanguage, properties);
            }
        }
        return this.convertTranslationsForLanguages(translationsForLanguages);
    }

    private Map<String, Map<String, String>> initTranslationsForLanguages(List<String> supportedLanguages) {
        HashMap<String, Map<String, String>> translationsForLanguages = new HashMap<String, Map<String, String>>();
        for (String supportedLanguage : supportedLanguages) {
            translationsForLanguages.put(supportedLanguage, new HashMap());
        }
        return translationsForLanguages;
    }

    private Map<Locale, Map<String, String>> convertTranslationsForLanguages(Map<String, Map<String, String>> translationsForLanguages) {
        return translationsForLanguages.entrySet().stream().collect(Collectors.toMap(entry -> new Locale((String)entry.getKey()), Map.Entry::getValue));
    }

    public void loadToSystem(String xpdlTranslations) throws Exception {
        Map<Locale, Map<String, String>> translationsForLanguages = this.buildTranslationsForLanguages(xpdlTranslations);
        this.xpdlTranslationService.addTranslations(translationsForLanguages);
    }

    public String openFromSaved(String additionalsFolderLocation) throws IOException {
        String fileLocation = this.buildTranslationsFileLocation(additionalsFolderLocation);
        PluginStoreResource resource = this.pluginService.getSavedResource(fileLocation);
        if (resource != null) {
            return this.read(resource);
        }
        return EMPTY_TRANSLATIONS;
    }

    private String read(PluginStoreResource resource) throws IOException {
        byte[] bytes = this.readBytes(resource);
        return this.convertToString(bytes, true);
    }

    private byte[] readBytes(PluginStoreResource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    private String convertToString(byte[] bytes, boolean encode) {
        String string = new String(bytes, Charset.forName("UTF-8"));
        if (encode) {
            return this.encodeString(string);
        }
        return string;
    }

    private String encodeString(String string) {
        string = StringUtils.replaceAll((String)string, (String)LT, (String)ENCODED_LT);
        return StringUtils.replaceAll((String)string, (String)GT, (String)ENCODED_GT);
    }

    public String openFromDisc(byte[] bytes, boolean encode) {
        return this.convertToString(bytes, encode);
    }

    public String openFromSystem(String packageId) throws IOException {
        MapOfMaps keyTranslationsMap = new MapOfMaps();
        Map translationsForLanguages = this.xpdlTranslationService.getTranslations(packageId, this.getSupportedLocales());
        for (Map.Entry languageEntry : translationsForLanguages.entrySet()) {
            String language = ((Locale)languageEntry.getKey()).getLanguage();
            for (Map.Entry translationEntry : ((Map)languageEntry.getValue()).entrySet()) {
                String key = (String)translationEntry.getKey();
                HashMap<String, String> translations = (HashMap<String, String>)keyTranslationsMap.get(key);
                if (translations == null) {
                    translations = new HashMap<String, String>();
                }
                translations.put(language, (String)translationEntry.getValue());
                keyTranslationsMap.put(key, translations);
            }
        }
        return new Gson().toJson(keyTranslationsMap, new TypeToken<MapOfMaps<String, String, String>>(){}.getType());
    }

    private List<Locale> getSupportedLocales() {
        return this.languageService.getSupportedLanguages().stream().map(Locale::new).collect(Collectors.toList());
    }

    public byte[] exportToExcel(String userId, String translations) {
        Date started = new Date();
        try {
            FileData fileData = this.buildExcelFileData(translations);
            Workbook workbook = this.excelGenerator.generate(fileData);
            byte[] bytes = this.convertToBytes(workbook);
            this.logExportTranslationsAudit(userId, started, true);
            return bytes;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logExportTranslationsAudit(userId, started, false);
            return new byte[0];
        }
    }

    private void logExportTranslationsAudit(String userId, Date started, boolean success) {
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_EXPORT_TRANSLATIONS.getValue()).username(userId).success(success).params(new LinkedHashMap()).started(started).stopped(new Date()).build().log();
    }

    private FileData buildExcelFileData(String translations) throws Exception {
        List<String> supportedLanguages = this.languageService.getSupportedLanguages();
        return new FileData(this.buildExcelHeader(supportedLanguages), this.buildExcelRows(translations, supportedLanguages));
    }

    private RowData buildExcelHeader(List<String> supportedLanguages) {
        ArrayList<CellData> cells = new ArrayList<CellData>();
        cells.add(new CellData(this.buildExcelHeaderKeyCellValue()));
        cells.add(new CellData(this.buildExcelHeaderKeyTypeCellValue()));
        cells.add(new CellData(this.buildExcelHeaderDefaultValueCellValue()));
        supportedLanguages.stream().map(CellData::new).forEach(cells::add);
        return new RowData(cells);
    }

    private String buildExcelHeaderKeyCellValue() {
        return this.translatorService.translateMessage(KEY_HEADER);
    }

    private String buildExcelHeaderKeyTypeCellValue() {
        return this.translatorService.translateMessage(KEY_TYPE_HEADER);
    }

    private String buildExcelHeaderDefaultValueCellValue() {
        return this.translatorService.translateMessage(DEFAULT_VALUE_HEADER);
    }

    private List<RowData> buildExcelRows(String translations, List<String> supportedLanguages) throws Exception {
        List<Map<String, String>> records = this.translationsJsonConverter.convertToList(LzStringUtils.decompressFromBase64((String)translations));
        return records.stream().map(r -> this.buildExcelRow((Map<String, String>)r, supportedLanguages)).collect(Collectors.toList());
    }

    private RowData buildExcelRow(Map<String, String> record, List<String> supportedLanguages) {
        ArrayList<CellData> cells = new ArrayList<CellData>();
        cells.add(new CellData(this.buildExcelCellValue(record, KEY_FIELD_NAME)));
        cells.add(new CellData(this.buildExcelCellValue(record, KEY_TYPE_FIELD_NAME)));
        cells.add(new CellData(this.buildExcelCellValue(record, DEFAULT_VALUE_FIELD_NAME)));
        supportedLanguages.stream().map(l -> this.buildExcelCell(record, (String)l)).forEach(cells::add);
        return new RowData(cells);
    }

    private String buildExcelCellValue(Map<String, String> record, String fieldName) {
        return StringUtils.defaultString((String)record.get(fieldName));
    }

    private CellData buildExcelCell(Map<String, String> record, String supportedLanguage) {
        return new CellData(this.buildExcelCellValue(record, supportedLanguage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertToBytes(Workbook workbook) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public PackageTranslationImportDto importFromExcel(String userId, MultipartFile file) {
        Date started = new Date();
        try {
            FileData fileData = this.excelReader.read(file.getInputStream());
            Map<Integer, String> languageIndexMap = this.getLanguageIndexMap(fileData.getHeader());
            ArrayList<PackageTranslationDto> dtos = new ArrayList<PackageTranslationDto>();
            for (RowData row : fileData.getRows()) {
                dtos.add(this.buildTranslationFromExcel(row, languageIndexMap));
            }
            this.logImportTranslationsAudit(userId, started, true);
            return new PackageTranslationImportDto(true, dtos);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logImportTranslationsAudit(userId, started, false);
            return new PackageTranslationImportDto(false, Collections.emptyList());
        }
    }

    private void logImportTranslationsAudit(String userId, Date started, boolean success) {
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_IMPORT_TRANSLATIONS.getValue()).username(userId).success(success).params(new LinkedHashMap()).started(started).stopped(new Date()).build().log();
    }

    private Map<Integer, String> getLanguageIndexMap(RowData header) {
        HashMap<Integer, String> languageIndexMap = new HashMap<Integer, String>();
        List<CellData> cells = header.getCells();
        for (int i = 3; i < cells.size(); ++i) {
            CellData cell = cells.get(i);
            languageIndexMap.put(i, cell.getValue());
        }
        return languageIndexMap;
    }

    private PackageTranslationDto buildTranslationFromExcel(RowData row, Map<Integer, String> languageIndexMap) {
        List<CellData> cells = row.getCells();
        String key = cells.get(0).getValue();
        ArrayList<KeyTranslationDto> keyTranslations = new ArrayList<KeyTranslationDto>();
        for (Map.Entry<Integer, String> entries : languageIndexMap.entrySet()) {
            if (cells.size() <= entries.getKey()) continue;
            CellData cell = cells.get(entries.getKey());
            String translation = this.encodeString(cell.getValue());
            keyTranslations.add(new KeyTranslationDto(entries.getValue(), translation));
        }
        return new PackageTranslationDto(key, keyTranslations);
    }
}

