/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.formpreview;

import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.util.FormVariableLabel;
import com.suncode.plugin.pwe.util.Label;
import com.suncode.plugin.pwe.util.ProcessGlobalSettings;
import com.suncode.plugin.pwe.util.VariableSetFont;
import com.suncode.plugin.pwe.util.XmlAttribute;
import java.io.OutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ProcessGlobalSettingsMarshaller {
    @Autowired
    private XmlService xmlService;

    public void marshall(OutputStream outputStream, ProcessGlobalSettings processGlobalSettings) throws Exception {
        Document document = this.xmlService.create();
        Element root = ProcessGlobalSettingsMarshaller.marshallRoot(document);
        document.appendChild(root);
        this.xmlService.setElementAttribute(root, new XmlAttribute("id", processGlobalSettings.getId()));
        Element formVariableLabelElement = this.marshallFormVariableLabel(document, processGlobalSettings.getFormVariableLabel());
        root.appendChild(formVariableLabelElement);
        Element labelElement = this.marshallLabelElement(document, processGlobalSettings.getLabel());
        root.appendChild(labelElement);
        Element variableSetFontElement = this.marshallVariableSetFontElement(document, processGlobalSettings.getVariableSetFont());
        root.appendChild(variableSetFontElement);
        this.xmlService.writeToOutputStream(outputStream, document);
    }

    private static Element marshallRoot(Document document) {
        return document.createElement("ProcessGlobalSettings");
    }

    private Element marshallFormVariableLabel(Document document, FormVariableLabel formVariableLabel) {
        Element element = document.createElement("FormVariableLabel");
        this.xmlService.appendTextElement(document, element, "LabelAlign", formVariableLabel.getLabelAlign());
        this.xmlService.appendTextElement(document, element, "LabelColor", formVariableLabel.getLabelColor());
        this.xmlService.appendTextElement(document, element, "LabelSeparator", formVariableLabel.getLabelSeparator());
        this.xmlService.appendTextElement(document, element, "LabelWidth", formVariableLabel.getLabelWidth());
        this.xmlService.appendTextElement(document, element, "LabelFontSize", formVariableLabel.getLabelFontSize());
        this.xmlService.appendTextElement(document, element, "TextDecoration", formVariableLabel.getTextDecoration());
        return element;
    }

    private Element marshallLabelElement(Document document, Label label) {
        Element element = document.createElement("Label");
        this.xmlService.appendTextElement(document, element, "FontSize", label.getFontSize());
        this.xmlService.appendTextElement(document, element, "Color", label.getColor());
        return element;
    }

    private Element marshallVariableSetFontElement(Document document, VariableSetFont variableSetFont) {
        Element element = document.createElement("VariableSetFont");
        this.xmlService.appendTextElement(document, element, "CellFontSize", variableSetFont.getCellFontSize());
        this.xmlService.appendTextElement(document, element, "HeaderFontSize", variableSetFont.getHeaderFontSize());
        return element;
    }
}

