/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.object.FormVariable;
import com.suncode.plugin.pwe.documentation.util.VariableUtils;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.stereotype.Component;

@Component
public class FormVariableBuilder {
    private static final String READONLY_EXT_ATTR_NAME = "READONLY";
    private static final String READONLY_EXT_ATTR_VALUE = "TRUE";

    public FormVariable buildVariableToProcessView(WorkflowProcess process, String extAttrValue) {
        FormVariable formVariable = this.buildBase(process, extAttrValue);
        return formVariable;
    }

    public FormVariable buildVariableToProcessUpdate(WorkflowProcess process, String extAttrValue) {
        FormVariable formVariable = this.buildBase(process, extAttrValue);
        formVariable.setEditable(true);
        return formVariable;
    }

    public FormVariable buildVariableToProcessHidden(WorkflowProcess process, String extAttrValue) {
        FormVariable formVariable = this.buildBase(process, extAttrValue);
        formVariable.setHidden(true);
        return formVariable;
    }

    private FormVariable buildBase(WorkflowProcess process, String extAttrValue) {
        String id = VariableUtils.getVariableIdFromExtendedAttribute(extAttrValue);
        DataField dataField = process.getDataField(id);
        FormVariable formVariable = new FormVariable();
        formVariable.setId(id);
        formVariable.setReadOnly(this.buildReadOnly(dataField));
        return formVariable;
    }

    private boolean buildReadOnly(DataField dataField) {
        return ExtAttrUtils.hasExtAttr(dataField.getExtendedAttributes(), READONLY_EXT_ATTR_NAME, READONLY_EXT_ATTR_VALUE);
    }
}

