/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ParticipantSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParticipantUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="processParticipantsListChapterBuilder")
public class ProcessParticipantsListChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.processparticipantslist";
    private static final String PARTICIPANT_ID_EXT_ATTR_NAME = "JaWE_GRAPH_PARTICIPANT_ID";
    private static final String PARTICIPANT_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.participantdescription";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification, translationInfo);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo) {
        Set<String> participantIds = this.buildParticipantIds(process);
        if (CollectionUtils.isNotEmpty(participantIds)) {
            Counter subchapterNo = new Counter(1);
            for (String participantId : participantIds) {
                Participant participant = this.buildParticipant(process, participantId);
                ParticipantSpecification participantSpecification = this.getParticipantSpecification(processSpecification, participantId);
                this.buildSubchapter(documentation, process, translationInfo, participant, participantSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private Set<String> buildParticipantIds(WorkflowProcess process) {
        HashSet<String> participantIds = new HashSet<String>();
        Activities activities = process.getActivities();
        if (!activities.isEmpty()) {
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                ExtendedAttributes extAttrs = activity.getExtendedAttributes();
                String participantId = ExtAttrUtils.getExtAttrValue(extAttrs, PARTICIPANT_ID_EXT_ATTR_NAME);
                participantIds.add(participantId);
            }
        }
        return participantIds;
    }

    private Participant buildParticipant(WorkflowProcess process, String participantId) {
        return ParticipantUtils.getParticipant(process, participantId);
    }

    private ParticipantSpecification getParticipantSpecification(ProcessSpecification processSpecification, String participantId) {
        if (MapUtils.isNotEmpty(processSpecification.getParticipantSpecifications()) && processSpecification.getParticipantSpecifications().containsKey(participantId)) {
            return processSpecification.getParticipantSpecifications().get(participantId);
        }
        return new ParticipantSpecification();
    }

    private void buildSubchapter(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Participant participant, ParticipantSpecification participantSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(process, translationInfo, participant, subchapterNo);
        String bookmarkName = this.buildBookmarkName(participant);
        documentation.addBookmarkedSubchapter(title, bookmarkName);
        if (StringUtils.isNotBlank((CharSequence)participantSpecification.getDescription())) {
            this.buildParticipantDescriptionPoint(documentation, process, translationInfo, participantSpecification);
        }
    }

    private String buildSubchapterTitle(WorkflowProcess process, TranslationInfo translationInfo, Participant participant, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        if (process.getParticipants().containsElement(participant.getId())) {
            title.append(this.translatorService.translateProcessParticipantName(translationInfo, process, participant));
        } else {
            title.append(this.translatorService.translatePackageParticipantName(translationInfo, participant));
        }
        return title.toString();
    }

    private String buildBookmarkName(Participant participant) {
        return BookmarkNameUtils.getNameForParticipant(participant.getId());
    }

    private void buildParticipantDescriptionPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, ParticipantSpecification participantSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, participantSpecification.getDescription());
        this.buildPoint(documentation, PARTICIPANT_DESCRIPTION_POINT_TITLE, contents);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, TranslationInfo translationInfo, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, translationInfo, description);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, contents);
    }
}

