function deleteBasicLine( lineEl ) {
    var connector = lineEl.data( 'connectFrom' );
    var transitionId = lineEl.data( 'transitionId' );
    var paper = connector.paper;
    paper.bpmn.eraseTrash( paper.resizerTrash );
    connector.removeConnectionById( transitionId );
}

function changeConditionalLineType( arg ) {
    var conditionType = arg.conditionType;
    var newConditionType = conditionType == 'XOR' ? 'AND' : 'XOR';
    var el = arg.el;
    var paper = el.paper;
    paper.bpmn.changeConditionalLineType( el, newConditionType );
}

function deleteConditionalLine( arg ) {
    var connector = arg.connector;
    var transitionId = arg.transitionId;
    var inout = arg.inout;
    var paper = connector.paper;
    var processDefId = arg.processDefId;
    var packagePanel = Ext.getCmp( 'package_panel' );

    switch ( inout ) {
        case 'in':
            var condBox = connector.getInConnectionBox( transitionId );
            var connectedWith = condBox.data( 'connectedWith' );
            var activityDefId = connectedWith.data( 'activityDefId' );
            var activityNode = packagePanel.findActivity( processDefId, activityDefId );
            activityNode.clearActionAcceptButtonForwardTo( transitionId );
            var fromActivityDefId = connector.data( 'activityDefId' );
            var fromActivityNode = packagePanel.findActivity( processDefId, fromActivityDefId );
            Ext.ux.suncode.DocumentationService.deleteTransitionSpecification( fromActivityNode, transitionId );
            break;
        case 'out':
            var activityDefId = connector.data( 'activityDefId' );
            var activityNode = packagePanel.findActivity( processDefId, activityDefId );

            for ( var i = 0; i < connector.outCondConnections.length; i++ ) {
                var outCondConn = connector.outCondConnections[i];

                if ( outCondConn.outTransitionId == transitionId ) {
                    var conns = outCondConn.connections;

                    for ( var j = 0; j < conns.length; j++ ) {
                        var connConnectionId = conns[j].inTransitionId;
                        activityNode.clearActionAcceptButtonForwardTo( connConnectionId );
                        Ext.ux.suncode.DocumentationService.deleteTransitionSpecification( activityNode, connConnectionId );
                    }
                    break;
                }
            }
            break;
        default:
            break;
    }

    paper.bpmn.eraseTrash( paper.helperTrash );
    paper.bpmn.eraseTrash( paper.resizerTrash );
    connector.removeCondConnectionById( transitionId, inout, false );
}

function deleteOtherwiseLine( lineEl ) {
    var connector = lineEl.data( 'connectFrom' );
    var transitionId = lineEl.data( 'transitionId' );
    var paper = connector.paper;
    paper.bpmn.eraseTrash( paper.resizerTrash );
    connector.removeOtherwiseConnectionById( transitionId );
}

function deleteDeadlineLine( arg ) {
    var connector = arg.connector;
    var transitionId = arg.transitionId;
    var paper = connector.paper;
    paper.bpmn.eraseTrash( paper.resizerTrash );
    connector.removeExceptionById( transitionId );
}

function typeDeadlineExceptionName( arg ) {
    var connector = arg.connector;
    var activityDefId = connector.data( 'activityDefId' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = Ext.getCmp( 'package_panel' ).findActivity( processDefId, activityDefId );
    var deadlineTransition = activityNode.findDeadlineTransition( arg.transitionId );

    var win = new Ext.ux.suncode.DeadlineExceptionNameWindow( {
        activityNode: activityNode,
        deadlineTransition: deadlineTransition
    } );
    win.show();
}

function showConditionalLineConditions( arg ) {
    var connectFrom = arg.connectFrom;
    var activityDefId = connectFrom.data( 'activityDefId' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = Ext.getCmp( 'package_panel' ).findActivity( processDefId, activityDefId );

    var win = new Ext.ux.suncode.TransitionConditionsWindow( {
        activityNode: activityNode
    } );
    win.show();
}

Ext.ux.suncode.TransitionConditionsWindow = function( config ) {
    var activityNode = config.activityNode;
    var activityName = activityNode.attributes.activityName;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );

    config = Ext.apply( {
        modal: true,
        width: 600,
        height: 400,
        layout: 'fit',
        title: getTranslation( 'Połączenia warunkowe dla zadania' ) + ' ' + activityNameTranslation,
        items: new Ext.ux.suncode.TransitionConditionsGrid( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.TransitionConditionsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TransitionConditionsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.TransitionConditionsWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.TransitionConditionsGrid = function( config ) {
    var activityNode = config.activityNode;

    config = Ext.apply( {
        store: getActivityTransitionsStore( activityNode ),
        columnLines: true,
        autoScroll: true,
        border: false,
        enableColumnResize: true,
        enableColumnMove: false,
        enableDragDrop: true,
        ddGroup: 'dd_conditions',
        ddScope: this,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ {
                id: 'activityName',
                header: getTranslation( 'Nazwa zadania' ),
                dataIndex: 'activityName',
                align: 'left'
            }, {
                id: 'condition',
                header: getTranslation( 'Warunek' ),
                dataIndex: 'condition',
                align: 'left',
                renderer: conditionRenderer
            }, {
                id: 'activityDefId',
                header: 'activityDefId',
                dataIndex: 'activityDefId',
                align: 'left',
                hidden: true,
                hideable: false
            }, {
                id: 'transitionId',
                header: 'transitionId',
                dataIndex: 'transitionId',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak połączeń warunkowych dla zadania' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'activityName' ) + '</b>';
                }
            }
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj warunki połączenia' ),
                scope: this,
                handler: function() {
                    var selModel = this.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz połączenie warunkowe.' ) );
                        return;
                    }
                    this.handleSelected( rows[0] );
                }
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                var row = grid.getStore().getAt( rowIndex );
                this.handleSelected( row );
            },
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.getEl(), {
                    ddGroup: 'dd_conditions',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: function( dd, e, data ) {
                        notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                          dd.grid.ddScope.onConditionMove( sindex, dindex );
                        } );
                    }
                } );
            }
        }
    }, config );

    Ext.ux.suncode.TransitionConditionsGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TransitionConditionsGrid, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.TransitionConditionsGrid.superclass.initComponent.call( this );
    },
    handleSelected: function( row ) {
        executeShowConditionalLineCondition( {
            activityNode: this.initialConfig.activityNode,
            activityName: row.get( 'activityName' ),
            condition: row.get( 'condition' ),
            transitionId: row.get( 'transitionId' ),
            saveTo: row
        } );
    },
    onConditionMove: function( sindex, dindex ) {
        if ( sindex == dindex ) {
            return;
        }

        this.initialConfig.activityNode.changeCondTransitionsOrder( sindex, dindex );
    }
} );

function showConditionalLineCondition( arg ) {
    var el = arg.el;
    var processDefId = arg.processDefId;
    var packagePanel = Ext.getCmp( 'package_panel' );
    var connectFrom = el.data( 'connectFrom' );
    var connector = el.data( 'connectedWith' );
    var transitionId = el.data( 'transitionId' );
    var fromActDefId = connectFrom.data( 'activityDefId' );
    var toActDefId = connector.data( 'activityDefId' );
    var fromActivityNode = packagePanel.findActivity( processDefId, fromActDefId );
    var toActivityNode = packagePanel.findActivity( processDefId, toActDefId );

    executeShowConditionalLineCondition( {
        activityNode: fromActivityNode,
        activityName: toActivityNode.attributes.activityName,
        transitionId: transitionId,
        condition: fromActivityNode.getCondTransitionCondition( transitionId )
    } );
}

function executeShowConditionalLineCondition( arg ) {
    var win = new Ext.ux.suncode.TransitionConditionWindow( arg );
    win.show();
}

Ext.ux.suncode.TransitionConditionWindow = function( config ) {
    var activityNode = config.activityNode;
    var transitionId = config.transitionId;
    var isCustom = isCustomTransitionCondition( config.condition );
    config = Ext.apply( {
        isCustom: isCustom
    }, config );

    var specification = Ext.ux.suncode.DocumentationService.getTransitionSpecification( activityNode, transitionId );

    config = Ext.apply( {
        modal: true,
        autoWidth: true,
        autoHeight: true,
        title: getTranslation( 'Połączenie warunkowe z zadaniem' ) + ' ' + config.activityName,
        closable: true,
        items: [ new Ext.ux.suncode.TransitionConditionGrid( config ), new Ext.ux.suncode.TransitionConditionArea( config ),
                        new Ext.ux.suncode.SpecificationDescriptionArea( {
                            processNode: activityNode.parentNode,
                            description: specification.description,
                            width: 600
                        } ) ],
        customCondition: isCustom,
        tbar: new Ext.Toolbar( {
        	width: 600,
            items: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                scope: this,
                handler: this.saveForm
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                scope: this,
                handler: this.closeWindow
            } ]
        } )
    }, config );

    Ext.ux.suncode.TransitionConditionWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TransitionConditionWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.TransitionConditionWindow.superclass.initComponent.call( this );
    },
    getCustomCondition: function() {
        return this.customCondition;
    },
    setCustomCondition: function( value ) {
        this.customCondition = value;
    },
    closeWindow: function() {
        this.close();
    },
    saveForm: function() {
        if ( this.getCustomCondition() ) {
            this.conditionAreaPanel.saveForm();
        } else {
            this.conditionGrid.saveForm();
        }
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.TransitionConditionGrid = function( config ) {
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var conjunction = false;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'operator',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    if ( !config.isCustom ) {
        var condition = config.condition;
        var conditionsTable = createTransitionConditionsTable( condition );

        if ( conditionsTable.length > 0 ) {
            conjunction = conditionsTable[0].conjunction;
            store.loadData( conditionsTable );
            store.commitChanges();
        }
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: processNode.attributes.variables,
        formalParameters: processNode.attributes.formalParameters,
        acceptedFormalParams: [ 'Action' ],
        listeners: {
        	scope: this,
        	change: function() {
        		this.storeParentWindowAsUnsaved();
        	}
        }
    } );
    var operatorsChooser = new Ext.ux.suncode.OperatorsChooser( {
    	listeners: {
        	scope: this,
        	change: function() {
        		this.storeParentWindowAsUnsaved();
        	}
        }
    } );

    config = Ext.apply( {
        width: 600,
        height: 300,
        store: store,
        columnLines: true,
        autoScroll: true,
        border: false,
        enableColumnResize: true,
        enableColumnMove: false,
        hidden: config.isCustom,
        ref: 'conditionGrid',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ {
                id: 'varId',
                header: getTranslation( 'Nazwa zmiennej' ),
                dataIndex: 'varId',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            }, {
                id: 'operator',
                header: getTranslation( 'Operator' ),
                dataIndex: 'operator',
                align: 'center',
                editor: operatorsChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( operatorsChooser )
            }, {
                id: 'value',
                header: getTranslation( 'Wartość' ),
                dataIndex: 'value',
                align: 'left',
                editor: new Ext.form.TextField( {
                    inputType: 'text',
                    stripCharsRe: /\'/g,
                    listeners: {
                    	scope: this,
                    	change: function() {
                    		this.storeParentWindowAsUnsaved();
                    	}
                    }
                } ),
                renderer: conditionValueRenderer
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak warunków' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '<b>' + getTranslation( 'Spełnij wszystkie warunki:' ) + '</b>', {
                xtype: 'tbspacer'
            }, {
                xtype: 'checkbox',
                ref: 'conjunctionItem',
                checked: conjunction,
                inputValue: 'true'
            }, '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                scope: this,
                handler: function() {
                    var store = this.getStore();
                    var c = store.recordType;
                    var rec = new c( {
                        varId: '',
                        operator: '',
                        value: ''
                    } );
                    this.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                scope: this,
                handler: function() {
                    var selModel = this.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz wartość do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( this, rows[0] );
                    this.getView().refresh();
                    this.storeParentWindowAsUnsaved();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Użyj własnej definicji' ),
                scope: this,
                handler: this.showConditionAreaPanel
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
            }
        }
    }, config );

    Ext.ux.suncode.TransitionConditionGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TransitionConditionGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.TransitionConditionGrid.superclass.initComponent.call( this );
    },
    showConditionAreaPanel: function() {
        var conditionsTab = this.buildConditionsTab( true );
        var condition = createTransitionConditionsText( conditionsTab );
        var win = this.ownerCt;
        var areaPanel = win.conditionAreaPanel;
        areaPanel.conditionArea.setValue( condition );
        this.hide();
        areaPanel.show();
        win.setCustomCondition( true );
    },
    saveForm: function() {
        var activityNode = this.initialConfig.activityNode;
        var transitionId = this.initialConfig.transitionId;
        var saveTo = this.initialConfig.saveTo;
        var conditionsTab = this.buildConditionsTab( false );

        if ( conditionsTab == null ) {
            return;
        }

        var condition = createTransitionConditionsText( conditionsTab );
        if ( saveTo ) {
            saveTo.set( 'condition', condition );
            saveTo.commit();
        }

        activityNode.updateCondTransitionCondition( {
            id: transitionId,
            condition: condition
        } );

        var specification = this.ownerCt.readSpecification();
        Ext.ux.suncode.DocumentationService.editTransitionSpecification( activityNode, transitionId, transitionId, specification );

        this.ownerCt.closeWindow();
    },
    buildConditionsTab: function( ignoreWarnings ) {
        var conditionsTab = new Array();
        var processNode = this.initialConfig.activityNode.parentNode;
        var store = this.getStore();
        var conjunction = this.getTopToolbar().conjunctionItem.getValue();

        if ( store.getCount() == 1 && conjunction && !ignoreWarnings ) {
            showWarn( getTranslation( 'Nie jest dozwolone użycie opcji "Spełnij wszystkie warunki" dla tylko jednego warunku.' ) );
            return null;
        }

        for ( var i = 0; i < store.getCount(); i++ ) {
            var rec = store.getAt( i );
            var varId = rec.get( 'varId' );
            var operator = rec.get( 'operator' );

            if ( Ext.isEmpty( varId ) || Ext.isEmpty( operator ) ) {
                if ( ignoreWarnings ) {
                    continue;
                }

                showWarn( getTranslation( 'Uzupełnij poprawnie warunki połączenia.' ) );
                return null;
            }

            var varDef = processNode.findVariable( varId );
            if ( !varDef ) {
                varDef = processNode.findFormalParam( varId );

                if ( !varDef && !ignoreWarnings ) {
                    showWarn( getTranslation( 'Uzupełnij poprawnie warunki połączenia.' ) );
                    return null;
                }
            }

            var varType = varDef ? varDef.type : 'STRING';
            var value = '';
            var valueIsVariable = false;
            var recValue = rec.get( 'value' );

            var valueVarDef = processNode.findVariable( recValue );
            if ( !valueVarDef ) {
              valueVarDef = processNode.findFormalParam( recValue );

              if ( valueVarDef ) {
                valueIsVariable = true;
              }
            } else {
              valueIsVariable = true;
            }

            if ( valueIsVariable || varType == 'INTEGER' || varType == 'FLOAT' || varType == 'AMOUNT'
                || varType == 'DATETIME' || varType == 'DATE' || varType == 'BOOLEAN'
                || rec.get( 'value' ).startsWith( '\'' ) ) {
                value = new String( recValue );
            } else {
                value = '\'' + recValue + '\'';
            }

            conditionsTab.push( {
                varId: varId,
                operator: operator,
                value: value,
                conjunction: conjunction
            } );
        }

        return conditionsTab;
    }
} );

Ext.ux.suncode.TransitionConditionArea = function( config ) {
    var condition = config.condition;

    config = Ext.apply( {
        width: 600,
        height: 300,
        layout: 'fit',
        border: false,
        hidden: !config.isCustom,
        ref: 'conditionAreaPanel',
        items: [ {
            xtype: 'form',
            frame: false,
            border: false,
            layout: 'fit',
            bodyCssClass: 'x-Module-container-padding',
            items: [ {
                xtype: 'fieldset',
                title: getTranslation( 'Warunek' ),
                layout: 'fit',
                items: [ {
                    xtype: 'textarea',
                    ref: '../../conditionArea',
                    autoScroll: true,
                    value: condition,
                    listeners: {
                        scope: this,
                        render: function( textArea ) {
                            textArea.getEl().on( 'contextmenu', this.onContextMenu, this );
                        }
                    }
                } ]
            } ]
        } ],
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'table' ),
                tooltip: getTranslation( 'Użyj definicji podstawowej' ),
                scope: this,
                handler: this.showConditionGrid
            } ]
        } )
    }, config );

    Ext.ux.suncode.TransitionConditionArea.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TransitionConditionArea, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.TransitionConditionArea.superclass.initComponent.call( this );
    },
    onContextMenu: function( e ) {
        e.stopEvent();
        showMenu( new Ext.ux.suncode.GlobalMenu( {
            valueUser: this
        } ), e );
    },
    handleGlobalMenuValue: function( value ) {
        this.conditionArea.replaceSelectedText( value );
    },
    showConditionGrid: function() {
        var win = this.ownerCt;
        var grid = win.conditionGrid;
        var condition = this.getCondition();
        var conditionsTable = createTransitionConditionsTable( condition );

        if ( conditionsTable.length > 0 ) {
            var conjunction = conditionsTable[0].conjunction;
            grid.getTopToolbar().conjunctionItem.setValue( conjunction );
            var store = grid.getStore();
            store.loadData( conditionsTable );
            store.commitChanges();
        }

        this.hide();
        grid.show();
        win.setCustomCondition( false );
    },
    getCondition: function() {
        return this.conditionArea.getValue();
    },
    saveForm: function() {
        var activityNode = this.initialConfig.activityNode;
        var transitionId = this.initialConfig.transitionId;
        var saveTo = this.initialConfig.saveTo;
        var condition = this.getCondition();

        if ( saveTo ) {
            saveTo.set( 'condition', condition );
            saveTo.commit();
        }

        activityNode.updateCondTransitionCondition( {
            id: transitionId,
            condition: condition
        } );

        var specification = this.ownerCt.readSpecification();
        Ext.ux.suncode.DocumentationService.editTransitionSpecification( activityNode, transitionId, transitionId, specification );

        this.ownerCt.closeWindow();
    }
} );

Ext.ux.suncode.DeadlineExceptionNameWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Nazwa terminu ostatecznego' ),
        closable: true,
        items: new Ext.ux.suncode.DeadlineExceptionNamePanel( config ),
        tbar: new Ext.Toolbar( {
            items: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                scope: this,
                handler: this.saveForm
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                scope: this,
                handler: this.closeWindow
            } ]
        } )
    }, config );

    Ext.ux.suncode.DeadlineExceptionNameWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeadlineExceptionNameWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DeadlineExceptionNameWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    },
    saveForm: function() {
        this.exceptionNamePanel.saveForm();
    }
} );

Ext.ux.suncode.DeadlineExceptionNamePanel = function( config ) {
    var nameLabel = addTooltipToField( getTranslation( 'Nazwa' ),
        getTranslation( 'Dostępne są tylko asynchroniczne terminy ostateczne' ) );

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'exceptionNamePanel',
        items: [ {
            xtype: 'compositefield',
            fieldLabel: nameLabel,
            ref: 'deadlineExceptionNameItem',
            items: [ new Ext.ux.suncode.AsynchronousActivityDeadlinesChooser( {
                value: config.deadlineTransition.exceptionName,
                flex: 1,
                activityNode: config.activityNode,
            } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść' ),
                flex: 0,
                handler: this.clearDeadlineExceptionName,
                scope: this
            } ]
        } ]
    }, config );

    Ext.ux.suncode.DeadlineExceptionNamePanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeadlineExceptionNamePanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.DeadlineExceptionNamePanel.superclass.initComponent.call( this );
    },
    clearDeadlineExceptionName: function() {
        this.deadlineExceptionNameItem.items.first().setValue( '' );
    },
    saveForm: function() {
        var activityNode = this.initialConfig.activityNode;
        var transitionId = this.initialConfig.deadlineTransition.id;
        var exceptionName = this.deadlineExceptionNameItem.items.first().getValue();

        if ( !Ext.isEmpty( exceptionName ) && !activityNode.validateDeadlineTransitionsExceptionName( transitionId, exceptionName ) ) {
            showWarn( getTranslation( 'Termin ostateczny jest już wykorzystany.' ) );
            return;
        }

        activityNode.setDeadlineTransitionExceptionName( transitionId, exceptionName );

        this.ownerCt.closeWindow();
    }
} );

function showLineReshaperContextMenu( e, reshaper ) {
    var itemsConfig = new Array();
    var itemConfig = new Object();

    itemConfig = Ext.apply( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'delete' ),
        text: getTranslation( 'Usuń punkt' ),
        functionName: 'deleteLinePoint',
        functionArg: reshaper
    }, itemConfig );
    itemsConfig.push( itemConfig );

    var menu = new Ext.ux.suncode.Menu( itemsConfig );
    menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
}

function addLinePoint( arg ) {
    var line = arg.line;
    var pos = arg.pos;
    var paper = line.paper;
    paper.bpmn.addLinePoint( paper, line, parseInt( pos.x ), parseInt( pos.y ) );
}

function deleteLinePoint( reshaper ) {
    var paper = reshaper.paper;
    paper.bpmn.deleteLinePoint( paper, reshaper );
}

function reduceTransitionToShortestPath( lineEl ) {
    var paper = lineEl.paper;
    paper.bpmn.reduceLineToShortestPath( paper, lineEl );
}

function markPath( lineEl ) {
    var paper = lineEl.paper;
    var set = lineEl.data( 'wholeSet' );
    var color = Ext.getCmp( 'main_panel' ).getHoverColor();
    paper.bpmn.markLine( paper, set, color );
}