Ext.ux.suncode.JavaCodingWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.8;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: config.winTitle,
        items: new Ext.ux.suncode.JavaCodingPanel( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'java_code' ),
                tooltip: getTranslation( 'Kompiluj' ),
                cancel: false,
                handler: this.compileSourceCore,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.JavaCodingWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.JavaCodingWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.JavaCodingWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.javaCodingPanel.saveForm();
    },
    compileSourceCore: function() {
        this.javaCodingPanel.compileSourceCore();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.JavaCodingPanel = function( config ) {
    var instruction = getTranslation( 'Korzystaj z szablonów lub przygotuj własny kod źródłowy.' ) + ' ';
    instruction += getTranslation( 'Zaznacz tekst, kliknij prawym przyciskiem myszy w obszar kodu źródłowego i wybieraj z menu wartości z mapy.' );

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'javaCodingPanel',
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Ścieżka do klasy' ),
            name: 'qualifiedName',
            anchor: '100%',
            readOnly: true,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
        	xtype: 'compositefield',
        	fieldLabel: getTranslation( 'Dostępny w systemie' ),
        	ref: 'availableInSystemItemWrapper',
        	items: [ {
                xtype: 'checkbox',
                name: 'availableInSystem',
                inputValue: 'true',
                disabled: true
            }, {
                xtype: 'button',
                id: 'delete_source_code_button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                disabled: true,
                handler: this.deleteSourceCode,
                scope: this
            } ]
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Autor' ),
            name: 'codeAuthor',
            anchor: '100%',
            readOnly: true
        }, new Ext.ux.suncode.TemplatesContainer( {
            templateType: config.sourceCodeType,
            templateLoadScope: this
        } ), {
            xtype: 'label',
            fieldLabel: getTranslation( 'Instrukcja' ),
            text: instruction
        }, {
            xtype: 'fieldset',
            autoHeight: true,
            anchor: '100%',
            title: getTranslation( 'Kod źródłowy' ),
            layout: 'fit',
            items: [ new Ext.ux.suncode.CodeEditor( {
                ref: '../codeEditor',
                codeMode: 'java'
            } ), {
                xtype: 'textarea',
                name: 'sourceCode',
                hidden: true
            } ]
        } ]
    }, config );

    Ext.ux.suncode.JavaCodingPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.JavaCodingPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.JavaCodingPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.loadSourceCode, this );
    },
    loadSourceCode: function() {
        this.getForm().load( {
            url: 'api/javacode/get',
            params: {
                sourceCodeType: this.initialConfig.sourceCodeType,
                qualifiedName: this.initialConfig.qualifiedName,
                sourceCodeOptions: Ext.util.JSON.encode( this.initialConfig.options )
            },
            method: 'POST',
            scope: this,
            success: function( form, action ) {
            	var data = action.result.data;
                this.codeEditor.setCode( data.sourceCode );
                
                if ( data.availableInSystem ) {
                	this.getDeleteSourceCodeButton().enable();
                } else {
                	this.getDeleteSourceCodeButton().disable();
                }
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );
    },
    getDeleteSourceCodeButton: function() {
    	return Ext.getCmp( 'delete_source_code_button' );
    },
    compileSourceCore: function() {
        var successTask = new Ext.ux.suncode.RunnableTask( {
            handler: this.afterCompileSourceCode,
            scope: this
        } );

        this.validateSourceCode( successTask );
    },
    afterCompileSourceCode: function() {
        Ext.Msg.show( {
            title: getTranslation( 'Kod poprawny' ),
            msg: getTranslation( 'Kompilacja zakończona sukcesem.' ),
            buttons: Ext.Msg.OK,
            icon: Ext.Msg.INFO
        } );
    },
    deleteSourceCode: function() {
    	Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: getTranslation( 'Usunąć kod źródłowy?' ),
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    this.executeDeleteSourceCode();
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    executeDeleteSourceCode: function() {
    	Ext.Ajax.request( {
            url: 'api/javacode/delete',
            method: 'GET',
            params: {
                qualifiedName: this.initialConfig.qualifiedName
            },
            scope: this,
            success: function( response, opts ) {
            	if ( parseBoolean( response.responseText ) ) {
            		this.loadSourceCode();
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    saveForm: function() {
        var successTask = new Ext.ux.suncode.RunnableTask( {
            handler: this.afterSaveForm,
            scope: this
        } );

        this.validateSourceCode( successTask );
    },
    afterSaveForm: function() {
        this.getForm().submit( {
            url: 'api/javacode/set',
            method: 'POST',
            scope: this,
            success: function( form, action ) {
                if ( parseBoolean( action.response.responseText ) ) {
                    this.ownerCt.closeWindow();
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );
    },
    validateSourceCode: function( successTask ) {
        var form = this.getForm();

        if ( form.isValid() ) {
            var code = this.codeEditor.getCode();

            if ( !Ext.isEmpty( code ) ) {
                var maskId = 'java_source_code_compilation_mask';
                showLoadingMask( maskId, getTranslation( 'Trwa kompilowanie kodu źródłowego...' ) );

                form.findField( 'sourceCode' ).setValue( code );
                form.submit( {
                    url: 'api/javacode/validate',
                    method: 'POST',
                    scope: this,
                    success: function( form, action ) {
                        removeLoadingMask( maskId );
                        var validationResult = Ext.util.JSON.decode( action.response.responseText ).data;

                        if ( validationResult.canAddToClasspath ) {
                            var compilationResult = validationResult.compilationResult;

                            if ( compilationResult.isCorrect ) {
                                successTask.run();
                            } else {
                                var win = new Ext.ux.suncode.JavaComilationErrorsWindow( {
                                    compilationErrors: compilationResult.errors,
                                    codeEditor: this.codeEditor
                                } );
                                win.show();
                            }
                        } else {
                            showWarn( getTranslation( 'Zabroniona ścieżka do klasy - klasa systemowa.' ) );
                        }
                    },
                    failure: function( form, action ) {
                        removeLoadingMask( maskId );
                        showServerFailure( action.response );
                    }
                } );
            } else {
                showWarn( getTranslation( 'Podaj kod źródłowy.' ) );
            }
        }
    },
    onLoadTemplate: function( templateId ) {
        Ext.Ajax.request( {
            url: 'api/javacode/getFromTemplate',
            method: 'POST',
            params: {
                sourceCodeType: this.initialConfig.sourceCodeType,
                qualifiedName: this.initialConfig.qualifiedName,
                sourceCodeOptions: Ext.util.JSON.encode( this.initialConfig.options ),
                templateId: templateId
            },
            scope: this,
            success: function( response, opts ) {
                this.codeEditor.setCode( response.responseText );
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    }
} );

Ext.ux.suncode.JavaComilationErrorsWindow = function( config ) {
    var size = Ext.getBody().getViewSize();

    config = Ext.apply( {
        modal: true,
        width: size.width * 0.8,
        height: size.height * 0.5,
        title: getTranslation( 'Błędy kompilacji' ),
        layout: 'fit',
        items: new Ext.ux.suncode.JavaComilationErrorsPanel( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.JavaComilationErrorsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.JavaComilationErrorsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.JavaComilationErrorsWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.JavaComilationErrorsPanel = function( config ) {
    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'lineNumber',
                type: 'int'
            }, {
                name: 'columnNumber',
                type: 'int'
            }, {
                name: 'message',
                type: 'string'
            }, {
                name: 'markError',
                type: 'string'
            }, {
                name: 'startPosition',
                type: 'int'
            }, {
                name: 'endPosition',
                type: 'int'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( config.compilationErrors ) ) {
        store.loadData( config.compilationErrors );
        store.commitChanges();
    }

    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        ref: 'errorsGrid',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'lineNumber',
                header: getTranslation( 'Wiersz' ),
                dataIndex: 'lineNumber',
                align: 'center',
                width: 25
            }, {
                id: 'columnNumber',
                header: getTranslation( 'Kolumna' ),
                dataIndex: 'columnNumber',
                align: 'center',
                width: 25
            }, {
                id: 'message',
                header: getTranslation( 'Informacja' ),
                dataIndex: 'message',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'markError',
                header: getTranslation( 'Zaznacz błąd' ),
                dataIndex: 'markError',
                align: 'center',
                width: 25,
                sortable: false,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    return '<img src=\"' + getPluginImgPath( 'error' ) + '\">';
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak błędów kompilacji' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, rowIndex, keepExisting, record ) {
                    return false;
                }
            }
        } )
    }, config );

    Ext.ux.suncode.JavaComilationErrorsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.JavaComilationErrorsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.JavaComilationErrorsPanel.superclass.initComponent.call( this );

        this.on( 'cellclick', this.markError, this );
    },
    markError: function( grid, rowIndex, columnIndex, e ) {
        var colId = this.getColumnModel().getColumnId( columnIndex );

        if ( colId == 'markError' ) {
            var rec = this.getStore().getAt( rowIndex );
            var codeEditor = this.initialConfig.codeEditor;
            var lineNumber = rec.get( 'lineNumber' );
            var columnNumber = rec.get( 'columnNumber' );
            var startPosition = rec.get( 'startPosition' );
            var endPosition = rec.get( 'endPosition' );

            if ( Ext.isEmpty( codeEditor ) || Ext.isEmpty( lineNumber ) || Ext.isEmpty( columnNumber ) || Ext.isEmpty( startPosition )
                            || Ext.isEmpty( endPosition ) ) {
                showWarn( getTranslation( 'Brak niezbędnych danych do zaznaczenia błędu kompilacji.' ) );
                return;
            }

            var startRow = lineNumber - 1;
            var startColumn = columnNumber - 1;
            var endRow = startRow;
            var endColumn = startColumn + ( endPosition - startPosition );
            codeEditor.markErrorCode( startRow, startColumn, endRow, endColumn );
            this.ownerCt.closeWindow();
        }
    }
} );