Ext.ux.suncode.DTButtonDefinitionWindow = function( config ) {
    var DTButton = config.DTButton;
    var winTitle = DTButton ? getTranslation( 'Definicja przycisku' ) + ' ' + DTButton.name : getTranslation( 'Kreator przycisku' );

    config = Ext.apply( {
        title: winTitle,
        width: Ext.getBody().getViewSize().width * 0.6,
        autoHeight: true,
        frame: false,
        modal: true,
        constrain: true,
        shadow: false,
        resizable: false,
        items: new Ext.ux.suncode.DTButtonDefPanel( config ),
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this,
                ref: 'saveBtn'
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.DTButtonDefinitionWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTButtonDefinitionWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DTButtonDefinitionWindow.superclass.initComponent.call( this );

        this.on( 'show', windowUp, this );
    },
    saveForm: function() {
        this.defPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.DTButtonDefPanel = function( config ) {
    var globalDefinition = config.globalDefinition;
	  var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var variableSetId = config.variableSetId;
    var DTButton = config.DTButton;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var compatibilityMode = mainPanel.getCompatibilityMode();
    var defItems = new Array();

    if ( globalDefinition ) {
      var nameTranslationKey = DTButton ? 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + variableSetId
          + ')_DTBUTTON(' + DTButton.buttonId + ')' : '';
      var nameTranslationKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + variableSetId + ')_DTBUTTON(';
      var tooltipTranslationKey = DTButton ? 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + variableSetId
          + ')_DTBUTTON(' + DTButton.buttonId + ')_DESC' : '';
      var tooltipTranslationKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + variableSetId + ')_DTBUTTON(';
      var specification = DTButton ? Ext.ux.suncode.DocumentationService.getTableButtonSpecification( processNode, DTButton.buttonId ) : new Object();

      defItems.push( this.buildIdItem( config.AV, DTButton ) );
      defItems.push( this.buildDtButtonsChooser( DTButton, false ) );
      defItems.push( this.buildNameItem( DTButton, nameTranslationKey, nameTranslationKeyPrefix ) );
      defItems.push( this.buildButtonDestinationsChooser( DTButton ) );
      defItems.push( this.buildSystemIconsChooser( DTButton ) );
      defItems.push( this.buildColorsChooser( DTButton ) );
      defItems.push( this.buildTooltipItem( DTButton, tooltipTranslationKey, tooltipTranslationKeyPrefix ) );
      defItems.push( this.buildTypesChooser( DTButton, compatibilityMode ) );
      defItems.push( this.buildHandlerItem( config.AV, DTButton ) );
      defItems.push( this.buildDisabledItem( DTButton ) );
      defItems.push( this.buildFormActionsItem( DTButton, compatibilityMode, config ) );
      defItems.push( this.buildEventActionsItem( DTButton, compatibilityMode, config ) );
      defItems.push( this.buildSpecificationItem( processNode, specification ) );
      defItems.push( this.buildSystemButtonSectionSplitter( DTButton ) );
      defItems.push( this.buildParameterizedItem( DTButton, false ) );
    } else {
      if ( DTButton && !Ext.isEmpty( DTButton.globalId ) ) {
        defItems.push( new Ext.form.DisplayField( {
          fieldLabel: getTranslation( 'Identyfikator' ),
          anchor: '100%',
          value: DTButton.buttonId
        } ) );
        defItems.push( this.buildDtButtonsChooser( DTButton, true ) );
        defItems.push( new Ext.form.DisplayField( {
          fieldLabel: getTranslation( 'Nazwa przycisku' ),
          anchor: '100%',
          value: DTButton.name
        } ) );
        defItems.push( this.buildButtonDestinationsChooser( DTButton ) );
        defItems.push( new Ext.form.DisplayField( {
          fieldLabel: getTranslation( 'Funkcja zdarzenia' ),
          anchor: '100%',
          hidden: Ext.isEmpty( DTButton.handler ),
          value: DTButton.handler
        } ) );
        defItems.push( this.buildFormActionsItem( DTButton, compatibilityMode, config ) );
        defItems.push( this.buildEventActionsItem( DTButton, compatibilityMode, config ) );
        defItems.push( this.buildSystemButtonSectionSplitter( DTButton ) );
        defItems.push( this.buildParameterizedItem( DTButton, true ) );
      } else {
        var activityNode = config.activityNode;
        var activityDefId = activityNode.attributes.activityDefId;
        var nameTranslationKey = DTButton ? 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
            + ')_VARIABLESET(' + variableSetId + ')_DTBUTTON(' + DTButton.buttonId + ')' : '';
        var nameTranslationKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
            + ')_VARIABLESET(' + variableSetId + ')_DTBUTTON(';
        var tooltipTranslationKey = DTButton ? 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
            + ')_VARIABLESET(' + variableSetId + ')_DTBUTTON(' + DTButton.buttonId + ')_DESC' : '';
        var tooltipTranslationKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
            + ')_VARIABLESET(' + variableSetId + ')_DTBUTTON(';
        var specification = DTButton ? Ext.ux.suncode.DocumentationService.getDtButtonSpecification( activityNode, DTButton.buttonId ) : new Object();

        defItems.push( this.buildIdItem( config.AV, DTButton ) );
        defItems.push( this.buildDtButtonsChooser( DTButton, false ) );
        defItems.push( this.buildNameItem( DTButton, nameTranslationKey, nameTranslationKeyPrefix ) );
        defItems.push( this.buildButtonDestinationsChooser( DTButton ) );
        defItems.push( this.buildSystemIconsChooser( DTButton ) );
        defItems.push( this.buildColorsChooser( DTButton ) );
        defItems.push( this.buildTooltipItem( DTButton, tooltipTranslationKey, tooltipTranslationKeyPrefix ) );
        defItems.push( this.buildTypesChooser( DTButton, compatibilityMode ) );
        defItems.push( this.buildHandlerItem( config.AV, DTButton ) );
        defItems.push( this.buildDisabledItem( DTButton ) );
        defItems.push( this.buildFormActionsItem( DTButton, compatibilityMode, config ) );
        defItems.push( this.buildEventActionsItem( DTButton, compatibilityMode, config ) );
        defItems.push( this.buildSpecificationItem( processNode, specification ) );
        defItems.push( this.buildSystemButtonSectionSplitter( DTButton ) );
        defItems.push( this.buildParameterizedItem( DTButton, false ) );
      }
    }

    config = Ext.apply( {
        autoHeight: true,
        autoWidth: true,
        autoScroll: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 150,
        layout: 'form',
        ref: 'defPanel',
        loadParams: true,
        systemButtonHandler: null,
        layoutConfig: {
            trackLabels: true
        },
        items: defItems
    }, config );

    Ext.ux.suncode.DTButtonDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTButtonDefPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.DTButtonDefPanel.superclass.initComponent.call( this );
    },
    buildIdItem: function( advancedView, DTButton ) {
      return new Ext.ux.suncode.IdField( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Identyfikator' ),
        value: DTButton ? DTButton.buttonId : generateId( 'button_' + Ext.id() ),
        ref: 'idItem',
        hidden: !advancedView,
        idChanged: !Ext.isEmpty( DTButton )
      } );
    },
    buildDtButtonsChooser: function( DTButton, readOnly ) {
      return new Ext.ux.suncode.DTButtonsChooser( {
        fieldLabel: addTooltipToField( getTranslation( 'Przyciski systemowe' ), null, null, true ),
        ref: 'buttonsChooser',
        readOnly: readOnly,
        buttonDefId: DTButton ? DTButton.buttonDefId : '',
        listeners: {
          scope: this,
          select: this.onSystemButtonChoose,
          afterrender: function( field ) {
            if ( !( DTButton && !Ext.isEmpty( DTButton.handler ) ) ) {
              window.setTimeout( function() {
                field.hide();
              }, 1 );
            }
          }
        }
      } );
    },
    buildNameItem: function( DTButton, nameTranslationKey, nameTranslationKeyPrefix ) {
      return new Ext.ux.suncode.I18NTranslatedField( {
        fieldLabel: getTranslation( 'Nazwa przycisku' ),
        anchor: '100%',
        ref: 'nameItem',
        field: {
          xtype: 'textfield',
          value: DTButton ? DTButton.name : '',
          listeners: {
            scope: this,
            blur: this.onSetName
          }
        },
        getIdFieldFunction: function() {
          return this.idItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj nazwę przycisku.' ),
        windowTitle: getTranslation( 'Tłumaczenia nazwy przycisku' ),
        keyPrefix: nameTranslationKeyPrefix,
        keyPostfix: ')',
        saveToCache: true,
        cache: DTButton && !Ext.isEmpty( DTButton.translations[nameTranslationKey] ) ? {
          key: nameTranslationKey,
          translations: DTButton.translations[nameTranslationKey]
        } : new Object(),
        initialId: DTButton ? DTButton.buttonId : null
      } );
    },
    buildButtonDestinationsChooser: function( DTButton ) {
      return new Ext.ux.suncode.ButtonDestinationsChooser( {
        value: DTButton ? DTButton.destination : 'TASKFORM'
      } );
    },
    buildSystemIconsChooser: function( DTButton ) {
      return new Ext.ux.suncode.SystemIconsChooser( {
        icon: DTButton ? DTButton.icon : ''
      } );
    },
    buildColorsChooser: function ( DTButton ) {
      return new Ext.ux.suncode.SystemColorsChooser( {
        color: DTButton ? DTButton.color : ''
      } );
    },
    buildTooltipItem: function( DTButton, tooltipTranslationKey, tooltipTranslationKeyPrefix ) {
      return new Ext.ux.suncode.I18NTranslatedField( {
        fieldLabel: getTranslation( 'Tooltip' ),
        anchor: '100%',
        ref: 'tooltipItem',
        field: {
          xtype: 'textfield',
          value: DTButton ? DTButton.tooltip : ''
        },
        getIdFieldFunction: function() {
          return this.idItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj nazwę przycisku.' ),
        windowTitle: getTranslation( 'Tłumaczenia tooltip\'u przycisku' ),
        keyPrefix: tooltipTranslationKeyPrefix,
        keyPostfix: ')_DESC',
        saveToCache: true,
        cache: DTButton && !Ext.isEmpty( DTButton.translations[tooltipTranslationKey] ) ? {
          key: tooltipTranslationKey,
          translations: DTButton.translations[tooltipTranslationKey]
        } : new Object(),
        initialId: DTButton ? DTButton.buttonId : null
      } );
    },
    buildTypesChooser: function( DTButton, compatibilityMode ) {
      return new Ext.ux.suncode.DTButtonTypesChooser( {
        fieldLabel: getTranslation( 'Typ' ),
        anchor: '100%',
        ref: 'typeItem',
        value: DTButton ? Ext.isEmpty( DTButton.handler ) ? 'FORM_ACTIONS' : 'HANDLER' :
            compatibilityMode.showDtButtonHandler( null ) ? '' : 'FORM_ACTIONS',
        hidden: !compatibilityMode.showDtButtonHandler( DTButton ? DTButton.handler : null ),
        listeners: {
          scope: this,
          select: function( combo, record, index ) {
            var value = combo.getValue();

            if ( value == 'HANDLER' ) {
              this.buttonsChooser.show();
              this.handlerItem.show();
              this.formActionsGrid.hide();
              this.eventActionsGrid.hide();
            } else if ( value == 'FORM_ACTIONS' ) {
              this.buttonsChooser.hide();
              this.buttonsChooser.setValue( '' );
              this.handlerItem.hide();
              this.handlerItem.items.first().setValue( '' );
              this.formActionsGrid.show();
              this.eventActionsGrid.show();
              this.removeParamsPanel();
              this.systemButtonSectionSplitter.hide();
              this.parameterizedItem.hide();
            }
          }
        }
      } );
    },
    buildHandlerItem: function( advancedView, DTButton ) {
      return {
        xtype: 'compositefield',
        fieldLabel: addTooltipToField( getTranslation( 'Funkcja zdarzenia' ), null, null, true ),
        anchor: '100%',
        ref: 'handlerItem',
        hidden: !( DTButton && !Ext.isEmpty( DTButton.handler ) ),
        items: [ {
          xtype: 'textfield',
          inputType: 'text',
          flex: 1,
          value: DTButton ? DTButton.handler : '',
          maskRe: /[a-zA-Z0-9_$]/
        }, {
          xtype: 'button',
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'scripts' ),
          tooltip: getTranslation( 'Przygotuj definicję funkcji' ),
          flex: 0,
          handler: this.showJSCodingWindow,
          scope: this,
          hidden: !advancedView
        } ]
      };
    },
    buildDisabledItem: function( DTButton ) {
      var disabledLabel = addTooltipToField( getTranslation( 'Zablokowany' ), getTranslation( 'Jeżeli opcja jest aktywna' ) + ',<br>'
          + getTranslation( 'to przycisk w tabeli początkowo jest zablokowany' ) );

      return {
        xtype: 'checkbox',
        fieldLabel: disabledLabel,
        ref: 'disabledItem',
        checked: DTButton ? DTButton.disabled : false,
        inputValue: 'true'
      };
    },
    buildFormActionsItem: function( DTButton, compatibilityMode, config ) {
      var formActionsCategories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();

      return new Ext.ux.suncode.IntegrationComponentTable( {
        ref: 'formActionsGrid',
        title: getTranslation( 'Akcje formularza' ),
        height: 250,
        hidden: ( DTButton && compatibilityMode.showDtButtonHandler( DTButton.handler ) && !Ext.isEmpty( DTButton.handler ) ) ||
            ( !DTButton && compatibilityMode.showDtButtonHandler( null ) ),
        frame: false,
        style: {
          marginBottom: '5px'
        },
        components: DTButton ? DTButton.formActions : new Array(),
        filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
            formActionsCategories, Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION, false ),
        allCategories: formActionsCategories,
        processNode: config.processNode,
        enableCopyPasteMenu: true,
        conditionalExecutionEnabled: true,
        inactiveEnabled: true,
        parametersWindowTitlePrefix: getTranslation( 'Parametry przycisku tabeli dynamicznej' ),
        globalDefinition: config.globalDefinition,
        availableVariables: config.availableVariables,
        missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: config.missingVariablesValidatorScope,
        systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
        getBindToFunction: function( component ) {
          var dtButtonDestination = Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION;
          var destination = Ext.ux.suncode.IntegrationComponentService.getDestination( component, dtButtonDestination );

          return !Ext.isEmpty( destination ) ? {
            id: destination.bindTo,
            value: this.getButtonId()
          } : null;
        },
        getBindToScope: this,
        getComponentRegistrationFunction: function( id ) {
          return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( components ) {
          Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( components );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
            if ( Ext.isFunction( func ) ) {
              var components = new Array();

              if ( !Ext.isEmpty( formActions ) ) {
                var service = Ext.ux.suncode.IntegrationComponentService;
                var categories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();

                Ext.each( formActions, function( component, index, allComponents ) {
                  var componentDef = service.getIntegrationComponent( categories, component.id );

                  if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.DT_BUTTON_DESTINATION, false ) ) {
                    components.push( component );
                  }
                } );
              }

              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ components ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
        validateFieldFunction: config.validateIntegrationComponentFieldFunction,
        validateFieldScope: config.validateIntegrationComponentFieldScope,
        validateRowFunction: config.validateIntegrationComponentRowFunction,
        validateRowScope: config.validateIntegrationComponentRowScope,
        pasteComponentsValidation: config.pasteIntegrationComponentsValidation,
        destinationType: Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION,
        tableId: config.variableSetId
      } );
    },
    buildEventActionsItem: function( DTButton, compatibilityMode, config ) {
      var mainPanel = Ext.getCmp( 'main_panel' );
      var eventTypes = mainPanel.getEventTypesForDtButton();
      var eventActionsCategories = mainPanel.getEventActionsCategories();

      return new Ext.ux.suncode.IntegrationComponentTable( {
        ref: 'eventActionsGrid',
        title: getTranslation( 'Zdarzenia' ),
        height: 250,
        hidden: ( DTButton && compatibilityMode.showDtButtonHandler( DTButton.handler ) && !Ext.isEmpty( DTButton.handler ) ) ||
            ( !DTButton && compatibilityMode.showDtButtonHandler( null ) ),
        frame: false,
        style: {
          marginBottom: '5px'
        },
        eventMode: true,
        eventTypes: eventTypes,
        components: DTButton ? DTButton.eventActions : new Array(),
        filteredCategories: eventActionsCategories,
        allCategories: eventActionsCategories,
        processNode: config.processNode,
        enableCopyPasteMenu: true,
        conditionalExecutionEnabled: true,
        inactiveEnabled: true,
        parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
        globalDefinition: config.globalDefinition,
        availableVariables: config.availableVariables,
        missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: config.missingVariablesValidatorScope,
        systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
        getComponentRegistrationFunction: function( id ) {
          return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( components ) {
          Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( components );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
            if ( Ext.isFunction( func ) ) {
              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ eventActions ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType,
        validateFieldFunction: config.validateIntegrationComponentFieldFunction,
        validateFieldScope: config.validateIntegrationComponentFieldScope,
        validateRowFunction: config.validateIntegrationComponentRowFunction,
        validateRowScope: config.validateIntegrationComponentRowScope,
        pasteComponentsValidation: config.pasteIntegrationComponentsValidation
      } );
    },
    buildSpecificationItem: function( processNode, specification ) {
      return new Ext.ux.suncode.SpecificationDescriptionArea( {
        processNode: processNode,
        description: specification.description
      } );
    },
    buildSystemButtonSectionSplitter: function( DTButton ) {
      return {
        xtype: 'box',
        ref: 'systemButtonSectionSplitter',
        hidden: DTButton ? Ext.isEmpty( DTButton.buttonDefId ) : true,
        autoEl: {
          tag: 'div',
          html: '<hr ' + getHRLineStyle() + '>',
          style: 'padding-bottom: 10px'
        }
      };
    },
    buildParameterizedItem: function( DTButton, disabled ) {
      var parameterizedLabel = addTooltipToField( getTranslation( 'Sparametryzowany' ), getTranslation( 'Należy aktywować eksportowanie skryptów' ) );

      return {
        xtype: 'checkbox',
        fieldLabel: parameterizedLabel,
        ref: 'parameterizedItem',
        checked: DTButton ? DTButton.parameterized : false,
        inputValue: 'true',
        disabled: disabled,
        hidden: DTButton ? Ext.isEmpty( DTButton.buttonDefId ) : true,
        listeners: {
          scope: this,
          check: this.onParameterizedCheck
        }
      };
    },
    onSetName: function( field, e ) {
      this.idItem.validate();
    },
    getButtonId: function() {
      var idItem = this.idItem;

      if ( !Ext.isEmpty( idItem ) ) {
        return idItem.getValue();
      } else {
        var DTButton = this.initialConfig.DTButton;

        return DTButton.buttonId;
      }
    },
    onSystemButtonChoose: function( combo, record, index ) {
        var buttonDefId = combo.getValue();

        if ( !Ext.isEmpty( buttonDefId ) && combo.isValid() && !Ext.isEmpty( record ) ) {
            var DTButton = this.initialConfig.DTButton;
            var handler = record.get( 'handler' );
            this.storeSystemButtonHandler( handler );
            this.removeParamsPanel();
            this.addParamsPanel( buttonDefId );
            this.systemButtonSectionSplitter.show();
            this.parameterizedItem.show();

            if ( !combo.firstLoad ) {
                this.nameItem.setValue( record.get( 'text' ) );
                this.iconsChooser.setValue( record.get( 'icon' ) );
                this.tooltipItem.setValue( record.get( 'tooltip' ) );
                this.setSystemButtonHandler( this.parameterizedItem.getValue() );
            } else if ( Ext.isEmpty( DTButton ) ) {
                this.setSystemButtonHandler( this.parameterizedItem.getValue() );
            }

            combo.firstLoad = false;
        }
    },
    removeParamsPanel: function() {
        var paramsPanel = this.paramsPanel;

        if ( paramsPanel ) {
            this.remove( paramsPanel );
        }
    },
    addParamsPanel: function( buttonDefId ) {
        this.add( new Ext.ux.suncode.DTButtonParamsPanel( {
            globalDefinition: this.initialConfig.globalDefinition,
            ref: 'paramsPanel',
            DTButton: this.initialConfig.DTButton,
            buttonDefId: buttonDefId,
            hidden: !this.parameterizedItem.getValue()
        } ) );
        this.doLayout();
    },
    storeSystemButtonHandler: function( handler ) {
        this.systemButtonHandler = handler;
    },
    setSystemButtonHandler: function( parameterized ) {
        if ( parameterized ) {
            this.handlerItem.items.first().setValue( 'init' + this.systemButtonHandler.replaceAll( '.', '_' ) + new Date().getTime() );
        } else {
            this.handlerItem.items.first().setValue( this.systemButtonHandler );
        }
    },
    onParameterizedCheck: function( field, checked ) {
        if ( checked ) {
            this.paramsPanel.show();
        } else {
            this.paramsPanel.hide();
        }

        this.setSystemButtonHandler( checked );
    },
    saveForm: function() {
        var globalDefinition = this.initialConfig.globalDefinition;
        var DTButton = this.initialConfig.DTButton;
        var dtBtnObj = new Object();

        if ( !globalDefinition && DTButton && !Ext.isEmpty( DTButton.globalId ) ) {
          dtBtnObj = Ext.apply( {
            buttonId: DTButton.buttonId,
            globalId: DTButton.globalId,
            name: DTButton.name,
            destination: this.destinationItem.getValue(),
            icon: DTButton.icon,
            color: DTButton.color,
            tooltip: DTButton.tooltip,
            handler: DTButton.handler,
            disabled: DTButton.disabled,
            formActions: this.formActionsGrid.readComponents(),
            eventActions: this.eventActionsGrid.readComponents(),
            translations: DTButton.translations,
            buttonDefId: DTButton.buttonDefId,
            parameterized: DTButton.parameterized
          }, dtBtnObj );

          if ( DTButton.parameterized ) {
            dtBtnObj = Ext.apply( {
              params: DTButton.params
            }, dtBtnObj );
          }
        } else {
          var processNode = this.initialConfig.processNode;
          var validateIdFunction = this.initialConfig.validateIdFunction;
          var validateIdScope = this.initialConfig.validateIdScope;
          var saveToObj = this.initialConfig.saveTo;
          var varRecord = this.initialConfig.varRecord;
          var buttonId = this.idItem.getValue();
          var name = this.nameItem.getValue();
          var icon = this.iconsChooser.getValue();
          var color = this.colorsChooser.getValue();
          var tooltip = this.tooltipItem.getValue();
          var handler = this.handlerItem.items.first().getValue();
          var buttonDefId = this.buttonsChooser.getValue();
          var parameterized = this.parameterizedItem.getValue();
          var type = this.typeItem.getValue();
          var globalId = null;

          if ( globalDefinition && !DTButton ) {
            globalId = generateGlobalId();
          } else if ( DTButton && !Ext.isEmpty( DTButton.globalId ) ) {
            globalId = DTButton.globalId;
          }

          if ( Ext.isEmpty( buttonId ) ) {
            showWarn( getTranslation( 'Podaj identyfikator przycisku.' ) );
            return;
          } else if ( Ext.isEmpty( type ) ) {
            showWarn( getTranslation( 'Podaj typ przycisku.' ) );
            return;
          } else if ( type == 'HANDLER' && Ext.isEmpty( handler ) ) {
            showWarn( getTranslation( 'Określ zdarzenie na przycisku.' ) );
            return;
          } else if ( Ext.isEmpty( name ) && Ext.isEmpty( icon ) ) {
            showWarn( getTranslation( 'Określ nazwę przycisku i/lub ikonę.' ) );
            return;
          } else if ( !DTButton && validateIdFunction.apply( validateIdScope, [ buttonId ] ) === false ) {
            showWarn( getTranslation( 'Przycisk musi być unikalny w obrębie tabeli dynamicznej.' ) );
            return;
          } else if ( DTButton && DTButton.buttonId != buttonId && validateIdFunction.apply( validateIdScope, [ buttonId ] ) === false ) {
            showWarn( getTranslation( 'Przycisk musi być unikalny w obrębie tabeli dynamicznej.' ) );
            return;
          } else if ( !globalDefinition && this.checkDuplication( buttonId ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return;
          } else if ( !DTButton && processNode.validateTableButtonIdDuplication( buttonId, null ) === false ) {
            showWarn( getTranslation( 'Istnieje już przycisk w globalnej tabeli dynamicznej o podanym identyfikatorze.' ) );
            return;
          } else if ( DTButton && DTButton.buttonId != buttonId && processNode.validateTableButtonIdDuplication( buttonId, DTButton.globalId ) === false ) {
            showWarn( getTranslation( 'Istnieje już przycisk w globalnej tabeli dynamicznej o podanym identyfikatorze.' ) );
            return;
          } else if ( globalDefinition ) {
            var validateResult = processNode.validateUpdateDtButton( globalId, buttonId );
            if ( !validateResult.valid ) {
              showWarn( validateResult.errorMessage );
              return;
            }
          }

          if ( saveToObj && varRecord ) {
            if ( DTButton ) {
              varRecord.set( 'buttonId', buttonId );
              varRecord.set( 'name', name );
              varRecord.set( 'icon', icon );
              varRecord.commit();
            } else {
              var store = saveToObj.getStore();
              store.add( new varRecord( {
                buttonId: buttonId,
                name: name,
                icon: icon
              } ) );
              store.commitChanges();
            }
          }

          dtBtnObj = Ext.apply( {
            buttonId: buttonId,
            name: name,
            destination: this.destinationItem.getValue(),
            icon: icon,
            color: color,
            tooltip: tooltip,
            handler: handler,
            disabled: this.disabledItem.getValue(),
            formActions: this.formActionsGrid.readComponents(),
            eventActions: this.eventActionsGrid.readComponents(),
            translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.nameItem, this.tooltipItem ] ),
            buttonDefId: buttonDefId
          }, dtBtnObj );

          if ( !Ext.isEmpty( buttonDefId ) ) {
            dtBtnObj = Ext.apply( {
              parameterized: parameterized
            }, dtBtnObj );

            if ( parameterized ) {
              var params = new Array();

              Ext.each( this.paramsPanel.paramsFieldset.items.items, function( item, index, items ) {
                if ( !Ext.isEmpty( item.realName ) ) {
                  params.push( {
                    realName: item.realName,
                    value: item.getValue()
                  } );
                }
              } );

              dtBtnObj = Ext.apply( {
                params: params
              }, dtBtnObj );
            }
          }

          var specification = this.readSpecification();

          if ( globalDefinition ) {
            if ( DTButton ) {
              Ext.ux.suncode.DocumentationService.editTableButtonSpecification( processNode, DTButton.buttonId, buttonId, specification );
            } else {
              Ext.ux.suncode.DocumentationService.addTableButtonSpecification( processNode, buttonId, specification );
            }
          } else {
            var activityNode = this.initialConfig.activityNode;

            if ( DTButton ) {
              Ext.ux.suncode.DocumentationService.editDtButtonSpecification( activityNode, DTButton.buttonId, buttonId, specification );
            } else {
              Ext.ux.suncode.DocumentationService.addDtButtonSpecification( activityNode, buttonId, specification );
            }
          }
        }

        if ( !Ext.isEmpty( globalId ) ) {
          dtBtnObj = Ext.apply( {
            globalId: globalId
          }, dtBtnObj );
        } else {
          dtBtnObj = Ext.apply( {
            genre: 'DT_BUTTON'
          }, dtBtnObj );
        }

        if ( DTButton ) {
          var updateFunction = this.initialConfig.updateFunction;
          var updateScope = this.initialConfig.updateScope;

          updateFunction.apply( updateScope, [ DTButton.buttonId, dtBtnObj ] );
        } else {
          var addFunction = this.initialConfig.addFunction;
          var addScope = this.initialConfig.addScope;

          addFunction.apply( addScope, [ dtBtnObj ] );
        }

        this.ownerCt.closeWindow();
    },
    checkDuplication: function( buttonId ) {
    	  var variableSetId = this.initialConfig.variableSetId;
        var drawingPanel = Ext.getCmp( 'drawing_panel' );
        var isDuplicated = false;

        drawingPanel.items.each( function( item ) {
            item.items.each( function( subitem ) {
                var definition = subitem.definition;
                var objectDef = definition.objectDef;

                switch ( objectDef.genre ) {
	                case 'VARIABLE':
	                    if ( subitem.idAssigned && objectDef.varId == buttonId ) {
	                        isDuplicated = true;
	                        return false;
	                    }
	                    break;
	                case 'VARIABLE_SET':
	                    if ( subitem.idAssigned ) {
	                        if ( objectDef.varId == buttonId ) {
	                            isDuplicated = true;
	                            return false;
	                        } else {
	                            var columns = objectDef.columns;
	
	                            for ( var i = 0; i < columns.length; i++ ) {
	                                var column = columns[i];
	
	                                if ( column.varId == buttonId ) {
	                                    isDuplicated = true;
	                                    return false;
	                                }
	                            }
	                            
	                            if ( variableSetId != objectDef.varId ) {
	                            	var dtButtons = objectDef.DTButtons;
	                            	
		                            for ( var i = 0; i < dtButtons.length; i++ ) {
		                                var dtButton = dtButtons[i];
		
		                                if ( dtButton.buttonId == buttonId ) {
		                                    isDuplicated = true;
		                                    return false;
		                                }
		                            }
	                            }
	                        }
	                    }
	                    break;
	                case 'LABEL':
	                    if ( subitem.idAssigned && objectDef.id == buttonId ) {
	                        isDuplicated = true;
	                        return false;
	                    }
	                    break;
                    case 'HTTP_LINK':
                    case 'ACTION_ACCEPT_BUTTON':
                    case 'GENERATE_PDF_BUTTON':
                    case 'ADD_FILE_BUTTON':
                    case 'BARCODE_PRINT':
                        if ( subitem.idAssigned &&
                        		( objectDef.actionName == buttonId || objectDef.actionName + '_button' == buttonId ) ) {
                            isDuplicated = true;
                            return false;
                        }
                        break;
                    default:
                        break;
                }
            } );

            if ( isDuplicated ) {
                return false;
            }
        } );

        return isDuplicated;
    },
    showJSCodingWindow: function() {
        var buttonDefId = this.buttonsChooser.getValue();
        var functionName = this.handlerItem.items.first().getValue();

        if ( !Ext.isEmpty( buttonDefId ) ) {
            showWarn( getTranslation( 'Opcja niedostępna dla przycisków systemowych.' ) );
            return;
        }

        if ( Ext.isEmpty( functionName ) ) {
            showWarn( getTranslation( 'Podaj nazwę funkcji.' ) );
            return;
        }

        var win = new Ext.ux.suncode.JsCodingWindow( {
            winTitle: getTranslation( 'Definicja funkcji przycisku w tabeli dynamicznej' ),
            sourceCodeType: 'JS_DT_BUTTON',
            functionName: functionName,
            options: {
                parameters: [ 'oButton' ]
            }
        } );
        win.show();
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.DTButtonParamsPanel = function( config ) {
    var buttonDefId = config.buttonDefId;
    var button = CUFDefs.DTButtons[buttonDefId];
    var params = button.params;

    var paramsFieldset = new Ext.form.FieldSet( {
        ref: 'paramsFieldset',
        title: getTranslation( 'Parametry przycisku' ) + ': ' + button.name,
        labelWidth: 200,
        anchor: '100%',
        defaults: {
            anchor: '100%'
        }
    } );

    if ( Ext.isEmpty( params ) ) {
        var label = new Ext.form.Label( {
            fieldLabel: getTranslation( 'Brak parametrów' ),
            labelSeparator: ''
        } );
        paramsFieldset.add( label );
    } else {
        var globalDefinition = config.globalDefinition;
        var DTButton = config.DTButton;
        var readOnly = !globalDefinition && DTButton && !Ext.isEmpty( DTButton.globalId );

        Ext.each( params, function( param, index, params ) {
            var field = null;

            if ( readOnly ) {
              switch ( param.type ) {
                case 'boolean':
                  field = new Ext.form.Checkbox( {
                    realName: param.realName,
                    fieldLabel: param.viewName,
                    checked: param.defaultValue,
                    inputValue: 'true',
                    disabled: true
                  } );
                  break;
                default:
                  field = new Ext.form.DisplayField( {
                    realName: param.realName,
                    fieldLabel: param.viewName,
                    value: param.defaultValue
                  } );
                  break;
              }
            } else {
              switch ( param.type ) {
                case 'boolean':
                  field = new Ext.form.Checkbox( {
                    realName: param.realName,
                    fieldLabel: param.viewName,
                    checked: param.defaultValue,
                    inputValue: 'true'
                  } );
                  break;
                case 'int':
                  field = new Ext.form.NumberField( {
                    realName: param.realName,
                    allowDecimals: false,
                    fieldLabel: param.viewName,
                    value: param.defaultValue
                  } );
                  break;
                case 'docclass':
                  field = new Ext.ux.suncode.SystemDocumentClassesChooser( {
                    label: param.viewName,
                    realName: param.realName,
                    docClassName: param.defaultValue
                  } );
                  break;
                default:
                  field = new Ext.form.TextField( {
                    realName: param.realName,
                    fieldLabel: param.viewName,
                    value: param.defaultValue
                  } );
                  break;
              }
            }

            paramsFieldset.add( field );
        } );
    }

    config = Ext.apply( {
        layout: 'form',
        items: paramsFieldset,
        border: false
    }, config );

    Ext.ux.suncode.DTButtonParamsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTButtonParamsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.DTButtonParamsPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var DTButton = this.initialConfig.DTButton;

        if ( DTButton && DTButton.parameterized && this.ownerCt.loadParams ) {
            this.onFill( DTButton.params );
        }

        this.ownerCt.loadParams = false;
    },
    onFill: function( params ) {
        if ( !Ext.isEmpty( params ) ) {
            Ext.each( this.paramsFieldset.items.items, function( item, index, items ) {
                if ( !Ext.isEmpty( item.realName ) ) {
                    for ( var i = 0; i < params.length; i++ ) {
                        if ( params[i].realName == item.realName ) {
                            item.setValue( params[i].value );
                            break;
                        }
                    }
                }
            }, this );
        }
    }
} );