Ext.ux.suncode.ClassesChooser = function( config ) {
    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'classpath',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( config.classes ) ) {
        var rec = store.recordType;

        Ext.each( config.classes, function( clazz, index, clazzes ) {
            var v = new rec( {
                classpath: clazz.classpath
            } );
            store.add( v );
        } );

        store.commitChanges();
    }

    config = Ext.apply( {
        triggerAction: 'all',
        mode: 'local',
        anchor: '100%',
        store: store,
        valueField: 'classpath',
        displayField: 'classpath',
        forceSelection: false
    }, config );

    Ext.ux.suncode.ClassesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ClassesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ClassesChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ClassDefinitionGrid = function( config ) {
	var buttons = new Array();
    var parametersMap = new HashMap();
    var classes = config.classes;
    var getClassFunction = config.getClassFunction;
    var getClassScope = config.getClassScope;
    var presentView = config.presentView;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'classpath',
                type: 'string'
            }, {
                name: 'noOfParams',
                type: 'integer'
            }, {
                name: 'setParams',
                type: 'integer'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( classes ) ) {
        var v = store.recordType;

        Ext.each( classes, function( clazz, idx, clazzez ) {
            var classId = Ext.id();
            var classpath = clazz.classpath;
            var parameters = clazz.parameters;
            var clazzDef = getClassFunction.apply( getClassScope, [ classpath ] );
            var description = clazzDef ? clazzDef.description : '';
            var noOfParams = 0;
            if ( !Ext.isEmpty( clazzDef ) ) {
            	noOfParams = clazzDef.parameters.length;
            } else {
            	noOfParams = parameters.length;
            }
            var setParams = noOfParams > 0 ? true : false;
            var rec = new v( {
                classId: classId,
                classpath: classpath,
                description: description,
                noOfParams: noOfParams,
                setParams: setParams
            } );
            store.add( rec );

            if ( setParams ) {
                parametersMap.put( classId, parameters );
            }
        } );

        store.commitChanges();
    }
    
    buttons.push( '->' );
    if ( presentView ) {
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'change' ),
            tooltip: getTranslation( 'Pokaż obecny widok' ),
            handler: this.onShowPresentView,
            scope: this
        } );
    }
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj' ),
        handler: function() {
            var grid = this.ownerCt.ownerCt;
            var store = grid.getStore();
            var v = store.recordType;
            var rec = new v( {
                classId: Ext.id(),
                classpath: '',
                noOfParams: 0,
                setParams: false
            } );
            grid.stopEditing();
            store.add( rec );
            store.commitChanges();
        }
    } );
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń' ),
        handler: function() {
            var grid = this.ownerCt.ownerCt;
            var selModel = grid.getSelectionModel();
            var rows = selModel.getSelections();
            if ( rows.length == 0 ) {
                showWarn( getTranslation( 'Wybierz klasę do usunięcia.' ) );
                return;
            }
            removeRowAndMarkNext( grid, rows[0] );
            grid.getView().refresh();
        }
    } );

    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        enableDragDrop: true,
        ddGroup: 'dd_classes',
        columnLines: true,
        autoScroll: true,
        parametersMap: parametersMap,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: true
            },
            columns: [ {
                id: 'classId',
                dataIndex: 'classId',
                hidden: true
            }, {
                id: 'classpath',
                header: getTranslation( 'Klasa' ),
                dataIndex: 'classpath',
                align: 'left',
                editor: config.classesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( config.classesChooser )
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'center',
                width: 50,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    if ( !Ext.isEmpty( value ) ) {
                        metaData.attr = 'ext:qtip="' + value + '"';
                        return '<img src=\"' + getPluginImgPath( 'info' ) + '\" width="12" height="12">';
                    } else {
                        return '';
                    }
                }
            }, {
                id: 'noOfParams',
                header: getTranslation( 'Ilość parametrów' ),
                dataIndex: 'noOfParams',
                align: 'center',
                editable: false,
                width: 60
            }, {
                id: 'setParams',
                header: getTranslation( 'Parametry' ),
                dataIndex: 'setParams',
                align: 'center',
                editable: false,
                width: 40,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    if ( value ) {
                        return '<img src=\"' + getPluginImgPath( 'parameters' ) + '\" width="12" height="12">';
                    } else {
                        return '';
                    }
                }
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'classpath' ) + '</b>';
                }
            }
        } ),
        tbar: new Ext.Toolbar( {
            buttons: buttons
        } ),
        listeners: {
            afteredit: function( e ) {
                var record = e.record;
                var classpath = record.get( 'classpath' );
                var clazz = getClassFunction.apply( getClassScope, [ classpath ] );

                if ( clazz && !Ext.isEmpty( clazz.parameters ) ) {
                    record.set( 'noOfParams', clazz.parameters.length );
                    record.set( 'setParams', true );
                } else {
                    record.set( 'noOfParams', 0 );
                    record.set( 'setParams', false );
                }
                if ( clazz && !Ext.isEmpty( clazz.description ) ) {
                    record.set( 'description', clazz.description );
                } else {
                    record.set( 'description', '' );
                }

                record.commit();
            },
            cellclick: function( grid, rowIndex, columnIndex, e ) {
                var store = grid.getStore();
                var colId = grid.getColumnModel().getColumnId( columnIndex );

                if ( colId == 'setParams' ) {
                    var rec = store.getAt( rowIndex );

                    if ( !rec.get( 'setParams' ) ) {
                        showWarn( getTranslation( 'Klasa nie posiada parametrów.' ) );
                        return;
                    }

                    var classpath = rec.get( 'classpath' );
                    var clazz = getClassFunction.apply( getClassScope, [ classpath ] );
                    var win = new Ext.ux.suncode.ClassParametersWindow( {
                        classId: rec.get( 'classId' ),
                        clazz: clazz,
                        parametersMap: grid.parametersMap
                    } );
                    win.show();
                }
            },
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.getEl(), {
                    ddGroup: 'dd_classes',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: notifyDropGrid
                } );
            }
        }
    }, config );

    Ext.ux.suncode.ClassDefinitionGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ClassDefinitionGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ClassDefinitionGrid.superclass.initComponent.call( this );
    },
    onShowPresentView: function() {
    	var showPresentViewFunction = this.initialConfig.showPresentViewFunction;
		
		if ( Ext.isFunction( showPresentViewFunction ) ) {
			var showPresentViewScope = !Ext.isEmpty( this.initialConfig.showPresentViewScope ) ?
					this.initialConfig.showPresentViewScope : window;
			showPresentViewFunction.apply( showPresentViewScope, [] );
		}
    },
    readClasses: function() {
        var classes = new Array();
        var store = this.getStore();

        if ( store.getCount() > 0 ) {
            var parametersMap = this.parametersMap;

            for ( var i = 0; i < store.getCount(); i++ ) {
                var record = store.getAt( i );
                var classpath = record.get( 'classpath' );
                var parameters = new Array();

                if ( record.get( 'setParams' ) ) {
                    var classId = record.get( 'classId' );
                    var definedParams = parametersMap.get( classId );

                    if ( Ext.isEmpty( definedParams ) || definedParams.length != record.get( 'noOfParams' ) ) {
                        showWarn( getTranslation( 'Zdefiniuj wszystkie parametry dla klasy' ) + ': ' + classpath + '.' );
                        return null;
                    } else {
                        parameters = [].concat( definedParams );
                    }
                }

                if ( !Ext.isEmpty( classpath ) ) {
                    classes.push( {
                        classpath: classpath,
                        parameters: parameters
                    } );
                }
            }
        }

        return classes;
    }
} );

Ext.ux.suncode.ClassParametersWindow = function( config ) {
    var viewSize = Ext.getBody().getViewSize();

    config = Ext.apply( {
        modal: true,
        width: viewSize.width * 0.5,
        height: viewSize.height * 0.5,
        layout: 'fit',
        title: getTranslation( 'Parametry mechanizmu uruchamianego po akceptacji' ) + ' ' + config.clazz.classpath,
        items: [ new Ext.ux.suncode.ClassParametersGrid( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.ClassParametersWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ClassParametersWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ClassParametersWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var store = this.parametersGrid.getStore();
        var parameters = new Array();
        var isOk = true;

        store.each( function( rec ) {
            var id = rec.get( 'id' );

            if ( Ext.isEmpty( id ) ) {
                showWarn( getTranslation( 'Zdefiniuj wszystkie parametry.' ) );
                isOk = false;

                return false;
            }

            parameters.push( {
                id: id
            } );
        } );

        if ( !isOk ) {
            return;
        }

        var parametersMap = this.initialConfig.parametersMap;
        parametersMap.put( this.initialConfig.classId, parameters );
        this.closeWindow();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ClassParametersGrid = function( config ) {
    var clazz = config.clazz;
    var parametersMap = config.parametersMap;
    var definedParams = parametersMap.get( config.classId );

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'descr',
                type: 'string'
            }, {
                name: 'id',
                type: 'string'
            } ] )
        } )
    } );

    var p = store.recordType;
    Ext.each( clazz.parameters, function( parameter, idx, parameters ) {
        var rec = new p( {
            descr: parameter.description,
            id: ( !Ext.isEmpty( definedParams ) && !Ext.isEmpty( definedParams[idx] ) ) ? definedParams[idx].id : ''
        } );
        store.add( rec );
    } );
    store.commitChanges();

    var formVariablesChooser = new Ext.ux.suncode.FormVariableChooser( {
        stripCharsRe: /;|,/g,
        acceptVariableSets: true
    } );

    config = Ext.apply( {
        ref: 'parametersGrid',
        store: store,
        columnLines: true,
        autoScroll: true,
        border: false,
        enableColumnResize: true,
        enableColumnMove: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ {
                id: 'descr',
                header: getTranslation( 'Opis parametru' ),
                dataIndex: 'descr',
                align: 'left',
                editable: false
            }, {
                id: 'id',
                header: getTranslation( 'Zmienna/Stała' ),
                dataIndex: 'id',
                align: 'left',
                editor: formVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( formVariablesChooser )
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak parametrów' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.ClassParametersGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ClassParametersGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ClassParametersGrid.superclass.initComponent.call( this );
    }
} );