Ext.ux.suncode.IntegrationComponentTable = function( config ) {
    var me = this;
	  var buttons = new Array();
    var conditionMap = new HashMap();
    var parametersMap = new HashMap();
    var extraConfigsMap = new HashMap();
    var filteredCategories = config.filteredCategories;
    var allCategories = config.allCategories;
    var components = config.components;
    var templateMode = config.templateMode;
    var pastView = config.pastView;
    var eventMode = config.eventMode;
    var ddGroup = 'dd_integration_component_' + Ext.id();
    var globalDefinition = config.globalDefinition;
    var storeReader = new Ext.data.JsonReader( {
      fields: Ext.data.Record.create( [ {
        name: 'generatedId',
        type: 'string'
      }, {
        name: 'templateId',
        type: 'string'
      }, {
        name: 'templateComponentId',
        type: 'string'
      }, {
        name: 'componentId',
        type: 'string'
      }, {
        name: 'name',
        type: 'string'
      }, {
        name: 'description',
        type: 'string'
      }, {
        name: 'templateName',
        type: 'string'
      }, {
        name: 'creationDate',
        type: 'string'
      }, {
        name: 'modificationDate',
        type: 'string'
      }, {
        name: 'setParams',
        type: 'boolean'
      }, {
        name: 'inactive',
        type: 'boolean'
      }, {
        name: 'globalId',
        type: 'string'
      }, {
        name: 'eventName',
        type: 'string'
      }, {
        name: 'eventOwnerId',
        type: 'string'
      }, {
        name: 'eventParentId',
        type: 'string'
      }, {
        name: 'eventGroupField',
        type: 'string'
      }, {
        name: 'eventRow',
        type: 'boolean'
      } ] )
    } );
    var store = null;
    var gridView = null;

    if ( eventMode ) {
      store = new Ext.data.GroupingStore( {
        reader: storeReader,
        groupField: 'eventGroupField'
      } );
    } else {
      store = new Ext.data.Store( {
        reader: storeReader
      } );
    }

    if ( templateMode ) {
    	this.loadTemplates( config.templates, store, allCategories, conditionMap, parametersMap, extraConfigsMap,
    			config.getTemplateFunction, config.getTemplateScope );
    }
    this.loadComponents( components, store, allCategories, conditionMap, parametersMap, extraConfigsMap, null, null, null );
    if ( eventMode ) {
      this.loadEventRows( store );
    }
    
    buttons.push( '->' );
    if ( pastView ) {
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'change' ),
            tooltip: getTranslation( 'Pokaż dotychczasowy widok' ),
            handler: this.onShowPastView,
            scope: this
        } );
    }
    if ( templateMode ) {
    	buttons.push( {
            cls: 'x-btn-icon',
            ref: 'saveBtn',
            icon: getPluginImgPath( 'save' ),
            tooltip: getTranslation( 'Zapisz jako szablon' ),
            handler: this.onSaveAsTemplate,
            scope: this
        } );
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'template' ),
            tooltip: getTranslation( 'Załaduj szablon' ),
            handler: this.onLoadTemplate,
            scope: this
        } );
    }
    if ( eventMode ) {
      buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'event_add' ),
        tooltip: getTranslation( 'Zdarzenia' ),
        menu: new Ext.ux.suncode.EventTypeMenu( {
          eventTypes: config.eventTypes,
          saveFunction: function( eventType ) {
            if ( !this.isEventTypeAdded( eventType, null ) ) {
              this.onAddEventType( eventType, null );
            } else {
              showWarn( getTranslation( 'Zdarzenie zostało już dodane.' ) );
            }
          },
          saveScope: this
        } )
      } );
    } else {
      buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'config' ),
        tooltip: getTranslation( 'Dodaj' ),
        menu: new Ext.ux.suncode.IntegrationComponentMenu( {
          categories: filteredCategories,
          saveFunction: function( componentDef ) {
            this.onChooseComponent( componentDef, null, null, null );
          },
          saveScope: this
        } )
      } );
    }
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń' ),
        handler: this.onDeleteComponent,
        scope: this
    } );

    if ( eventMode ) {
      gridView = new Ext.grid.GroupingView( {
        forceFit: true,
        grid: this,
        getRowClass: this.getTableRowClass,
        groupTextTpl: '{[buildEventActionsGroupTemplate(values)]}'
      } );
    } else {
      gridView = new Ext.grid.GridView( {
        forceFit: true,
        grid: this,
        getRowClass: this.getTableRowClass
      } );
    }

    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        enableColumnMove: !eventMode,
        columnLines: true,
        autoScroll: true,
        enableDragDrop: true,
        ddGroup: ddGroup,
        conditionMap: conditionMap,
        parametersMap: parametersMap,
        extraConfigsMap: extraConfigsMap,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: !eventMode,
                menuDisabled: false
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'generatedId',
                dataIndex: 'generatedId',
                hidden: true,
                hideable: false
            }, {
                id: 'templateId',
                dataIndex: 'templateId',
                hidden: true,
                hideable: false
            }, {
                id: 'componentId',
                dataIndex: 'componentId',
                hidden: true,
                hideable: false
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                groupable: false,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  if ( record.get( 'eventRow' ) === true ) {
                    metaData.css = 'x-Module-integrationComponentTableEventRowCell';
                  }
                  return value;
                }
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'center',
                groupable: false,
                width: 200,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  if ( record.get( 'eventRow' ) !== true ) {
                    var newValue = !Ext.isEmpty( value ) ? value : '';
                    var eventOwnerId = record.get( 'eventOwnerId' );

                    if ( !Ext.isEmpty( eventOwnerId ) && store.find( 'eventParentId', eventOwnerId ) !== -1 ) {
                      if ( !Ext.isEmpty( newValue ) ) {
                        newValue += ' ';
                      }

                      newValue += ' [';
                      newValue += getTranslation( 'Tag' );
                      newValue += ': ';
                      newValue += eventOwnerId;
                      newValue += ']';
                    }

                    if ( !Ext.isEmpty( newValue ) ) {
                      metaData.attr = 'ext:qtip="' + newValue + '"';
                      return wrapColumnValue( newValue.ellipse( 100 ) );
                    } else {
                      return '';
                    }
                  } else {
                    metaData.css = 'x-Module-integrationComponentTableEventRowCell';
                    return '';
                  }
                }
            }, {
                id: 'templateName',
                header: getTranslation( 'Szablon' ),
                dataIndex: 'templateName',
                align: 'left',
                hidden: !templateMode,
                hideable: templateMode,
                groupable: false,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  if ( record.get( 'eventRow' ) === true ) {
                    metaData.css = 'x-Module-integrationComponentTableEventRowCell';
                  }
                  return value;
                }
            }, {
              id: 'creationDate',
              header: getTranslation( 'Data utworzenia' ),
              dataIndex: 'creationDate',
              align: 'center'
            }, {
              id: 'modificationDate',
              header: getTranslation( 'Data modyfikacji' ),
              dataIndex: 'modificationDate',
              align: 'center'
            }, {
                id: 'setParams',
                header: getTranslation( 'Parametry' ),
                dataIndex: 'setParams',
                align: 'center',
                editable: false,
                groupable: false,
                width: 60,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  if ( record.get( 'eventRow' ) !== true ) {
                    if ( !globalDefinition && !Ext.isEmpty( record.get( 'globalId' ) ) ) {
                      return '<img src=\"' + getPluginImgPath( 'global' ) + '\" width="12" height="12">';
                    } else {
                      return '<img src=\"' + getPluginImgPath( 'parameters' ) + '\" width="12" height="12">';
                    }
                  } else {
                    metaData.css = 'x-Module-integrationComponentTableEventRowCell';
                    return '';
                  }
                }
            }, {
                id: 'inactive',
                header: getTranslation( 'Aktywny' ),
                dataIndex: 'inactive',
                align: 'center',
                editable: false,
                groupable: false,
                width: 60,
                renderer: {
                  fn: function( value, metaData, record, rowIndex, colIndex, store ) {
                    if ( record.get( 'eventRow' ) !== true ) {
                      return tickCrossValue( !value, metaData, record, rowIndex, colIndex, store );
                    } else {
                      metaData.css = 'x-Module-integrationComponentTableEventRowCell';
                      var id = me.getId();
                      var addEventActionTooltip = getTranslation( 'Dodaj akcję' );
                      var pasteEventActionsTooltip = getTranslation( 'Wklej akcje' );
                      var eventActions = me.getEventActionsByEventGroupField( record.get( 'eventGroupField' ) );
                      var rendered = '<img onmouseover=\"new Function(showImageTooltip(this, \'' + addEventActionTooltip + '\'))\" '
                          + 'onclick="callGridFunctionForRow(\'' + id + '\', \'onAddEventAction\', \''
                          + rowIndex + '\')" '+ 'src=\"' + getPluginImgPath( 'add' ) + '\">';
                      rendered += '&nbsp;&nbsp;';
                      rendered += '<img onmouseover=\"new Function(showImageTooltip(this, \'' + pasteEventActionsTooltip + '\'))\" '
                          + 'onclick="callGridFunctionForRow(\'' + id + '\', \'onPasteEventActions\', \''
                          + rowIndex + '\')" '+ 'src=\"' + getPluginImgPath( 'paste' ) + '\">';

                      if ( Ext.isEmpty( eventActions ) ) {
                        var removeEventTypeTooltip = getTranslation( 'Usuń zdarzenie' );
                        rendered += '&nbsp;&nbsp;';
                        rendered += '<img onmouseover=\"new Function(showImageTooltip(this, \'' + removeEventTypeTooltip + '\'))\" '
                            + 'onclick="callGridFunctionForRow(\'' + id + '\', \'onRemoveEventType\', \''
                            + rowIndex + '\')" '+ 'src=\"' + getPluginImgPath( 'delete' ) + '\">';
                      }

                      return rendered;
                    }
                  },
                  scope: this
                }
            }, {
              id: 'support-event-mode',
              hidden: !eventMode,
              hideable: false,
              width: 10
            }, {
              id: 'eventGroupField',
              dataIndex: 'eventGroupField',
              align: 'left',
              hidden: true,
              hideable: false
            } ]
        } ),
        viewConfig: gridView,
        sm: new Ext.grid.RowSelectionModel( {
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                  sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'name' ) + '</b>';
                  return !( row.get( 'eventRow' ) === true );
                }
            }
        } ),
        tbar: new Ext.Toolbar( {
            buttons: buttons
        } ),
        listeners: {
            scope: this,
            render: function( grid ) {
            	new Ext.dd.DropTarget( grid.container, {
                    ddGroup: ddGroup,
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: this.onComponentDrop
                } );
            },
            cellclick: this.onCellClick,
            containercontextmenu: this.onContainerContextMenu,
            rowcontextmenu: this.onRowContextMenu
        }
    }, config );

    Ext.ux.suncode.IntegrationComponentTable.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTable, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTable.superclass.initComponent.call( this );
    },
    onShowPastView: function() {
    	var showPastViewFunction = this.initialConfig.showPastViewFunction;
		
		if ( Ext.isFunction( showPastViewFunction ) ) {
			var showPastViewScope = !Ext.isEmpty( this.initialConfig.showPastViewScope ) ?
					this.initialConfig.showPastViewScope : window;
			showPastViewFunction.apply( showPastViewScope, [] );
		}
    },
    onSaveAsTemplate: function() {
    	var components = this.readComponents();
    	if ( Ext.isEmpty( components ) ) {
    		showWarn( this.initialConfig.noComponentsMessage );
            return;
    	}
		var generateTemplateIdFunction = this.initialConfig.generateTemplateIdFunction;
		
		if ( Ext.isFunction( generateTemplateIdFunction ) ) {
			var generateTemplateIdScope = !Ext.isEmpty( this.initialConfig.generateTemplateIdScope ) ?
					this.initialConfig.generateTemplateIdScope : window;
			var template = new Object();
			template = Ext.apply( template, {
				components: components
			} );
			var templateId = generateTemplateIdFunction.apply( generateTemplateIdScope, [] );
			var allCategories = this.initialConfig.allCategories;
			var win = new Ext.ux.suncode.IntegrationComponentTemplateEditorWindow( {
	    		title: getTranslation( 'Kreator szablonu' ),
	    		templateId: templateId,
	    		template: template,
	    		processNode: this.initialConfig.processNode,
	    		conditionalExecutionEnabled: this.initialConfig.conditionalExecutionEnabled,
	    		inactiveEnabled: this.initialConfig.inactiveEnabled,
	    		componentsTableTitle: this.initialConfig.componentsTableTitle,
	    		categories: allCategories,
	    		parametersWindowTitlePrefix: this.initialConfig.parametersWindowTitlePrefix,
	    		noComponentsMessage: this.initialConfig.noComponentsMessage,
	    		systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
	    		saveCallback: function( savedTemplate ) {
	    			var addTemplateFunction = this.initialConfig.addTemplateFunction;
	    			
	    			if ( Ext.isFunction( addTemplateFunction ) ) {
	    				var addTemplateScope = !Ext.isEmpty( this.initialConfig.addTemplateScope ) ?
	    						this.initialConfig.addTemplateScope : window;
	    				addTemplateFunction.apply( addTemplateScope, [ savedTemplate ] );
	        			var store = this.getStore();
	        			store.removeAll();
	        			this.loadTemplate( savedTemplate, this.getStore(), allCategories, this.conditionMap,
	        					this.parametersMap, this.extraConfigsMap, this.initialConfig.getTemplateFunction,
	        					this.initialConfig.getTemplateScope );
	        			win.close();
	    			}
	    		},
	    		saveCallbackScope: this,
	    		getComponentRegistrationFunction: this.initialConfig.getComponentRegistrationFunction,
          getComponentRegistrationScope: this.initialConfig.getComponentRegistrationScope,
          copyComponentsFunction: this.initialConfig.copyComponentsFunction,
          copyComponentsScope: this.initialConfig.copyComponentsScope,
          handleCopiedComponentsFunction: this.initialConfig.handleCopiedComponentsFunction,
          handleCopiedComponentsScope: this.initialConfig.handleCopiedComponentsScope,
          pasteSpecialMessageType: this.initialConfig.pasteSpecialMessageType
	    	} );
	    	win.show();
		}
    },
    onLoadTemplate: function() {
    	var win = new Ext.ux.suncode.IntegrationComponentTemplateWindow( {
            title: this.initialConfig.templatesWindowTitle,
            editionMode: false,
            enableCopyPasteMenu: this.initialConfig.enableCopyPasteMenu,
            getTemplatesFunction: this.initialConfig.getTemplatesFunction,
            getTemplatesScope: this.initialConfig.getTemplatesScope,
            getTemplateFunction: this.initialConfig.getTemplateFunction,
            getTemplateScope: this.initialConfig.getTemplateScope,
            useTemplateFunction: function( template ) {
            	var useTemplateFunction = this.initialConfig.useTemplateFunction;
        		
        		if ( Ext.isFunction( useTemplateFunction ) ) {
        			var useTemplateScope = !Ext.isEmpty( this.initialConfig.useTemplateScope ) ?
    						this.initialConfig.useTemplateScope : window;
    				  useTemplateFunction.apply( useTemplateScope, [ template ] );
        		}
            	
            	this.loadTemplate( template, this.getStore(), this.initialConfig.allCategories, this.conditionMap,
    					this.parametersMap, this.extraConfigsMap, this.initialConfig.getTemplateFunction,
    					this.initialConfig.getTemplateScope );
            	this.storeParentWindowAsUnsaved();
            },
            useTemplateScope: this,
            getComponentRegistrationFunction: this.initialConfig.getComponentRegistrationFunction,
            getComponentRegistrationScope: this.initialConfig.getComponentRegistrationScope,
            copyComponentsFunction: this.initialConfig.copyComponentsFunction,
            copyComponentsScope: this.initialConfig.copyComponentsScope,
            handleCopiedComponentsFunction: this.initialConfig.handleCopiedComponentsFunction,
            handleCopiedComponentsScope: this.initialConfig.handleCopiedComponentsScope,
            pasteSpecialMessageType: this.initialConfig.pasteSpecialMessageType
        } );
        win.show();
    },
    loadTemplates: function( templates, store, allCategories, conditionMap, parametersMap, extraConfigsMap, getTemplateFunction,
    		getTemplateScope ) {
    	if( !Ext.isEmpty( templates ) ) {
    		Ext.each( templates, function( template, idx, allTemplates ) {
    			this.loadTemplate( template, store, allCategories, conditionMap, parametersMap, extraConfigsMap, getTemplateFunction,
    					getTemplateScope );
    		}, this );
    	}
    },
    loadTemplate: function( template, store, allCategories, conditionMap, parametersMap, extraConfigsMap, getTemplateFunction,
    		getTemplateScope ) {
    	var components = template.components;
    	
    	this.loadComponents( components, store, allCategories, conditionMap, parametersMap, extraConfigsMap, getTemplateFunction,
    			getTemplateScope, template.id );
    },
    appendComponents( components ) {
      this.loadComponents( components, this.getStore(), this.initialConfig.allCategories, this.conditionMap,
          this.parametersMap, this.extraConfigsMap, null, null, null );
    },
    loadComponents: function( components, store, allCategories, conditionMap, parametersMap, extraConfigsMap, getTemplateFunction,
    		getTemplateScope, templateId, loadIndex ) {
      if ( !Ext.isEmpty( components ) ) {
        Ext.each( components, function( component, idx, allComponents ) {
          var componentId = component.id;
          var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( allCategories, componentId );
          var generatedId = Ext.id();
          var template = null;
          if ( !Ext.isEmpty( templateId ) && Ext.isFunction( getTemplateFunction ) ) {
            getTemplateScope = !Ext.isEmpty( getTemplateScope ) ? getTemplateScope : window;
            template = getTemplateFunction.apply( getTemplateScope, [ templateId ] );
          }
          var description = !Ext.isEmpty( componentDef ) ? componentDef.description : '';
          var customDescription = component.customDescription;
          var setParams = hasAnyProperty( component.parameters );
          var v = store.recordType;
          var rec = new v( {
            generatedId: generatedId,
            templateId: templateId,
            templateComponentId: component.templateComponentId,
            componentId: componentId,
            name: !Ext.isEmpty( componentDef ) ? componentDef.name : componentId,
            description: this.buildDescription( description, customDescription ),
            templateName: !Ext.isEmpty( template ) ? template.name : '',
            setParams: setParams,
            inactive: component.inactive,
            creationDate: component.creationDate,
            modificationDate: component.modificationDate,
            globalId: component.globalId,
            eventName: component.eventName,
            eventOwnerId: component.eventOwnerId,
            eventParentId: component.eventParentId,
            eventGroupField: this.buildEventGroupField( component.eventName, component.eventParentId ),
            eventRow: false
          } );

          if ( Ext.isEmpty( loadIndex ) ) {
            store.add( rec );
          } else {
            store.insert( loadIndex, rec );
            loadIndex++;
          }

          conditionMap.put( generatedId, component.condition );
          extraConfigsMap.put( generatedId, {
            customDescription: customDescription,
            creationDate: component.creationDate,
            modificationDate: component.modificationDate,
            confirmation: component.confirmation,
            error: component.error,
            errorHandling: component.errorHandling,
            inactive: component.inactive
          } );

          if ( setParams ) {
            parametersMap.put( generatedId, component.parameters );
          }
        }, this );

        store.commitChanges();
      }
    },
    buildDescription: function( description, customDescription ) {
      if ( !Ext.isEmpty( customDescription ) ) {
        return Ext.util.Format.htmlEncode( customDescription );
      } else {
        return Ext.util.Format.htmlEncode( description );
      }
    },
    buildEventGroupField: function( eventName, eventParentId ) {
      var eventGroupField = '';

      if ( !Ext.isEmpty( eventName ) ) {
        eventGroupField += eventName;
      }

      if ( !Ext.isEmpty( eventParentId ) ) {
        eventGroupField += '-';
        eventGroupField += eventParentId;
      }

      return eventGroupField;
    },
    loadEventRows: function( store ) {
      var count = store.getCount();

      if ( count > 0 ) {
        var eventRows = new Array();
        var firstRow = store.getAt( 0 );
        var currentEventGroupField = firstRow.get( 'eventGroupField' );
        var previousRecord = null;
        var index = 0;
        var insertIndex = 0;

        store.each( function( record ) {
          var eventGroupField = record.get( 'eventGroupField' );

          if ( eventGroupField != currentEventGroupField ) {
            eventRows.push( {
              index: insertIndex,
              eventName: previousRecord.get( 'eventName' ),
              eventParentId: previousRecord.get( 'eventParentId' )
            } );
            currentEventGroupField = eventGroupField;
            insertIndex++;
          }

          if ( index == count - 1 ) {
            eventRows.push( {
              index: insertIndex + 1,
              eventName: record.get( 'eventName' ),
              eventParentId: record.get( 'eventParentId' )
            } );
          }

          previousRecord = record;
          index++;
          insertIndex++;
        }, this );

        Ext.each( eventRows, function( eventRow, index, allEventRows ) {
          var eventRowRecord = this.buildEventRowRecord( store, eventRow.eventName, eventRow.eventParentId );
          store.insert( eventRow.index, eventRowRecord );
        }, this );

        store.commitChanges();
      }
    },
    buildEventRowRecord: function( store, eventName, eventParentId ) {
      var v = store.recordType;

      return new v( {
        eventName: eventName,
        eventParentId: eventParentId,
        eventGroupField: this.buildEventGroupField( eventName, eventParentId ),
        eventRow: true
      } );
    },
    onDeleteComponent: function() {
      var selModel = this.getSelectionModel();
      var rows = selModel.getSelections();

      if ( rows.length == 0 ) {
        showWarn( getTranslation( 'Wybierz komponent do usunięcia.' ) );
        return;
      }

      var globalDefinition = this.initialConfig.globalDefinition;
      var row = rows[0];

      if ( !globalDefinition && !Ext.isEmpty( row.get( 'globalId' ) ) ) {
        showWarn( getTranslation( 'Globalny komponent nie może być usunięty.' ) );
        return;
      }

      if ( this.initialConfig.templateMode ) {
        var templateId = row.get( 'templateId' );
        var getTemplateFunction = this.initialConfig.getTemplateFunction;

        if ( !Ext.isEmpty( templateId ) && Ext.isFunction( getTemplateFunction ) ) {
          var getTemplateScope = !Ext.isEmpty( this.initialConfig.getTemplateScope ) ?
              this.initialConfig.getTemplateScope : window;
          var template = getTemplateFunction.apply( getTemplateScope, [ templateId ] );
          this.onBeforeDeleteTemplateComponent( row, template );
          return;
        }
      }

      if ( this.initialConfig.eventMode ) {
        var eventOwnerId = row.get( 'eventOwnerId' );
        var store = this.getStore();
        var index = store.find( 'eventParentId', eventOwnerId );

        if ( index != -1 ) {
          this.onBeforeDeleteDependentComponents( row );
          return;
        }
      }

      this.executeDeleteComponent( row );
    },
    executeDeleteComponent: function( row ) {
      if ( this.initialConfig.eventMode ) {
        var eventOwnerId = row.get( 'eventOwnerId' );
        var depententRecords = this.findDependentRecords( eventOwnerId );

        if ( !Ext.isEmpty( depententRecords ) ) {
          var store = this.getStore();
          store.remove( depententRecords );
          store.commitChanges();
        }
      }

      removeRowAndMarkNext( this, row );
      this.refreshView();
      this.storeParentWindowAsUnsaved();
    },
    findDependentRecords: function( eventOwnerId ) {
      var depententRecords = new Array();
      var store = this.getStore();
      store.each( function( record ) {
        if ( record.get( 'eventParentId' ) === eventOwnerId ) {
          depententRecords.push( record );
        }
      } );

      if ( !Ext.isEmpty( depententRecords ) ) {
        Ext.each( depententRecords, function( record, index, records ) {
          if ( record.get( 'eventRow') !== true ) {
            depententRecords = depententRecords.concat( this.findDependentRecords( record.get( 'eventOwnerId' ) ) );
          }
        }, this );
      }

      return depententRecords;
    },
    onBeforeDeleteDependentComponents: function( row ) {
      Ext.ux.suncode.IntegrationComponentService.showDependentEventsRemovalWarning(
          this.executeDeleteComponent, this, [ row ] );
    },
    onBeforeDeleteTemplateComponent: function( row, template ) {
    	Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: getTranslation( 'Komponent jest częścią szablonu o nazwie' + ' ' + template.name + '.' ),
            buttons: {
                yes: getTranslation( 'Usuń szablon' ),
                no: getTranslation( 'Usuń komponent' ),
                cancel: getTranslation( 'Anuluj' )
            },
            fn: function( buttonId ) {
            	switch ( buttonId ) {
            		case 'yes':
            			this.onDeleteTemplate( template.id );
            			break;
            		case 'no':
            			this.onDeleteTemplateComponent( row, template.id );
            			break;
            		default:
            			break;
            	}
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    onDeleteTemplate: function( templateId ) {
    	this.executeRemoveTemplateFunction( templateId );
    	this.getStore().each( function( record ) {
    		if ( templateId == record.get( 'templateId' ) ) {
    			removeRowAndMarkNext( this, record );
    		}
    	}, this );
    	this.refreshView();
    	this.storeParentWindowAsUnsaved();
    },
    onDeleteTemplateComponent: function( row, templateId ) {
    	this.executeRemoveTemplateFunction( templateId );
    	removeRowAndMarkNext( this, row );
    	this.getStore().each( function( record ) {
    		if ( templateId == record.get( 'templateId' ) ) {
    			record.set( 'templateId', null );
    		}
    	}, this );
    	this.refreshView();
    	this.storeParentWindowAsUnsaved();
    },
    executeRemoveTemplateFunction: function( templateId ) {
    	var removeTemplateFunction = this.initialConfig.removeTemplateFunction;
    	
    	if ( Ext.isFunction( removeTemplateFunction ) ) {
    		var removeTemplateScope = !Ext.isEmpty( this.initialConfig.removeTemplateScope ) ?
					this.initialConfig.removeTemplateScope : window;
    		removeTemplateFunction.apply( removeTemplateScope, [ templateId ] );
    	}
    },
    onAddEventType: function( eventType, eventTypesTag ) {
      var eventName = eventType.name;
      var store = this.getStore();
      var eventRowRecord = this.buildEventRowRecord( store, eventName, eventTypesTag );
      store.add( eventRowRecord );
      store.commitChanges();
      this.storeParentWindowAsUnsaved();

      if ( !Ext.isEmpty( eventTypesTag ) ) {
        this.addEventAction( eventName, eventTypesTag );
      }
    },
    isEventTypeAdded: function( eventType, eventTypesTag ) {
      var store = this.getStore();
      var eventName = eventType.name;
      var index = store.findBy( function ( record, id ) {
        return record.get( 'eventName' ) === eventName && ( Ext.isEmpty( eventTypesTag ) || record.get( 'eventParentId' ) === eventTypesTag );
      } );

      return index !== -1;
    },
    generateEventOwnerId: function( componentId ) {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();

      return componentId + '_' + packageNode.getAndIncrementEventActionIdCounter();
    },
    getEventActionsByEventGroupField: function( eventGroupField ) {
      var store = this.getStore();
      var eventActions = new Array();

      store.each( function( record ) {
        if ( record.get( 'eventRow') !== true && record.get( 'eventGroupField' ) === eventGroupField ) {
          eventActions.push( record );
        }
      } );

      return eventActions;
    },
    onAddEventAction: function( rowIndex ) {
      var store = this.getStore();
      var record = store.getAt( rowIndex );
      var eventName = record.get( 'eventName' );
      var eventParentId = record.get( 'eventParentId' );

      this.addEventAction( eventName, eventParentId );
    },
    addEventAction: function( eventName, eventParentId ) {
      var menu = new Ext.ux.suncode.IntegrationComponentMenu( {
        categories: this.initialConfig.filteredCategories,
        saveFunction: function( componentDef ) {
          var eventOwnerId = this.generateEventOwnerId( componentDef.id );
          this.onChooseComponent( componentDef, eventName, eventOwnerId, eventParentId );
        },
        saveScope: this
      } );
      menu.showAt( this.getPosition() );
    },
    onPasteEventActions: function( rowIndex ) {
      this.getComponentsToPaste( function ( components ) {
        this.executePasteEventActions( components, rowIndex );
      }, this );
    },
    executePasteEventActions: function( components, rowIndex ) {
      if ( Ext.isEmpty( components ) ) {
        showWarn( getTranslation( 'Brak komponentów do wklejenia.' ) );
        return;
      }

      var store = this.getStore();
      var record = store.getAt( rowIndex );
      var eventName = record.get( 'eventName' );
      var eventParentId = record.get( 'eventParentId' );
      var me = this;

      window.setTimeout( function() {
        me.executePasteComponents( components, eventName, eventParentId );
      }, 50 );
    },
    onRemoveEventType: function( rowIndex ) {
      var store = this.getStore();
      store.removeAt( rowIndex );
      store.commitChanges();
      this.refreshView();
      this.storeParentWindowAsUnsaved();
    },
    onChooseComponent: function( componentDef, eventName, eventOwnerId, eventParentId ) {
      var generatedId = Ext.id();
      this.showParametersWindow( componentDef, generatedId, false, null, null, eventName, eventOwnerId, eventParentId );
    },
    onComponentDrop: function( dd, e, data, callback ) {
      var grid = dd.grid;
      var eventMode = grid.initialConfig.eventMode;

      if ( eventMode ) {
        var dragData = dd.getDragData( e );

        if ( dragData ) {
          var sindex = dd.dragData.rowIndex;
          var dindex = dragData.rowIndex;
          var store = grid.getStore();
          var draggedRecord = store.getAt( sindex );
          var onDropRecord = store.getAt( dindex );

          if ( draggedRecord.get( 'eventName' ) !== onDropRecord.get( 'eventName' )
              || draggedRecord.get( 'eventParentId' ) !== onDropRecord.get( 'eventParentId' ) ) {
            if ( dd.markedRow ) {
              dd.markedRow.removeClass( 'x-Module-gridDropTopProxy' );
              dd.markedRow.removeClass( 'x-Module-gridDropBottomProxy' );
            }

            showWarn( getTranslation( 'Przenoszenie akcji między zdarzeniami jest zabronione.' ) );
          } else if ( onDropRecord.get( 'eventRow' ) === true && dd.markedRow ) {
            dd.markedRow.removeClass( 'x-Module-gridDropTopProxy' );
            dd.markedRow.removeClass( 'x-Module-gridDropBottomProxy' );
          } else {
            notifyDropGrid( dd, e, data, callback );
          }
        } else if ( dd.markedRow ) {
          dd.markedRow.removeClass( 'x-Module-gridDropTopProxy' );
          dd.markedRow.removeClass( 'x-Module-gridDropBottomProxy' );
        }
      } else {
        notifyDropGrid( dd, e, data, callback );
      }

      grid.refreshView();
    },
    onCellClick: function( grid, rowIndex, columnIndex, e ) {
        var store = grid.getStore();
        var rec = store.getAt( rowIndex );

        if ( Ext.isEmpty( rec ) || rec.get( 'eventRow' ) === true ) {
          return;
        }

        var colId = grid.getColumnModel().getColumnId( columnIndex );

        if ( colId == 'setParams' ) {
            var globalDefinition = this.initialConfig.globalDefinition;

            if ( !globalDefinition && !Ext.isEmpty( rec.get( 'globalId' ) ) ) {
              var warnMsg = getTranslation( 'Komponent jest globalny.' );
              warnMsg += ' ' + getTranslation( 'Edycja parametrów spowoduje ich zmianę we wszystkich zadaniach.' );
              warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

              Ext.Msg.show( {
                title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
                msg: warnMsg,
                buttons: {
                  yes: getTranslation( 'Tak' ),
                  no: getTranslation( 'Nie' )
                },
                fn: function( buttonId ) {
                  if ( buttonId == 'yes' ) {
                    this.editParameters( rec );
                  }
                },
                icon: Ext.Msg.QUESTION,
                scope: this
              } );
            } else {
              this.editParameters( rec );
            }
        } else if ( colId == 'inactive' ) {
        	  var newInactive = !rec.get( 'inactive' );
            rec.set( 'inactive', newInactive );
            store.commitChanges();
            var generatedId = rec.get( 'generatedId' );
            var extraConfig = this.extraConfigsMap.get( generatedId );

            if ( !Ext.isEmpty( extraConfig ) ) {
            	extraConfig = Ext.apply( extraConfig, {
            		inactive: newInactive
            	} );

            	this.extraConfigsMap.put( generatedId, extraConfig );
              grid.refreshView();
            }
        }
    },
    editParameters: function( rec ) {
      var allCategories = this.initialConfig.allCategories;
      var componentId = rec.get( 'componentId' );
      var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( allCategories, componentId );

      if ( !Ext.isEmpty( componentDef ) ) {
        var generatedId = rec.get( 'generatedId' );
        var templateId = rec.get( 'templateId' );
        var templateComponentId = rec.get( 'templateComponentId' );
        var eventName = rec.get( 'eventName' );
        var eventOwnerId = rec.get( 'eventOwnerId' );
        var eventParentId = rec.get( 'eventParentId' );
        this.showParametersWindow( componentDef, generatedId, true, templateId, templateComponentId, eventName, eventOwnerId, eventParentId );
      } else {
        showWarn( getTranslation( 'Komponent nie istnieje.' ) );
      }
    },
    onContainerContextMenu: function( grid, e ) {
      if ( this.initialConfig.enableCopyPasteMenu ) {
        if ( this.initialConfig.eventMode ) {
          this.showCopyContextMenu( e );
        } else {
          this.showCopyPasteContextMenu( e );
        }
      }
    },
    onRowContextMenu: function( grid, rowIndex, e ) {
      if ( this.initialConfig.enableCopyPasteMenu ) {
        var selModel = this.getSelectionModel();
        selModel.selectRow( rowIndex, true );

        if ( this.initialConfig.eventMode ) {
          this.showCopyContextMenu( e );
        } else {
          this.showCopyPasteContextMenu( e );
        }
      }
    },
    showCopyPasteContextMenu: function( e ) {
      this.getComponentsToPaste( function( components ) {
        var menu = this.buildCopyPasteContextMenu( components );
        showMenu( menu, e );
      }, this );
    },
    showCopyContextMenu: function( e ) {
      var menu = this.buildCopyContextMenu();
      showMenu( menu, e );
    },
    buildCopyPasteContextMenu: function( clipboardComponents ) {
    	return new Ext.menu.Menu( {
        style: {
          zIndex: '30000'
        },
    		items: [ this.buildCopyContextMenuItem(),
          this.buildPasteContextMenuItem( clipboardComponents ),
          this.buildPasteSpecialContextMenuItem() ]
    	} );
    },
    buildCopyContextMenu: function() {
      return new Ext.menu.Menu( {
        style: {
          zIndex: '30000'
        },
        items: [ this.buildCopyContextMenuItem() ]
      } );
    },
    buildCopyContextMenuItem: function() {
      var selModel = this.getSelectionModel();
      var rows = selModel.getSelections();

      return {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'copy' ),
        text: getTranslation( 'Kopiuj komponenty' ),
        disabled: Ext.isEmpty( rows ),
        listeners: {
          scope: this,
          click: this.onCopyComponents
        }
      };
    },
    buildPasteContextMenuItem: function( clipboardComponents ) {
      return {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej komponenty' ),
        disabled: Ext.isEmpty( clipboardComponents ),
        clipboardComponents: clipboardComponents,
        listeners: {
          scope: this,
          click: this.onPasteComponents
        }
      };
    },
    buildPasteSpecialContextMenuItem: function() {
      return {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej specjalnie' ),
        listeners: {
          scope: this,
          click: this.onPasteSpecial
        }
      };
    },
    onCopyComponents: function( menuItem, e ) {
    	var selModel = this.getSelectionModel();
        var rows = selModel.getSelections();
        var templateMode = this.initialConfig.templateMode;
        var components = new Array();
        var doCopy = true;

        Ext.each( rows, function( record, index, records ) {
        	if ( templateMode && !Ext.isEmpty( record.get( 'templateId' ) ) ) {
        		doCopy = false;
        		return false;
        	} else {
        		components.push( this.readComponent( record ) );
        	}
        }, this );
        
        if ( doCopy ) {
        	this.executeCopyComponents( components );
        } else {
        	showWarn( getTranslation( 'Kopiowanie komponentów należących do szablonu jest zabronione.' ) );
        }
    },
    executeCopyComponents: function( components ) {
    	var copyComponentsFunction = this.initialConfig.copyComponentsFunction;

        if ( Ext.isFunction( copyComponentsFunction ) ) {
            var copyComponentsScope = !Ext.isEmpty( this.initialConfig.copyComponentsScope ) ?
            		this.initialConfig.copyComponentsScope : window;
            copyComponentsFunction.apply( copyComponentsScope, [ components ] );
        }
    },
    onPasteComponents: function( menuItem, e ) {
      var clipboardComponents = menuItem.clipboardComponents;

    	this.executePasteComponents( clipboardComponents );
    },
    executePasteComponents: function( components, eventName, eventParentId ) {
      if ( this.initialConfig.eventMode ) {
        Ext.each( components, function( component, index, allComponents ) {
          Ext.apply( component, {
            eventName: eventName,
            eventOwnerId: this.generateEventOwnerId( component.id ),
            eventParentId: eventParentId,
            eventGroupField: this.buildEventGroupField( eventName, eventParentId ),
          } );
        }, this );
      }

      var processNode = this.initialConfig.processNode;

      var validationResult = Ext.ux.suncode.IntegrationComponentService.validateComponentsPaste(
          this.initialConfig.filteredCategories, components, processNode, this.initialConfig.pasteComponentsValidation );

      if ( validationResult.isAnyValid() ) {
        this.finalExecutePasteComponents( validationResult.getValid(), eventName );
      }

      if ( validationResult.isAnyInvalid() ) {
        Ext.Msg.show( {
          title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
          msg: validationResult.getInvalidMessage(),
          buttons: validationResult.hasIncompatible() ? {
            yes: getTranslation( 'Zastąp zmienne' ),
            no: getTranslation( 'Zamknij' )
          } : {
            no: getTranslation( 'Zamknij' )
          },
          fn: function( buttonId ) {
            if ( buttonId == 'yes' ) {
              var toReplace = new Array();
              var toPasteAfterReplacement = new Array();

              Ext.each( validationResult.getIncompatible(), function( incompatible, index, allIncompatible ) {
                Ext.each( incompatible.discrepancies, function ( discrepancy, innerIndex, allDiscrepancies ) {
                  toReplace.push( {
                    placement: incompatible.componentName + ' -> ' + discrepancy.parameterName,
                    description: incompatible.component.customDescription,
                    replacedVariable: discrepancy.variableName,
                    expectedType: discrepancy.parameterType,
                    expectedInArray: discrepancy.parameterInArray,
                    modificationContext: discrepancy.modificationContext,
                    modificationProperty: 'value'
                  } );
                } );

                toPasteAfterReplacement.push( incompatible.component );
              } );

              var win = new Ext.ux.suncode.ReplaceVariablesWindow( {
                processNode: processNode,
                toReplace: toReplace,
                availableVariables: this.initialConfig.availableVariables,
                saveFunction: function () {
                  var currentDate = new Date().format( 'Y-m-d H:i:s' );

                  Ext.each( toPasteAfterReplacement, function( oneToPaste, index, allToPaste ) {
                    Ext.apply( oneToPaste, {
                      creationDate: currentDate,
                      modificationDate: currentDate
                    } );
                  } );

                  this.finalExecutePasteComponents( toPasteAfterReplacement, eventName );
                },
                saveScope: this
              } );
              win.show();
            }
          },
          icon: Ext.Msg.WARNING,
          scope: this
        } );
      }
    },
    finalExecutePasteComponents: function( toPaste, eventName ) {
      var store = this.getStore();
      var loadIndex = store.getCount();

      if ( this.initialConfig.eventMode ) {
        loadIndex = store.findBy( function ( record, id ) {
          return record.get( 'eventName' ) === eventName && record.get( 'eventRow' ) === true;
        } );
      }

      this.loadComponents( toPaste, store, this.initialConfig.allCategories, this.conditionMap, this.parametersMap,
          this.extraConfigsMap, null, null, null, loadIndex );
      this.storeParentWindowAsUnsaved();
    },
    onPasteSpecial: function() {
      var win = new Ext.ux.suncode.PasteSpecialWindow( {
        pasteSpecialFunction: function( components ) {
          this.executePasteComponents( components );
        },
        pasteSpecialScope: this,
        messageType: this.initialConfig.pasteSpecialMessageType
      } );
      win.show();
    },
    getComponentsToPaste: function( handler, scope ) {
    	var handleCopiedComponentsFunction = this.initialConfig.handleCopiedComponentsFunction;

        if ( Ext.isFunction( handleCopiedComponentsFunction ) ) {
            var handleCopiedComponentsScope = !Ext.isEmpty( this.initialConfig.handleCopiedComponentsScope ) ?
            		this.initialConfig.handleCopiedComponentsScope : window;
            handleCopiedComponentsFunction.apply( handleCopiedComponentsScope, [ handler, scope ] );
        }
    },
    showParametersWindow: function( componentDef, generatedId, edition, templateId, templateComponentId, eventName, eventOwnerId, eventParentId ) {
    	  var extraConfig = this.extraConfigsMap.get( generatedId );
        var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
            title: this.initialConfig.parametersWindowTitlePrefix + ': ' + componentDef.name,
            component: componentDef,
            customDescription: !Ext.isEmpty( extraConfig ) ? extraConfig.customDescription : null,
            creationDate: !Ext.isEmpty( extraConfig ) ? extraConfig.creationDate : null,
            modificationDate: !Ext.isEmpty( extraConfig ) ? extraConfig.modificationDate : null,
            condition: this.conditionMap.get( generatedId ),
            confirmation: !Ext.isEmpty( extraConfig ) ? extraConfig.confirmation : null,
            error: !Ext.isEmpty( extraConfig ) ? extraConfig.error : null,
            errorHandling: !Ext.isEmpty( extraConfig ) ? extraConfig.errorHandling : null,
            inactive: !Ext.isEmpty( extraConfig ) ? extraConfig.inactive : false,
            parameters: this.parametersMap.get( generatedId ),
            processNode: this.initialConfig.processNode,
            conditionalExecutionEnabled: this.initialConfig.conditionalExecutionEnabled,
            inactiveEnabled: this.initialConfig.inactiveEnabled,
            eventTypesEnabled: !Ext.isEmpty( this.initialConfig.eventTypes ),
            bindTo: this.getBindTo( componentDef ),
            destinationType: this.initialConfig.destinationType,
            acceptButton: this.initialConfig.acceptButton,
            tableId: this.initialConfig.tableId,
            buttonId: this.initialConfig.buttonId,
            availableVariables: this.initialConfig.availableVariables,
            additionalContextVariables: this.getAdditionalContextVariables( eventName, eventParentId ),
            missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
            systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
            validateFieldFunction: this.initialConfig.validateFieldFunction,
            validateFieldScope: this.initialConfig.validateFieldScope,
            saveFunction: function( condition, values, extraConfig ) {
              if ( !edition ) {
                var store = this.getStore();
                var v = store.recordType;
                var eventGroupField = this.buildEventGroupField( eventName, eventParentId );
                var rec = new v( {
                  generatedId: generatedId,
                  componentId: componentDef.id,
                  templateComponentId: this.getTemplateComponentId(),
                  name: componentDef.name,
                  description: this.buildDescription( componentDef.description, extraConfig.customDescription ),
                  setParams: componentDef.parameters.length > 0 ? true : false,
                  inactive: extraConfig.inactive,
                  creationDate: extraConfig.creationDate,
                  modificationDate: extraConfig.modificationDate,
                  eventName: eventName,
                  eventOwnerId: eventOwnerId,
                  eventParentId: eventParentId,
                  eventGroupField: eventGroupField,
                  eventRow: false
                } );

                if ( this.initialConfig.eventMode ) {
                  var insertIndex = store.findBy( function ( record, id ) {
                    return record.get( 'eventGroupField' ) === eventGroupField && record.get( 'eventRow' ) === true;
                  } );
                  store.insert( insertIndex, rec );
                } else {
                  store.add( rec );
                }

                store.commitChanges();
              } else {
                if ( this.initialConfig.templateMode && !Ext.isEmpty( templateId ) ) {
                  this.updateTemplateComponent( templateId, templateComponentId, componentDef.id, condition, values, extraConfig );
                }

                var store = this.getStore();
                var index = store.find( 'generatedId', generatedId );

                if ( index != -1 ) {
                  var rec = store.getAt( index );
                  rec.set( 'description', this.buildDescription( componentDef.description, extraConfig.customDescription ) );
                  rec.set( 'inactive', extraConfig.inactive );
                  rec.set( 'modificationDate', extraConfig.modificationDate );
                  rec.set( 'setParams', hasAnyProperty( values ) );
                  rec.commit();
                }
              }

              var conditionMap = this.conditionMap;
              conditionMap.put( generatedId, condition );
              var parametersMap = this.parametersMap;
              parametersMap.put( generatedId, values );
              var extraConfigsMap = this.extraConfigsMap;
              extraConfigsMap.put( generatedId, extraConfig );

              var globalDefinition = this.initialConfig.globalDefinition;
              var globalId = rec.get( 'globalId' );

              if ( !globalDefinition && !Ext.isEmpty( globalId ) ) {
                var modifyGlobalDefinitionFunction = this.initialConfig.modifyGlobalDefinitionFunction;

                if ( Ext.isFunction( modifyGlobalDefinitionFunction ) ) {
                  var modifyGlobalDefinitionScope = !Ext.isEmpty( this.initialConfig.modifyGlobalDefinitionScope )
                      ? this.initialConfig.modifyGlobalDefinitionScope : window;
                  modifyGlobalDefinitionFunction.apply( modifyGlobalDefinitionScope, [ globalId, condition, values, extraConfig ] );
                }
              }

              this.refreshView();
              this.storeParentWindowAsUnsaved();
            },
            saveScope: this,
            getComponentRegistrationFunction: this.initialConfig.getComponentRegistrationFunction,
            getComponentRegistrationScope: this.initialConfig.getComponentRegistrationScope,
            eventTypeAddedFunction: this.isEventTypeAdded,
            eventTypeAddedScope: this,
            addEventTypeFunction: this.onAddEventType,
            addEventTypeScope: this,
            eventTypesTag: eventOwnerId
        } );
        win.show();
    },
    getBindTo: function( componentDef ) {
        var getBindToFunction = this.initialConfig.getBindToFunction;

        if ( Ext.isFunction( getBindToFunction ) ) {
            var getBindToScope = !Ext.isEmpty( this.initialConfig.getBindToScope ) ? this.initialConfig.getBindToScope : window;
            return getBindToFunction.apply( getBindToScope, [ componentDef ] );
        } else {
            return null;
        }
    },
    editBindToParameter: function() {
        var store = this.getStore();

        if ( store.getCount() > 0 ) {
            var allCategories = this.initialConfig.allCategories;
            var parametersMap = this.parametersMap;

            store.each( function( record ) {
                var componentId = record.get( 'componentId' );
                var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( allCategories, componentId );
                var bindTo = this.getBindTo( componentDef );

                if ( !Ext.isEmpty( bindTo ) && !Ext.isEmpty( bindTo.id ) ) {
                    var generatedId = record.get( 'generatedId' );
                    var parameters = parametersMap.get( generatedId );

                    Ext.iterate( parameters, function( id, value, object ) {
                        if ( id == bindTo.id ) {
                            value.value = bindTo.value;
                        }
                    } );

                    parametersMap.put( generatedId, parameters );
                }
            }, this );
        }
    },
    getAdditionalContextVariables: function( eventName, eventParentId ) {
        if ( this.initialConfig.eventMode ) {
          var eventType = null;

          // if there is a parent-event, read event properties from the definition
          if(eventParentId != null) {
            const store = this.getStore();
            const parentEventAction = store.getAt(store.findExact('eventOwnerId', eventParentId));

            const eventActionSpec = Ext.getCmp("main_panel").getEventAction(parentEventAction.get("componentId"));
            const event = eventActionSpec.events.find((event) => event.name === eventName);

            return event?.properties;
          }

          Ext.each( this.initialConfig.eventTypes, function( ev, index, all ) {
            if ( ev.name == eventName ) {
              eventType = ev;
              return false;
            }
          } );

          if ( !Ext.isEmpty( eventType ) ) {
            return eventType.properties;
          }
        }

        return new Array();
    },
    getTemplateComponentId: function() {
    	var generateTemplateComponentIdFunction = this.initialConfig.generateTemplateComponentIdFunction;

        if ( Ext.isFunction( generateTemplateComponentIdFunction ) ) {
            var generateTemplateComponentIdScope = !Ext.isEmpty( this.initialConfig.generateTemplateComponentIdScope ) ?
            		this.initialConfig.generateTemplateComponentIdScope : window;
            return generateTemplateComponentIdFunction.apply( generateTemplateComponentIdScope, [] );
        } else {
            return null;
        }
    },
    updateTemplateComponent: function( templateId, templateComponentId, componentId, condition, values, extraConfig ) {
    	var func = this.initialConfig.updateTemplateComponentFunction;
		
      if ( Ext.isFunction( func ) ) {
        var scope = !Ext.isEmpty( this.initialConfig.updateTemplateComponentScope ) ?
            this.initialConfig.updateTemplateComponentScope : window;
        func.apply( scope, [ templateId, templateComponentId, componentId, condition, values, extraConfig ] );
      }
    },
    getTableRowClass: function( record, index, rowParams, store ) {
      if ( record.get( 'eventRow' ) === true ) {
        return 'x-Module-integrationComponentTableEventRow';
      }

      var grid = this.grid;
      var validateRowFunction = grid.initialConfig.validateRowFunction;

      if ( Ext.isFunction( validateRowFunction ) ) {
        var component = grid.readComponent( record );

        if ( !component.inactive ) {
          var validateRowScope = !Ext.isEmpty( grid.initialConfig.validateRowScope ) ?
              grid.initialConfig.validateRowScope : window;
          var valid = validateRowFunction.apply( validateRowScope, [ component ] );

          if ( !valid ) {
            return 'x-Module-errorRow';
          }
        }
      }

      return '';
    },
    removeAllComponents: function() {
      var store = this.getStore();
      store.removeAll();
      store.commitChanges();
    },
    refreshView: function() {
      this.getView().refresh();
    },
    readComponents: function() {
        var components = new Array();
        var store = this.getStore();

        if ( store.getCount() > 0 ) {
            var globalDefinition = this.initialConfig.globalDefinition;

            for ( var i = 0; i < store.getCount(); i++ ) {
            	var record = store.getAt( i );

            	if ( ( !this.initialConfig.templateMode || Ext.isEmpty( record.get( 'templateId' ) ) )
                && ( !this.initialConfig.eventMode || record.get( 'eventRow' ) !== true ) ) {
            	    var component = this.readComponent( record );

            	    if ( globalDefinition ) {
                    component = Ext.apply( component, {
                      globalId: generateGlobalId()
                    } );
                  } else if ( !Ext.isEmpty( record.get( 'globalId' ) ) ) {
                    component = Ext.apply( component, {
                      globalId: record.get( 'globalId' )
                    } );
                  }

	                components.push( component );
            	}
            }
        }

        return components;
    },
    readComponent: function( record ) {
    	  var generatedId = record.get( 'generatedId' );
        var parameters = new Object();
        var extraConfig = this.extraConfigsMap.get( generatedId );

        if ( record.get( 'setParams' ) ) {
            var definedParams = this.parametersMap.get( generatedId );
            parameters = Ext.apply( parameters, definedParams );
        }

        return {
            id: record.get( 'componentId' ),
            templateComponentId: record.get( 'templateComponentId' ),
            eventName: this.initialConfig.eventMode ? record.get( 'eventName' ) : null,
            eventOwnerId: this.initialConfig.eventMode ? record.get( 'eventOwnerId' ) : null,
            eventParentId: this.initialConfig.eventMode ? record.get( 'eventParentId' ) : null,
            customDescription: !Ext.isEmpty( extraConfig ) ? extraConfig.customDescription : null,
            creationDate: !Ext.isEmpty( extraConfig ) ? extraConfig.creationDate : null,
            modificationDate: !Ext.isEmpty( extraConfig ) ? extraConfig.modificationDate : null,
            condition: this.conditionMap.get( generatedId ),
            confirmation: !Ext.isEmpty( extraConfig ) ? extraConfig.confirmation : null,
            error: !Ext.isEmpty( extraConfig ) ? extraConfig.error : null,
            errorHandling: !Ext.isEmpty( extraConfig ) ? extraConfig.errorHandling : null,
            inactive: !Ext.isEmpty( extraConfig ) ? extraConfig.inactive : false,
            parameters: parameters
        };
    }
} );