Ext.ux.suncode.VariableSetFontGlobalSettingsWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.4;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: getTranslation( 'Ustawienia globalne czcionki w tabeli dynamicznej' ),
        items: [ new Ext.ux.suncode.VariableSetFontGlobalSettingsPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.VariableSetFontGlobalSettingsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableSetFontGlobalSettingsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.VariableSetFontGlobalSettingsWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.VariableSetFontGlobalSettingsPanel = function( config ) {
	var processNode = config.processNode;
	var globalSettings = processNode.attributes.globalSettings.variableSetFont;
	
    config = Ext.apply( {
    	layout: 'form',
        labelWidth: 200,
        autoHeight: true,
        border: false,
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        buttonAlign: 'center',
        items: [ {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'headerFontSizeItem',
            fieldLabel: getTranslation( 'Rozmiar czcionki nagłówka' ),
            items: [ {
            	xtype: 'numberfield',
            	flex: 1,
            	allowDecimals: false,
            	allowNegative: false,
              emptyText: getTranslation( 'Domyślny' ),
                value: globalSettings.headerFontSize
            }, {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setHeaderFontSize( true );
                },
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'cellFontSizeItem',
            fieldLabel: getTranslation( 'Rozmiar czcionki komórki' ),
            items: [ {
            	xtype: 'numberfield',
            	flex: 1,
            	allowDecimals: false,
            	allowNegative: false,
              emptyText: getTranslation( 'Domyślny' ),
                value: globalSettings.cellFontSize
            }, {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setCellFontSize( true );
                },
                scope: this
            } ]
        } ],
        buttons: [ {
        	cls: 'x-btn-text',
            text: getTranslation( 'Ustaw wszystkie' ),
            handler: this.setAll,
            scope: this
        }, {
        	cls: 'x-btn-text',
            text: getTranslation( 'Przywróć domyślne' ),
            handler: this.restoreDefaults,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.VariableSetFontGlobalSettingsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableSetFontGlobalSettingsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.VariableSetFontGlobalSettingsPanel.superclass.initComponent.call( this );
    },
    setHeaderFontSize: function( showMsg ) {
    	var field = this.headerFontSizeItem.items.first();
    	var value = field.getValue();
      value = !Ext.isEmpty( value ) ? value : null;
    	
    	this.setSetting( 'headerFontSize', value, showMsg );
    },
    setCellFontSize: function( showMsg ) {
    	var field = this.cellFontSizeItem.items.first();
    	var value = field.getValue();
      value = !Ext.isEmpty( value ) ? value : null;
    	
    	this.setSetting( 'cellFontSize', value, showMsg );
    },
    setSetting: function( settingName, settingValue, showMsg ) {
    	var processNode = this.initialConfig.processNode;
    	var globalSettings = processNode.attributes.globalSettings.variableSetFont;

      globalSettings[settingName] = settingValue;
    	
    	processNode.eachChild( function( activityNode ) {
    		var template = activityNode.attributes.form.template;
            
    		if ( !Ext.isEmpty( template.rows ) ) {
    			Ext.each( template.rows, function( row, outerIndex, rows ) {
    				Ext.each( row.items, function( item, innerIndex, items ) {
    					if ( Ext.isDefined( item[settingName] ) ) {
    						item[settingName] = settingValue;
    					}
        			} );
    			} );
    	    }
        } );
    	
    	if ( showMsg ) {
    		Ext.getCmp( 'main_panel' ).setSaved( false );
    		this.showSuccessMessage( getTranslation( 'Zmieniono ustawienie.' ) );
    	}
    },
    setAll: function() {
    	this.setHeaderFontSize( false );
    	this.setCellFontSize( false );
    	Ext.getCmp( 'main_panel' ).setSaved( false );
    	this.showSuccessMessage( getTranslation( 'Zmieniono ustawienia.' ) );
    },
    showSuccessMessage: function( msg ) {
    	Ext.Msg.show( {
            title: getTranslation( 'Zmiana zakończona sukcesem' ),
            msg: msg,
            buttons: Ext.Msg.OK,
            icon: Ext.Msg.INFO
        } );
    },
    restoreDefaults: function() {
    	var defaults = Ext.ux.suncode.GlobalSettingsService.getVariableSetFontDefaults();
    	this.headerFontSizeItem.items.first().setValue( defaults.headerFontSize );
    	this.cellFontSizeItem.items.first().setValue( defaults.cellFontSize );
    }
} );