Ext.ux.suncode.LabelGlobalSettingsWindow = function( config ) {
  var windowWidth = Ext.getBody().getViewSize().width * 0.4;

  config = Ext.apply( {
    modal: true,
    width: windowWidth,
    title: getTranslation( 'Ustawienia globalne etykiety' ),
    items: [ new Ext.ux.suncode.LabelGlobalSettingsPanel( config ) ],
    closable: true,
    tbar: new Ext.Toolbar( {
      buttons: [ {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this
      } ]
    } )
  }, config );

  Ext.ux.suncode.LabelGlobalSettingsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.LabelGlobalSettingsWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.LabelGlobalSettingsWindow.superclass.initComponent.call( this );
  },
  closeWindow: function() {
    this.close();
  }
} );

Ext.ux.suncode.LabelGlobalSettingsPanel = function( config ) {
  var processNode = config.processNode;
  var globalSettings = processNode.attributes.globalSettings.label;

  config = Ext.apply( {
    layout: 'form',
    labelWidth: 200,
    autoHeight: true,
    border: false,
    frame: false,
    bodyCssClass: 'x-Module-container-padding',
    buttonAlign: 'center',
    items: [ {
      xtype: 'compositefield',
      anchor: '100%',
      ref: 'fontSizeItem',
      fieldLabel: getTranslation( 'Rozmiar czcionki' ),
      items: [ {
        xtype: 'numberfield',
        flex: 1,
        allowDecimals: false,
        allowNegative: false,
        emptyText: getTranslation( 'Domyślny' ),
        value: globalSettings.fontSize
      }, {
        xtype: 'button',
        cls: 'x-btn-text',
        text: getTranslation( 'Ustaw' ),
        flex: 0,
        handler: function() {
          this.setFontSize( true );
        },
        scope: this
      } ]
    }, {
      xtype: 'compositefield',
      anchor: '100%',
      ref: 'colorItem',
      fieldLabel: getTranslation( 'Kolor' ),
      items: [ {
        xtype: 'textfield',
        emptyText: getTranslation( 'Domyślny' ),
        flex: 1,
        style: 'background: ' + globalSettings.color + ';',
        color: globalSettings.color,
        readOnly: true,
        value: !Ext.isEmpty( globalSettings.color ) ? ' ' : ''
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'color_wheel' ),
        tooltip: getTranslation( 'Wybierz kolor' ),
        flex: 0,
        handler: this.chooseColor,
        scope: this
      }, {
        xtype: 'button',
        cls: 'x-btn-text',
        text: getTranslation( 'Ustaw' ),
        flex: 0,
        handler: function() {
          this.setColor( true );
        },
        scope: this
      } ]
    } ],
    buttons: [ {
      cls: 'x-btn-text',
      text: getTranslation( 'Ustaw wszystkie' ),
      handler: this.setAll,
      scope: this
    }, {
      cls: 'x-btn-text',
      text: getTranslation( 'Przywróć domyślne' ),
      handler: this.restoreDefaults,
      scope: this
    } ]
  }, config );

  Ext.ux.suncode.LabelGlobalSettingsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.LabelGlobalSettingsPanel, Ext.Panel, {
  initComponent: function() {
    Ext.ux.suncode.LabelGlobalSettingsPanel.superclass.initComponent.call( this );
  },
  setFontSize: function( showMsg ) {
    var field = this.fontSizeItem.items.first();
    var value = field.getValue();
    value = !Ext.isEmpty( value ) ? value : null;

    this.setSetting( 'fontSize', value, showMsg );
  },
  chooseColor: function( button, e ) {
    closeColorChooser();

    var me = this;
    var colorField = this.colorItem.items.first();
    var colorChooser = new Ext.ux.suncode.ColorChooser( {
      title: getTranslation( 'Kolor etykiety' ),
      e: e,
      color: colorField.color,
      saveFunction: function( choosenColor ) {
        colorField.getEl().setStyle( 'background', choosenColor );
        colorField.color = choosenColor;
        colorField.setValue(' ');
        me.storeParentWindowAsUnsaved();
      }
    } );
    colorChooser.show();
  },
  setColor: function( showMsg ) {
    var field = this.colorItem.items.first();
    var value = field.color;

    this.setSetting( 'color', value, showMsg );
  },
  setSetting: function( settingName, settingValue, showMsg ) {
    var processNode = this.initialConfig.processNode;
    var globalSettings = processNode.attributes.globalSettings.label;

    globalSettings[settingName] = settingValue;

    processNode.eachChild( function( activityNode ) {
      var template = activityNode.attributes.form.template;

      if ( !Ext.isEmpty( template.rows ) ) {
        Ext.each( template.rows, function( row, outerIndex, rows ) {
          Ext.each( row.items, function( item, innerIndex, items ) {
            if ( item.type === 'LABEL' ) {
              item[settingName] = settingValue;
            }
          } );
        } );
      }
    } );

    if ( showMsg ) {
      Ext.getCmp( 'main_panel' ).setSaved( false );
      this.showSuccessMessage( getTranslation( 'Zmieniono ustawienie.' ) );
    }
  },
  setAll: function() {
    this.setFontSize( false );
    this.setColor( false );
    Ext.getCmp( 'main_panel' ).setSaved( false );
    this.showSuccessMessage( getTranslation( 'Zmieniono ustawienia.' ) );
  },
  showSuccessMessage: function( msg ) {
    Ext.Msg.show( {
      title: getTranslation( 'Zmiana zakończona sukcesem' ),
      msg: msg,
      buttons: Ext.Msg.OK,
      icon: Ext.Msg.INFO
    } );
  },
  restoreDefaults: function() {
    var defaults = Ext.ux.suncode.GlobalSettingsService.getLabelDefaults();
    this.fontSizeItem.items.first().setValue( defaults.fontSize );
    this.colorItem.items.first().getEl().setStyle( 'background', defaults.color );
    this.colorItem.items.first().color = defaults.color;
  }
} );