Ext.ux.suncode.ScheduledTaskSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var scheduledTask = config.scheduledTask;
    var winTitle = scheduledTask ? getTranslation( 'Definicja zadania zaplanowanego' ) + ' ' + scheduledTask.name
                    : getTranslation( 'Kreator zadania zaplanowanego' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ScheduledTaskSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ScheduledTaskSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ScheduledTaskSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ScheduledTaskSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.scheduledTaskSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ScheduledTaskSpecificationPanel = function( config ) {
    var scheduledTask = config.scheduledTask;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();

    config = Ext.apply( {
        labelWidth: 250,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'scheduledTaskSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, {
            xtype: 'textfield',
            name: 'className',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa klasy' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            maskRe: /[a-zA-Z0-9._$]/
        }, {
            xtype: 'textfield',
            name: 'methodName',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa metody' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            maskRe: /[a-zA-Z0-9_$]/
        }, {
            xtype: 'numberfield',
            name: 'executionFrequencyValue',
            anchor: '100%',
            fieldLabel: getTranslation( 'Częstotliwość wykonania (wartość)' ),
            allowDecimals: false,
            allowNegative: false,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, new Ext.ux.suncode.ScheduledTaskExecutionFrequencyUnitsChooser(), {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            style: {
                marginBottom: '5px'
            },
            bodyStyle: {
                border: 0
            },
            items: [ new Ext.ux.suncode.ParameterSpecificationsPanel( {
                title: getTranslation( 'Parametry wejściowe' ),
                ref: '../inputParametersPanel',
                parameters: scheduledTask ? scheduledTask.inputParameters : []
            } ) ]
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis algorytmu' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'algorithmDescription',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ScheduledTaskSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ScheduledTaskSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ScheduledTaskSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var scheduledTask = this.initialConfig.scheduledTask;

        if ( !Ext.isEmpty( scheduledTask ) ) {
            this.getForm().setValues( scheduledTask );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var scheduledTask = panel.scheduledTask;

        if ( !Ext.isEmpty( scheduledTask ) && scheduledTask.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getScheduledTask( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Zadanie zaplanowane już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() && this.inputParametersPanel.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var scheduledTask = this.initialConfig.scheduledTask;
            var def = form.getValues();
            def = Ext.apply( {
                inputParameters: this.inputParametersPanel.readParameters()
            }, def );

            if ( saveToObj && varRecord ) {
                if ( scheduledTask ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'className', def.className );
                    varRecord.set( 'methodName', def.methodName );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        className: def.className,
                        methodName: def.methodName
                    } ) );
                    store.commitChanges();
                }
            }

            if ( scheduledTask ) {
                Ext.ux.suncode.DocumentationService.editScheduledTask( processNode, scheduledTask.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addScheduledTask( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );

Ext.ux.suncode.ScheduledTaskExecutionFrequencyUnitsChooser = function() {
    var config = new Object();
    var units = [ [ 'seconds', getTranslation( 'sekundy' ) ], [ 'minutes', getTranslation( 'minuty' ) ], [ 'hours', getTranslation( 'godziny' ) ],
                    [ 'days', getTranslation( 'dni' ) ], [ 'months', getTranslation( 'miesiące (30 dni)' ) ] ];

    config = Ext.apply( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Częstotliwość wykonania (jednostka)' ),
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'unit', 'unitName' ],
            data: units
        } ),
        hiddenName: 'executionFrequencyUnit',
        valueField: 'unit',
        displayField: 'unitName',
        forceSelection: true,
        resizable: true,
        allowBlank: false,
        blankText: getTranslation( 'Pole jest wymagane' ),
        editable: false
    }, config );

    Ext.ux.suncode.ScheduledTaskExecutionFrequencyUnitsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ScheduledTaskExecutionFrequencyUnitsChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ScheduledTaskExecutionFrequencyUnitsChooser.superclass.initComponent.call( this );
    }
} );