/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.simulationconfig.builder;

import com.suncode.plugin.pwe.model.simulationconfig.SimulationConfig;
import com.suncode.plugin.pwe.web.support.dto.simulationconfig.SimulationConfigDto;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SimulationConfigDtoBuilder {
    private static final String DEFAULT_COLOR = "#f99b0c";
    private static final double DEFAULT_SPEED = 0.3;
    private static final int DEFAULT_FORM_DISPLAY_TIME = 6;

    public SimulationConfigDto build(SimulationConfig config) {
        SimulationConfigDto dto = new SimulationConfigDto();
        dto.setAnimationsOn(BooleanUtils.isTrue((Boolean)config.getAnimationsOn()));
        dto.setDistinctionColor(this.resolveColor(config.getDistinctionColor()));
        dto.setFitMap(BooleanUtils.isTrue((Boolean)config.getFitMap()));
        dto.setFormDisplayTimeValue(config.getFormDisplayTime());
        dto.setShowForms(BooleanUtils.isTrue((Boolean)config.getShowForms()));
        dto.setShowSummary(BooleanUtils.isTrue((Boolean)config.getShowSummary()));
        dto.setSpeedValue(config.getSpeed());
        return dto;
    }

    private String resolveColor(String color) {
        if (StringUtils.isNotBlank((CharSequence)color)) {
            return color;
        }
        return DEFAULT_COLOR;
    }

    public SimulationConfigDto build() {
        SimulationConfigDto dto = new SimulationConfigDto();
        dto.setDistinctionColor(DEFAULT_COLOR);
        dto.setFormDisplayTimeValue(DEFAULT_FORM_DISPLAY_TIME);
        dto.setSpeedValue(DEFAULT_SPEED);
        return dto;
    }

    public SimulationConfig extract(String userId, SimulationConfigDto dto) {
        SimulationConfig config = new SimulationConfig();
        config.setAnimationsOn(dto.getAnimationsOn());
        config.setDistinctionColor(dto.getDistinctionColor());
        config.setFitMap(dto.getFitMap());
        config.setFormDisplayTime(dto.getFormDisplayTimeValue());
        config.setShowForms(dto.getShowForms());
        config.setShowSummary(dto.getShowSummary());
        config.setSpeed(dto.getSpeedValue());
        config.setUserId(userId);
        return config;
    }
}

