/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.jscode.builder;

import com.plusmpm.util.CoreTools;
import com.suncode.plugin.pwe.model.jscode.JsCode;
import com.suncode.plugin.pwe.web.support.dto.jscode.JsCodeDto;
import org.springframework.stereotype.Component;

@Component
public class JsCodeDtoBuilder {
    public JsCodeDto build(JsCode jsCode) {
        JsCodeDto dto = new JsCodeDto();
        dto.setFunctionName(jsCode.getFunctionName());
        dto.setCodeAuthor(jsCode.getCodeAuthor());
        dto.setSourceCode(jsCode.getSourceCode());
        dto.setAvailableInSystem(true);
        return dto;
    }

    public JsCodeDto build(String userId, String functionName, String sourceCode) {
        JsCodeDto dto = new JsCodeDto();
        dto.setFunctionName(functionName);
        dto.setCodeAuthor(this.buildCodeAuthor(userId));
        dto.setSourceCode(sourceCode);
        dto.setAvailableInSystem(false);
        return dto;
    }

    private String buildCodeAuthor(String userId) {
        return CoreTools.GetRealUserName((String)userId);
    }

    public JsCode extract(JsCodeDto dto) {
        JsCode jsCode = this.extractBase(dto);
        jsCode.setCodeAuthor(dto.getCodeAuthor());
        return jsCode;
    }

    public JsCode extract(String userId, JsCodeDto dto) {
        JsCode jsCode = this.extractBase(dto);
        jsCode.setCodeAuthor(this.buildCodeAuthor(userId));
        return jsCode;
    }

    private JsCode extractBase(JsCodeDto dto) {
        JsCode jsCode = new JsCode();
        jsCode.setFunctionName(dto.getFunctionName());
        jsCode.setSourceCode(dto.getSourceCode());
        return jsCode;
    }
}

