/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.zip;

import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeDto;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ZipService {
    public void addToZip(ZipOutputStream outputStream, String fileName, byte[] bytes) throws IOException {
        outputStream.setLevel(6);
        outputStream.putNextEntry(this.buildEntry(fileName, bytes));
        outputStream.write(bytes);
        outputStream.closeEntry();
    }

    private ZipEntry buildEntry(String fileName, byte[] bytes) {
        ZipEntry entry = new ZipEntry(fileName);
        entry.setSize(ArrayUtils.getLength((Object)bytes));
        entry.setCrc(this.buildCrcValue(bytes));
        entry.setTime(System.currentTimeMillis());
        return entry;
    }

    private long buildCrcValue(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(bytes);
        return crc.getValue();
    }

    public void addToZip(ZipOutputStream outputStream, List<JavaCodeDto> dtos) throws IOException {
        if (CollectionUtils.isNotEmpty(dtos)) {
            for (JavaCodeDto dto : dtos) {
                byte[] sourceCodeBytes = dto.getSourceCode().getBytes(Charset.forName("UTF-8"));
                this.addToZip(outputStream, this.buildFileName(dto), sourceCodeBytes);
            }
        }
    }

    private String buildFileName(JavaCodeDto dto) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(StringUtils.replace((String)dto.getQualifiedName(), (String)".", (String)File.separator));
        fileName.append(".java");
        return fileName.toString();
    }
}

