/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.variablessetter;

import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.util.ClasspathScanner;
import com.suncode.plugin.pwe.web.support.dto.variablessetter.VariablesSetterDefinitionDto;
import com.suncode.plugin.pwe.web.support.dto.variablessetter.builder.VariablesSetterDefinitionDtoBuilder;
import com.suncode.pwfl.form.acceptance.VariablesSetter;
import com.suncode.pwfl.form.stereotype.Setter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class VariablesSetterService {
    public static Logger log = Logger.getLogger(VariablesSetterService.class);
    private static final Class<? extends Annotation> VARIABLES_SETTER_ANNOTATION = Setter.class;
    private static final Class<?> VARIABLES_SETTER_INTERFACE = VariablesSetter.class;
    @Autowired
    private VariablesSetterDefinitionDtoBuilder variablesSetterDefinitionDtoBuilder;

    public List<VariablesSetterDefinitionDto> findAll() {
        ArrayList<VariablesSetterDefinitionDto> dtos = new ArrayList<VariablesSetterDefinitionDto>();
        List clazzes = ClasspathScanner.getAllClassesWithAnnotationAndInterface(VARIABLES_SETTER_ANNOTATION, VARIABLES_SETTER_INTERFACE);
        if (CollectionUtils.isNotEmpty((Collection)clazzes)) {
            I18NCustom i18n = new I18NCustom(LocaleContextHolder.getLocale());
            for (Class clazz : clazzes) {
                try {
                    Setter setter = (Setter)clazz.getAnnotation(VARIABLES_SETTER_ANNOTATION);
                    VariablesSetterDefinitionDto dto = this.variablesSetterDefinitionDtoBuilder.build(clazz.getName(), setter, i18n);
                    dtos.add(dto);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return dtos;
    }
}

