/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.enumeration.DtConfType;
import com.suncode.plugin.pwe.documentation.object.VariableSet;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.util.VariableSetConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.stereotype.Component;

@Component
public class VariableSetBuilder {
    private static final String DT_HIDDEN_EXT_ATTR_NAME = "DT_HIDDEN";
    private static final String DT_HIDDEN_EXT_ATTR_VALUE = "TRUE";
    private static final String DT_CONF_PREFIX = "DT_CONF_";
    private static final String CONNECTOR = "_";
    private static final String DT_HIDDEN_DT_CONF = "DT_HIDDEN";
    private static final String READONLY_DT_CONF = "READONLY";
    private static final String COLUMNS_JOINER = ";";

    public VariableSet buildToView(WorkflowProcess process, String extAttrValue) {
        VariableSet variableSet = this.buildBase(process, extAttrValue);
        return variableSet;
    }

    public VariableSet buildToUpdate(WorkflowProcess process, String extAttrValue) {
        VariableSet variableSet = this.buildBase(process, extAttrValue);
        variableSet.setEditable(true);
        return variableSet;
    }

    public VariableSet buildBase(WorkflowProcess process, String extAttrValue) {
        VariableSet variableSet = new VariableSet();
        variableSet.setId("");
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        ArrayList<String> readOnlyColumns = new ArrayList<String>();
        block10: for (String oneExtAttrValue : extAttrValue.split("\n")) {
            String[] configs = oneExtAttrValue.split("=");
            String configName = configs[0];
            switch (VariableSetConfig.getByName(configName)) {
                case DT_TABLE_ID: {
                    variableSet.setId(configs[1]);
                    continue block10;
                }
                case DT_TABLE_NAME: {
                    variableSet.setTitle(configs[1]);
                    continue block10;
                }
                case COLUMN: {
                    columns.add(configName);
                    if (!this.isDtHidden(process, configName)) continue block10;
                    hiddenColumns.add(configName);
                    continue block10;
                }
                case DT_CONF: {
                    String dtConfVariableId = this.buildDtConfVariableId(configName);
                    DtConfType dtConfType = this.buildDtConfType(configName, dtConfVariableId);
                    switch (dtConfType) {
                        case DT_HIDDEN: {
                            hiddenColumns.add(dtConfVariableId);
                            continue block10;
                        }
                        case READONLY: {
                            readOnlyColumns.add(dtConfVariableId);
                            continue block10;
                        }
                    }
                    continue block10;
                }
            }
        }
        variableSet.setColumnsId(this.buildColumnsId(columns));
        variableSet.setColumns(columns);
        variableSet.setHiddenColumns(hiddenColumns);
        variableSet.setReadOnlyColumns(readOnlyColumns);
        return variableSet;
    }

    private boolean isDtHidden(WorkflowProcess process, String column) {
        return Optional.ofNullable(process.getDataField(column)).map(d -> ExtAttrUtils.hasExtAttr(d.getExtendedAttributes(), "DT_HIDDEN", DT_HIDDEN_EXT_ATTR_VALUE)).orElse(false);
    }

    private String buildDtConfVariableId(String configName) {
        String variableIdWithDtConfType = configName.substring(DT_CONF_PREFIX.length());
        if (variableIdWithDtConfType.endsWith("_DT_HIDDEN")) {
            return this.separateDtConfVariableId(variableIdWithDtConfType, "DT_HIDDEN");
        }
        if (variableIdWithDtConfType.endsWith("_READONLY")) {
            return this.separateDtConfVariableId(variableIdWithDtConfType, READONLY_DT_CONF);
        }
        return "";
    }

    private String separateDtConfVariableId(String variableIdWithDtConfType, String dtConfType) {
        return variableIdWithDtConfType.substring(0, variableIdWithDtConfType.indexOf(CONNECTOR + dtConfType));
    }

    private DtConfType buildDtConfType(String configName, String variableId) {
        if (StringUtils.isBlank((String)variableId)) {
            return DtConfType.UNSUPPORTED;
        }
        String variableIdWithPostfix = variableId + CONNECTOR;
        return DtConfType.getDtConfType(configName.substring(configName.indexOf(variableIdWithPostfix) + variableIdWithPostfix.length()));
    }

    private String buildColumnsId(List<String> columns) {
        Collections.sort(columns, String.CASE_INSENSITIVE_ORDER);
        return StringUtils.join(columns, (String)COLUMNS_JOINER);
    }
}

