/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.enumeration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum DataChooserConfig {
    CLASS,
    TYPE,
    COMBOFORCESELECTION,
    COMBOFILTERINGDISABLED,
    COMBOLAZYINIT,
    COMBOQUERYDELAY,
    FORMCRITERIA,
    FIRST_MAPPING,
    MAPPING,
    COLUMNALIGN,
    CUSTOM_KEY;

    private static final Pattern PATTERN;
    private static final String FIRST_MAPPING_NAME = "mapping1";

    public static DataChooserConfig getByName(String name) {
        try {
            Matcher matcher = PATTERN.matcher(name);
            if (matcher.matches()) {
                if (DataChooserConfig.isFirstMapping(name)) {
                    return FIRST_MAPPING;
                }
                return MAPPING;
            }
            return DataChooserConfig.valueOf(name.toUpperCase());
        }
        catch (Exception exception) {
            return CUSTOM_KEY;
        }
    }

    private static boolean isFirstMapping(String name) {
        return StringUtils.equalsIgnoreCase((CharSequence)FIRST_MAPPING_NAME, (CharSequence)name);
    }

    static {
        PATTERN = Pattern.compile("mapping\\d+");
    }
}

