/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentsPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.VariableSetColumnsPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.VariableSetDtButtonsPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.object.VariableSet;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.FormVariableSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityVariableSetsPointBuilder")
public class ActivityVariableSetsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.variablesets";
    private static final String NO_TITLE = "pwe.documentation.text.notitle";
    private static final String DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.variablesetdescription";
    private static final String COLUMNS_POINT_TITLE = "pwe.documentation.point.title.columns";
    private static final String BUTTONS_POINT_TITLE = "pwe.documentation.point.title.buttons";
    private static final String FORM_ACTIONS_POINT_TITLE = "pwe.documentation.point.title.formactions";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private VariableSetColumnsPointBuilder variableSetColumnsPointBuilder;
    @Autowired
    private VariableSetDtButtonsPointBuilder variableSetDtButtonsPointBuilder;
    @Autowired
    private IntegrationComponentsPointBuilder<FormAction> formActionsIntegrationComponentsPointBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        this.buildTitle(documentation);
        documentation.removeLastObject();
        for (VariableSet variableSet : activityForm.getVariableSets()) {
            this.buildPoints(documentation, process, translationInfo, activity, activitySpecification, variableSet);
        }
    }

    private void buildTitle(Documentation documentation) {
        this.buildPoint(documentation);
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, VariableSet variableSet) {
        FormVariableSpecification formVariableSpecification = this.getFormVariableSpecification(activitySpecification, variableSet);
        this.buildTitlePoint(documentation, process, translationInfo, activity, variableSet);
        if (StringUtils.isNotBlank((CharSequence)formVariableSpecification.getDescription())) {
            this.buildDescriptionPoint(documentation, process, translationInfo, formVariableSpecification);
        }
        this.buildColumnsPoint(documentation, process, variableSet);
        if (CollectionUtils.isNotEmpty(variableSet.getDtButtons())) {
            this.buildDtButtonsPoint(documentation, process, translationInfo, activitySpecification, variableSet);
        }
        if (CollectionUtils.isNotEmpty(variableSet.getFormActions())) {
            this.buildFormActionsPoint(documentation, process, variableSet);
        }
        documentation.addNewLine();
    }

    private FormVariableSpecification getFormVariableSpecification(ActivitySpecification activitySpecification, VariableSet variableSet) {
        String id = variableSet.getId();
        if (MapUtils.isNotEmpty(activitySpecification.getFormVariableSpecifications()) && activitySpecification.getFormVariableSpecifications().containsKey(id)) {
            return activitySpecification.getFormVariableSpecifications().get(id);
        }
        return new FormVariableSpecification();
    }

    private void buildTitlePoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, VariableSet variableSet) {
        this.buildPoint(documentation, this.buildTitle(process, translationInfo, activity, variableSet));
    }

    private String buildTitle(WorkflowProcess process, TranslationInfo translationInfo, Activity activity, VariableSet variableSet) {
        String translatedTitle = this.translatorService.translateVariableSetTitle(translationInfo, process, activity, variableSet);
        return (String)StringUtils.defaultIfBlank((CharSequence)translatedTitle, (CharSequence)this.translatorService.translateMessage(NO_TITLE));
    }

    private void buildDescriptionPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, FormVariableSpecification formVariableSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, formVariableSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(3));
        this.buildPoint(documentation, DESCRIPTION_POINT_TITLE, contents);
    }

    private void buildColumnsPoint(Documentation documentation, WorkflowProcess process, VariableSet variableSet) {
        Table table = this.variableSetColumnsPointBuilder.build(process, variableSet);
        this.buildPoint(documentation, COLUMNS_POINT_TITLE, table.getHeaders(), table.getRecords());
    }

    private void buildDtButtonsPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, ActivitySpecification activitySpecification, VariableSet variableSet) {
        Table table = this.variableSetDtButtonsPointBuilder.build(process, translationInfo, activitySpecification, variableSet);
        this.buildPoint(documentation, BUTTONS_POINT_TITLE, table.getHeaders(), table.getRecords());
    }

    private void buildFormActionsPoint(Documentation documentation, WorkflowProcess process, VariableSet variableSet) {
        this.formActionsIntegrationComponentsPointBuilder.build(documentation, process, variableSet.getFormActions(), FORM_ACTIONS_POINT_TITLE, 3);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, TranslationInfo translationInfo, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, translationInfo, description);
    }

    private void buildPoint(Documentation documentation) {
        this.subchapterBuilder.build(documentation, POINT_TITLE);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.subchapterBuilder.build(documentation, title, 2);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, 3, contents);
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, titleKey, 3, headers, records);
    }
}

