/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.FormVariable;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.DescriptionSpecification;
import com.suncode.plugin.pwe.documentation.specification.FormVariableSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.documentation.util.VariableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityFormVariablesPointBuilder")
public class ActivityFormVariablesPointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.formvariables";
    private static final String NAME_TABLE_COLUMN_ID = "name";
    private static final String NAME_TABLE_HEADER = "pwe.documentation.table.header.name";
    private static final String READ_ONLY_TABLE_COLUMN_ID = "readonly";
    private static final String READ_ONLY_TABLE_HEADER = "pwe.documentation.table.header.readonly";
    private static final BigInteger READ_ONLY_TABLE_CELL_WIDTH = BigInteger.valueOf(2000L);
    private static final String REMARKS_TABLE_COLUMN_ID = "remarks";
    private static final String REMARKS_TABLE_HEADER = "pwe.documentation.table.header.remarks";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        List<DefinitionSpecificationPair> pairs = this.buildParis(activitySpecification, activityForm);
        boolean anyDescriptionPresent = this.isAnyDescriptionPresent(pairs);
        TableHeaders headers = this.buildTableHeaders(anyDescriptionPresent);
        TableRecords records = new TableRecords();
        for (DefinitionSpecificationPair pair : pairs) {
            records.add(this.buildTableRecord(process, translationInfo, pair, anyDescriptionPresent));
        }
        this.buildPoint(documentation, POINT_TITLE, headers, records);
    }

    private List<DefinitionSpecificationPair> buildParis(ActivitySpecification activitySpecification, ActivityForm activityForm) {
        return activityForm.getFormVariables().stream().map(formVariable -> new DefinitionSpecificationPair((FormVariable)formVariable, this.getFormVariableSpecification(activitySpecification, (FormVariable)formVariable))).collect(Collectors.toList());
    }

    private boolean isAnyDescriptionPresent(List<DefinitionSpecificationPair> pairs) {
        return pairs.stream().map(DefinitionSpecificationPair::getSpecification).map(DescriptionSpecification::getDescription).anyMatch(StringUtils::isNotBlank);
    }

    private TableHeaders buildTableHeaders(boolean anyDescriptionPresent) {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTableNameHeader());
        headers.add(this.buildTableReadOnlyHeader());
        if (anyDescriptionPresent) {
            headers.add(this.buildTableRemarksHeader());
        }
        return headers;
    }

    private TableHeader buildTableNameHeader() {
        return TableUtils.buildTableHeader(NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(NAME_TABLE_HEADER));
    }

    private TableHeader buildTableReadOnlyHeader() {
        TableHeader header = TableUtils.buildTableHeader(READ_ONLY_TABLE_COLUMN_ID, this.translatorService.translateMessage(READ_ONLY_TABLE_HEADER));
        header.setWidth(READ_ONLY_TABLE_CELL_WIDTH);
        return header;
    }

    private TableHeader buildTableRemarksHeader() {
        return TableUtils.buildTableHeader(REMARKS_TABLE_COLUMN_ID, this.translatorService.translateMessage(REMARKS_TABLE_HEADER));
    }

    private TableRecord buildTableRecord(WorkflowProcess process, TranslationInfo translationInfo, DefinitionSpecificationPair pair, boolean anyDescriptionPresent) {
        TableRecord record = new TableRecord();
        record.addCell(NAME_TABLE_COLUMN_ID, this.buildTableNameCell(process, translationInfo, pair.getDefinition()));
        record.addCell(READ_ONLY_TABLE_COLUMN_ID, this.buildTableReadOnlyCell(pair.getDefinition()));
        if (anyDescriptionPresent) {
            record.addCell(REMARKS_TABLE_COLUMN_ID, this.buildTableRemarksCell(process, translationInfo, pair.getSpecification()));
        }
        return record;
    }

    private TableCell buildTableNameCell(WorkflowProcess process, TranslationInfo translationInfo, FormVariable formVariable) {
        String name = VariableUtils.getName(process, formVariable.getId());
        String translatedName = this.translatorService.translateVariableName(translationInfo, process, formVariable.getId(), name);
        return TableUtils.buildTableCell(translatedName);
    }

    private TableCell buildTableReadOnlyCell(FormVariable formVariable) {
        String value = "";
        value = formVariable.isReadOnly() || !formVariable.isEditable() ? this.translatorService.translateMessage(YES) : this.translatorService.translateMessage(NO);
        return TableUtils.buildTableCell(value);
    }

    private TableCell buildTableRemarksCell(WorkflowProcess process, TranslationInfo translationInfo, FormVariableSpecification formVariableSpecification) {
        ParagraphContents paragraphContents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, formVariableSpecification.getDescription());
        return TableUtils.buildTableCell(paragraphContents);
    }

    private FormVariableSpecification getFormVariableSpecification(ActivitySpecification activitySpecification, FormVariable formVariable) {
        String id = formVariable.getId();
        if (MapUtils.isNotEmpty(activitySpecification.getFormVariableSpecifications()) && activitySpecification.getFormVariableSpecifications().containsKey(id)) {
            return activitySpecification.getFormVariableSpecifications().get(id);
        }
        return new FormVariableSpecification();
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, TranslationInfo translationInfo, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, translationInfo, description);
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, titleKey, headers, records);
    }

    private class DefinitionSpecificationPair {
        private final FormVariable definition;
        private final FormVariableSpecification specification;

        public FormVariable getDefinition() {
            return this.definition;
        }

        public FormVariableSpecification getSpecification() {
            return this.specification;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefinitionSpecificationPair)) {
                return false;
            }
            DefinitionSpecificationPair other = (DefinitionSpecificationPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FormVariable this$definition = this.getDefinition();
            FormVariable other$definition = other.getDefinition();
            if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
                return false;
            }
            FormVariableSpecification this$specification = this.getSpecification();
            FormVariableSpecification other$specification = other.getSpecification();
            return !(this$specification == null ? other$specification != null : !this$specification.equals(other$specification));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DefinitionSpecificationPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FormVariable $definition = this.getDefinition();
            result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
            FormVariableSpecification $specification = this.getSpecification();
            result = result * 59 + ($specification == null ? 43 : $specification.hashCode());
            return result;
        }

        public String toString() {
            return "ActivityFormVariablesPointBuilderImpl.DefinitionSpecificationPair(definition=" + String.valueOf(this.getDefinition()) + ", specification=" + String.valueOf(this.getSpecification()) + ")";
        }

        public DefinitionSpecificationPair(FormVariable definition, FormVariableSpecification specification) {
            this.definition = definition;
            this.specification = specification;
        }
    }
}

