Ext.ux.suncode.ExtraDataChooserConfigWindow = function( config ) {
    var activityNode = config.activityNode;
    var attrNode = config.attrNode;
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var variable = attrNode ? activityNode.parentNode.findVariable( attrNode.attributes.extraConfig.dataChooserId ) : null;
    var winTitle = variable ? getTranslation( 'Definicja konfiguracji' ) + ' ' + variable.name : getTranslation( 'Kreator konfiguracji' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: [ new Ext.ux.suncode.ExtraDataChooserConfigPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.ExtraDataChooserConfigWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ExtraDataChooserConfigWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ExtraDataChooserConfigWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.configDefPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ExtraDataChooserConfigPanel = function( config ) {
    var activityNode = config.activityNode;
    var attrNode = config.attrNode;
    var variables = activityNode.parentNode.attributes.variables;

    var attrsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'key',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    if ( attrNode ) {
        attrsStore.loadData( attrNode.attributes.extraConfig.attributes );
        attrsStore.commitChanges();
    }

    config = Ext.apply( {
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'configDefPanel',
        labelWidth: 120,
        items: [ new Ext.ux.suncode.AllVariablesChooser( {
            fieldLabel: getTranslation( 'Dynamiczna lista' ),
            ref: 'dataChooserIdItem',
            flex: 1,
            variables: variables,
            acceptedTypes: [ 'DATA_CHOOSER' ],
            startWith: attrNode ? attrNode.attributes.extraConfig.dataChooserId : ''
        } ), {
            xtype: 'editorgrid',
            height: 250,
            store: attrsStore,
            title: getTranslation( 'Atrybuty' ),
            ref: 'attrsGrid',
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            frame: false,
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                columns: [ {
                    id: 'key',
                    header: getTranslation( 'Nazwa' ),
                    dataIndex: 'key',
                    align: 'left',
                    editor: new Ext.form.TextField( {
                        inputType: 'text',
                        stripCharsRe: /=/g
                    } )
                }, {
                    id: 'value',
                    header: getTranslation( 'Wartość' ),
                    dataIndex: 'value',
                    align: 'left',
                    editor: new Ext.form.TextField( {
                        inputType: 'text'
                    } )
                } ]
            } ),
            viewConfig: new Ext.grid.GridView( {
                forceFit: true
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            key: '',
                            value: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                    }
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz atrybut do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                    }
                } ]
            } ),
            listeners: {
                validateedit: function( e ) {
                    var grid = e.grid;
                    var store = grid.getStore();
                    var cm = grid.getColumnModel();
                    var colIndex = e.column;
                    var value = e.value;

                    if ( cm.getColumnId( colIndex ) == 'key' && store.findExact( 'key', value ) != -1 ) {
                        showWarn( getTranslation( 'Atrybut został już dodany.' ) );
                        return false;
                    }
                },
                afteredit: function( e ) {
                    e.record.commit();
                }
            }
        } ]
    }, config );

    Ext.ux.suncode.ExtraDataChooserConfigPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ExtraDataChooserConfigPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ExtraDataChooserConfigPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var activityNode = this.initialConfig.activityNode;
        var treePanel = this.initialConfig.treePanel;
        var attrNode = this.initialConfig.attrNode;
        var dataChooserId = this.dataChooserIdItem.getValue();
        var attrsStore = this.attrsGrid.getStore();
        var attributes = new Array();

        if ( Ext.isEmpty( dataChooserId ) ) {
            showWarn( getTranslation( 'Wybierz dynamiczną listę.' ) );
            return;
        } else if ( !attrNode && treePanel.hasExtraConfig( dataChooserId ) ) {
            showWarn( getTranslation( 'Dynamiczna lista posiada już atrybuty.' ) );
            return;
        } else if ( attrNode && attrNode.attributes.extraConfig.dataChooserId != dataChooserId && treePanel.hasExtraConfig( dataChooserId ) ) {
            showWarn( getTranslation( 'Dynamiczna lista posiada już atrybuty.' ) );
            return;
        } else if ( attrsStore.getCount() == 0 ) {
            showWarn( getTranslation( 'Podaj atrybuty.' ) );
            return;
        }

        for ( var i = 0; i < attrsStore.getCount(); i++ ) {
            var attr = attrsStore.getAt( i );
            var key = attr.get( 'key' );
            var value = attr.get( 'value' );

            if ( Ext.isEmpty( key ) || Ext.isEmpty( value ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie atrybuty.' ) );
                return;
            }

            attributes.push( {
                key: key,
                value: value
            } );
        }

        var extraConfigObj = new Object();
        extraConfigObj = Ext.apply( {
            dataChooserId: dataChooserId,
            attributes: attributes
        }, extraConfigObj );

        if ( attrNode ) {
            var variable = activityNode.parentNode.findVariable( dataChooserId );
            attrNode.setText( getExtraDataChooserConfigNodeText( variable.name, attributes ) );
            attrNode.attributes.extraConfig = extraConfigObj;
        } else {
            var variable = activityNode.parentNode.findVariable( dataChooserId );
            treePanel.getRootNode().appendChild( {
                text: getExtraDataChooserConfigNodeText( variable.name, attributes ),
                icon: getPluginImgPath( 'parameters' ),
                leaf: true,
                extraConfig: extraConfigObj
            } );
        }

        this.ownerCt.closeWindow();
    }
} );