Raphael.fn.touchpad = {
    touchConfig: {
        active: false,
        processPanel: null,
        lastX: -1,
        lastY: -1
    },
    activateTouchpad: function( paper ) {
        paper.canvas.onmousedown = this.activateTouchScroll;
        paper.canvas.onmouseup = this.deactivateTouchScroll;
        paper.canvas.onmouseout = this.checkTouchScrollBoundary;
        paper.canvas.onmousemove = this.doTouchScroll;
    },
    activateTouchScroll: function( e ) {
        if ( e.button == 0 ) {
            var tc = Raphael.fn.touchpad.touchConfig;
            tc.active = true;
            tc.processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
            tc.lastX = e.pageX;
            tc.lastY = e.pageY;
            this.style.cursor = 'move';
        }
    },
    deactivateTouchScroll: function( e ) {
        Raphael.fn.touchpad.clearTouchConfig();
        this.style.cursor = 'auto';
    },
    clearTouchConfig: function() {
        this.touchConfig.active = false;
        this.touchConfig.processPanel = null;
        this.touchConfig.lastX = -1;
        this.touchConfig.lastY = -1;
    },
    checkTouchScrollBoundary: function( e ) {
        if ( Raphael.fn.touchpad.isActive() ) {
            var relTarg = e.relatedTarget || e.toElement;

            if ( !( relTarg.raphael || relTarg.parentElement.raphael ) ) {
                Raphael.fn.touchpad.clearTouchConfig();
                this.style.cursor = 'auto';
            }
        }
    },
    isActive: function() {
        return this.touchConfig.active;
    },
    doTouchScroll: function( e ) {
        var tc = Raphael.fn.touchpad.touchConfig;

        if ( tc.active && tc.lastX > 0 && tc.lastY > 0 ) {
            var processPanel = tc.processPanel;
            var newX = e.pageX;
            var newY = e.pageY;

            var newScrollLeft = processPanel.body.dom.scrollLeft + ( tc.lastX - newX );
            processPanel.body.dom.scrollLeft = newScrollLeft;

            var newScrollTop = processPanel.body.dom.scrollTop + ( tc.lastY - newY );
            processPanel.body.dom.scrollTop = newScrollTop;

            tc.lastX = newX;
            tc.lastY = newY;
        }
    }
};