Ext.ux.suncode.IntegrationComponentCatalog = function( config ) {
    var categories = config.categories;
    var components = this.convertCategoriesToComponents( categories, new Array(), 0 );
    
    var viewerTemplate = new Ext.XTemplate( '<tpl for=".">', '<tpl if="isFirstInCategory === true">',
    				'<tpl for="categoriesTree">', '<tpl if="values.collapsed === true">',
    				'<div class="x-Module-integrationComponentCategory x-Module-collapsed">', '</tpl>',
    				'<tpl if="values.collapsed === false">', '<div class="x-Module-integrationComponentCategory">', '</tpl>',
    				'<h2 style="margin-left: {[2 * values.depth]}em;"><div>{name}</div></h2>', '</tpl>',
    				'<dl style="margin-left: {[2 * values.depth]}em;">', '</tpl>',
    				'<dd>', '<div class="x-Module-integrationComponentThumbWrap" title="{name}">',
                    '<div class="x-Module-integrationComponentThumb">', '{image}', '</div>', '<span>{name}</span>', '</div>', '</dd>',
                    '<tpl if="isLastInCategory === true">', '<div style="clear: left"/></dl></div>',
                    '<tpl if="isLastCategory === true">', '</div>', '</tpl>', '</tpl>', '</tpl>' );
    viewerTemplate.compile();
    
    config = Ext.apply( {
        border: false,
        items: [ {
            xtype: 'panel',
            layout: 'form',
            border: false,
            labelWidth: 90,
            ref: 'filtersPanel',
            items: [ {
                xtype: 'compositefield',
                fieldLabel: getTranslation( 'Nazwa' ),
                anchor: '100%',
                ref: 'nameFilter',
                getFilterValue: function() {
                  return this.items.first().getValue();
                },
                setFilterValue: function( value ) {
                  var filter = this.items.first();
                  filter.setValue( value );
                },
                items: [ {
                    xtype: 'textfield',
                    emptyText: getTranslation( 'Szukaj' ) + '...',
                    flex: 1,
                    value: Ext.ux.suncode.StateService.getFormActionsCatalogNameFilterValue(),
                    listeners: {
                        scope: this,
                        afterrender: this.onNameFilterAfterRender
                    }
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'clear' ),
                    style: 'margin-top: 7px',
                    tooltip: getTranslation( 'Wyczyść filtr' ),
                    flex: 0,
                    handler: this.clearNameFilter,
                    scope: this
                } ]
            }, {
              xtype: 'compositefield',
              fieldLabel: getTranslation( 'Przeznaczenie' ),
              anchor: '100%',
              ref: 'destinationFilter',
              getFilterValue: function() {
                return this.items.first().getValue();
              },
              setFilterValue: function( value ) {
                var filter = this.items.first();
                filter.setValue( value );
              },
              items: [ new Ext.ux.suncode.IntegrationComponentDestinationChooser( {
                emptyText: getTranslation( 'Szukaj' ) + '...',
                flex: 1,
                listWidth: 200,
                value: Ext.ux.suncode.StateService.getFormActionsCatalogDestinationFilterValue(),
                listeners: {
                  scope: this,
                  select: this.applyDestinationFilter
                }
              } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                style: 'margin-top: 7px',
                tooltip: getTranslation( 'Wyczyść filtr' ),
                flex: 0,
                handler: this.clearDestinationFilter,
                scope: this
              } ]
            }, {
              xtype: 'compositefield',
              fieldLabel: getTranslation( 'Wtyczka' ),
              anchor: '100%',
              ref: 'sourceFilter',
              getFilterValue: function() {
                return this.items.first().getValue();
              },
              setFilterValue: function( value ) {
                var filter = this.items.first();
                filter.setValue( value );
              },
              items: [ new Ext.ux.suncode.IntegrationComponentPluginNameChooser( {
                emptyText: getTranslation( 'Szukaj' ) + '...',
                flex: 1,
                value: Ext.ux.suncode.StateService.getFormActionsCatalogSourceFilterValue(),
                listeners: {
                  scope: this,
                  select: this.applySourceFilter
                }
              } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                style: 'margin-top: 7px',
                tooltip: getTranslation( 'Wyczyść filtr' ),
                flex: 0,
                handler: this.clearSourceFilter,
                scope: this
              } ]
            } ]
        }, new Ext.ux.suncode.IntegrationComponentViewer( {
        	ref: 'viewerPanel',
        	cls: config.viewerScroll ? 'x-Module-dataViewScroll' : '',
            tpl: viewerTemplate,
            components: components,
            detailsPanel: config.detailsPanel,
            listeners: {
            	scope: this,
            	render: this.onViewerRender,
            	containerclick: this.onCategoryClick
            }
        } ) ],
        listeners: {
          scope: this,
          afterrender: this.onAfterRender
        }
    }, config );

    Ext.ux.suncode.IntegrationComponentCatalog.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentCatalog, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentCatalog.superclass.initComponent.call( this );
    },
    onAfterRender: function() {
        var name = Ext.ux.suncode.StateService.getFormActionsCatalogNameFilterValue();
        var destination = Ext.ux.suncode.StateService.getFormActionsCatalogDestinationFilterValue();
        var source = Ext.ux.suncode.StateService.getFormActionsCatalogSourceFilterValue();
        this.doFilterComponents( name, destination, source );
    },
    convertCategoriesToComponents: function( categories, categoriesTree, depth ) {
      var components = new Array();

      if ( !Ext.isEmpty( categories ) ) {
        var categoryIndex = 0;

        Ext.iterate( categories, function( category, elements, allCategories ) {
          categoryIndex++;
          categoriesTree.push( {
            name: category,
            depth: depth,
            collapsed: Ext.ux.suncode.StateService.getFormActionsCatalogCategoryCollapsed( category )
          } );

          if ( Ext.isArray( elements ) ) {
            var componentsCopy = [].concat( elements );
            componentsCopy.sort( function( a, b ) {
              return a.name > b.name ? 1 : -1;
            } );

            Ext.each( componentsCopy, function( component, index, allComponents ) {
              var componentCopy = deepObjectCopy( component );
              componentCopy = Ext.apply( {
                isFirstInCategory: ( index === 0 ),
                isLastInCategory: ( index === allComponents.length - 1 ),
                categoriesTree: [].concat ( categoriesTree ),
                depth: depth,
                isLastCategory: ( categoryIndex === Object.keys( allCategories ).length )
              }, componentCopy );

              components.push( componentCopy );
            } );

            clearArray( categoriesTree );
          } else {
            depth = depth + 1;
            components = components.concat( this.convertCategoriesToComponents( elements, categoriesTree, depth ) );
            depth = depth - 1;
          }
        }, this );
      }

      return components;
    },
    onNameFilterAfterRender: function( filter ) {
        filter.getEl().on( 'keyup', function() {
        	var value = filter.getValue();
        	Ext.ux.suncode.StateService.setFormActionsCatalogNameFilterValue( value );
          this.applyNameFilter( value );
        }, this, {
            buffer: 500
        } );
    },
    applyNameFilter: function( value ) {
      var filtersPanel = this.getFiltersPanel();
      var destinationFilter = filtersPanel.destinationFilter;
      var sourceFilter = filtersPanel.sourceFilter;
      this.doFilterComponents( value, destinationFilter.getFilterValue(), sourceFilter.getFilterValue() );
      filtersPanel.doLayout();
    },
    clearNameFilter: function() {
      var filtersPanel = this.getFiltersPanel();
      var nameFilter = filtersPanel.nameFilter;
      var destinationFilter = filtersPanel.destinationFilter;
      var sourceFilter = filtersPanel.sourceFilter;
      nameFilter.setFilterValue( '' );
      Ext.ux.suncode.StateService.setFormActionsCatalogNameFilterValue( '' );
      this.doFilterComponents( '', destinationFilter.getFilterValue(), sourceFilter.getFilterValue() );
      filtersPanel.doLayout();
    },
    applyDestinationFilter: function( combo, record, index ) {
      var value = combo.getValue();
      Ext.ux.suncode.StateService.setFormActionsCatalogDestinationFilterValue( value );
      var filtersPanel = this.getFiltersPanel();
      var nameFilter = filtersPanel.nameFilter;
      var sourceFilter = filtersPanel.sourceFilter;
      this.doFilterComponents( nameFilter.getFilterValue(), value, sourceFilter.getFilterValue() );
      filtersPanel.doLayout();
    },
    clearDestinationFilter: function() {
      var filtersPanel = this.getFiltersPanel();
      var nameFilter = filtersPanel.nameFilter;
      var destinationFilter = filtersPanel.destinationFilter;
      var sourceFilter = filtersPanel.sourceFilter;
      destinationFilter.setFilterValue( '' );
      Ext.ux.suncode.StateService.setFormActionsCatalogDestinationFilterValue( '' );
      this.doFilterComponents( nameFilter.getFilterValue(), '', sourceFilter.getFilterValue() );
      filtersPanel.doLayout();
    },
    applySourceFilter: function( combo, record, index ) {
      var value = combo.getValue();
      Ext.ux.suncode.StateService.setFormActionsCatalogSourceFilterValue( value );
      var filtersPanel = this.getFiltersPanel();
      var nameFilter = filtersPanel.nameFilter;
      var destinationFilter = filtersPanel.destinationFilter;
      this.doFilterComponents( nameFilter.getFilterValue(), destinationFilter.getFilterValue(), value );
      filtersPanel.doLayout();
    },
    clearSourceFilter: function() {
      var filtersPanel = this.getFiltersPanel();
      var nameFilter = filtersPanel.nameFilter;
      var destinationFilter = filtersPanel.destinationFilter;
      var sourceFilter = filtersPanel.sourceFilter;
      sourceFilter.setFilterValue( '' );
      Ext.ux.suncode.StateService.setFormActionsCatalogSourceFilterValue( '' );
      this.doFilterComponents( nameFilter.getFilterValue(), destinationFilter.getFilterValue(), '' );
      filtersPanel.doLayout();
    },
    getFiltersPanel: function() {
      return this.filtersPanel;
    },
    doFilterComponents: function( name, destination, source ) {
      var viewerPanel = this.viewerPanel;
      var store = viewerPanel.getStore();
      var filteredCategories = this.filterCategories( this.initialConfig.categories, name, destination, source );

      store.loadData( this.convertCategoriesToComponents( filteredCategories, new Array(), 0 ) );
    },
    filterCategories: function( categories, name, destination, source ) {
      var filteredCategories = new Object();
      var nameRegex = new RegExp( Ext.escapeRe( name ), 'i' );
      var destinationRegex = new RegExp( Ext.escapeRe( destination ), 'i' );
      var sourceRegex = new RegExp( Ext.escapeRe( source ), 'i' );

      if ( !Ext.isEmpty( categories ) ) {
        Ext.iterate( categories, function ( category, elements, allCategories ) {
          if ( Ext.isArray( elements ) ) {
            var filteredComponentsInCategory = new Array();

            Ext.each( elements, function ( component, index, allComponents ) {
              var componentName = component.name;
              var componentDestinations = component.destinations;
              var destinationMatch = false;
              var componentSource  = component.source;
              var componentSourceName = componentSource.name;

              if ( !Ext.isEmpty( componentDestinations ) ) {
                Ext.each( componentDestinations, function( componentDestination, index, allComponentDestinations ) {
                  if ( destinationRegex.test( componentDestination.type ) ) {
                    destinationMatch = true;
                    return false;
                  }
                } );
              } else {
                destinationMatch = true;
              }

              if ( nameRegex.test( componentName ) && destinationMatch && sourceRegex.test( componentSourceName ) ) {
                filteredComponentsInCategory.push(component);
              }
            } );

            if ( Ext.isArray( filteredComponentsInCategory ) ) {
              filteredCategories[category] = filteredComponentsInCategory;
            }
          } else if ( Ext.isObject( elements ) ) {
            filteredCategories[category] = this.filterCategories( elements, name, destination, source );
          }
        }, this );
      }

      return filteredCategories;
    },
    onViewerRender: function( view ) {
        if ( this.initialConfig.enableDrag ) {
            this.initViewerDragZone( view );
        }
        if ( this.initialConfig.showTooltip ) {
        	this.initViewerTooltip( view );
        }
        if ( this.initialConfig.viewerScroll ) {
        	var viewerHeight = this.viewerPanel.getHeight();
        	var searchHeight = this.filtersPanel.getHeight();
        	
        	this.viewerPanel.setHeight( viewerHeight - searchHeight - 22 );
        }
    },
    initViewerDragZone: function( view ) {
        var dragConfig = {
            getDragData: function( e ) {
                var sourceEl = e.getTarget( view.itemSelector, 10 );

                if ( !Ext.isEmpty( sourceEl ) ) {
                    var d = sourceEl.cloneNode( true );
                    d.id = Ext.id();

                    return {
                        ddel: d,
                        sourceEl: sourceEl,
                        repairXY: Ext.fly( sourceEl ).getXY(),
                        component: view.getRecord( sourceEl ).data
                    };
                }
            },
            getRepairXY: function() {
                return this.dragData.repairXY;
            }
        };

        if ( Ext.isObject( this.initialConfig.dragConfig ) ) {
            dragConfig = Ext.apply( this.initialConfig.dragConfig, dragConfig );
        }

        view.dragZone = new Ext.dd.DragZone( view.getEl(), dragConfig );
    },
    initViewerTooltip: function( view ) {
        view.tip = new Ext.ToolTip( {
            target: view.el,
            delegate: view.itemSelector,
            trackMouse: true,
            dismissDelay: 0,
            showDelay: 100,
            renderTo: Ext.getBody(),
            frame: false,
            viewer: view,
            cls: 'x-Module-integrationComponentDetailsTooltip',
            items: [ new Ext.ux.suncode.IntegrationComponentDetailsPanel( {
                ref: 'detailsPanel'
            } ) ],
            onMouseMove: function( e ) {		
        		var x = e.getPageX(), y = e.getPageY();
        		var t = this.delegate ? e.getTarget( this.delegate ) : this.triggerElement = true;
        	    if ( t ) {
        	        this.targetXY = e.getXY();
        	        if ( t === this.triggerElement ) {
        	            if ( !this.hidden && this.trackMouse ){
        	            	var box = this.getBox();
        	    	    	if ( box.x + box.width > Ext.getBody().getWidth() ) {
        	    	    		x = Ext.getBody().getWidth() - ( box.width + 10 );
        	    	    	}
        	    	    	if ( box.y + box.height > Ext.getBody().getHeight() ) {
        	    	    		y = Ext.getBody().getHeight() - ( box.height + 10 );
        	    	    	}
        	    	    	if ( y < jQuery( document ).scrollTop() ) {
        	    	    		y = jQuery( document ).scrollTop() + 10;
        	    	    	}
        	    	    	this.targetXY = [ x, y ];
        	    	    	this.setPagePosition( this.getTargetXY() );
        	            }
        	        } else {
        	            this.hide();
        	            this.lastActive = new Date( 0 );
        	            this.onTargetOver( e );
        	        }
        	    } else if ( !this.closable && this.isVisible() ) {
        	        this.hide();
        	    }
        	},
            show: function() {
            	this.showAt( [ -1000, -1000 ] );
                var box = this.getBox();
                var xy = this.getTargetXY();
                var x = xy[0], y = xy[1];
                if ( x + box.width > Ext.getBody().getWidth() ) {
    	    		x = Ext.getBody().getWidth() - ( box.width + 10 );
    	    	}
    	    	if ( y + box.height > Ext.getBody().getHeight() ) {
    	    		y = Ext.getBody().getHeight() - ( box.height + 10 );
    	    	}
    	    	if ( y < jQuery( document ).scrollTop() ) {
    	    		y = jQuery( document ).scrollTop() + 10;
    	    	}
    	    	this.targetXY = [ x, y ];
                this.showAt( this.getTargetXY() );
                this.anchorEl.hide();
            },
            listeners: {
                scope: this,
                beforeshow: this.onViewerTipBeforeShow
            }
        } );
    },
    onViewerTipBeforeShow: function( tip ) {
        var detailsPanel = tip.detailsPanel;
        var detailsPanelBody = detailsPanel.body;
        var record = tip.viewer.getRecord( tip.triggerElement );
        var component = record.data;
        detailsPanel.detailsTemplate.overwrite( detailsPanelBody, component );
    },
    onCategoryClick: function( dataView, e ) {
        var category = e.getTarget( 'h2', 3, true );

        if ( !Ext.isEmpty( category ) ) {
        	var categoryDiv = category.up( 'div' );
        	categoryDiv.toggleClass( 'x-Module-collapsed' );
        	var categoryNameDiv = category.down( 'div' );
        	Ext.ux.suncode.StateService.setFormActionsCatalogCategoryCollapsed(
        			categoryNameDiv.dom.innerHTML, categoryDiv.hasClass( 'x-Module-collapsed' ) );
        	var filtersPanel = this.filtersPanel;
          filtersPanel.doLayout();
        }
    },
    getSelectedComponent: function() {
    	var viewer = this.viewerPanel;
        var selections = viewer.getSelectedNodes();

        if ( !Ext.isEmpty( selections ) ) {
            return viewer.getRecord( selections[0] ).data;
        } else {
        	return null;
        }
    }
} );