Ext.ux.suncode.ActivityFormDesignerWindow = function( config ) {
    var activityNode = config.activityNode;
    var activityName = activityNode.attributes.activityName;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId;
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );
    var formDesignerConfig = config.formDesignerConfig;
    var viewSize = Ext.getBody().getViewSize();

    var mainPanel = Ext.getCmp( 'main_panel' );
    config = Ext.apply( {
        AV: mainPanel.getAdvancedView(),
        animationsOn: mainPanel.getAnimationsOn(),
        showTooltips: mainPanel.getShowTooltips()
    }, config );

    config = Ext.apply( {
        modal: true,
        width: viewSize.width * 0.95,
        height: viewSize.height * 0.95,
        title: getTranslation( 'Edytor formularza dla zadania' ) + ' ' + activityNameTranslation,
        layout: 'border',
        items: [ new Ext.ux.suncode.ActivityFormDesignerManagerPanel( config ),
                 new Ext.ux.suncode.ActivityFormDesignerDrawingPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CopyFormButton( {
            	activityNode: activityNode,
            	activityFormDesignerWindow: this
            } ), {
                cls: 'x-btn-icon',
                icon: formDesignerConfig.gridActive ? getPluginImgPath( 'hide_grid' ) : getPluginImgPath( 'show_grid' ),
                tooltip: formDesignerConfig.gridActive ? getTranslation( 'Ukryj siatkę' ) : getTranslation( 'Pokaż siatkę' ),
                enableToggle: true,
                handler: this.toggleGrid,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: formDesignerConfig.copyModeActive ? getPluginImgPath( 'copy_off' ) : getPluginImgPath( 'copy_on' ),
                tooltip: formDesignerConfig.copyModeActive ? getTranslation( 'Wyłącz tryb kopiowania' ) :
                	getTranslation( 'Włącz tryb kopiowania' ),
                enableToggle: true,
                handler: this.toggleCopyMode,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: formDesignerConfig.integrationComponentsVisible ? getPluginImgPath( 'hide_integration_components' ) :
                	getPluginImgPath( 'show_integration_components' ),
                tooltip: formDesignerConfig.integrationComponentsVisible ? getTranslation( 'Ukryj komponenty integracyjne' )
                		: getTranslation( 'Pokaż komponenty integracyjne' ),
                enableToggle: true,
                handler: this.toggleIntegrationComponentsVisibility,
                scope: this
            }, {
              cls: 'x-btn-icon',
              icon: getPluginImgPath( 'list' ),
              tooltip: getTranslation( 'Wyświetl listę komponentów integracyjnych na formularzu' ),
              handler: this.showAllIntegrationComponentsOnForm,
              scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'copy_form_actions' ),
                tooltip: getTranslation( 'Kopiuj akcje z innego zadania' ),
                handler: this.copyFormActions,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'preview' ),
                tooltip: getTranslation( 'Pokaż podgląd formularza' ),
                handler: this.showActivityFormPreview,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'config' ),
                tooltip: getTranslation( 'Inicjuj podgląd formularza' ),
                handler: this.initializeActivityFormPreview,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } ),
        listeners: {
        	scope: this,
        	close: this.onWindowClose
        }
    }, config );

    Ext.ux.suncode.ActivityFormDesignerWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.drawingPanel.saveForm();
    },
    copyForm: function( choosenActivityNode ) {
    	this.variablesTree.onCopyForm( choosenActivityNode );
      this.tablesTree.onCopyForm( choosenActivityNode );
    	this.labelsTree.onCopyForm( choosenActivityNode );
    	this.drawingPanel.onCopyForm( choosenActivityNode );
    },
    toggleGrid: function( button ) {
        var drawingPanel = this.drawingPanel;

        if ( drawingPanel.isGridActive() ) {
            drawingPanel.deactivateGrid();
            button.setTooltip( getTranslation( 'Pokaż siatkę' ) );
            button.setIcon( getPluginImgPath( 'show_grid' ) );
        } else {
            drawingPanel.activateGrid();
            button.setTooltip( getTranslation( 'Ukryj siatkę' ) );
            button.setIcon( getPluginImgPath( 'hide_grid' ) );
        }
        
        drawingPanel.updateFormDesignerConfig();
    },
    toggleCopyMode: function( button ) {
        var drawingPanel = this.drawingPanel;

        if ( drawingPanel.isCopyModeActive() ) {
            drawingPanel.deactivateCopyMode();
            button.setTooltip( getTranslation( 'Włącz tryb kopiowania' ) );
            button.setIcon( getPluginImgPath( 'copy_on' ) );
        } else {
            drawingPanel.activateCopyMode();
            button.setTooltip( getTranslation( 'Wyłącz tryb kopiowania' ) );
            button.setIcon( getPluginImgPath( 'copy_off' ) );
        }
        
        drawingPanel.updateFormDesignerConfig();
    },
    toggleIntegrationComponentsVisibility: function( button ) {
        var drawingPanel = this.drawingPanel;

        if ( drawingPanel.areIntegrationComponentsVisible() ) {
            drawingPanel.hideIntegrationComponents();
            button.setTooltip( getTranslation( 'Pokaż komponenty integracyjne' ) );
            button.setIcon( getPluginImgPath( 'show_integration_components' ) );
        } else {
            drawingPanel.showIntegrationComponents();
            button.setTooltip( getTranslation( 'Ukryj komponenty integracyjne' ) );
            button.setIcon( getPluginImgPath( 'hide_integration_components' ) );
        }
        
        drawingPanel.updateFormDesignerConfig();
    },
    showAllIntegrationComponentsOnForm: function() {
      var drawingPanel = this.drawingPanel;
      drawingPanel.showAllIntegrationComponentsOnForm();
    },
    copyFormActions: function() {
    	var win = new Ext.ux.suncode.CopyFromActivityWindow( {
            activityNode: this.initialConfig.activityNode,
            copyFunction: function( choosenActivityNode ) {
            	var drawingPanel = this.drawingPanel;
            	drawingPanel.copyFormActions( choosenActivityNode );
            },
            copyScope: this
        } );
        win.show();
    },
    showActivityFormPreview: function() {
    	var activityNode = this.initialConfig.activityNode;
    	var formElements = this.drawingPanel.getFormElements();
    	if ( !formElements ) {
    		return;
    	}

    	Ext.ux.suncode.FormPreviewService.showPreview( activityNode, formElements, new Object(), false );
    },
    initializeActivityFormPreview: function() {
    	var formElements = this.drawingPanel.getFormElements();
    	if ( !formElements ) {
    		return;
    	}
    	
    	var win = new Ext.ux.suncode.ActivityFormPreviewInitializationWindow( {
    		activityNode: this.initialConfig.activityNode,
    		formElements: formElements
    	} );
    	win.show();
    },
    closeWindow: function() {
        this.close();
    },
    onWindowClose: function() {
    	var wins = Ext.ux.suncode.Clipboard.getActivityFormPreviews();
    	
    	if ( !Ext.isEmpty( wins ) ) {
    		Ext.each( wins, function( win, index, allWins ) {
    			if ( !win.closed ) {
    				win.close();
    			}
    		} );
    	}
    	
    	Ext.ux.suncode.Clipboard.deleteActivityFormPreviews();
    	Ext.ux.suncode.Clipboard.deleteActivityFormDesigner();
    }
} );

Ext.ux.suncode.ActivityFormDesignerManagerPanel = function( config ) {
    var items = new Array();
    items.push( new Ext.ux.suncode.ActivityFormDesignerVariablesPanel( config ) );
    items.push( new Ext.ux.suncode.ActivityFormDesignerTablesPanel( config ) );
    items.push( new Ext.ux.suncode.ActivityFormDesignerLabelsPanel( config ) );
    items.push( new Ext.ux.suncode.ActivityFormDesignerFieldsPanel( config ) );
    items.push( new Ext.ux.suncode.ActivityFormDesignerButtonsPanel( config ) );
    items.push( new Ext.ux.suncode.ActivityFormDesignerGadgetsPanel( config ) );
    items.push( new Ext.ux.suncode.ActivityFormDesignerFormActionsPanel( config ) );

    config = Ext.apply( {
        id: 'activityFormDesignerManagerPanel',
        region: 'west',
        width: 300,
        border: true,
        ref: 'managerPanel',
        autoScroll: true,
        split: true,
        layout: 'accordion',
        defaults: {
            style: 'margin-bottom: 5px'
        },
        layoutConfig: {
            animate: config.animationsOn,
            fill: false
        },
        items: items
    }, config );

    Ext.ux.suncode.ActivityFormDesignerManagerPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerManagerPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerManagerPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ActivityFormDesignerVariablesPanel = function( config ) {
    var children = new Array();
    var headerVariables = new Array();
    var tableVariables = new Array();
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var variables = processNode.attributes.variables;
    var formTemplate = activityNode.attributes.form.template;
    var usedVariables = new Array();

    if ( !Ext.isEmpty( formTemplate.rows ) ) {
        for ( var i = 0; i < formTemplate.rows.length; i++ ) {
            var row = formTemplate.rows[i];

            for ( var j = 0; j < row.items.length; j++ ) {
                var item = row.items[j];

                if ( item.type == 'VARIABLE_SET' ) {
                	var variableSet = activityNode.getFormVariable( item.id );
                	
                	if ( !Ext.isEmpty( variableSet ) ) {
                		var columns = variableSet.columns;

                        for ( var k = 0; k < columns.length; k++ ) {
                            usedVariables.push( columns[k].varId );
                        }
                	}
                } else {
                    usedVariables.push( item.id );
                }
            }
        }
    }

    if ( !Ext.isEmpty( variables ) ) {
        variables.sort( function( a, b ) {
            if ( a.name > b.name ) {
                return 1;
            } else {
                return -1;
            }
        } );

        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];
            var used = usedVariables.indexOf( variable.id ) != -1;
            var child = {
            	varId: variable.id,
            	text: variable.name,
            	icon: getPluginImgPath( 'variable' ),
            	leaf: true,
            	hidden: used,
            	used: used,
            	isVariable: true,
            	variable: variable,
            	listeners: {
            		scope: this,
            		dblclick: this.onVariableDblClick
	            }
	        };

            if ( variable.placement == 'form' ) {
            	headerVariables.push( child );
            } else {
            	tableVariables.push( child );
            }
        }
    }
    
    children.push( {
        text: getTranslation( 'Zmienne nagłówkowe' ),
        icon: getPluginImgPath( 'contents' ),
        expanded: Ext.ux.suncode.StateService.getHeaderFormVariablesExpanded(),
        leaf: false,
        subCategory: this.HEADER_SUB_CATEGORY,
        children: headerVariables,
        listeners: {
        	scope: this,
        	collapse: this.onHeaderSubCategoryCollapse,
        	expand: this.onHeaderSubCategoryExpand
        }
    } );
    children.push( {
    	text: getTranslation( 'Zmienne tabelaryczne' ),
        icon: getPluginImgPath( 'contents' ),
        expanded: Ext.ux.suncode.StateService.getTableFormVariablesExpanded(),
        leaf: false,
        subCategory: this.TABLE_SUB_CATEGORY,
        children: tableVariables,
        listeners: {
        	scope: this,
        	collapse: this.onTableSubCategoryCollapse,
        	expand: this.onTableSubCategoryExpand
        }
    } );

    config = Ext.apply( {
        title: getTranslation( 'Zmienne procesu' ),
        iconCls: 'x-Module-activityFormDesignerVariablesPanel',
        ref: '../variablesTree',
        layout: 'fit',
        useArrows: true,
        autoScroll: true,
        animate: config.animationsOn,
        containerScroll: true,
        frame: false,
        border: false,
        bodyStyle: {
            border: '0'
        },
        bodyCssClass: 'x-Module-whiteBody, x-Module-container-padding',
        enableDrag: true,
        collapsed: Ext.ux.suncode.StateService.getFormDesignerVariablesPanelCollapsed(),
        dragConfig: {
            ddGroup: 'dd_component',
            onBeforeDrag: this.onVariableDrag
        },
        tbar: new Ext.Toolbar( {
        	items: [ {
        		xtype: 'panel',
        		layout: 'form',
        		border: false,
        		width: 270,
        		labelWidth: 90,
        		items: [ {
        	        xtype: 'compositefield',
        	        fieldLabel: getTranslation( 'Nazwa' ),
        	        ref: 'nameFilter',
        	        getFilterValue: function() {
        	        	return this.items.first().getValue();
        	        },
        	        setFilterValue: function( value ) {
        	        	var filter = this.items.first();
        	        	filter.setValue( value );
        	        },
        	        items: [ {
        	            xtype: 'textfield',
        	            emptyText: getTranslation( 'Szukaj' ) + '...',
        	            flex: 1,
        	            cls: 'x-Module-field-leftAlign',
        	            value: Ext.ux.suncode.StateService.getFormVariablesNameFilterValue(),
        	            listeners: {
            				scope: this,
            				afterrender: this.onNameFilterAfterRender
            			}
        	        }, {
        	            xtype: 'button',
        	            cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'clear' ),
        	            tooltip: getTranslation( 'Wyczyść filtr' ),
        	            flex: 0,
                        style: 'margin-top: 4px',
        	            handler: this.clearNameFilter,
        	            scope: this
        	        } ]
        		}, {
        	        xtype: 'compositefield',
        	        fieldLabel: getTranslation( 'Typ' ),
        	        ref: 'typeFilter',
        	        getFilterValue: function() {
        	        	return this.items.first().getValue();
        	        },
        	        setFilterValue: function( value ) {
        	        	var filter = this.items.first();
        	        	filter.setValue( value );
        	        },
        	        items: [ new Ext.ux.suncode.TypesChooser( {
            			utilization: 'extended',
            			emptyText: getTranslation( 'Szukaj' ) + '...',
            			cls: 'x-Module-field-leftAlign',
            			flex: 1,
                        listWidth: 200,
            			value: Ext.ux.suncode.StateService.getFormVariablesTypeFilterValue(),
            			listeners: {
            				scope: this,
            				select: this.applyTypeFilter
            			}
            		} ), {
        	            xtype: 'button',
        	            cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'clear' ),
        	            tooltip: getTranslation( 'Wyczyść filtr' ),
        	            flex: 0,
                        style: 'margin-top: 4px',
        	            handler: this.clearTypeFilter,
        	            scope: this
        	        } ]
        		} ]
        	} ]
        } ),
        root: new Ext.tree.AsyncTreeNode( {
            text: getTranslation( 'Dostępne zmienne' ),
            icon: getPluginImgPath( 'contents' ),
            expanded: Ext.ux.suncode.StateService.getFormVariablesRootExpanded(),
            leaf: false,
            children: children,
            listeners: {
            	scope: this,
            	collapse: this.onRootCollapse,
            	expand: this.onRootExpand
            }
        } )
    }, config );

    Ext.ux.suncode.ActivityFormDesignerVariablesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerVariablesPanel, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerVariablesPanel.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
        this.on( 'expand', this.onPanelExpand, this );
        this.on( 'collapse', this.onPanelCollapse, this );
    },
    HEADER_SUB_CATEGORY: 'header',
    TABLE_SUB_CATEGORY: 'table',
    onAfterRender: function() {
    	var nameFilterValue = Ext.ux.suncode.StateService.getFormVariablesNameFilterValue();
    	var typeFilterValue = Ext.ux.suncode.StateService.getFormVariablesTypeFilterValue();

    	if ( !( Ext.isEmpty( nameFilterValue ) && Ext.isEmpty( typeFilterValue ) ) ) {
    		this.doFilter( nameFilterValue, typeFilterValue );
    	}
    },
    onPanelExpand: function() {
    	this.doLayout();
    	Ext.ux.suncode.StateService.setFormDesignerVariablesPanelCollapsed( false );
    },
    onPanelCollapse: function() {
    	Ext.ux.suncode.StateService.setFormDesignerVariablesPanelCollapsed( true );
    },
    onVariableDblClick: function( node, e ) {
    	var variable = node.attributes.variable;
      var drawingPanel = this.ownerCt.ownerCt.drawingPanel;
    	if ( drawingPanel.checkDuplication( variable.id ) ) {
    		showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
    	} else {
    		drawingPanel.placeComponent( node, null, true, false, false );
        this.markAsUsed( variable );
        drawingPanel.analyzeOverlays();
    	}
    },
    onVariableDrag: function( data, e ) {
        if ( !data.node.isLeaf() ) {
            return false;
        }

        return true;
    },
    markAsUsed: function( variable ) {
        var node = this.findNode( variable );
        this.hideNode( node );
        node.attributes.used = true;
        this.addToPresentVariableIds( variable );
    },
    markAsUnused: function( variable ) {
        var node = this.findNode( variable );
        this.showNode( node );
        node.attributes.used = false;
        this.removeFromPresentVariableIds( variable );
    },
    findNode: function( variable ) {
    	var subCategory = this.getSubCategory( variable );
        var node = this.getRootNode().findChild( 'subCategory', subCategory ).findChild( 'varId', variable.id );
        return node ? node : this.addNode( variable );
    },
    hideNode: function( node ) {
    	node.unselect( true );
        node.getUI().hide();
    },
    showNode: function( node ) {
    	node.unselect( true );
        node.getUI().removeClass( 'x-tree-node-over' );
        node.getUI().show();
    },
    addNode: function( variable ) {
    	var subCategory = this.getSubCategory( variable );
        var nodeConfig = {
            varId: variable.id,
            text: variable.name,
            icon: getPluginImgPath( 'variable' ),
            leaf: true,
            variable: variable,
            isVariable: true,
            listeners: {
                scope: this,
                dblclick: this.onVariableDblClick
            }
        };
        var categoryNode = this.getRootNode().findChild( 'subCategory', subCategory );
        var refNode = null;

        categoryNode.eachChild( function( node ) {
            if ( node.attributes.variable.name > variable.name ) {
                refNode = node;
                return false;
            }
        } );

        if ( refNode ) {
            return categoryNode.insertBefore( nodeConfig, refNode );
        } else {
            return categoryNode.appendChild( nodeConfig );
        }
    },
    getSubCategory: function( variable ) {
    	return variable.placement === 'table' ? this.TABLE_SUB_CATEGORY : this.HEADER_SUB_CATEGORY;
    },
    addToPresentVariableIds: function( variable ) {
      var drawingPanel = this.ownerCt.ownerCt.drawingPanel;
      drawingPanel.addToPresentVariableIds( variable.id );
    },
    removeFromPresentVariableIds: function( variable ) {
      var drawingPanel = this.ownerCt.ownerCt.drawingPanel;
      drawingPanel.removeFromPresentVariableIds( variable.id );
    },
    onCopyForm: function( choosenActivityNode ) {
    	this.getRootNode().eachChild( function( categoryNode ) {
    		categoryNode.eachChild( function( node ) {
    			var variable = node.attributes.variable;
        		var formVariable = choosenActivityNode.getFormVariable( variable.id );
        		
        		if ( !Ext.isEmpty( formVariable ) ) {
        			this.markAsUsed( node.attributes.variable );
        		} else {
        			this.markAsUnused( node.attributes.variable );
        		}
    		}, this );
        }, this );
    },
    onRootCollapse: function() {
    	Ext.ux.suncode.StateService.setFormVariablesRootExpanded( false );
    },
    onRootExpand: function() {
    	Ext.ux.suncode.StateService.setFormVariablesRootExpanded( true );
    },
    onHeaderSubCategoryCollapse: function() {
    	Ext.ux.suncode.StateService.setHeaderFormVariablesExpanded( false );
    },
    onHeaderSubCategoryExpand: function() {
    	Ext.ux.suncode.StateService.setHeaderFormVariablesExpanded( true );
    },
    onTableSubCategoryCollapse: function() {
    	Ext.ux.suncode.StateService.setTableFormVariablesExpanded( false );
    },
    onTableSubCategoryExpand: function() {
    	Ext.ux.suncode.StateService.setTableFormVariablesExpanded( true );
    },
    onNameFilterAfterRender: function( filter ) {
    	filter.getEl().on( 'keyup', function() {
    		this.applyNameFilter( filter.getValue() );
        }, this, {
            buffer: 500
        } );
    },
    applyNameFilter: function( value ) {
    	var filtersPanel = this.getFiltersPanel();
        var typeFilter = filtersPanel.typeFilter;
        Ext.ux.suncode.StateService.setFormVariablesNameFilterValue( value );
        this.doFilter( value, typeFilter.getFilterValue() );
    },
    clearNameFilter: function() {
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var typeFilter = filtersPanel.typeFilter;
        Ext.ux.suncode.StateService.setFormVariablesNameFilterValue( '' );
        nameFilter.setFilterValue( '' );
        this.doFilter( '', typeFilter.getFilterValue() );
    },
    applyTypeFilter: function( combo, record, index ) {
    	var value = combo.getValue();
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        Ext.ux.suncode.StateService.setFormVariablesTypeFilterValue( value );
        this.doFilter( nameFilter.getFilterValue(), value );
    },
    clearTypeFilter: function() {
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var typeFilter = filtersPanel.typeFilter;
        Ext.ux.suncode.StateService.setFormVariablesTypeFilterValue( '' );
        typeFilter.setFilterValue( '' );
        this.doFilter( nameFilter.getFilterValue(), '' );
    },
    getFiltersPanel: function() {
    	var tbar = this.getTopToolbar();
    	
        return tbar.items.first();
    },
    doFilter: function( name, type ) {
    	var nameRegex = new RegExp( Ext.escapeRe( name ), 'i' );
    	var typeRegex = new RegExp( Ext.escapeRe( type ), 'i' );
    	
    	this.getRootNode().eachChild( function( subcategoryNode ) {
			subcategoryNode.eachChild( function( variableNode ) {
				if ( !variableNode.attributes.used ) {
					var variableName = variableNode.attributes.variable.name;
					var variableType = variableNode.attributes.variable.type;
					
					if ( nameRegex.test( variableName ) && typeRegex.test( variableType ) ) {
						this.showNode( variableNode );
					} else {
						this.hideNode( variableNode );
					}
				}
			}, this );
        }, this ); 
    }
} );

Ext.ux.suncode.ActivityFormDesignerTablesPanel = function( config ) {
  var children = new Array();
  var activityNode = config.activityNode;
  var processNode = activityNode.parentNode;
  var tables = processNode.attributes.tables;
  var formTemplate = activityNode.attributes.form.template;
  var usedTables = new Array();

  if ( !Ext.isEmpty( formTemplate.rows ) ) {
    for ( var i = 0; i < formTemplate.rows.length; i++ ) {
      var row = formTemplate.rows[i];

      for ( var j = 0; j < row.items.length; j++ ) {
        var item = row.items[j];

        if ( item.type == 'VARIABLE_SET' ) {
          usedTables.push( item.id );
        }
      }
    }
  }

  if ( !Ext.isEmpty( tables ) ) {
    tables.sort( function( a, b ) {
      if ( a.name > b.name ) {
        return 1;
      } else {
        return -1;
      }
    } );

    for ( var i = 0; i < tables.length; i++ ) {
      var table = tables[i];
      var child = {
        tableId: table.id,
        text: table.name,
        icon: getPluginImgPath( 'table' ),
        leaf: true,
        hidden: usedTables.indexOf( table.id ) != -1,
        isTable: true,
        table: table,
        listeners: {
          scope: this,
          dblclick: this.onTableDblClick
        }
      };

      children.push( child );
    }
  }

  config = Ext.apply( {
    title: getTranslation( 'Tabele' ),
    iconCls: 'x-Module-activityFormDesignerTablesPanel',
    ref: '../tablesTree',
    layout: 'fit',
    useArrows: true,
    autoScroll: true,
    animate: config.animationsOn,
    containerScroll: true,
    frame: false,
    border: false,
    bodyStyle: {
       border: '0'
    },
    bodyCssClass: 'x-Module-whiteBody, x-Module-container-padding',
    enableDrag: true,
    collapsed: Ext.ux.suncode.StateService.getFormDesignerTablesPanelCollapsed(),
    dragConfig: {
      ddGroup: 'dd_component',
      onBeforeDrag: this.onTableDrag
    },
    root: new Ext.tree.AsyncTreeNode( {
      text: getTranslation( 'Dostępne tabele' ),
      icon: getPluginImgPath( 'contents' ),
      expanded: true,
      leaf: false,
      children: children
    } )
  }, config );

  Ext.ux.suncode.ActivityFormDesignerTablesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerTablesPanel, Ext.tree.TreePanel, {
  initComponent: function() {
    Ext.ux.suncode.ActivityFormDesignerTablesPanel.superclass.initComponent.call( this );

    this.on( 'expand', this.onPanelExpand, this );
    this.on( 'collapse', this.onPanelCollapse, this );
  },
  onPanelExpand: function() {
    this.doLayout();
    Ext.ux.suncode.StateService.setFormDesignerTablesPanelCollapsed( false );
  },
  onPanelCollapse: function() {
    Ext.ux.suncode.StateService.setFormDesignerTablesPanelCollapsed( true );
  },
  onTableDblClick: function( node, e ) {
    var table = node.attributes.table;
    var drawingPanel = Ext.getCmp( 'drawing_panel' );
    if ( drawingPanel.checkTableDuplication( table ) ) {
      showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
    } else {
      drawingPanel.placeComponent( node, null, false, true, false );
      this.markAsUsed( table );
      var processNode = this.initialConfig.activityNode.parentNode;
      var variablesTree = drawingPanel.getVariablesTree();
      Ext.each( table.columns, function( column, index, columns ) {
        var variable = processNode.findVariable( column.varId );
        variablesTree.markAsUsed( variable );
      } );
      drawingPanel.analyzeOverlays();
    }
  },
  onTableDrag: function( data, e ) {
    if ( !data.node.isLeaf() ) {
      return false;
    }

    return true;
  },
  markAsUsed: function( table ) {
    var node = this.findNode( table );
    node.unselect( true );
    node.getUI().hide();
  },
  markAsUnused: function( table ) {
    var node = this.findNode( table );
    node.unselect( true );
    node.getUI().removeClass( 'x-tree-node-over' );
    node.getUI().show();
  },
  findNode: function( table ) {
    var node = this.getRootNode().findChild( 'tableId', table.id );
    return node ? node : this.addNode( table );
  },
  addNode: function( table ) {
    var nodeConfig = {
      tableId: table.id,
      text: table.name,
      icon: getPluginImgPath( 'table' ),
      leaf: true,
      isTable: true,
      table: table,
      listeners: {
        scope: this,
        dblclick: this.onTableDblClick
      }
    };
    var rootNode = this.getRootNode();
    var refNode = null;

    rootNode.eachChild( function( node ) {
      if ( node.attributes.table.name > table.name ) {
        refNode = node;
        return false;
      }
    } );

    if ( refNode ) {
      return rootNode.insertBefore( nodeConfig, refNode );
    } else {
      return rootNode.appendChild( nodeConfig );
    }
  },
  onCopyForm: function( choosenActivityNode ) {
    this.getRootNode().eachChild( function( node ) {
      var table = node.attributes.table;

      if ( choosenActivityNode.hasFormElement( table.id ) ) {
        this.markAsUsed( node.attributes.table );
      } else {
        this.markAsUnused( node.attributes.table );
      }
    }, this );
  }
} );

Ext.ux.suncode.ActivityFormDesignerLabelsPanel = function( config ) {
    var children = new Array();
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var labels = processNode.attributes.labels;
    var formTemplate = activityNode.attributes.form.template;
    var usedLabels = new Array();

    if ( !Ext.isEmpty( formTemplate.rows ) ) {
        for ( var i = 0; i < formTemplate.rows.length; i++ ) {
            var row = formTemplate.rows[i];

            for ( var j = 0; j < row.items.length; j++ ) {
                var item = row.items[j];

                if ( item.type == 'LABEL' ) {
                	usedLabels.push( item.id );
                }
            }
        }
    }

    if ( !Ext.isEmpty( labels ) ) {
    	labels.sort( function( a, b ) {
            if ( a.name > b.name ) {
                return 1;
            } else {
                return -1;
            }
        } );

        for ( var i = 0; i < labels.length; i++ ) {
            var label = labels[i];
            var child = {
            	labelId: label.id,
            	text: label.name,
            	icon: getPluginImgPath( 'label' ),
            	leaf: true,
            	hidden: usedLabels.indexOf( label.id ) != -1,
            	isLabel: true,
            	label: label,
            	listeners: {
            		scope: this,
            		dblclick: this.onLabelDblClick
	            }
	        };

            children.push( child );
        }
    }
    
    config = Ext.apply( {
        title: getTranslation( 'Etykiety' ),
        iconCls: 'x-Module-activityFormDesignerLabelsPanel',
        ref: '../labelsTree',
        layout: 'fit',
        useArrows: true,
        autoScroll: true,
        animate: config.animationsOn,
        containerScroll: true,
        frame: false,
        border: false,
        bodyStyle: {
            border: '0'
        },
        bodyCssClass: 'x-Module-whiteBody, x-Module-container-padding',
        enableDrag: true,
        collapsed: Ext.ux.suncode.StateService.getFormDesignerLabelsPanelCollapsed(),
        dragConfig: {
            ddGroup: 'dd_component',
            onBeforeDrag: this.onLabelDrag
        },
        root: new Ext.tree.AsyncTreeNode( {
            text: getTranslation( 'Dostępne etykiety' ),
            icon: getPluginImgPath( 'contents' ),
            expanded: true,
            leaf: false,
            children: children
        } )
    }, config );

    Ext.ux.suncode.ActivityFormDesignerLabelsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerLabelsPanel, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerLabelsPanel.superclass.initComponent.call( this );
        
        this.on( 'expand', this.onPanelExpand, this );
        this.on( 'collapse', this.onPanelCollapse, this );
    },
    onPanelExpand: function() {
    	this.doLayout();
    	Ext.ux.suncode.StateService.setFormDesignerLabelsPanelCollapsed( false );
    },
    onPanelCollapse: function() {
    	Ext.ux.suncode.StateService.setFormDesignerLabelsPanelCollapsed( true );
    },
    onLabelDblClick: function( node, e ) {
    	var label = node.attributes.label;
    	var drawingPanel = Ext.getCmp( 'drawing_panel' );
    	if ( drawingPanel.checkDuplication( label.id ) ) {
    		showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
    	} else {
    		drawingPanel.placeComponent( node, null, false, false, true );
    		this.markAsUsed( label );
    	}
    },
    onLabelDrag: function( data, e ) {
        if ( !data.node.isLeaf() ) {
            return false;
        }

        return true;
    },
    markAsUsed: function( label ) {
        var node = this.findNode( label );
        node.unselect( true );
        node.getUI().hide();
    },
    markAsUnused: function( label ) {
        var node = this.findNode( label );
        node.unselect( true );
        node.getUI().removeClass( 'x-tree-node-over' );
        node.getUI().show();
    },
    findNode: function( label ) {
        var node = this.getRootNode().findChild( 'labelId', label.id );
        return node ? node : this.addNode( label );
    },
    addNode: function( label ) {
        var nodeConfig = {
        	labelId: label.id,
           	text: label.name,
           	icon: getPluginImgPath( 'label' ),
           	leaf: true,
           	isLabel: true,
           	label: label,
           	listeners: {
           		scope: this,
          		dblclick: this.onLabelDblClick
            }
        };
        var rootNode = this.getRootNode();
        var refNode = null;

        rootNode.eachChild( function( node ) {
            if ( node.attributes.label.name > label.name ) {
                refNode = node;
                return false;
            }
        } );

        if ( refNode ) {
            return rootNode.insertBefore( nodeConfig, refNode );
        } else {
            return rootNode.appendChild( nodeConfig );
        }
    },
    onCopyForm: function( choosenActivityNode ) {
    	this.getRootNode().eachChild( function( node ) {
    		var label = node.attributes.label;
    		
    		if ( choosenActivityNode.hasFormElement( label.id ) ) {
    			this.markAsUsed( node.attributes.label );
    		} else {
    			this.markAsUnused( node.attributes.label );
    		}
        }, this );
    }
} );

Ext.ux.suncode.ActivityFormDesignerFieldsPanel = function( config ) {
    config = Ext.apply( {
        title: getTranslation( 'Pola' ),
        iconCls: 'x-Module-activityFormDesignerFieldsPanel',
        frame: false,
        border: false,
        bodyStyle: {
            border: '0'
        },
        autoScroll: true,
        bodyCssClass: 'x-Module-whiteBody x-Module-container-padding',
        cls: 'x-Module-ddProxy',
        collapsed: Ext.ux.suncode.StateService.getFormDesignerFieldsPanelCollapsed(),
        defaults: {
            xtype: 'panel',
            layout: 'form',
            autoHeight: true,
            frame: false,
            border: false,
            draggable: {
                ddGroup: 'dd_component',
                insertProxy: true
            },
            listeners: {
                scope: this,
                afterrender: function( panel ) {
                    var panelEl = panel.getEl();
                    panelEl.on( 'dblclick', this.onFieldDblClick, this, {
                        component: panel
                    } );

                    if ( config.showTooltips ) {
                        panelEl.on( 'mouseenter', this.showFieldTooltip, this, {
                            component: panel
                        } );
                        panelEl.on( 'mouseleave', this.hideFieldTooltip, this, {
                            component: panel
                        } );
                    }
                }
            }
        },
        tooltipTrash: [],
        items: [ {
            type: 'STRING',
            componentName: getTranslation( 'Zmienna tekstowa' ),
            items: [ {
                xtype: 'textfield',
                anchor: '100%',
                hideLabel: true,
                readOnly: true,
                value: getTranslation( 'Dowolny tekst' )
            } ]
        }, {
            type: 'INTEGER',
            componentName: getTranslation( 'Zmienna całkowita' ),
            items: [ {
                xtype: 'numberfield',
                anchor: '100%',
                hideLabel: true,
                readOnly: true,
                allowDecimals: false,
                value: 123
            } ]
        }, {
            type: 'FLOAT',
            componentName: getTranslation( 'Zmienna dziesiętna' ),
            items: [ {
                xtype: 'numberfield',
                anchor: '100%',
                hideLabel: true,
                readOnly: true,
                allowDecimals: true,
                decimalSeparator: ',',
                decimalPrecision: 5,
                value: 123.45678
            } ]
        }, {
            type: 'AMOUNT',
            componentName: getTranslation( 'Zmienna kwotowa' ),
            items: [ {
                xtype: 'numberfield',
                anchor: '100%',
                hideLabel: true,
                readOnly: true,
                allowDecimals: true,
                decimalSeparator: ',',
                decimalPrecision: 2,
                value: 123.45
            } ]
        }, {
            type: 'DATE',
            componentName: getTranslation( 'Zmienna datowa' ),
            items: [ {
                xtype: 'datefield',
                anchor: '100%',
                hideLabel: true,
                format: 'Y-m-d',
                triggerClass: 'dvnt-icon-calendar-normal',
                value: new Date(),
                onTriggerClick: function() {
                    return false;
                }
            } ]
        }, {
            type: 'DATETIME',
            componentName: getTranslation( 'Zmienna datowa z czasem' ),
            items: [ {
                xtype: 'datefield',
                anchor: '100%',
                hideLabel: true,
                format: 'Y-m-d H:i:s',
                triggerClass: 'dvnt-icon-time',
                value: new Date(),
                onTriggerClick: function() {
                    return false;
                }
            } ]
        }, {
            type: 'TEXTAREA',
            componentName: getTranslation( 'Pole tekstowe' ),
            items: [ {
                xtype: 'textarea',
                anchor: '100%',
                hideLabel: true,
                height: 50,
                readOnly: true,
                value: getTranslation( 'Wartość wynosi' ) + ' 123,45\n' + getTranslation( 'bez podatku' )
            } ]
        }, {
            type: 'RADIOBUTTON',
            componentName: getTranslation( 'Przycisk jednokrotnego wyboru' ),
            items: [ {
                xtype: 'radiogroup',
                anchor: '100%',
                hideLabel: true,
                defaults: {
                    listeners: {
                        check: function( field, checked ) {
                            field.setValue( false );
                        }
                    }
                },
                items: [ {
                    boxLabel: 'A',
                    name: 'radiobutton'
                }, {
                    boxLabel: 'B',
                    name: 'radiobutton'
                } ]
            } ]
        }, {
            type: 'CHECKBOX',
            componentName: getTranslation( 'Przycisk wyboru (checkbox)' ),
            items: [ {
                xtype: 'checkboxgroup',
                anchor: '100%',
                hideLabel: true,
                defaults: {
                    listeners: {
                        check: function( field, checked ) {
                            field.setValue( false );
                        }
                    }
                },
                items: [ {
                    boxLabel: 'A',
                    name: 'checkboxgroup'
                }, {
                    boxLabel: 'B',
                    name: 'checkboxgroup'
                } ]
            } ]
        }, {
            type: 'BOOLEAN',
            componentName: getTranslation( 'Zmienna logiczna' ),
            items: [ {
                xtype: 'checkbox',
                hideLabel: true,
                listeners: {
                    check: function( field, checked ) {
                        field.setValue( false );
                    }
                }
            } ]
        }, {
            type: 'DATA_CHOOSER',
            componentName: getTranslation( 'Dynamiczna lista' ),
            items: [ {
                xtype: 'combo',
                anchor: '100%',
                hideLabel: true,
                store: new Ext.data.Store( {} ),
                triggerClass: 'x-Module-combobox-field-trigger',
                value: getTranslation( 'Dynamiczna lista' ),
                onTriggerClick: function() {
                    return false;
                }
            } ]
        }, {
            type: 'LISTBOX_NO_FILTER',
            componentName: getTranslation( 'Lista wartości' ),
            items: [ {
                xtype: 'combo',
                anchor: '100%',
                hideLabel: true,
                store: new Ext.data.Store( {} ),
                triggerClass: 'x-Module-combobox-field-trigger',
                value: getTranslation( 'Lista wartości' ),
                onTriggerClick: function() {
                    return false;
                }
            } ]
        }, {
            type: 'USERLIST',
            componentName: getTranslation( 'Tabela użytkowników systemu' ),
            items: [ {
                xtype: 'trigger',
                anchor: '100%',
                hideLabel: true,
                triggerClass: 'dvnt-icon-users',
                value: 'j.kowalski',
                onTriggerClick: function() {
                    return false;
                }
            } ]
        }, {
            type: 'LABEL',
            componentName: getTranslation( 'Etykieta' ),
            items: [ {
                xtype: 'label',
                anchor: '100%',
                text: getTranslation( 'Etykieta' )
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ActivityFormDesignerFieldsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerFieldsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerFieldsPanel.superclass.initComponent.call( this );
        
        this.on( 'expand', this.onPanelExpand, this );
        this.on( 'collapse', this.onPanelCollapse, this );
    },
    onPanelExpand: function() {
    	this.doLayout();
    	Ext.ux.suncode.StateService.setFormDesignerFieldsPanelCollapsed( false );
    },
    onPanelCollapse: function() {
    	Ext.ux.suncode.StateService.setFormDesignerFieldsPanelCollapsed( true );
    },
    onFieldDblClick: function( e, t, o ) {
        Ext.getCmp( 'drawing_panel' ).placeComponent( o.component, null, false, false );
    },
    showFieldTooltip: function( e, t, o ) {
        var tooltip = new Ext.ux.suncode.TooltipInfo( {
            info: o.component.componentName,
            maxWidth: 400
        } );
        tooltip.showAt( e.xy );
        this.tooltipTrash.push( tooltip );
    },
    hideFieldTooltip: function( e, t, o ) {
        Ext.each( this.tooltipTrash, function( el, index, els ) {
            el.remove();
        } );
        this.tooltipTrash.splice( 0, this.tooltipTrash.length );
        this.tooltipTrash = new Array();
    }
} );

Ext.ux.suncode.ActivityFormDesignerButtonsPanel = function( config ) {
	var mainPanel = Ext.getCmp( 'main_panel' );
    var compatibilityMode = mainPanel.getCompatibilityMode();
    
    config = Ext.apply( {
        title: getTranslation( 'Przyciski' ),
        iconCls: 'x-Module-activityFormDesignerButtonsPanel',
        frame: false,
        border: false,
        bodyStyle: {
            border: '0'
        },
        autoScroll: true,
        bodyCssClass: 'x-Module-whiteBody',
        cls: 'x-Module-ddProxy',
        collapsed: Ext.ux.suncode.StateService.getFormDesignerButtonsPanelCollapsed(),
        defaults: {
            xtype: 'panel',
            layout: 'form',
            autoHeight: true,
            frame: false,
            border: false,
            style: 'padding: 5px;',
            draggable: {
                ddGroup: 'dd_component',
                insertProxy: true
            },
            listeners: {
                scope: this,
                afterrender: function( panel ) {
                    var panelEl = panel.getEl();
                    panelEl.on( 'dblclick', this.onButtonDblClick, this, {
                        component: panel
                    } );
                }
            }
        },
        tooltipTrash: [],
        items: [ {
            type: 'HTTP_LINK',
            items: [ {
                xtype: 'panel',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'middle',
                    pack: 'center'
                },
                items: [ {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button',
                    text: getTranslation( 'Przycisk' ),
                    listeners: {
                    	scope: this,
                    	afterrender: function( button ) {
                    		this.onButtonAfterRender( button, getTranslation( 'Przycisk formularza' ) );
                    	}
                    }
                } ]
            } ]
        }, {
            type: 'ACTION_ACCEPT_BUTTON',
            items: [ {
                xtype: 'panel',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'middle',
                    pack: 'center'
                },
                items: [ {
                    xtype: 'button',
                    cls: 'x-btn-text-icon dvnt-pwe-form-button',
                    iconCls: 'dvnt-icon-report',
                    text: getTranslation( 'Przycisk' ),
                    listeners: {
                    	scope: this,
                    	afterrender: function( button ) {
                    		this.onButtonAfterRender( button, getTranslation( 'Przycisk akceptacji' ) );
                    	}
                    }
                } ]
            } ]
        }, {
            type: 'GENERATE_PDF_BUTTON',
            hidden: !compatibilityMode.showGeneratePdfButton(),
            items: [ {
                xtype: 'panel',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'middle',
                    pack: 'center'
                },
                items: [ {
                    xtype: 'button',
                    cls: 'x-btn-text-icon dvnt-pwe-form-button',
                    iconCls: 'dvnt-icon-pdf',
                    text: getTranslation( 'Przycisk' ),
                    listeners: {
                    	scope: this,
                    	afterrender: function( button ) {
                    		this.onButtonAfterRender( button, getTranslation( 'Przycisk generowania PDF' ) );
                    	}
                    }
                }, {
                	xtype: 'box',
                	autoEl: {
                        tag: 'div',
                        style: 'padding-left: 3px; padding-top: 3px;',
                        cn: [ {
                            tag: 'img',
                            src: getPluginImgPath( 'warning' )
                        } ]
                    },
                    listeners: {
                    	render: function( p ) {
                    		Ext.QuickTips.register( {
                                target: p.getEl(),
                                text: getTranslation( 'Opcja jest przestarzała' )
                            } );
                    	}
                    }
                } ]
            } ]
        }, {
            type: 'ADD_FILE_BUTTON',
            items: [ {
                xtype: 'panel',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'middle',
                    pack: 'center'
                },
                items: [ {
                    xtype: 'button',
                    cls: 'x-btn-text-icon dvnt-pwe-form-button',
                    iconCls: 'dvnt-icon-folder-note',
                    text: getTranslation( 'Przycisk' ),
                    listeners: {
                    	scope: this,
                    	afterrender: function( button ) {
                    		this.onButtonAfterRender( button, getTranslation( 'Przycisk podłączania pliku' ) );
                    	}
                    }
                } ]
            } ]
        }, {
            type: 'BARCODE_PRINT',
            items: [ {
                xtype: 'panel',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'middle',
                    pack: 'center'
                },
                items: [ {
                    xtype: 'button',
                    cls: 'x-btn-text-icon dvnt-pwe-form-button',
                    iconCls: 'dvnt-icon-printer2',
                    text: getTranslation( 'Przycisk' ),
                    listeners: {
                    	scope: this,
                    	afterrender: function( button ) {
                    		this.onButtonAfterRender( button, getTranslation( 'Przycisk drukowania kodu kreskowego' ) );
                    	}
                    }
                } ]
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ActivityFormDesignerButtonsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerButtonsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerButtonsPanel.superclass.initComponent.call( this );
        
        this.on( 'expand', this.onPanelExpand, this );
        this.on( 'collapse', this.onPanelCollapse, this );
    },
    onPanelExpand: function() {
    	this.doLayout();
    	Ext.ux.suncode.StateService.setFormDesignerButtonsPanelCollapsed( false );
    },
    onPanelCollapse: function() {
    	Ext.ux.suncode.StateService.setFormDesignerButtonsPanelCollapsed( true );
    },
    onButtonDblClick: function( e, t, o ) {
        Ext.getCmp( 'drawing_panel' ).placeComponent( o.component, null, false, false );
    },
    onButtonAfterRender: function( button, tooltip ) {
    	var showTooltips = this.initialConfig.showTooltips;
    	
    	if ( showTooltips ) {
        	var buttonEl = button.getEl();
        	buttonEl.on( 'mouseenter', this.showButtonTooltip, this, {
        		tooltip: tooltip
            } );
        	buttonEl.on( 'mouseleave', this.hideButtonTooltip, this );
        }
    },
    showButtonTooltip: function( e, t, o ) {
        var tooltip = new Ext.ux.suncode.TooltipInfo( {
            info: o.tooltip,
            maxWidth: 400
        } );
        tooltip.showAt( e.xy );
        this.tooltipTrash.push( tooltip );
    },
    hideButtonTooltip: function( e, t, o ) {
        Ext.each( this.tooltipTrash, function( el, index, els ) {
            el.remove();
        } );
        this.tooltipTrash.splice( 0, this.tooltipTrash.length );
        this.tooltipTrash = new Array();
    }
} );

Ext.ux.suncode.ActivityFormDesignerGadgetsPanel = function( config ) {
    config = Ext.apply( {
        title: getTranslation( 'Gadżety' ),
        iconCls: 'x-Module-activityFormDesignerGadgetsPanel',
        frame: false,
        border: false,
        bodyStyle: {
            border: '0'
        },
        autoScroll: true,
        bodyCssClass: 'x-Module-whiteBody x-Module-container-padding',
        cls: 'x-Module-ddProxy',
        collapsed: Ext.ux.suncode.StateService.getFormDesignerGadgetsPanelCollapsed(),
        defaults: {
            xtype: 'panel',
            layout: 'form',
            bodyCssClass: 'bodyCssClass',
            labelWidth: 1,
            autoHeight: true,
            frame: false,
            draggable: {
                ddGroup: 'dd_component',
                insertProxy: true
            },
            listeners: {
                scope: this,
                afterrender: function( panel ) {
                    var panelEl = panel.getEl();
                    panelEl.on( 'dblclick', this.onGadgetDblClick, this, {
                        component: panel
                    } );

                    if ( config.showTooltips ) {
                        panelEl.on( 'mouseenter', this.showGadgetTooltip, this, {
                            component: panel
                        } );
                        panelEl.on( 'mouseleave', this.hideGadgetTooltip, this, {
                            component: panel
                        } );
                    }
                }
            }
        },
        tooltipTrash: [],
        items: [ {
            type: 'VARIABLE_SET',
            componentName: getTranslation( 'Tabela dynamiczna' ),
            items: [ {
                xtype: 'grid',
                title: getTranslation( 'Tabela dynamiczna' ),
                height: 30,
                hideBorders: true,
                border: false,
                frame: false,
                cls: 'x-Module-small-header',
                header: true,
                store: new Ext.data.Store( {} ),
                colModel: new Ext.grid.ColumnModel( {
                    columns: []
                } )
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ActivityFormDesignerGadgetsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerGadgetsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerGadgetsPanel.superclass.initComponent.call( this );
        
        this.on( 'expand', this.onPanelExpand, this );
        this.on( 'collapse', this.onPanelCollapse, this );
    },
    onPanelExpand: function() {
    	this.doLayout();
    	Ext.ux.suncode.StateService.setFormDesignerGadgetsPanelCollapsed( false );
    },
    onPanelCollapse: function() {
    	Ext.ux.suncode.StateService.setFormDesignerGadgetsPanelCollapsed( true );
    },
    onGadgetDblClick: function( e, t, o ) {
      var drawingPanel = Ext.getCmp( 'drawing_panel' );
      var component = o.component;

      if ( component.type == 'VARIABLE_SET' ) {
        drawingPanel.createAndPlaceGlobalTable();
      } else {
        drawingPanel.placeComponent( o.component, null, false, false, false );
      }
    },
    showGadgetTooltip: function( e, t, o ) {
        var tooltip = new Ext.ux.suncode.TooltipInfo( {
            info: o.component.componentName,
            maxWidth: 400
        } );
        tooltip.showAt( e.xy );
        this.tooltipTrash.push( tooltip );
    },
    hideGadgetTooltip: function( e, t, o ) {
        Ext.each( this.tooltipTrash, function( el, index, els ) {
            el.remove();
        } );
        this.tooltipTrash.splice( 0, this.tooltipTrash.length );
        this.tooltipTrash = new Array();
    }
} );

Ext.ux.suncode.ActivityFormDesignerFormActionsPanel = function( config ) {
    config = Ext.apply( {
        title: getTranslation( 'Akcje formularza' ),
        iconCls: 'x-Module-activityFormDesignerFormActionsPanel',
        frame: false,
        border: false,
        bodyStyle: {
            border: '0'
        },
        autoScroll: true,
        bodyCssClass: 'x-Module-whiteBody x-Module-container-padding-small',
        cls: 'x-Module-ddProxy',
        collapsed: Ext.ux.suncode.StateService.getFormDesignerFormActionsPanelCollapsed(),
        items: [ new Ext.ux.suncode.IntegrationComponentCatalog( {
            categories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDeprecated(
            		Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories() ),
            enableDrag: true,
            dragConfig: {
                ddGroup: 'dd_form_action',
                onStartDrag: function( x, y ) {
                    Ext.getCmp( 'drawing_panel' ).onFormActionStartDrag( this.dragData );
                },
                onEndDrag: function( data, e ) {
                    Ext.getCmp( 'drawing_panel' ).onFormActionEndDrag( data, e );
                },
                beforeDragEnter: function( target, e, id ) {
                    return Ext.getCmp( 'drawing_panel' ).onFormActionBeforeDragEnter( target, e, id );
                },
                beforeDragOut: function( target, e, id ) {
                    return Ext.getCmp( 'drawing_panel' ).onFormActionBeforeDragOut( target, e, id );
                }
            },
            showTooltip: true
        } ) ]
    }, config );

    Ext.ux.suncode.ActivityFormDesignerFormActionsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerFormActionsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerFormActionsPanel.superclass.initComponent.call( this );
        
        this.on( 'expand', this.onPanelExpand, this );
        this.on( 'collapse', this.onPanelCollapse, this );
    },
    onPanelExpand: function() {
    	this.doLayout();
    	Ext.ux.suncode.StateService.setFormDesignerFormActionsPanelCollapsed( false );
    },
    onPanelCollapse: function() {
    	Ext.ux.suncode.StateService.setFormDesignerFormActionsPanelCollapsed( true );
    }
} );

Ext.ux.suncode.ActivityFormDesignerDrawingPanel = function( config ) {
	var activityNode = config.activityNode;
	var formDesignerConfig = config.formDesignerConfig;
	
    config = Ext.apply( {
        id: 'drawing_panel',
        region: 'center',
        bodyStyle: 'overflowY: scroll; border-width: 1px;',
        layoutConfig: {
            trackLabels: true
        },
        ref: 'drawingPanel',
        frame: false,
        border: false,
        gridActive: formDesignerConfig.gridActive,
        copyModeActive: formDesignerConfig.copyModeActive,
        integrationComponentsVisible: formDesignerConfig.integrationComponentsVisible,
        definition: {
            objectDef: {
                genre: 'FORM',
                formActions: deepObjectCopy( activityNode.attributes.form.actions ),
                eventActions: deepObjectCopy( activityNode.attributes.form.events )
            }
        },
        presentVariableIds: activityNode.getVariableIdsOnForm(),
        items: this.buildItems( activityNode, formDesignerConfig, {
          hideHiddenVariables: config.hideHiddenVariables
        } )
    }, config );

    Ext.ux.suncode.ActivityFormDesignerDrawingPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormDesignerDrawingPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormDesignerDrawingPanel.superclass.initComponent.call( this );

        this.on( 'render', this.initializeComponentDropTarget, this );
        this.on( 'afterrender', this.onAfterRender, this );
    },
    integrationComponentsMargin: 27,
    integrationComponentsLargeMargin: 33,
    errorMargin: 19,
    dropAllowedCls: 'x-dd-drop-ok',
    dropNotAllowedCls: 'x-dd-drop-nodrop',
    initializeComponentDropTarget: function( panel ) {
        new Ext.dd.DropTarget( this.getEl(), {
            ddGroup: 'dd_component',
            copy: false,
            notifyDrop: this.onComponentDrop.createDelegate( this )
        } );
    },
    onAfterRender: function( panel ) {
        var setFormImageTask = this.initialConfig.setFormImageTask;

        if ( !Ext.isEmpty( setFormImageTask ) ) {
            var activityNode = this.initialConfig.activityNode;

            html2canvas( Ext.getDom( panel.getEl() ), {
                onrendered: function( canvas ) {
                    var values = new Object();
                    values = Ext.apply( {
                        formImage: canvas.toDataURL( 'image/png' )
                    } );

                    Ext.ux.suncode.DocumentationService.setActivitySpecification( activityNode, values );
                    panel.ownerCt.close();
                    setFormImageTask.run();
                }
            } );
        } else {
        	this.getEl().on( 'click', this.onDrawingPanelClick, this );
        	this.getEl().on( 'contextmenu', this.onDrawingPanelContextMenu, this );

          this.analyzeVariablesMissingInIntegrationComponents( panel );

        	if ( this.areIntegrationComponentsVisible() ) {
        		this.addFormActionsOverlay( this );
            this.addEventActionsOverlay( this );
        	}
        }
    },
    getDrawingPanelTarget: function( e ) {
    	return e.getTarget( 'div[id=drawing_panel]', 7 );
    },
    onDrawingPanelClick: function( e, t, o ) {
    	if ( !e.ctrlKey ) {
    		var drawingPanel = this.getDrawingPanelTarget( e );
        	
        	if ( !Ext.isEmpty( drawingPanel ) ) {
        		this.unmarkAllComponents();
        	}
    	}
    },
    onDrawingPanelContextMenu: function( e, t, o ) {
    	var drawingPanel = this.getDrawingPanelTarget( e );

    	if ( !Ext.isEmpty( drawingPanel ) ) {
        Ext.ux.suncode.Clipboard.getActivityFormComponents( function( cmps ) {
          if ( !Ext.isEmpty( cmps ) ) {
            var xy = e.getXY();
            var menu = new Ext.menu.Menu( {
              items: [ {
                xtype: 'menuitem',
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'add' ),
                text: getTranslation( 'Wklej komponenty' ),
                scope: this,
                handler: function() {
                  this.onPasteComponents( xy[1], cmps );
                }
              }, {
                xtype: 'menuitem',
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'add' ),
                text: getTranslation( 'Wklej specjalnie' ),
                scope: this,
                handler: function() {
                  var win = new Ext.ux.suncode.PasteSpecialWindow( {
                    pasteSpecialFunction: function( pastedComponents ) {
                      this.onPasteComponents( xy[1], cmps );
                    },
                    pasteSpecialScope: this,
                    messageType: Ext.ux.suncode.Clipboard.activityFormComponentsMessageType
                  } );
                  win.show();
                }
              } ]
            } );

            showMenu( menu, e );
          }
        }, this );
    	}
    },
    buildItems: function( activityNode, formDesignerConfig, buildConfig ) {
    	var items = new Array();
        var formTemplate = activityNode.attributes.form.template;

        if ( !Ext.isEmpty( formTemplate.rows ) ) {
            var showLines = activityNode.attributes.formStyles.showLines;
            var processVariablesCopy = [].concat( activityNode.parentNode.attributes.variables );
            var allObjectsCopy = [].concat( activityNode.attributes.form.variables ).concat( activityNode.attributes.form.httpLinks )
                            .concat( activityNode.attributes.form.buttons );
            var labelActions = activityNode.attributes.form.labelActions;
            var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        	var packageId = packageNode.attributes.packageId;
        	var processNode = activityNode.parentNode;
        	var processDefId = processNode.attributes.processDefId;
        	var activityDefId = activityNode.attributes.activityDefId;
            var translationKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')';

            for ( var i = 0; i < formTemplate.rows.length; i++ ) {
                var row = formTemplate.rows[i];
                var columnPanelItems = new Array();

                for ( var j = 0; j < row.items.length; j++ ) {
                    var item = row.items[j];
                    var objectDef = item.type == 'LABEL' ? this.getObjectDefForLabel( labelActions, item )
                    		: this.getObjectDefByIdAndType( allObjectsCopy, item.id, item.type );

                    if ( !Ext.isEmpty( objectDef ) ) {
                        var component = {
                            processVariables: processVariablesCopy,
                            item: item
                        };

                        columnPanelItems.push( this.createFormVariable( component, false, false, false, true, objectDef, formDesignerConfig,
                        		translationKeyPrefix, activityNode, buildConfig ) );
                    }
                }

                if ( !Ext.isEmpty( columnPanelItems ) ) {
                    items.push( this.executeCreateFormVariableWrapper( columnPanelItems, row.layoutPack, showLines ) );
                }
            }
        }
        
        return items;
    },
    onComponentDrop: function( dd, e, data ) {
        if ( data.panel ) {
            return this.placeComponent( data.panel, e, data.panel.isVariable, data.panel.isTable, data.panel.isLabel );
        } else if ( data.node ) {
            var node = data.node;
            var isVariable = node.attributes.isVariable;
            var isTable = node.attributes.isTable;
            var id = null;

            if ( isVariable ) {
              id = node.attributes.variable.id
            } else if ( isTable ) {
              id = node.attributes.table.id
            } else {
              id = node.attributes.label.id;
            }

            if ( isTable && this.checkTableDuplication( node.attributes.table ) ) {
              showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o ' +
                  'tym samym identyfikatorze został już dodany do formularza.' ) );
              return false;
            } else if ( !isTable && this.checkDuplication( id ) ) {
            	showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o ' +
            			'tym samym identyfikatorze został już dodany do formularza.' ) );
            	return false;
            } else {
            	var result = this.placeComponent( node, e, isVariable, node.attributes.isTable, node.attributes.isLabel );

                if ( result ) {
                	if ( isVariable ) {
                		this.getVariablesTree().markAsUsed( node.attributes.variable );
                		this.analyzeOverlays();
                	} else if ( isTable ) {
                	  var table = node.attributes.table;
                    this.getTablesTree().markAsUsed( table );
                    var processNode = this.initialConfig.activityNode.parentNode;
                    var variablesTree = this.getVariablesTree();
                    Ext.each( table.columns, function( column, index, columns ) {
                      var variable = processNode.findVariable( column.varId );
                      variablesTree.markAsUsed( variable );
                    } );
                    this.analyzeOverlays();
                  } else {
                		this.getLabelsTree().markAsUsed( node.attributes.label );
                	}
                }

                return result;
            }
        }
    },
    getVariablesTree: function() {
        return this.ownerCt.variablesTree;
    },
    getTablesTree: function() {
      return this.ownerCt.tablesTree;
    },
    getLabelsTree: function() {
        return this.ownerCt.labelsTree;
    },
    checkDuplication: function( id ) {
    	var isDuplicated = false;
    	
    	this.items.each( function( item, i, externalSize ) {
            item.items.each( function( subitem, j, internalSize ) {
            	var definition = subitem.definition;
                var objectDef = definition.objectDef;

                switch ( objectDef.genre ) {
	                case 'VARIABLE':
	                    if ( subitem.idAssigned && objectDef.varId == id ) {
	                    	isDuplicated = true;
	                        return false;
	                    }
	                    break;
                    case 'VARIABLE_SET':
                        if ( subitem.idAssigned ) {
                        	if ( objectDef.varId == id ) {
                        		isDuplicated = true;
                                return false;
                        	} else {
                        		var columns = objectDef.columns;

                                for ( var k = 0; k < columns.length; k++ ) {
                                    var column = columns[k];

                                    if ( column.varId == id ) {
                                        isDuplicated = true;
                                        return false;
                                    }
                                }
                                
                                var dtButtons = objectDef.DTButtons;

                                for ( var k = 0; k < dtButtons.length; k++ ) {
                                    var dtButton = dtButtons[k];

                                    if ( dtButton.buttonId == id ) {
                                        isDuplicated = true;
                                        return false;
                                    }
                                }
                        	}
                        }
                        break;
                    case 'LABEL':
                        if ( subitem.idAssigned && objectDef.id == id ) {
                        	isDuplicated = true;
                            return false;
                        }
                        break;
                    case 'HTTP_LINK':
                    case 'ACTION_ACCEPT_BUTTON':
                    case 'GENERATE_PDF_BUTTON':
                    case 'ADD_FILE_BUTTON':
                    case 'BARCODE_PRINT':
                        if ( subitem.idAssigned &&
                        		( objectDef.actionName == id || objectDef.actionName + '_button' == id ) ) {
                            isDuplicated = true;
                            return false;
                        }
                        break;
                    default:
                        break;
                }
            } );
            
            if ( isDuplicated ) {
                return false;
            }
        } );
    	
    	return isDuplicated;
    },
    checkTableDuplication: function( table ) {
      var presentComponentIds = this.collectPresentComponentIds();

      if ( presentComponentIds.indexOf( table.id ) != -1 ) {
        return true;
      }

      if ( !Ext.isEmpty( table.columns ) ) {
        var columns = table.columns;

        for ( var i = 0; i < columns.length; i++ ) {
          var column = columns[i];

          if ( presentComponentIds.indexOf( column.varId ) != -1 ) {
            return true;
          }
        }
      }

      if ( !Ext.isEmpty( table.DTButtons ) ) {
        var dtButtons = table.DTButtons;

        for ( var i = 0; i < dtButtons.length; i++ ) {
          var dtButton = dtButtons[i];

          if ( presentComponentIds.indexOf( dtButton.buttonId ) != -1 ) {
            return true;
          }
        }
      }

      return false;
    },
    collectPresentComponentIds: function() {
    	var ids = new Array();
    	
    	this.items.each( function( item, i, externalSize ) {
            item.items.each( function( subitem, j, internalSize ) {
            	var definition = subitem.definition;
                var objectDef = definition.objectDef;

                switch ( objectDef.genre ) {
	                case 'VARIABLE':
	                    if ( subitem.idAssigned ) {
	                    	ids.push( objectDef.varId );
	                    }
	                    break;
                    case 'VARIABLE_SET':
                        if ( subitem.idAssigned ) {
                        	ids.push( objectDef.varId );
                        	var columns = objectDef.columns;

                            for ( var k = 0; k < columns.length; k++ ) {
                                var column = columns[k];

                                ids.push( column.varId );
                            }
                            
                            var dtButtons = objectDef.DTButtons;

                            for ( var k = 0; k < dtButtons.length; k++ ) {
                                var dtButton = dtButtons[k];

                                ids.push( dtButton.buttonId );
                            }
                        }
                        break;
                    case 'LABEL':
                        if ( subitem.idAssigned ) {
                        	ids.push( objectDef.id );
                        }
                        break;
                    case 'HTTP_LINK':
                    case 'ACTION_ACCEPT_BUTTON':
                    case 'GENERATE_PDF_BUTTON':
                    case 'ADD_FILE_BUTTON':
                    case 'BARCODE_PRINT':
                        if ( subitem.idAssigned ) {
                        	ids.push( objectDef.actionName + '_button' );
                        }
                        break;
                    default:
                        break;
                }
            } );
        } );
    	
    	return ids;
    },
    placeComponent: function( component, e, isVariable, isTable, isLabel ) {
        if ( !e ) {
            this.add( this.createColumnPanel( component, isVariable, isTable, isLabel ) );
            this.doLayout();
            this.showPreviewOutOfDateMessage();
            this.storeParentWindowAsUnsaved();

            return true;
        }

        if ( component.type == 'VARIABLE_SET' && !component.idAssigned ) {
          this.createAndPlaceGlobalTable();
          return true;
        }

        var xy = e.getXY();
        var x = xy[0];
        var y = xy[1];
        var matrix = this.getPanelsMatrix();

        for ( var i = 0; i < matrix.length; i++ ) {
            var elY = matrix[i].y;
            var elHeight = matrix[i].h;

            if ( y >= elY && y < elY + elHeight ) {
                var panel = matrix[i].panel;
                var panelItems = panel.items.items;
                var textareaInLine = this.isTextareaInLine( panelItems );
                
                for ( var j = panelItems.length - 1; j >= 0; j-- ) {
                    var panelItem = panelItems[j];
                    var el = panelItem.getEl();
                    var elX = el.getX();
                    var elWidth = el.getWidth();

                    if ( elX > 0 && elWidth > 0 && x >= elX + elWidth ) {
                        if ( this.isPanelWithColumnWidth( panelItem ) || component.type == 'VARIABLE_SET'
                        		|| ( ( component.type == 'TEXTAREA' ||
                        				( isVariable && !Ext.isEmpty( component.attributes )
                        						&& component.attributes.variable.type == 'TEXTAREA' ) ) && textareaInLine ) ) {
                            showWarn( getTranslation( 'Komponent nie może zostać umieszczony w tym miejscu.' ) );
                            return false;
                        }

                        this.handleComponentExistence( component );

                        if ( component.addedToForm ) {
                            panel.insert( j + 1, component );
                        } else {
                            panel.insert( j + 1, this.createFormVariable( component, isVariable, isTable, isLabel, false ) );
                        }

                        panel.doLayout();
                        this.showPreviewOutOfDateMessage();
                        this.storeParentWindowAsUnsaved();

                        return true;
                    }
                }

                this.handleComponentExistence( component );

                if ( component.addedToForm ) {
                    this.insert( i, this.createFormVariableWrapper( component ) );
                } else {
                    this.insert( i, this.createColumnPanel( component, isVariable, isTable, isLabel ) );
                }

                this.doLayout();
                this.showPreviewOutOfDateMessage();
                this.storeParentWindowAsUnsaved();

                return true;
            }
        }

        this.handleComponentExistence( component );

        if ( component.addedToForm ) {
            this.add( this.createFormVariableWrapper( component ) );
        } else {
            this.add( this.createColumnPanel( component, isVariable, isTable, isLabel ) );
        }

        this.doLayout();
        this.showPreviewOutOfDateMessage();
        this.storeParentWindowAsUnsaved();

        return true;
    },
    createAndPlaceGlobalTable: function() {
      var processNode = this.initialConfig.activityNode.parentNode;
      var tableDefWin = new Ext.ux.suncode.GlobalGridDefWindow( {
        globalDefinition: true,
        processNode: processNode,
        beforeSaveFunction: function( tableDef ) {
          if ( this.checkDuplication( tableDef.varId ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o ' +
                'tym samym identyfikatorze został już dodany do formularza.' ) );
            return false;
          }

          var columns = tableDef.columns;
          for ( var i = 0; i < columns.length; i++ ) {
            var column = columns[i];

            if ( this.checkDuplication( column.varId ) ) {
              showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o ' +
                  'tym samym identyfikatorze został już dodany do formularza.' ) );
              return false;
            }
          }

          var dtButtons = tableDef.DTButtons;
          for ( var i = 0; i < dtButtons.length; i++ ) {
            var dtButton = dtButtons[i];

            if ( this.checkDuplication( dtButton.buttonId ) ) {
              showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o ' +
                  'tym samym identyfikatorze został już dodany do formularza.' ) );
              return false;
            }
          }

          Ext.each( tableDef.columns, function( column, index, columns ) {
            var variable = processNode.findVariable( column.varId );
            this.getVariablesTree().markAsUsed( variable );
          }, this );

          return true;
        },
        beforeSaveScope: this,
        afterSaveFunction: function( tableDef ) {
          var node = {
            attributes: {
              table: tableDef
            }
          };
          this.placeComponent( node, null, false, true, false );
        },
        afterSaveScope: this
      } );
      tableDefWin.show();
    },
    isTextareaInLine: function( panelItems ) {
    	for ( var i = 0; i < panelItems.length; i++ ) {
    		var panelItem = panelItems[i];
    		
    		if ( panelItem.type == 'TEXTAREA' ) {
    			return true;
    		}
    	}
    	
    	return false;
    },
    createColumnPanel: function( component, isVariable, isTable, isLabel ) {
        var formVariable = this.createFormVariable( component, isVariable, isTable, isLabel, false );
        return this.createFormVariableWrapper( formVariable );
    },
    createFormVariableWrapper: function( formVariable ) {
        var activityNode = this.initialConfig.activityNode;
        var showLines = activityNode.attributes.formStyles.showLines;

        return this.executeCreateFormVariableWrapper( [ formVariable ], 'start', showLines );
    },
    executeCreateFormVariableWrapper: function( items, pack, showLines ) {
        return {
            xtype: 'panel',
            border: false,
            layout: 'column',
            layoutPack: pack,
            cls: showLines ? 'x-Module-drawingPanel-columnPanel-underline x-Module-drawingPanel-columnPanel' : 'x-Module-drawingPanel-columnPanel',
            items: items,
            listeners: {
                add: function( panel ) {
                    Ext.getCmp( 'drawing_panel' ).recalculateLayoutPack( panel );
                },
                remove: function( panel ) {
                    Ext.getCmp( 'drawing_panel' ).recalculateLayoutPack( panel );
                }
            }
        };
    },
    createFormVariable: function( component, isVariable, isTable, isLabel, isLoaded, varDef, formDesignerConfig, translationKeyPrefix, activityNode, buildConfig ) {
        var config = null;
        formDesignerConfig = !Ext.isEmpty( formDesignerConfig ) ? formDesignerConfig : this.getFormDesignerConfig();
        activityNode = !Ext.isEmpty( activityNode ) ? activityNode : this.initialConfig.activityNode;

        if ( isVariable ) {
            config = this.createVariableConfig( component );
        } else if ( isTable ) {
            config = this.createTableConfig( component );
        } else if ( isLabel ) {
        	  config = this.createLabelConfig( component );
        } else if ( isLoaded ) {
            config = this.createLoadedConfig( component, varDef, translationKeyPrefix, activityNode, buildConfig );
        } else {
            config = this.createDefaultConfig( component );
        }

        var cls = 'x-Module-component-overlay-5';
        if ( formDesignerConfig.gridActive ) {
            cls += ' x-Module-drawingPanel-grid';
        }

        return {
            xtype: 'panel',
            layout: 'form',
            border: false,
            cls: cls,
            columnWidth: this.createColumnWidth( config ),
            labelWidth: config.definition.labelWidth,
            labelAlign: config.definition.labelAlign,
            definition: config.definition,
            items: config.definition,
            type: config.type,
            style: this.createStyle( component.item ),
            isVariable: isVariable || ( isLoaded && config.definition.objectDef.genre == 'VARIABLE' ),
            isTable: isTable || ( isLoaded && config.definition.objectDef.genre == 'VARIABLE_SET' ),
            isLabel: isLabel || ( isLoaded && config.definition.objectDef.genre == 'LABEL' ),
            idAssigned: isVariable || isTable || isLabel || isLoaded,
            draggable: {
                ddGroup: 'dd_component',
                insertProxy: false,
                onBeforeDrag: this.onFormElementBeforeDrag
            },
            addedToForm: true,
            isEditable: config.isEditable,
            forceHidden: config.forceHidden,
            listeners: {
                scope: this,
                render: function( panel ) {
                    var panelEl = panel.getEl();
                    panelEl.on( 'contextmenu', this.onComponentContextMenu, this, {
                        component: panel
                    } );

                    if ( panel.isEditable ) {
                        panelEl.on( 'dblclick', this.onComponentDblClick, this, {
                            component: panel
                        } );
                    }
                    
                    panelEl.on( 'click', this.onComponentClick, this, {
                        component: panel
                    } );

                    this.analyzeVariablesMissingInIntegrationComponents( panel );

                    if ( this.hasFormActions( panel ) && formDesignerConfig.integrationComponentsVisible ) {
                      this.addFormActionsOverlay( panel );
                    }
                    if ( this.hasEventActions( panel ) && formDesignerConfig.integrationComponentsVisible ) {
                      this.addEventActionsOverlay( panel );
                    }
                }
            }
        };
    },
    onFormElementBeforeDrag: function( data, e ) {
      var drawingPanel = Ext.getCmp( 'drawing_panel' );

      return !drawingPanel.isEventOnOverlay( e );
    },
    createColumnWidth: function( config ) {
        return config.type == 'VARIABLE_SET' ? 1 : null;
    },
    analyzeOverlays: function() {
      var integrationComponentsVisible = this.areIntegrationComponentsVisible();
      this.analyzeVariablesMissingInIntegrationComponents( this );

      if ( integrationComponentsVisible ) {
        this.updateFormActionsOverlay( this );
      }

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( subitem, j, internalSize ) {
          if ( subitem.definition.objectDef.genre == 'VARIABLE_SET' ) {
            var variableSet = subitem.items.first();
            var toolbar = variableSet.getBottomToolbar();
            toolbar.items.each( function( button ) {
              if ( !Ext.isEmpty( button.definition ) ) {
                this.analyzeVariablesMissingInIntegrationComponents( button );

                if ( integrationComponentsVisible && this.hasFormActions( button ) ) {
                  this.updateFormActionsOverlay( button );
                }
              }
            }, this );
          }

          this.analyzeVariablesMissingInIntegrationComponents( subitem );

          if ( integrationComponentsVisible && this.hasFormActions( subitem ) ) {
            this.updateFormActionsOverlay( subitem );
          }
        }, this );
      }, this );
    },
    analyzeVariablesMissingInIntegrationComponents: function( component ) {
      var missingVariables = Ext.ux.suncode.IntegrationComponentService.getVariablesMissingInComponents(
          component.definition.objectDef.formActions, this.presentVariableIds );
      missingVariables = missingVariables.concat( Ext.ux.suncode.IntegrationComponentService.getVariablesMissingInComponents(
          component.definition.objectDef.eventActions, this.presentVariableIds ) );

      if ( !Ext.isEmpty( missingVariables ) ) {
        var errorMessage = this.buildVariablesMissingInIntegrationComponentsMessage( missingVariables );

        if ( component.hasError ) {
          this.updateErrorOverlayTooltip( component, errorMessage );
        } else {
          component = Ext.apply( component, {
            hasError: true
          } );

          this.addErrorOverlay( component, errorMessage );
        }
      } else {
        delete component.hasError;
        this.removeErrorOverlay( component );
      }
    },
    updateErrorOverlayTooltip: function( component, message ) {
      var el = this.getOverlayReceiverEl( component );
      var overlayEl = el.down( 'div[class*=x-Module-errorOverlay]' );

      if ( overlayEl ) {
        var iconEl = overlayEl.down( 'div[class*=x-Module-formItemError]' );
        Ext.QuickTips.unregister( iconEl );
        Ext.QuickTips.register( {
          target: iconEl,
          text: message
        } );
      }
    },
    buildVariablesMissingInIntegrationComponentsMessage: function( missingVariables ) {
        var msg = getTranslation( 'Akcje formularza/Zdarzenia zawierają zmienne nieistniejące na formularzu' );
        msg += ': ';

        Ext.each( missingVariables, function( variable, index, variables ) {
          msg += '<br>- ';
          msg += getTranslation( 'akcja formularza/zdarzenie' );
          msg += ': <b>';
          msg += variable.componentId;
          msg += '</b>, ';
          msg += getTranslation( 'zmienna procesu' );
          msg += ': <b>';
          msg += variable.variableId;
          msg += '</b>';
        } );

        return msg;
    },
    addErrorOverlay: function( component, message ) {
      if ( component.definition.objectDef.genre == 'VARIABLE_SET' ) {
        component.setWidth( component.getWidth() - this.getMarginForError() );
      }
      if ( component.definition.objectDef.genre != 'FORM' ) {
        this.removeComponentOverlayClasses( component );
        component.addClass( this.getComponentClsForOverlays( component ) );
      }

      var el = this.getOverlayReceiverEl( component );
      var overlayDivEl = el.createChild( {
        tag: 'div',
        'class': 'x-Module-errorOverlay'
      } );
      var innerDivEl = overlayDivEl.createChild( {
        tag: 'div',
        'class': 'x-Module-formItemError'
      } );
      Ext.QuickTips.register( {
        target: innerDivEl,
        text: message
      } );
    },
    removeErrorOverlay: function( component ) {
      this.removeOverlay( component, 'x-Module-errorOverlay', this.getMarginForError() );
    },
    addFormActionsOverlay: function( component ) {
      this.addIntegrationComponentsOverlay( component, 'formActions',
          this.getRightPaddingForFormActionsOverlay( component ), this.onFormActionsDblClick,
          this.onFormActionsContextMenu, this.buildFormActionsOverlayTooltipMessage() );
    },
    getRightPaddingForFormActionsOverlay: function( component ) {
      var rightPadding = 5;

      if ( component.hasError ) {
        rightPadding += 19;
      }

      return rightPadding;
    },
    buildFormActionsOverlayTooltipMessage: function() {
        var msg = '<b>' + getTranslation( 'Dwuklik' ) + '</b>';
        msg += ' - ';
        msg += getTranslation( 'wyświetla tabelę akcji formularza' );
        msg += '<br>';
        msg += '<b>' + getTranslation( 'Menu kontekstowe' ) + '</b>';
        msg += ' - ';
        msg += getTranslation( 'umożliwia edycję lub usunięcie akcji formularza' );

        return msg;
    },
    analyzeFormActionsOverlay: function( component ) {
    	if ( this.areIntegrationComponentsVisible() ) {
    		if ( this.hasFormActions( component ) ) {
    			this.updateFormActionsOverlay( component );
    		} else {
    			this.removeFormActionsOverlay( component );
    		}
    	}
    },
    removeFormActionsOverlay: function( component ) {
      this.removeOverlay( component, 'x-Module-formActionsOverlay', this.getMarginForIntegrationComponents( component, 'formActions' ) );
      var overlayReceiverEl = this.getOverlayReceiverEl( component );
      var eventActionsOverlayDivEl = overlayReceiverEl.down( 'div[class*=x-Module-eventActionsOverlay]' );

      if ( !Ext.isEmpty( eventActionsOverlayDivEl ) ) {
        var eventActionsDivEl = eventActionsOverlayDivEl.down( 'div[class*=x-Module-eventActionsFormItem]' );

        if ( !Ext.isEmpty( eventActionsDivEl ) ) {
          var rightPadding = this.getRightPaddingForEventActionsOverlay( component );
          var paddingStyle = '8px ' + rightPadding + 'px 0 14px';
          eventActionsDivEl.setStyle( 'padding', paddingStyle );
        }
      }
    },
    updateFormActionsOverlay: function( component ) {
        var el = this.getOverlayReceiverEl( component );
        var spanEl = el.down( 'div[class*=x-Module-formActionsOverlay] span' );

        if ( !Ext.isEmpty( spanEl ) ) {
            var currentValue = component.definition.objectDef.formActions.length;

            if ( component.definition.objectDef.genre == 'VARIABLE_SET' ) {
              var spanElDom = Ext.getDom( spanEl );
              var previousValue = parseInt( spanElDom.innerHTML );

              if ( currentValue > 9  && previousValue <= 9 ) {
                component.setWidth( component.getWidth() - ( this.integrationComponentsLargeMargin - this.integrationComponentsMargin ) );
              } else if ( currentValue <= 9 && previousValue > 9 ) {
                component.setWidth( component.getWidth() + ( this.integrationComponentsLargeMargin - this.integrationComponentsMargin ) );
              }
            }

            spanEl.update( new String( currentValue ) );

            if ( component.definition.objectDef.genre != 'FORM' ) {
              this.removeComponentOverlayClasses( component );
              component.addClass( this.getComponentClsForOverlays( component ) );
            }

            var iconEl = spanEl.up( 'div[class*=x-Module-formActionsFormItem]' );

            if ( !Ext.isEmpty( iconEl ) ) {
              var iconElStyle = component.hasError ? '8px 24px 0 14px' : '8px 5px 0 14px';
              iconEl.setStyle( 'padding', iconElStyle );
            }
        } else {
            this.addFormActionsOverlay( component );
        }
    },
    addEventActionsOverlay: function( component ) {
      this.addIntegrationComponentsOverlay( component, 'eventActions',
          this.getRightPaddingForEventActionsOverlay( component ), this.onEventActionsDblClick,
          this.onEventActionsContextMenu, this.buildEventActionsOverlayTooltipMessage() );
    },
    getRightPaddingForEventActionsOverlay: function( component ) {
      var rightPadding = 5;

      if ( component.hasError ) {
        rightPadding += 19;
      }
      if ( !Ext.isEmpty( component.definition.objectDef.formActions )
        || component.definition.objectDef.genre == 'FORM' ) {
        rightPadding += 24;
      }

      return rightPadding;
    },
    buildEventActionsOverlayTooltipMessage: function() {
      var msg = '<b>' + getTranslation( 'Dwuklik' ) + '</b>';
      msg += ' - ';
      msg += getTranslation( 'wyświetla tabelę zdarzeń' );
      msg += '<br>';
      msg += '<b>' + getTranslation( 'Menu kontekstowe' ) + '</b>';
      msg += ' - ';
      msg += getTranslation( 'umożliwia edycję lub usunięcie zdarzenia' );

      return msg;
    },
    analyzeEventActionsOverlay: function( component ) {
      if ( this.areIntegrationComponentsVisible() ) {
        if ( this.hasEventActions( component ) ) {
          this.updateEventActionsOverlay( component );
        } else {
          this.removeEventActionsOverlay( component );
        }
      }
    },
    removeEventActionsOverlay: function( component ) {
      this.removeOverlay( component, 'x-Module-eventActionsOverlay', this.getMarginForIntegrationComponents( component, 'eventActions' ) );
    },
    updateEventActionsOverlay: function( component ) {
      var el = this.getOverlayReceiverEl( component );
      var spanEl = el.down( 'div[class*=x-Module-eventActionsOverlay] span' );

      if ( !Ext.isEmpty( spanEl ) ) {
        var currentValue = component.definition.objectDef.eventActions.length;

        if ( component.definition.objectDef.genre == 'VARIABLE_SET' ) {
          var spanElDom = Ext.getDom( spanEl );
          var previousValue = parseInt( spanElDom.innerHTML );

          if ( currentValue > 9  && previousValue <= 9 ) {
            component.setWidth( component.getWidth() - ( this.integrationComponentsLargeMargin - this.integrationComponentsMargin ) );
          } else if ( currentValue <= 9 && previousValue > 9 ) {
            component.setWidth( component.getWidth() + ( this.integrationComponentsLargeMargin - this.integrationComponentsMargin ) );
          }
        }

        spanEl.update( new String( currentValue ) );

        if ( component.definition.objectDef.genre != 'FORM' ) {
          this.removeComponentOverlayClasses( component );
          component.addClass( this.getComponentClsForOverlays( component ) );
        }

        var iconEl = spanEl.up( 'div[class*=x-Module-eventActionsFormItem]' );

        if ( !Ext.isEmpty( iconEl ) ) {
          var rightPadding = this.getRightPaddingForEventActionsOverlay( component );
          var iconElStyle = '8px ' + rightPadding + 'px 0 14px';
          iconEl.setStyle( 'padding', iconElStyle );
        }
      } else {
        this.addEventActionsOverlay( component );
      }
    },
    addIntegrationComponentsOverlay: function( component, componentType, rightPadding,
        dblClickFunction, contextMenuFunction, tooltipMessage ) {
      if ( component.definition.objectDef.genre == 'VARIABLE_SET' ) {
        component.setWidth( component.getWidth() - this.getMarginForIntegrationComponents( component, componentType ) );
      }
      if ( component.definition.objectDef.genre != 'FORM' ) {
        this.removeComponentOverlayClasses( component );
        component.addClass( this.getComponentClsForOverlays( component ) );
      }

      var el = this.getOverlayReceiverEl( component );
      var overlayDivEl = el.createChild( {
        tag: 'div',
        'class': 'x-Module-' + componentType + 'Overlay'
      } );
      var innerDivEl = overlayDivEl.createChild( {
        tag: 'div',
        'class': 'x-Module-' + componentType + 'FormItem',
        style: 'padding: 8px ' + rightPadding + 'px 0 14px;'
      } );
      var integrationComponents = component.definition.objectDef[componentType];
      innerDivEl.createChild( {
        tag: 'span',
        html: new String( integrationComponents.length )
      } );
      innerDivEl.on( 'dblclick', dblClickFunction, this, {
        component: component
      } );
      innerDivEl.on( 'contextmenu', contextMenuFunction, this, {
        component: component
      } );
      this.registerTooltipForElement( innerDivEl, tooltipMessage );

      if ( component.marked ) {
        this.updateMarkedComponentMask( component );
      }
    },
    removeOverlay: function( component, overlayCls, variableSetMargin) {
      var el = this.getOverlayReceiverEl( component );
      var overlayDivEl = el.down( 'div[class*=' + overlayCls +']' );

      if ( !Ext.isEmpty( overlayDivEl ) ) {
        overlayDivEl.remove();

        if ( component.definition.objectDef.genre == 'VARIABLE_SET' ) {
          component.setWidth( component.getWidth() + variableSetMargin );
        }
        if ( component.definition.objectDef.genre != 'FORM' ) {
          this.removeComponentOverlayClasses( component );
          component.addClass( this.getComponentClsForOverlays( component ) );
        }

        if ( component.marked ) {
          this.updateMarkedComponentMask( component );
        }
      }
    },
    getOverlayReceiverEl: function( component ) {
        if ( component.definition.objectDef.genre == 'FORM' ) {
            return this.ownerCt.getTopToolbar().getEl();
        } else {
            return component.getEl();
        }
    },
    validateMissingVariablesInIntegrationComponentParameterValue: function( value ) {
        var missingVariables = Ext.ux.suncode.IntegrationComponentService.getVariablesMissingInValue(
            '', value, this.presentVariableIds );

        if ( !Ext.isEmpty( missingVariables ) ) {
          showWarn( this.buildVariablesMissingInIntegrationComponentParameterMessage( missingVariables ) );

          return false;
        } else {
          return true;
        }
    },
    buildVariablesMissingInIntegrationComponentParameterMessage: function( missingVariables ) {
      var msg = getTranslation( 'Wartość zawiera zmienne nieistniejące na formularzu' );
      msg += ': ';

      Ext.each( missingVariables, function ( variable, index, variables ) {
        msg += '<br>- ';
        msg += variable.variableId;
      } );

      return msg;
    },
    validateVariablesInIntegrationComponent: function( formAction ) {
      return !Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponent( formAction, this.presentVariableIds );
    },
    onFormActionsDblClick: function( e, t, o ) {
        var component = o.component;
        var integrationComponentDestination = this.getIntegrationComponentDestinationForComponent( component.definition.objectDef.genre );
        var isAcceptButton = component.definition.objectDef.genre == 'ACTION_ACCEPT_BUTTON';
        var bindToValue = this.getFormActionBindToValue( component );
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var mainPanel = Ext.getCmp( 'main_panel' );
        var categories = mainPanel.getFormActionsIntegrationComponentCategories();
        var filteredCategories = Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
            categories, integrationComponentDestination, isAcceptButton );
        var windowTitle = getTranslation( 'Akcje formularza' );

        switch ( component.definition.objectDef.genre ) {
          case 'VARIABLE':
            var varId = component.definition.objectDef.varId;
            var variable = processNode.findVariable( varId );

            if ( !Ext.isEmpty( variable ) ) {
              windowTitle += ' - ' + getTranslation( 'Pole' ).toLowerCase()
                  + ' ' + variable.name;
            }
            break;
          case 'VARIABLE_SET':
            windowTitle += ' - ' + getTranslation( 'Tabela' ).toLowerCase()
                + ' ' + component.definition.objectDef.name;
            break;
          case 'HTTP_LINK':
          case 'ACTION_ACCEPT_BUTTON':
            windowTitle += ' - ' + getTranslation( 'Przycisk' ).toLowerCase()
                + ' ' + component.definition.objectDef.buttonName;
            break;
          case 'LABEL':
            windowTitle += ' - ' + getTranslation( 'Etykieta' ).toLowerCase()
                + ' ' + component.definition.objectDef.text;
            break;
          case 'DT_BUTTON':
            windowTitle += ' - ' + getTranslation( 'Przycisk tabeli' ).toLowerCase()
                + ' ' + component.definition.objectDef.name;
            break;
          default:
            break;
        }

      var win = new Ext.ux.suncode.IntegrationComponentWindow( {
            title: windowTitle,
            iconCls: 'x-Module-formActionsWindow',
            allCategories: categories,
            filteredCategories: filteredCategories,
            integrationComponentDestination: integrationComponentDestination,
            acceptButton: isAcceptButton,
            tableId: this.getTableIdForComponent( component ),
            buttonId: this.getButtonIdForComponent( component ),
            components: component.definition.objectDef.formActions,
            processNode: activityNode.parentNode,
            enableCopyPasteMenu: true,
            parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
            availableVariables: this.getPresentVariableIds(),
            getBindToFunction: function( cmp ) {
              var destination = Ext.ux.suncode.IntegrationComponentService.getDestination(
                  cmp, integrationComponentDestination, isAcceptButton );

              return !Ext.isEmpty( destination ) ? {
                id: destination.bindTo,
                value: bindToValue
              } : null;
            },
            getBindToScope: this,
            getComponentRegistrationFunction: function( id ) {
              return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
            },
            getComponentRegistrationScope: this,
            copyComponentsFunction: function( cmps ) {
              Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( cmps );
            },
            copyComponentsScope: this,
            handleCopiedComponentsFunction: function( func, scope ) {
              Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
                if ( Ext.isFunction( func ) ) {
                  var cmps = new Array();

                  if ( !Ext.isEmpty( formActions ) ) {
                    var service = Ext.ux.suncode.IntegrationComponentService;

                    Ext.each( formActions, function( cmp, index, allComponents ) {
                      var componentDef = service.getIntegrationComponent( categories, cmp.id );

                      if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, integrationComponentDestination ) ) {
                        cmps.push( cmp );
                      }
                    } );
                  }

                  scope = !Ext.isEmpty( scope ) ? scope : window;
                  func.apply( scope, [ cmps ] );
                }
              }, this );
            },
            handleCopiedComponentsScope: this,
            pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
            missingVariablesValidatorFunction: this.validateMissingVariablesInIntegrationComponentParameterValue,
            missingVariablesValidatorScope: this,
            validateFieldFunction: this.validateIntegrationComponentParameterValue,
            validateFieldScope: this,
            validateRowFunction: this.validateVariablesInIntegrationComponent,
            validateRowScope: this,
            pasteComponentsValidation: {
              func: function( variableId ) {
                var presentVariableIds = this.getPresentVariableIds();

                return presentVariableIds.includes( variableId );
              },
              scope: this,
              invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
            },
            saveFunction: function( formActions ) {
                component.definition.objectDef.formActions = formActions;

                this.analyzeVariablesMissingInIntegrationComponents( component );

                if ( !Ext.isEmpty( formActions ) || component.definition.objectDef.genre == 'FORM' ) {
                    this.updateFormActionsOverlay( component );
                } else {
                    this.removeFormActionsOverlay( component );
                }
                
                this.showPreviewOutOfDateMessage();
                this.storeParentWindowAsUnsaved();
            },
            saveScope: this,
            modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
              var formActionUpdate = {
                customDescription: extraConfig.customDescription,
                condition: condition,
                inactive: extraConfig.inactive,
                modificationDate: extraConfig.modificationDate,
                parameters: values
              };

              Ext.each( component.definition.objectDef.formActions, function( formAction, index, formActions ) {
                if ( formAction.globalId == globalId ) {
                  Ext.apply( formAction, formActionUpdate );
                }
              } );

              this.updateGlobalFormAction( component, globalId, formActionUpdate );
            },
            modifyGlobalDefinitionScope: this
        } );
        win.show();
    },
    onFormActionsContextMenu: function( e, t, o ) {
        var component = o.component;

        if ( this.hasFormActions( component ) ) {
        	var integrationComponentDestination = this.getIntegrationComponentDestinationForComponent(
        			component.definition.objectDef.genre );
            var mainPanel = Ext.getCmp( 'main_panel' );
            var processNode = this.initialConfig.activityNode.parentNode;

            var menu = new Ext.ux.suncode.IntegrationComponentContextMenu( {
                components: component.definition.objectDef.formActions,
                categories: mainPanel.getFormActionsIntegrationComponentCategories(),
                processNode: processNode,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
                destinationType: integrationComponentDestination,
                acceptButton: component.definition.objectDef.genre === 'ACTION_ACCEPT_BUTTON',
                tableId: this.getTableIdForComponent( component ),
                buttonId: this.getButtonIdForComponent( component ),
                availableVariables: this.getPresentVariableIds(),
                missingVariablesValidatorFunction: this.validateMissingVariablesInIntegrationComponentParameterValue,
                missingVariablesValidatorScope: this,
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
                getBindToFunction: function( componentDef ) {
                    var destination = Ext.ux.suncode.IntegrationComponentService.getDestination(
                    		componentDef, integrationComponentDestination );

                    return !Ext.isEmpty( destination ) ? {
                        id: destination.bindTo,
                        value: this.getFormActionBindToValue( component )
                    } : null;
                },
                getBindToScope: this,
                validateFieldFunction: this.validateIntegrationComponentParameterValue,
                validateFieldScope: this,
                editFunction: function( index, condition, values, extraConfig ) {
                    var formActions = component.definition.objectDef.formActions;
                    var formAction = formActions[index];

                    if ( !Ext.isEmpty( formAction ) ) {
                        var formActionUpdate = {
                          customDescription: extraConfig.customDescription,
                          condition: condition,
                          inactive: extraConfig.inactive,
                          modificationDate: extraConfig.modificationDate,
                          parameters: values
                        };
                        formAction = Ext.apply( formAction, formActionUpdate );

                        this.updateGlobalFormAction( component, formAction.globalId, formActionUpdate );
                        this.analyzeVariablesMissingInIntegrationComponents( component );

                        if ( !Ext.isEmpty( formActions ) || component.definition.objectDef.genre == 'FORM' ) {
                          this.updateFormActionsOverlay( component );
                        }

                        this.showPreviewOutOfDateMessage();
                        this.storeParentWindowAsUnsaved();
                    }
                },
                editScope: this,
                deleteFunction: function( index ) {
                    var formActions = component.definition.objectDef.formActions;
                    formActions.splice( index, 1 );

                    this.analyzeVariablesMissingInIntegrationComponents( component );
                    
                    if ( !Ext.isEmpty( formActions ) || component.definition.objectDef.genre == 'FORM' ) {
	                    this.updateFormActionsOverlay( component );
	                } else {
	                    this.removeFormActionsOverlay( component );
	                }
                
                    this.showPreviewOutOfDateMessage();
                    this.storeParentWindowAsUnsaved();
                },
                deleteScope: this,
                getComponentRegistrationFunction: function( id ) {
                	return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
                },
                getComponentRegistrationScope: this
            } );

            showMenu( menu, e );
        }
    },
    updateGlobalFormAction: function( component, globalId, formActionUpdate ) {
      var processNode = this.initialConfig.activityNode.parentNode;

      switch ( component.definition.objectDef.genre ) {
        case 'VARIABLE':
          var varId = component.definition.objectDef.varId;
          var variable = processNode.findVariable( varId );

          if ( !Ext.isEmpty( variable ) && !Ext.isEmpty( globalId ) ) {
            processNode.updateVariableFormAction( variable.id, globalId, formActionUpdate );
          }
          break;
        case 'VARIABLE_SET':
          var tableId = component.definition.objectDef.varId;
          var table = processNode.findTable( tableId );

          if ( !Ext.isEmpty( table ) && !Ext.isEmpty( globalId ) ) {
            processNode.updateTableFormAction( table.id, globalId, formActionUpdate );
          }
          break;
        case 'LABEL':
          var labelId = component.definition.objectDef.varId;
          var label = processNode.findLabel( labelId );

          if ( !Ext.isEmpty( label ) && !Ext.isEmpty( globalId ) ) {
            processNode.updateLabelFormAction( label.id, globalId, formActionUpdate );
          }
          break;
        default:
          break;
      }
    },
    getIntegrationComponentDestinationForComponent: function( genre ) {
        switch ( genre ) {
            case 'FORM':
                return Ext.ux.suncode.IntegrationComponentService.FORM_DESTINATION;
            case 'VARIABLE_SET':
                return Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION;
            case 'DT_BUTTON':
              return Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION;
            case 'HTTP_LINK':
            case 'ACTION_ACCEPT_BUTTON':
            	return Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION;
            case 'LABEL':
            	return Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION;
            case 'GENERATE_PDF_BUTTON':
            case 'ADD_FILE_BUTTON':
            case 'BARCODE_PRINT':
                return null;
            default:
                return Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION;
        }
    },
    onEventActionsDblClick: function( e, t, o ) {
      var component = o.component;
      var activityNode = this.initialConfig.activityNode;
      var mainPanel = Ext.getCmp( 'main_panel' );
      var eventTypes = this.getEventTypesForComponent( component.definition.objectDef.genre );
      var categories = mainPanel.getEventActionsCategories();

      var win = new Ext.ux.suncode.IntegrationComponentWindow( {
        title: getTranslation( 'Zdarzenia' ),
        iconCls: 'x-Module-eventsWindow',
        eventMode: true,
        eventTypes: eventTypes,
        allCategories: categories,
        filteredCategories: categories,
        components: component.definition.objectDef.eventActions,
        processNode: activityNode.parentNode,
        enableCopyPasteMenu: true,
        parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
        availableVariables: this.getPresentVariableIds(),
        getComponentRegistrationFunction: function( id ) {
          return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( cmps ) {
          Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( cmps );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
            if ( Ext.isFunction( func ) ) {
              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ eventActions ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType,
        missingVariablesValidatorFunction: this.validateMissingVariablesInIntegrationComponentParameterValue,
        missingVariablesValidatorScope: this,
        validateFieldFunction: this.validateIntegrationComponentParameterValue,
        validateFieldScope: this,
        validateRowFunction: this.validateVariablesInIntegrationComponent,
        validateRowScope: this,
        pasteComponentsValidation: {
          func: function( variableId ) {
            var presentVariableIds = this.getPresentVariableIds();

            return presentVariableIds.includes( variableId );
          },
          scope: this,
          invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
        },
        saveFunction: function( eventActions ) {
          component.definition.objectDef.eventActions = eventActions;

          this.analyzeVariablesMissingInIntegrationComponents( component );

          if ( !Ext.isEmpty( eventActions ) || component.definition.objectDef.genre == 'FORM' ) {
            this.updateEventActionsOverlay( component );
          } else {
            this.removeEventActionsOverlay( component );
          }

          this.showPreviewOutOfDateMessage();
          this.storeParentWindowAsUnsaved();
        },
        saveScope: this,
        modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
          var eventActionUpdate = {
            customDescription: extraConfig.customDescription,
            condition: condition,
            inactive: extraConfig.inactive,
            modificationDate: extraConfig.modificationDate,
            parameters: values
          };

          Ext.each( component.definition.objectDef.eventActions, function( eventAction, index, eventActions ) {
            if ( eventAction.globalId == globalId ) {
              Ext.apply( eventAction, eventActionUpdate );
            }
          } );

          this.updateGlobalEventAction( component, globalId, eventActionUpdate );
        },
        modifyGlobalDefinitionScope: this
      } );
      win.show();
    },
    getEventTypesForComponent: function( genre ) {
      var mainPanel = Ext.getCmp( 'main_panel' );

      switch ( genre ) {
        case 'FORM':
          return mainPanel.getEventTypesForForm();
        case 'VARIABLE_SET':
          return mainPanel.getEventTypesForVariableSet();
        case 'DT_BUTTON':
          return mainPanel.getEventTypesForDtButton();
        case 'HTTP_LINK':
          return mainPanel.getEventTypesForHttpLink();
        case 'ACTION_ACCEPT_BUTTON':
          return mainPanel.getEventTypesForAcceptButton();
        case 'LABEL':
        case 'GENERATE_PDF_BUTTON':
        case 'ADD_FILE_BUTTON':
        case 'BARCODE_PRINT':
          return new Array();
        default:
          return mainPanel.getEventTypesForVariable();
      }
    },
    onEventActionsContextMenu: function( e, t, o ) {
      var component = o.component;

      if ( this.hasEventActions( component ) ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var processNode = this.initialConfig.activityNode.parentNode;

        var menu = new Ext.ux.suncode.IntegrationComponentContextMenu( {
          components: component.definition.objectDef.eventActions,
          categories: mainPanel.getEventActionsCategories(),
          processNode: processNode,
          enableCopyPasteMenu: true,
          conditionalExecutionEnabled: true,
          inactiveEnabled: true,
          parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
          availableVariables: this.getPresentVariableIds(),
          missingVariablesValidatorFunction: this.validateMissingVariablesInIntegrationComponentParameterValue,
          missingVariablesValidatorScope: this,
          systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
          validateFieldFunction: this.validateIntegrationComponentParameterValue,
          validateFieldScope: this,
          editFunction: function( index, condition, values, extraConfig ) {
            var eventActions = component.definition.objectDef.eventActions;
            var eventAction = eventActions[index];

            if ( !Ext.isEmpty( eventAction ) ) {
              var eventActionUpdate = {
                customDescription: extraConfig.customDescription,
                condition: condition,
                inactive: extraConfig.inactive,
                modificationDate: extraConfig.modificationDate,
                parameters: values
              };
              eventAction = Ext.apply( eventAction, eventActionUpdate );

              this.updateGlobalEventAction( component, eventAction.globalId, eventActionUpdate );
              this.analyzeVariablesMissingInIntegrationComponents( component );

              if ( !Ext.isEmpty( eventActions ) || component.definition.objectDef.genre == 'FORM' ) {
                this.updateEventActionsOverlay( component );
              }

              this.showPreviewOutOfDateMessage();
              this.storeParentWindowAsUnsaved();
            }
          },
          editScope: this,
          deleteFunction: function( index ) {
            var eventActions = component.definition.objectDef.eventActions;
            var eventAction = eventActions[index];
            var eventOwnerId = eventAction.eventOwnerId;
            var hasDependentEvents = false;

            Ext.each( eventActions, function ( cmp, index, allCmp ) {
              if ( cmp.eventParentId === eventOwnerId ) {
                hasDependentEvents = true;
                return false;
              }
            } );

            if ( hasDependentEvents ) {
              Ext.ux.suncode.IntegrationComponentService.showDependentEventsRemovalWarning(
                  this.deleteEventActionWithDependencies, this, [ component, index ] );
            } else {
              eventActions.splice( index, 1 );

              this.afterDeleteEventActions( component );
            }
          },
          deleteScope: this,
          getComponentRegistrationFunction: function( id ) {
            return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
          },
          getComponentRegistrationScope: this
        } );

        showMenu( menu, e );
      }
    },
    updateGlobalEventAction: function( component, globalId, eventActionUpdate ) {
      var processNode = this.initialConfig.activityNode.parentNode;

      switch ( component.definition.objectDef.genre ) {
        case 'VARIABLE':
          var varId = component.definition.objectDef.varId;
          var variable = processNode.findVariable( varId );

          if ( !Ext.isEmpty( variable ) && !Ext.isEmpty( globalId ) ) {
            processNode.updateVariableEventAction( variable.id, globalId, eventActionUpdate );
          }
          break;
        case 'VARIABLE_SET':
          var tableId = component.definition.objectDef.varId;
          var table = processNode.findTable( tableId );

          if ( !Ext.isEmpty( table ) && !Ext.isEmpty( globalId ) ) {
            processNode.updateTableEventAction( table.id, globalId, eventActionUpdate );
          }
          break;
        default:
          break;
      }
    },
    deleteEventActionWithDependencies: function( component, index ) {
      var eventActions = component.definition.objectDef.eventActions;
      var eventOwnerId = eventActions[index].eventOwnerId;
      var convertedEvents = new Array();

      eventActions.splice( index, 1 );

      Ext.each( eventActions, function( eventAction, index, allEventAction ) {
        convertedEvents.push( {
          index: index,
          event: eventAction
        } );
      } );

      var depententEventActions = this.findDependentEventActions( convertedEvents, eventOwnerId );

      if ( !Ext.isEmpty( depententEventActions ) ) {
        depententEventActions.sort( function( a, b ) {
          return b.index - a.index;
        } );

        Ext.each( depententEventActions, function( depententEventAction, index, allDepententEventActions ) {
          eventActions.splice( depententEventAction.index, 1 );
        }, this );

        this.afterDeleteEventActions( component );
      }
    },
    findDependentEventActions: function( eventActions, eventOwnerId ) {
      var depententEventActions = new Array();
      Ext.each( eventActions, function( eventAction, index, allEventActions ) {
        if ( eventAction.event.eventParentId === eventOwnerId ) {
          depententEventActions.push( eventAction );
        }
      } );

      if ( !Ext.isEmpty( depententEventActions ) ) {
        Ext.each( depententEventActions, function( eventAction, index, allEvents ) {
          depententEventActions = depententEventActions.concat( this.findDependentEventActions( eventActions, eventAction.event.eventOwnerId ) );
        }, this );
      }

      return depententEventActions;
    },
    afterDeleteEventActions: function( component ) {
      var eventActions = component.definition.objectDef.eventActions;

      this.analyzeVariablesMissingInIntegrationComponents(component);

      if (!Ext.isEmpty(eventActions) || component.definition.objectDef.genre == 'FORM') {
        this.updateEventActionsOverlay(component);
      } else {
        this.removeEventActionsOverlay(component);
      }

      this.showPreviewOutOfDateMessage();
      this.storeParentWindowAsUnsaved();
    },
    getTableIdForComponent: function( component ) {
      switch( component.definition.objectDef.genre ) {
        case 'VARIABLE_SET':
          return component.definition.objectDef.varId;
        case 'DT_BUTTON':
          var variableSetComponent = component.ownerCt.ownerCt.ownerCt;
          return variableSetComponent.definition.objectDef.varId;
        default:
          return null;
      }
    },
    getButtonIdForComponent: function( component ) {
      switch ( component.definition.objectDef.genre ) {
        case 'HTTP_LINK':
        case 'ACTION_ACCEPT_BUTTON':
        case 'GENERATE_PDF_BUTTON':
        case 'BARCODE_PRINT':
        case 'ADD_FILE_BUTTON':
          return component.definition.objectDef.actionName;
        default:
          return null;
      }
    },
    registerTooltipForElement: function( element, message ) {
        if ( this.showTooltips ) {
            Ext.QuickTips.register( {
                target: element,
                text: message
            } );
        }
    },
    isPanelWithColumnWidth: function( panel ) {
        return ( panel.columnWidth != null );
    },
    handleComponentExistence: function( component ) {
        if ( component.addedToForm ) {
            var panel = component.ownerCt;
            panel.remove( component, false );
            var dom = component.getPositionEl().dom;
            dom.parentNode.removeChild( dom );
            panel.doLayout();

            if ( panel.items.length == 0 ) {
                this.remove( panel );
                this.doLayout();
            }
        }
    },
    getPanelsMatrix: function() {
        var matrix = new Array();

        this.items.each( function( panel ) {
            var el = panel.getEl();
            var marginTop = el.getMargins( 't' );
            var marginBotton = el.getMargins( 'b' );
            marginBotton = marginBotton < 10 ? marginBotton : 0;
            var x = el.getX();
            var y = el.getY() - marginTop;
            var w = el.getWidth();
            var h = el.getHeight() + marginTop + marginBotton;

            if ( h > 0 ) {
                matrix.push( {
                    panel: panel,
                    x: x,
                    y: y,
                    w: w,
                    h: h
                } );
            }
        } );

        return matrix;
    },
    createVariableConfig: function( component ) {
        var config = new Object();
        var definition = new Object();
        var variable = component.attributes.variable;
        var forceHidden = variable.placement === 'table';
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var globalSettings = processNode.attributes.globalSettings.formVariableLabel;
        definition = Ext.apply( {
            id: variable.id,
            fieldLabel: this.getFormVariableLabel( activityNode, variable ),
            labelAlign: globalSettings.labelAlign,
            labelWidth: Ext.ux.suncode.Constants.FIELD_DEFAULT_LABEL_WIDTH,
            labelSeparator: globalSettings.labelSeparator,
            labelFontSize: globalSettings.labelFontSize,
            labelColor: globalSettings.labelColor,
            textDecoration: globalSettings.textDecoration,
            hideLabel: false,
            marginTop: null,
            marginRight: null,
            marginBottom: null,
            marginLeft: null,
            width: Ext.ux.suncode.Constants.FIELD_DEFAULT_WIDTH
        }, definition );

        switch ( variable.type ) {
            case 'STRING':
                definition = Ext.apply( {
                    xtype: 'textfield',
                    inputType: 'text',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'INTEGER':
                definition = Ext.apply( {
                    xtype: 'numberfield',
                    allowDecimals: false,
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'FLOAT':
                definition = Ext.apply( {
                    xtype: 'numberfield',
                    allowDecimals: true,
                    decimalSeparator: ',',
                    decimalPrecision: 5,
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'AMOUNT':
            	definition = Ext.apply( {
                    xtype: 'numberfield',
                    allowDecimals: true,
                    decimalSeparator: ',',
                    decimalPrecision: 2,
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'DATE':
                definition = Ext.apply( {
                    xtype: 'datefield',
                    format: 'Y-m-d',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    triggerClass: 'dvnt-icon-calendar-normal',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'DATETIME':
                definition = Ext.apply( {
                    xtype: 'datefield',
                    format: 'Y-m-d H:i:s',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    triggerClass: 'dvnt-icon-time',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'TEXTAREA':
                definition = Ext.apply( {
                    xtype: 'textarea',
                    height: 100,
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'RADIOBUTTON':
                definition = Ext.apply( {
                    xtype: 'radiogroup',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    defaults: {
                        listeners: {
                            check: function( field, checked ) {
                                field.setValue( false );
                            }
                        }
                    },
                    items: this.createRadioCheckItems( variable )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'CHECKBOX':
                definition = Ext.apply( {
                    xtype: 'checkboxgroup',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    defaults: {
                        listeners: {
                            check: function( field, checked ) {
                                field.setValue( false );
                            }
                        }
                    },
                    items: this.createRadioCheckItems( variable )
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'BOOLEAN':
                definition = Ext.apply( {
                    xtype: 'checkbox',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    listeners: {
                        check: function( field, checked ) {
                            field.setValue( false );
                        }
                    }
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'LISTBOX':
            case 'LISTBOX_EDIT':
            case 'LISTBOX_NO_FILTER':
            case 'LISTBOX_EDIT_NO_FILTER':
            case 'LISTBOX_NO_LAZY':
            case 'LISTBOX_NO_FILTER_NO_LAZY':
            case 'USERLISTLISTBOX':
            case 'ROLEUSERS':
            case 'ROLEUSERS_NO_FILTER':
                definition = Ext.apply( {
                    xtype: 'combo',
                    store: new Ext.data.Store( {} ),
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    triggerClass: this.resolveComboboxTriggerClass( variable ),
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'DATA_CHOOSER':
            	if ( variable.sort === 'window' && variable.fieldType === 'textarea' ) {
            		definition = Ext.apply( {
                        xtype: 'compositefield',
                        items: [ {
                        	xtype: 'textarea',
                        	flex: 1,
                            height: 100
                        }, {
                            xtype: 'button',
                            cls: 'x-btn-icon',
                            iconCls: 'dvnt-icon-modules',
                            flex: 0
                        } ]
                    }, definition );
            	} else {
            		definition = Ext.apply( {
                        xtype: 'combo',
                        store: new Ext.data.Store( {} ),
                        itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                        labelStyle: this.createLabelStyle( {
                        	labelFontSize: globalSettings.labelFontSize,
                            labelColor: globalSettings.labelColor,
                            textDecoration: globalSettings.textDecoration
                        } ),
                        triggerClass: this.resolveComboboxTriggerClass( variable ),
                        onTriggerClick: function() {
                            return false;
                        }
                    }, definition );
            	}
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            case 'USERLIST':
                definition = Ext.apply( {
                    xtype: 'trigger',
                    itemCls: forceHidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    triggerClass: 'dvnt-icon-users',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                definition = this.initVarDefInDefinition( definition, variable, forceHidden );
                break;
            default:
                break;
        }
        
        config = Ext.apply( {
            type: variable.type,
            isEditable: true,
            forceHidden: forceHidden,
            definition: definition
        }, config );

        return config;
    },
    createRadioCheckItems: function( variable ) {
        var items = new Array();

        Ext.each( variable.valuesList, function( v, i, all ) {
            items.push( {
                boxLabel: v.value,
                name: variable.id,
                inputValue: i
            } );
        } );

        return items;
    },
    initVarDefInDefinition: function( definition, variable, forceHidden ) {
        var objectDef = {
            type: variable ? variable.type : '',
            varId: variable ? variable.id : '',
            name: variable ? variable.name : '',
            hidden: forceHidden,
            editable: true,
            autoUpdates: new Array(),
            formActions: variable ? variable.formActions : new Array(),
            eventActions: variable ? variable.eventActions : new Array(),
            genre: 'VARIABLE'
        };
        
        switch( objectDef.type ) {
	        case 'TEXTAREA':
	        	objectDef = Ext.apply( {
            		height: 100
                }, objectDef );
	        	break;
	        case 'ROLEUSERS':
	        case 'ROLEUSERS_NO_FILTER':
	        	var activityNode = this.initialConfig.activityNode;
	        	
	        	objectDef = Ext.apply( {
            		roleusersFilters: [ {
            			type: 'role',
            			value: activityNode.attributes.roleId
            		} ],
                roleusersConjunction: false
                }, objectDef );
	        	break;
        	default:
        		break;
        }

        definition = Ext.apply( {
            objectDef: objectDef
        }, definition );

        return definition;
    },
    initGridDefInDefinition: function( definition ) {
        definition = Ext.apply( {
            objectDef: this.initGridObjectDef()
        }, definition );

        return definition;
    },
    initGridObjectDef: function() {
      var processNode = this.initialConfig.activityNode.parentNode;
      var globalSettings = processNode.attributes.globalSettings.variableSetFont;

      return {
        varId: generateId( 'variable_set_' + Ext.id() ),
        name: '',
        columns: new Array(),
        editable: true,
        local: 'DEFAULT',
        collapsible: true,
        stateful: true,
        autoHeight: false,
        autoHeightMin: '',
        autoHeightMax: '',
        clicksToEdit: 2,
        showDeleteConfirmation: false,
        hideRowNumber: false,
        headerFontSize: globalSettings.headerFontSize,
        cellFontSize: globalSettings.cellFontSize,
        actions: new Array(),
        groupers: new Array,
        DTButtons: new Array(),
        formActions: new Array(),
        eventActions: new Array(),
        translations: new Object(),
        genre: 'VARIABLE_SET'
      };
    },
    initHttpLinkDefInDefinition: function( definition ) {
        var objectDef = {
            actionName: '',
            buttonName: '',
            destination: 'TASKFORM',
            type: '',
            url: '',
            saveForm: false,
            icon: '',
            color: '',
            params: new Array(),
            formActions: new Array(),
            eventActions: new Array(),
            translations: new Object(),
            genre: 'HTTP_LINK'
        };

        definition = Ext.apply( {
        	translations: new Object(),
            objectDef: objectDef
        }, definition );

        return definition;
    },
    initButtonDefInDefinition: function( definition, buttonType ) {
        var objectDef = null;

        switch ( buttonType ) {
            case 'ACTION_ACCEPT_BUTTON':
                objectDef = {
                    actionName: '',
                    buttonName: '',
                    jsAction: '',
                    checkForm: false,
                    saveBeforeAccept: false,
                    destination: '',
                    forwardTo: '',
                    icon: '',
                    color: '',
                    acceptConcurrently: '',
                    nextActivity: '',
                    acceptedNextActivities: new Array(),
                    filled: false,
                    hideFrame: false,
                    width: null,
                    height: null,
                    actions: new Array(),
                    dcIncludes: new Array(),
                    dcExcludes: new Array(),
                    validators: new Array(),
                    oldValidators: new Array(),
                    validatorsTemplates: new Array(),
                    variablesSetters: new Array(),
                    oldVariablesSetters: new Array(),
                    variablesSettersTemplates: new Array(),
                    formActions: new Array(),
                    eventActions: new Array(),
                    translations: new Object(),
                    genre: buttonType
                };
                break;
            case 'GENERATE_PDF_BUTTON':
                objectDef = {
                    actionName: '',
                    buttonName: '',
                    docClassName: '',
                    templateName: '',
                    color: '',
                    checkForm: false,
                    translations: new Object(),
                    genre: buttonType
                };
                break;
            case 'ADD_FILE_BUTTON':
                objectDef = {
                    actionName: '',
                    buttonName: '',
                    icon: '',
                    color: '',
                    docClassName: '',
                    checkForm: false,
                    sourceName: 'addFile',
                    translations: new Object(),
                    genre: buttonType
                };
                break;
            case 'BARCODE_PRINT':
                objectDef = {
                    actionName: '',
                    buttonName: '',
                    labelPath: '',
                    labelTextVar: '',
                    color: '',
                    checkForm: false,
                    genre: buttonType
                };
                break;
            default:
                objectDef = new Object();
        }

        definition = Ext.apply( {
            objectDef: objectDef
        }, definition );

        return definition;
    },
    createTableConfig: function( component ) {
      var config = new Object();
      var definition = new Object();
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var packageNode = processNode.parentNode;
      var packageId = packageNode.attributes.packageId;
      var processDefId = processNode.attributes.processDefId;
      var activityDefId = activityNode.attributes.activityDefId;
      var table = component.attributes.table;
      var objectDef = this.initGridObjectDef();
      objectDef = Ext.apply( objectDef, deepObjectCopy( table ) );
      objectDef = Ext.apply( objectDef, {
        varId: table.id,
        type: 'VARIABLE_SET'
      } );
      delete objectDef.id;

      var translationRegex = 'PROC(' + processDefId + ')_TABLE(' + table.id +')';
      var translationReplacement = 'PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET(' + table.id +')';

      Ext.iterate( objectDef.translations, function( key, packageTranslation, object ) {
        var newKey = key.replaceAll( translationRegex, translationReplacement );
        object[newKey] = packageTranslation;
        delete object[key];
      } );

      var tableSpecification = Ext.ux.suncode.DocumentationService.getTableSpecification( processNode, table.id );
      Ext.ux.suncode.DocumentationService.addFormVariableSpecification( activityNode, table.id, tableSpecification );

      var columns = new Array();
      columns.push( new Ext.grid.RowNumberer( {
        hidden: objectDef.hideRowNumber
      } ) );
      var toolbarItems = this.initDefaultVariableSetButtons();

      Ext.each( objectDef.columns, function( col, index, cols ) {
        var variable = processNode.findVariable( col.varId );
        var header = '<center>' + this.getVariableSetHeader( activityNode, variable, objectDef.headerFontSize ) + '</center>';

        Ext.apply( col, {
          differentHidden: false,
          differentReadonly: false
        } );

        columns.push( {
          id: variable.id,
          header: header,
          dataIndex: variable.id,
          hidden: col.hidden,
          customWidth: variable.dtSize ? variable.dtSize : undefined
        } );
      }, this );

      Ext.each( objectDef.DTButtons, function( btn, index, btns ) {
        var btnCls = '';

        if ( !Ext.isEmpty( btn.name ) && !Ext.isEmpty( btn.icon ) ) {
          btnCls = 'x-btn-text-icon';
        } else if ( !Ext.isEmpty( btn.name ) ) {
          btnCls = 'x-btn-text';
        } else {
          btnCls = 'x-btn-icon';
        }

        btnCls += ' dvnt-pwe-dt-button ' + Ext.ux.suncode.UtilService.resolveDtButtonColorCls( btn.color );

        toolbarItems.push( {
          xtype: 'panel',
          layout: 'form',
          border: false,
          cls: 'x-Module-dtButton-container',
          items: [ {
            xtype: 'button',
            cls: btnCls,
            iconCls: Ext.ux.suncode.UtilService.resolveIconCls( btn.icon ),
            text: getXpdlVariableSetDtButtonNameTranslation(
                packageId, processDefId, activityDefId, table.id, btn.buttonId, btn.name ),
            tooltip: btn.tooltip
          } ],
          definition: {
            objectDef: btn
          },
          listeners: {
            scope: this,
            render: function( panel ) {
              var panelEl = panel.getEl();
              panelEl.on( 'contextmenu', this.onDtButtonContextMenu, this, {
                component: panel
              } );
              panelEl.on( 'dblclick', this.onDtButtonDblClick, this, {
                component: panel
              } );

              this.analyzeVariablesMissingInIntegrationComponents( panel );

              if ( this.hasFormActions( panel ) && this.integrationComponentsVisible ) {
                this.addFormActionsOverlay( panel );
              }
              if ( this.hasEventActions( panel ) && this.integrationComponentsVisible ) {
                this.addEventActionsOverlay( panel );
              }
            }
          }
        } );

        Ext.iterate( btn.translations, function( key, packageTranslation, object ) {
          var newKey = key.replaceAll( translationRegex, translationReplacement );
          object[newKey] = packageTranslation;
          delete object[key];
        } );

        var tableButtonSpecification = Ext.ux.suncode.DocumentationService.getTableButtonSpecification( processNode, btn.buttonId );
        Ext.ux.suncode.DocumentationService.addDtButtonSpecification( activityNode, btn.buttonId, tableButtonSpecification );
      }, this );

      if ( !Ext.isEmpty( objectDef.dtButtonsFillPosition ) ) {
        toolbarItems.splice( objectDef.dtButtonsFillPosition + 3, 0, {
          xtype: 'tbfill',
          isFill: true
        } );
      }

      definition = Ext.apply( {
        xtype: 'grid',
        title: getXpdlVariableSetTitleTranslation( packageId, processDefId, activityDefId, table.id, objectDef.name ),
        height: 250,
        frame: false,
        cls: 'variable-set-grid',
        header: true,
        store: new Ext.data.Store( {} ),
        objectDef: objectDef,
        colModel: new Ext.grid.ColumnModel( {
          defaults: {
            sortable: false,
            menuDisabled: true
          },
          columns: columns
        } ),
        view: new Ext.grid.GridView( {
          autoFill: true,
          forceFit: true
        } ),
        columnLines: true,
        enableColumnResize: false,
        tools: this.buildVariableSetTools( objectDef.collapsible ),
        bbar: new Ext.Toolbar( {
          hidden: !objectDef.editable,
          items: toolbarItems
        } ),
        listeners: {
          columnmove: this.onVariableSetColumnMove
        }
      }, definition );

      config = Ext.apply( {
        type: 'VARIABLE_SET',
        definition: definition,
        isEditable: true
      }, config );

      return config;
    },
    buildVariableSetTools: function( collapsible ) {
      var tools = new Array();
      tools.push( {
        id: 'refresh',
        qtip: getTranslation( 'Przywróć domyślne ustawienia tabeli' )
      } );
      tools.push( {
        id: 'maximize',
        qtip: getTranslation( 'Maksymalizuj tabelę' )
      } );
      if ( collapsible ) {
        tools.push( {
          id: 'toggle',
          qtip: getTranslation( 'Zwiń/Rozwiń tabelę' )
        } );
      }

      return tools;
    },
    createLabelConfig: function( component ) {
        var config = new Object();
        var definition = new Object();
        var label = component.attributes.label;
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var globalSettings = processNode.attributes.globalSettings.formVariableLabel;
        
        definition = Ext.apply( {
            xtype: 'label',
            text: getXpdlLabelNameTranslation( packageId, processDefId, label.id, label.name ),
            style: {
                fontSize: globalSettings.labelFontSize + 'px',
                color: globalSettings.labelColor
            }
        }, definition );
        definition = this.initLabelDefInDefinition( definition, label );
        
        config = Ext.apply( {
            type: 'LABEL',
            definition: definition,
            isEditable: true
        }, config );

        return config;
    },
    initLabelDefInDefinition: function( definition, label ) {
    	  var processNode = this.initialConfig.activityNode.parentNode;
        var globalSettings = processNode.attributes.globalSettings.formVariableLabel;
        var objectDef = {
            id: label ? label.id : generateId( 'label_' + Ext.id() ),
            text: label ? label.name : getTranslation( 'Etykieta' ),
            fontSize: globalSettings.labelFontSize,
            color: globalSettings.labelColor,
            marginTop: null,
            marginRight: null,
            marginBottom: null,
            marginLeft: null,
            formActions: label ? label.formActions : new Array(),
            eventActions: new Array(),
            genre: 'LABEL'
        };

        definition = Ext.apply( {
            objectDef: objectDef
        }, definition );

        return definition;
    },
    createDefaultConfig: function( component ) {
        var config = new Object();
        var definition = new Object();
        var isEditable = true;
        var processNode = this.initialConfig.activityNode.parentNode;
        var globalSettings = processNode.attributes.globalSettings.formVariableLabel;

        switch ( component.type ) {
            case 'STRING':
                definition = Ext.apply( {
                    xtype: 'textfield',
                    inputType: 'text',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'INTEGER':
                definition = Ext.apply( {
                    xtype: 'numberfield',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    allowDecimals: false
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'FLOAT':
                definition = Ext.apply( {
                    xtype: 'numberfield',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    allowDecimals: true,
                    decimalSeparator: ',',
                    decimalPrecision: 5
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'AMOUNT':
                definition = Ext.apply( {
                    xtype: 'numberfield',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    allowDecimals: true,
                    decimalSeparator: ',',
                    decimalPrecision: 2
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'DATE':
                definition = Ext.apply( {
                    xtype: 'datefield',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    format: 'Y-m-d',
                    triggerClass: 'dvnt-icon-calendar-normal',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'DATETIME':
                definition = Ext.apply( {
                    xtype: 'datefield',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    format: 'Y-m-d H:i:s',
                    triggerClass: 'dvnt-icon-time',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'TEXTAREA':
                definition = Ext.apply( {
                    xtype: 'textarea',
                    itemCls: 'x-Module-form-text-area-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    height: 100
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'RADIOBUTTON':
                definition = Ext.apply( {
                    xtype: 'radiogroup',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    defaults: {
                        listeners: {
                            check: function( field, checked ) {
                                field.setValue( false );
                            }
                        }
                    },
                    items: [ {
                        boxLabel: 'A',
                        name: 'radiobutton-' + Ext.id(),
                        inputValue: 0
                    } ]
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'CHECKBOX':
                definition = Ext.apply( {
                    xtype: 'checkboxgroup',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    defaults: {
                        listeners: {
                            check: function( field, checked ) {
                                field.setValue( false );
                            }
                        }
                    },
                    items: [ {
                        boxLabel: 'A',
                        name: 'checkboxgroup-' + Ext.id(),
                        inputValue: 0
                    } ]
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'BOOLEAN':
                definition = Ext.apply( {
                    xtype: 'checkbox',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    listeners: {
                        check: function( field, checked ) {
                            field.setValue( false );
                        }
                    }
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'DATA_CHOOSER':
            case 'LISTBOX':
            case 'LISTBOX_NO_FILTER':
                definition = Ext.apply( {
                    xtype: 'combo',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    store: new Ext.data.Store( {} ),
                    triggerClass: 'x-Module-combobox-field-trigger',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'USERLIST':
                definition = Ext.apply( {
                    xtype: 'trigger',
                    itemCls: 'x-Module-form-field-margins',
                    fieldLabel: '######',
                    labelStyle: this.createLabelStyle( {
                    	labelFontSize: globalSettings.labelFontSize,
                        labelColor: globalSettings.labelColor,
                        textDecoration: globalSettings.textDecoration
                    } ),
                    labelAlign: globalSettings.labelAlign,
                    labelWidth: globalSettings.labelWidth,
                    labelSeparator: globalSettings.labelSeparator,
                    labelFontSize: globalSettings.labelFontSize,
                    labelColor: globalSettings.labelColor,
                    textDecoration: globalSettings.textDecoration,
                    hideLabel: false,
                    triggerClass: 'dvnt-icon-users',
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                definition = this.initVarDefInDefinition( definition, null, false );
                break;
            case 'VARIABLE_SET':
                definition = Ext.apply( {
                    xtype: 'grid',
                    title: '',
                    height: 250,
                    frame: false,
                    cls: 'variable-set-grid',
                    header: true,
                    store: new Ext.data.Store( {} ),
                    colModel: new Ext.grid.ColumnModel( {
                        defaults: {
                            sortable: false,
                            menuDisabled: true
                        },
                        columns: []
                    } ),
                    view: new Ext.grid.GridView( {
                    	autoFill: true,
                    	forceFit: true
                    } ),
                    columnLines: true,
                    enableColumnResize: false,
                    tools: this.buildVariableSetTools( true ),
                    bbar: new Ext.Toolbar( {
                        items: this.initDefaultVariableSetButtons()
                    } ),
                    listeners: {
                        columnmove: this.onVariableSetColumnMove
                    }
                }, definition );
                isEditable = true;
                definition = this.initGridDefInDefinition( definition );
                break;
            case 'HTTP_LINK':
                definition = Ext.apply( {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button',
                    text: getTranslation( 'Przycisk' )
                }, definition );
                isEditable = true;
                definition = this.initHttpLinkDefInDefinition( definition );
                break;
            case 'ACTION_ACCEPT_BUTTON':
                definition = Ext.apply( {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button',
                    text: getTranslation( 'Przycisk' )
                }, definition );
                isEditable = true;
                definition = this.initButtonDefInDefinition( definition, component.type );
                break;
            case 'GENERATE_PDF_BUTTON':
                definition = Ext.apply( {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button',
                    text: getTranslation( 'Przycisk' )
                }, definition );
                isEditable = true;
                definition = this.initButtonDefInDefinition( definition, component.type );
                break;
            case 'ADD_FILE_BUTTON':
                definition = Ext.apply( {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button',
                    text: getTranslation( 'Przycisk' )
                }, definition );
                isEditable = true;
                definition = this.initButtonDefInDefinition( definition, component.type );
                break;
            case 'BARCODE_PRINT':
                definition = Ext.apply( {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button',
                    text: getTranslation( 'Przycisk' )
                }, definition );
                isEditable = true;
                definition = this.initButtonDefInDefinition( definition, component.type );
                break;
            case 'LABEL':
                definition = Ext.apply( {
                    xtype: 'label',
                    text: '######',
                    style: {
                        fontSize: globalSettings.labelFontSize + 'px',
                        color: globalSettings.labelColor
                    }
                }, definition );
                isEditable = true;
                definition = this.initLabelDefInDefinition( definition, null );
            default:
                break;
        }

        config = Ext.apply( {
            type: component.type,
            definition: definition,
            isEditable: isEditable
        }, config );

        return config;
    },
    initDefaultVariableSetButtons: function() {
      return [ {
        xtype: 'panel',
        layout: 'form',
        border: false,
        cls: 'x-Module-dtButton-container',
        items: [ {
          xtype: 'button',
          cls: 'x-btn-text-icon',
          iconCls: 'dvnt-icon-plus-circle',
          text: getTranslation( 'Dodaj wiersz' ),
          tooltip: getTranslation( 'Dodaje jeden pusty wiersz' )
        } ]
      }, {
        xtype: 'panel',
        layout: 'form',
        border: false,
        cls: 'x-Module-dtButton-container',
        items: [ {
          xtype: 'button',
          cls: 'x-btn-text-icon',
          iconCls: 'dvnt-icon-minus-circle',
          text: getTranslation( 'Usuń wiersz' ),
          tooltip: getTranslation( 'Usuwa aktualnie wybrany wiersz' ),
          disabled: true
        } ]
      }, {
        xtype: 'panel',
        layout: 'form',
        border: false,
        cls: 'x-Module-dtButton-container',
        items: [ {
          xtype: 'button',
          cls: 'x-btn-text-icon',
          iconCls: 'dvnt-icon-copy',
          icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/page_copy.png',
          text: getTranslation( 'Kopiuj wiersz' ),
          tooltip: getTranslation( 'Kopiuje aktualnie wybrany wiersz i dodaje go' ),
          disabled: true
        } ]
      } ];
    },
    createLoadedConfig: function( component, objectDef, translationKeyPrefix, activityNode, buildConfig ) {
        var config = new Object();
        var item = component.item;
        var processVariable = null;
        var definition = new Object();
        var isEditable = true;
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var activityDefId = activityNode.attributes.activityDefId;
        var hideHiddenVariables = buildConfig ? buildConfig.hideHiddenVariables : false;

        switch ( item.type ) {
            case 'STRING':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'textfield' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'INTEGER':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'numberfield' ),
                    id: item.id,
                    allowDecimals: false,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'FLOAT':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'numberfield' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    allowDecimals: true,
                    decimalSeparator: ',',
                    decimalPrecision: 5,
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'AMOUNT':
            	processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'numberfield' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    allowDecimals: true,
                    decimalSeparator: ',',
                    decimalPrecision: 2,
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'DATE':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'datefield' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    format: 'Y-m-d',
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    triggerClass: 'dvnt-icon-calendar-normal',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef,
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                break;
            case 'DATETIME':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'datefield' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    format: 'Y-m-d H:i:s',
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    triggerClass: 'dvnt-icon-time',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef,
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                break;
            case 'TEXTAREA':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'textfield' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-text-area-margins' :
                    	'x-Module-form-text-area-margins',
                    height: item.height ? item.height : 100,
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'RADIOBUTTON':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: 'radiogroup',
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    defaults: {
                        listeners: {
                            check: function( field, checked ) {
                                field.setValue( false );
                            }
                        }
                    },
                    items: this.createRadioCheckItems( processVariable ),
                    disabled: !objectDef.editable,
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'CHECKBOX':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: 'checkboxgroup',
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    defaults: {
                        listeners: {
                            check: function( field, checked ) {
                                field.setValue( false );
                            }
                        }
                    },
                    items: this.createRadioCheckItems( processVariable ),
                    disabled: !objectDef.editable,
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'BOOLEAN':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: 'checkbox',
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    listeners: {
                        check: function( field, checked ) {
                            field.setValue( false );
                        }
                    },
                    disabled: !objectDef.editable,
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'LISTBOX':
            case 'LISTBOX_EDIT':
            case 'LISTBOX_NO_FILTER':
            case 'LISTBOX_EDIT_NO_FILTER':
            case 'LISTBOX_NO_LAZY':
            case 'LISTBOX_NO_FILTER_NO_LAZY':
            case 'USERLISTLISTBOX':
            case 'ROLEUSERS':
            case 'ROLEUSERS_NO_FILTER':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'combo' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    store: new Ext.data.Store( {} ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    triggerClass: this.resolveComboboxTriggerClass( processVariable ),
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef,
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                break;
            case 'DATA_CHOOSER':
                objectDef = this.mergeObjectDefAndItem( objectDef, item );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    hidden: hideHiddenVariables && objectDef.hidden,
                    objectDef: objectDef
                }, definition );

                if ( objectDef.editable && processVariable.sort === 'window' && processVariable.fieldType === 'textarea' ) {
                	definition = Ext.apply( {
                        xtype: 'compositefield',
                        items: [ {
                        	xtype: 'textarea',
                        	flex: 1,
                            height: 100
                        }, {
                            xtype: 'button',
                            cls: 'x-btn-icon',
                            iconCls: 'dvnt-icon-modules',
                            flex: 0
                        } ]
                    }, definition );
                } else {
                	definition = Ext.apply( {
                		xtype: this.getFormVariableXtype( objectDef.editable, 'combo' ),
                		store: new Ext.data.Store( {} ),
                		triggerClass: this.resolveComboboxTriggerClass( processVariable ),
                		onTriggerClick: function() {
                            return false;
                        }
                    }, definition );
                }
                
                isEditable = true;
                break;
            case 'USERLIST':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
                processVariable = this.getProcessVariableById( component.processVariables, item.id );

                definition = Ext.apply( {
                    xtype: this.getFormVariableXtype( objectDef.editable, 'trigger' ),
                    id: item.id,
                    fieldLabel: this.getFormVariableLabel( activityNode, processVariable ),
                    labelStyle: this.createLabelStyle( item ),
                    labelAlign: item.labelAlign,
                    labelWidth: this.getFormVariableLabelWidth(item),
                    labelSeparator: item.labelSeparator,
                    labelFontSize: item.labelFontSize,
                    labelColor: item.labelColor,
                    textDecoration: item.textDecoration,
                    hideLabel: item.hideLabel,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    itemCls: objectDef.hidden ? 'x-Module-hiddenFormObject x-Module-form-field-margins' : 'x-Module-form-field-margins',
                    triggerClass: 'dvnt-icon-users',
                    value: this.getFormVariableValue( objectDef.editable ),
                    width: this.getFormVariableWidth(item),
                    objectDef: objectDef,
                    hidden: hideHiddenVariables && objectDef.hidden,
                    onTriggerClick: function() {
                        return false;
                    }
                }, definition );
                isEditable = true;
                break;
            case 'VARIABLE_SET':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );

                var variableSetColumns = new Array();
                variableSetColumns.push( new Ext.grid.RowNumberer( {
                  hidden: objectDef.hideRowNumber
                } ) );
                var toolbarItems = this.initDefaultVariableSetButtons();
                var table = processNode.findTable( objectDef.varId );

                Ext.each( objectDef.columns, function( col, index, cols ) {
                    var variable = processNode.findVariable( col.varId );
                    var header = '<center>' + this.getVariableSetHeader( activityNode, variable, objectDef.headerFontSize ) + '</center>';

                    variableSetColumns.push( {
                        id: variable.id,
                        header: header,
                        dataIndex: variable.id,
                        hidden: col.hidden,
                        customWidth: variable.dtSize ? variable.dtSize : undefined
                    } );
                }, this );

                Ext.each( objectDef.DTButtons, function( btn, index, btns ) {
                  var btnNameTranslation = '';
                  var nameTranslationKey = Ext.ux.suncode.I18NService.getXpdlVariableSetDtButtonNameTranslationKey(
                      packageId, processDefId, activityDefId, objectDef.varId, btn.buttonId );
                  var btnNameTranslations = btn.translations[nameTranslationKey];

                  if ( !Ext.isEmpty( btnNameTranslations ) ) {
                    var xpdlTranslationLanguage = Ext.ux.suncode.I18NService.getXpdlTranslationLanguage();

                    btnNameTranslation = btnNameTranslations[xpdlTranslationLanguage];
                  }

                  if ( Ext.isEmpty( btnNameTranslation ) ) {
                    btnNameTranslation = getXpdlVariableSetDtButtonNameTranslation(
                        packageId, processDefId, activityDefId, objectDef.varId, btn.buttonId, btn.name );
                  }

                  toolbarItems.push( this.createDtButton( btn, btnNameTranslation ) );
                }, this );

                if ( !Ext.isEmpty( objectDef.dtButtonsFillPosition ) ) {
                  toolbarItems.splice( objectDef.dtButtonsFillPosition + 3, 0, {
                    xtype: 'tbfill',
                    isFill: true
                  } );
                }

                var title = '';
                var iconCls = '';

                if ( !Ext.isEmpty( table ) ) {
                  title = getXpdlVariableSetTitleTranslation( packageId, processDefId, activityDefId, table.id, objectDef.name );

                  if ( objectDef.editable ) {
                    iconCls = 'x-Module-tableGlobalEditable';
                  } else {
                    iconCls = 'x-Module-tableGlobalReadonly';
                  }
                } else {
                  title = objectDef.name;

                  if ( objectDef.editable ) {
                    iconCls = 'x-Module-tableLocalEditable';
                  } else {
                    iconCls = 'x-Module-tableLocalReadonly';
                  }
                }

                definition = Ext.apply( {
                    xtype: 'grid',
                    title: title,
                    height: 250,
                    frame: false,
                    cls: 'variable-set-grid',
                    header: true,
                    store: new Ext.data.Store( {} ),
                    objectDef: objectDef,
                    colModel: new Ext.grid.ColumnModel( {
                        defaults: {
                            sortable: false,
                            menuDisabled: true
                        },
                        columns: variableSetColumns
                    } ),
                    view: new Ext.grid.GridView( {
                    	autoFill: true,
                    	forceFit: true
                    } ),
                    columnLines: true,
                    enableColumnResize: false,
                    tools: this.buildVariableSetTools( objectDef.collapsible ),
                    bbar: new Ext.Toolbar( {
                        hidden: !objectDef.editable,
                        items: toolbarItems
                    } ),
                    listeners: {
                        columnmove: this.onVariableSetColumnMove
                    }
                }, definition );
                isEditable = true;
                break;
            case 'HTTP_LINK':
                objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );

                definition = Ext.apply( {
                    xtype: 'button',
                    cls: 'x-btn-text dvnt-pwe-form-button ' + Ext.ux.suncode.UtilService.resolveFormButtonColorCls(objectDef.color),
                    text: getXpdlHttpLinkNameTranslation ( packageId, processDefId, activityDefId, objectDef.buttonName, objectDef.buttonName ),
                    iconCls: Ext.ux.suncode.UtilService.resolveIconCls( objectDef.icon ),
                    objectDef: objectDef
                }, definition );
                isEditable = true;
                break;
            case 'ACTION_ACCEPT_BUTTON':
                definition = this.createLoadedActionButton( component, objectDef, translationKeyPrefix );
                definition = Ext.apply( definition, {
                  text: getXpdlActionAcceptButtonNameTranslation ( packageId, processDefId, activityDefId, objectDef.actionName, objectDef.buttonName )
                } );
                isEditable = true;
                break;
            case 'GENERATE_PDF_BUTTON':
                definition = this.createLoadedActionButton( component, objectDef, translationKeyPrefix );
                definition = Ext.apply( definition, {
                  text: getXpdlGeneratePdfButtonNameTranslation ( packageId, processDefId, activityDefId, objectDef.actionName, objectDef.buttonName )
                } );
                isEditable = true;
                break;
            case 'ADD_FILE_BUTTON':
                definition = this.createLoadedActionButton( component, objectDef, translationKeyPrefix );
                definition = Ext.apply( definition, {
                  text: getXpdlAddFileButtonNameTranslation ( packageId, processDefId, activityDefId, objectDef.docClassName, objectDef.buttonName )
                } );
                isEditable = true;
                break;
            case 'BARCODE_PRINT':
                definition = this.createLoadedActionButton( component, objectDef, translationKeyPrefix );
                isEditable = true;
                break;
            case 'LABEL':
                objectDef = Ext.apply( {
                    id: item.id,
                    text: item.text,
                    fontSize: item.fontSize,
                    color: item.color,
                    marginTop: item.marginTop,
                    marginRight: item.marginRight,
                    marginBottom: item.marginBottom,
                    marginLeft: item.marginLeft,
                    genre: 'LABEL'
                }, objectDef );

                definition = Ext.apply( {
                    xtype: 'label',
                    text: getXpdlLabelNameTranslation( packageId, processDefId, item.id, objectDef.text ),
                    objectDef: objectDef,
                    style: {
                        fontSize: objectDef.fontSize + 'px',
                        color: objectDef.color
                    }
                }, definition );
                isEditable = true;
                break;
            default:
                break;
        }

        config = Ext.apply( {
            type: item.type,
            definition: definition,
            isEditable: isEditable
        }, config );

        return config;
    },
    createDtButton: function( btn, nameTranslation ) {
      var btnCls = '';

      if ( !Ext.isEmpty( btn.name ) && !Ext.isEmpty( btn.icon ) ) {
        btnCls = 'x-btn-text-icon';
      } else if ( !Ext.isEmpty( btn.name ) ) {
        btnCls = 'x-btn-text';
      } else {
        btnCls = 'x-btn-icon';
      }

      btnCls += ' dvnt-pwe-dt-button ' + Ext.ux.suncode.UtilService.resolveDtButtonColorCls( btn.color );

    	return {
        xtype: 'panel',
        layout: 'form',
        border: false,
        cls: 'x-Module-dtButton-container',
        buttonWrapper: true,
        items: [ {
          xtype: 'button',
          cls: btnCls,
          iconCls: Ext.ux.suncode.UtilService.resolveIconCls( btn.icon ),
          text: nameTranslation,
          tooltip: btn.tooltip
        } ],
        definition: {
          objectDef: btn
        },
        listeners: {
          scope: this,
          render: function( panel ) {
            var panelEl = panel.getEl();
            panelEl.on( 'contextmenu', this.onDtButtonContextMenu, this, {
              component: panel
            } );
            panelEl.on( 'dblclick', this.onDtButtonDblClick, this, {
              component: panel
            } );

            this.analyzeVariablesMissingInIntegrationComponents( panel );

            if ( this.hasFormActions( panel ) && this.integrationComponentsVisible ) {
              this.addFormActionsOverlay( panel );
            }
            if ( this.hasEventActions( panel ) && this.integrationComponentsVisible ) {
              this.addEventActionsOverlay( panel );
            }
          }
        }
      };
    },
    createLabelStyle: function( item ) {
        var labelStyle = 'font-size: ' + item.labelFontSize + 'px;';
        labelStyle += 'color: ' + item.labelColor + ';';
        labelStyle += 'text-decoration: ' + item.textDecoration + ';';

        return labelStyle;
    },
    createStyle: function( item ) {
      var style = new Object();

      if ( !Ext.isEmpty( item ) ) {
        if ( !Ext.isEmpty( item.marginTop ) ) {
          style = Ext.apply( style, {
            paddingTop: item.marginTop + 'px'
          } );
        }
        if ( !Ext.isEmpty( item.marginRight ) ) {
          style = Ext.apply( style, {
            paddingRight: item.marginRight + 'px'
          } );
        }
        if ( !Ext.isEmpty( item.marginBottom ) ) {
          style = Ext.apply( style, {
            paddingBottom: item.marginBottom + 'px'
          } );
        }
        if ( !Ext.isEmpty( item.marginLeft ) ) {
          style = Ext.apply( style, {
            paddingLeft: item.marginLeft + 'px'
          } );
        }
      }

      return style;
    },
    getObjectDefByIdAndType: function( array, id, type ) {
        for ( var i = 0; i < array.length; i++ ) {
            var object = array[i];
            if ( !Ext.isEmpty( object.type ) && object.type == type && !Ext.isEmpty( object.varId ) && id == object.varId ) {
                return deepObjectCopy( array.splice( i, 1 )[0] );
            } else if ( !Ext.isEmpty( object.genre ) && object.genre == type && !Ext.isEmpty( object.actionName ) && id == object.actionName ) {
                return deepObjectCopy( array.splice( i, 1 )[0] );
            }
        }
        return null;
    },
    getObjectDefForLabel: function( labelActions, item ) {
    	item = Ext.apply( item, {
    		formActions: new Array(),
        eventActions: new Array()
    	} );
    	
    	for ( var i = 0; i < labelActions.length; i++ ) {
            var labelAction = labelActions[i];
            
            if ( labelAction.labelId == item.id ) {
            	item = Ext.apply( item, {
            		formActions: [].concat( labelAction.formActions )
            	} );
            }
        }
    	
    	return item;
    },
    getProcessVariableById: function( variables, id ) {
        for ( var i = 0; i < variables.length; i++ ) {
            if ( id == variables[i].id ) {
                return variables.splice( i, 1 )[0];
            }
        }
        return null;
    },
    createLoadedActionButton: function( component, objectDef, translationKeyPrefix ) {
        var definition = new Object();
        var item = component.item;
        objectDef = this.mergeObjectDefAndItem( objectDef, item, translationKeyPrefix );
        var cls = '';

        if ( this.isActionButtonOnForm( objectDef ) ) {
            cls = 'x-btn-text dvnt-pwe-form-button ' + Ext.ux.suncode.UtilService.resolveFormButtonColorCls(objectDef.color);
        } else {
            cls = 'x-Module-hiddenFormObject x-btn-text dvnt-pwe-form-button ' + Ext.ux.suncode.UtilService.resolveFormButtonColorCls(objectDef.color);
        }

        definition = Ext.apply( {
            xtype: 'button',
            cls: cls,
            text: objectDef.buttonName,
            iconCls: Ext.ux.suncode.UtilService.resolveIconCls( objectDef.icon ),
            objectDef: objectDef,
            listeners: {
              afterrender: function( button ) {
                var buttonEl = button.btnEl;

                if ( objectDef.filled ) {
                  buttonEl.addClass( 'x-Module-filledButton' );
                }

                if ( objectDef.hideFrame ) {
                  buttonEl.addClass( 'x-Module-noBorder' );
                }

                if ( !Ext.isEmpty( objectDef.width ) ) {
                  buttonEl.setWidth( objectDef.width );
                }

                if ( !Ext.isEmpty( objectDef.height ) ) {
                  buttonEl.setHeight( objectDef.height );
                }
              }
            }
        }, definition );

        return definition;
    },
    mergeObjectDefAndItem: function( objectDef, item, translationKeyPrefix ) {
        switch ( item.type ) {
	        case 'TEXTAREA':
	        	objectDef = Ext.apply( objectDef, {
                    height: item.height ? item.height : 100
                } );
	        	break;
            case 'HTTP_LINK':
            	objectDef = Ext.apply( objectDef, {
                    icon: item.icon ? item.icon : '',
                    color: item.color ? item.color : ''
                } );
            	
            	if ( Ext.isEmpty( objectDef.translations ) ) {
	            	var nameTranslationKey = translationKeyPrefix + '_HTTPLINK('
                        + Ext.ux.suncode.I18NService.replaceHttpLinkId( objectDef.buttonName ) + ')';
                var tooltipTranslationKey = nameTranslationKey + '_DESC';
	            	var translations = new Object();
	            	translations[nameTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( nameTranslationKey );
                translations[tooltipTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( tooltipTranslationKey );
	            	
	                objectDef = Ext.apply( objectDef, {
	                    translations: translations
	                } );
            	}
                break;
            case 'ACTION_ACCEPT_BUTTON':
              objectDef = Ext.apply( objectDef, {
                icon: item.icon ? item.icon : '',
                color: item.color ? item.color : ''
              } );

            	if ( Ext.isEmpty( objectDef.translations ) ) {
	            	var nameTranslationKey = translationKeyPrefix + '_ACTIONBUTTON(' + objectDef.actionName + ')';
                var tooltipTranslationKey = nameTranslationKey + '_DESC';
                var translations = new Object();
	            	translations[nameTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( nameTranslationKey );
                translations[tooltipTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( tooltipTranslationKey );

                objectDef = Ext.apply( objectDef, {
	                    translations: translations
	                } );
            	}
                break;
            case 'GENERATE_PDF_BUTTON':
              objectDef = Ext.apply( objectDef, {
                color: item.color ? item.color : ''
              } );

            	if ( Ext.isEmpty( objectDef.translations ) ) {
	            	var nameTranslationKey = translationKeyPrefix + '_PDFBUTTON(' + objectDef.actionName + ')';
	            	var translations = new Object();
	            	translations[nameTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( nameTranslationKey );
	            	
	                objectDef = Ext.apply( objectDef, {
	                    translations: translations
	                } );
            	}
                break;
            case 'ADD_FILE_BUTTON':
              objectDef = Ext.apply( objectDef, {
                icon: item.icon ? item.icon : '',
                color: item.color ? item.color : ''
              } );

            	if ( Ext.isEmpty( objectDef.translations ) ) {
	            	var nameTranslationKey = translationKeyPrefix + '_ADDFILEBUTTON('
                        + Ext.ux.suncode.I18NService.replaceAddFileButtonId( objectDef.docClassName ) + ')';
	            	var translations = new Object();
	            	translations[nameTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( nameTranslationKey );
	            	
	                objectDef = Ext.apply( objectDef, {
	                    translations: translations
	                } );
            	}
                break;
          case 'BARCODE_PRINT':
            objectDef = Ext.apply( objectDef, {
              color: item.color ? item.color : ''
            } );
            break;
            case 'VARIABLE_SET':
            	objectDef = Ext.apply( objectDef, {
            		headerFontSize: item.headerFontSize,
            		cellFontSize: item.cellFontSize
                } );
            	var titleTranslationKey = translationKeyPrefix + '_VARIABLESET(' + objectDef.varId +')';
            	
            	if ( Ext.isEmpty( objectDef.translations ) ) {
                	var translations = new Object();
                	translations[titleTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( titleTranslationKey );
                	
                	objectDef = Ext.apply( objectDef, {
                		translations: translations
                    } );
            	}
            	
            	Ext.each( objectDef.DTButtons, function( dtButton, index, dtButtons ) {
            		if ( Ext.isEmpty( dtButton.translations ) ) {
    	            	var nameTranslationKey = titleTranslationKey + '_DTBUTTON(' + dtButton.buttonId + ')';
    	            	var translations = new Object();
    	            	translations[nameTranslationKey] = Ext.ux.suncode.I18NService.getPackageTranslations( nameTranslationKey );
    	            	
    	            	dtButton = Ext.apply( dtButton, {
    	                    translations: translations
    	                } );
                	}
            	}, this );
            	break;
            default:
                break;
        }

        return objectDef;
    },
    isActionButtonOnForm: function( objectDef ) {
        if ( objectDef.genre == 'ACTION_ACCEPT_BUTTON' && objectDef.destination == 'GROUPFORM' ) {
            return false;
        } else {
            return true;
        }
    },
    getFormVariableXtype: function( editable, editableType ) {
        return editable ? editableType : 'displayfield';
    },
    getFormVariableValue: function( editable ) {
        return editable ? '' : getTranslation( 'Wartość' );
    },
    getFormVariableLabel: function( activityNode, processVariable ) {
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var label = getXpdlVariableNameTranslation( packageId, processDefId, processVariable.id, processVariable.name );

        if ( processVariable.requirement ) {
            label += ' <span class="x-Module-required-field-label">*</span>';
        }

        if ( !Ext.isEmpty( processVariable.descr ) ) {
            label += ' <span class="form-field-description-img"/>';
        }

        return label;
    },
    getVariableSetHeader: function( activityNode, processVariable, headerFontSize ) {
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var variableNameTranslated = getXpdlVariableNameTranslation( packageId, processDefId, processVariable.id, processVariable.name );
        var label = '<span style="font-size: ' + headerFontSize + 'px;">' + variableNameTranslated + '</span>';

        if ( processVariable.requirement ) {
            label += ' <span style="font-size: ' + headerFontSize + 'px;" class="x-Module-required-field-label">*</span>';
        }

        if ( !Ext.isEmpty( processVariable.descr ) ) {
            label += ' <span class="form-field-description-img"/>';
        }

        return label;
    },
    getFormVariableWidth: function (item) {
        return item.width ? item.width : Ext.ux.suncode.Constants.FIELD_DEFAULT_WIDTH;
    },
    getFormVariableLabelWidth: function (item) {
        return item.labelWidth ? item.labelWidth : Ext.ux.suncode.Constants.FIELD_DEFAULT_LABEL_WIDTH;
    },
    onComponentContextMenu: function( e, t, o ) {
      if ( this.isEventOnOverlay( e ) || this.isEventOnDtButton( e ) ) {
        return;
      }

      Ext.ux.suncode.Clipboard.getActivityFormComponents( function( cmps ) {
        var copyModeActive = this.isCopyModeActive();
        var componentsToCopy = null;
        var component = o.component;
        if ( copyModeActive ) {
          this.markComponent( component );
          componentsToCopy = this.getComponentsToCopy();
        }
        var componentContainer = component.ownerCt;
        var layoutPack = componentContainer.layoutPack;
        var xy = e.getXY();

        var menu = new Ext.menu.Menu( {
          items: [ {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'edit' ),
            text: getTranslation( 'Edytuj komponent' ),
            hidden: !component.isEditable,
            scope: this,
            handler: function() {
              this.onEditComponent( component );
            }
          }, {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'copy' ),
            text: getTranslation( 'Kopiuj komponenty' ),
            disabled: Ext.isEmpty( componentsToCopy ),
            hidden: !copyModeActive,
            scope: this,
            handler: function() {
              this.onCopyComponents( componentsToCopy );
            }
          }, {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'add' ),
            text: getTranslation( 'Wklej komponenty' ),
            disabled: Ext.isEmpty( cmps ),
            hidden: !copyModeActive,
            scope: this,
            handler: function() {
              this.onPasteComponents( xy[1], cmps );
            }
          }, {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'add' ),
            text: getTranslation( 'Wklej specjalnie' ),
            hidden: !copyModeActive,
            scope: this,
            handler: function() {
              var win = new Ext.ux.suncode.PasteSpecialWindow( {
                pasteSpecialFunction: function( pastedComponents ) {
                  this.onPasteComponents( xy[1], pastedComponents );
                },
                pasteSpecialScope: this,
                messageType: Ext.ux.suncode.Clipboard.activityFormComponentsMessageType
              } );
              win.show();
            }
          }, {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń komponent' ),
            scope: this,
            handler: function() {
              this.onRemoveComponent( component );
            }
          }, new Ext.menu.Separator(), {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'utilization' ),
            text: getTranslation( 'Pokaż wykorzystanie' ),
            hidden: !component.isVariable,
            scope: this,
            handler: function() {
              this.onShowComponentUtilization( component );
            }
          }, {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'position' ),
            text: getTranslation( 'Położenie' ),
            menu: [ {
              xtype: 'menuitem',
              cls: 'x-btn-text-icon',
              iconCls: layoutPack == 'start' ? 'x-Module-tickIcon' : undefined,
              text: getTranslation( 'Początek' ),
              scope: this,
              handler: function() {
                this.onChangeLayoutPack( componentContainer, 'start' );
              }
            }, {
              xtype: 'menuitem',
              cls: 'x-btn-text-icon',
              iconCls: layoutPack == 'center' ? 'x-Module-tickIcon' : undefined,
              text: getTranslation( 'Środek' ),
              scope: this,
              handler: function() {
                this.onChangeLayoutPack( componentContainer, 'center' );
              }
            }, {
              xtype: 'menuitem',
              cls: 'x-btn-text-icon',
              iconCls: layoutPack == 'end' ? 'x-Module-tickIcon' : undefined,
              text: getTranslation( 'Koniec' ),
              scope: this,
              handler: function() {
                this.onChangeLayoutPack( componentContainer, 'end' );
              }
            } ]
          } ]
        } );

        showMenu( menu, e );
      }, this );
    },
    onComponentDblClick: function( e, t, o ) {
    	if ( e.ctrlKey ) {
    		return;
    	}

        if ( this.isEventOnOverlay( e ) || this.isEventOnDtButton( e ) ) {
            return;
        }

        this.onEditComponent( o.component );
    },
    onDtButtonContextMenu: function( e, t, o ) {
      if ( this.isEventOnOverlay( e ) ) {
        return;
      }

      var component = o.component;
      var menuItems = new Array();
      menuItems.push( {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'edit' ),
        text: getTranslation( 'Edytuj przycisk' ),
        scope: this,
        handler: function() {
          this.onEditDtButton( component );
        }
      } );

      if ( Ext.isEmpty( component.definition.objectDef.globalId ) ) {
        menuItems.push( {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'delete' ),
          text: getTranslation( 'Usuń przycisk' ),
          scope: this,
          handler: function() {
            this.onRemoveDtButton( component );
          }
        } );
      }

      var menu = new Ext.menu.Menu( {
        items: menuItems
      } );

      showMenu( menu, e );
    },
    onDtButtonDblClick: function( e, t, o ) {
      if ( e.ctrlKey ) {
        return;
      }

      if ( this.isEventOnOverlay( e ) ) {
        return;
      }

      this.onEditDtButton( o.component );
    },
    onEditDtButton: function( component ) {
      var variableSet = component.ownerCt.ownerCt;
      var activityNode = this.initialConfig.activityNode;
      var mainPanel = Ext.getCmp( 'main_panel' );

      var win = new Ext.ux.suncode.DTButtonDefinitionWindow( {
        globalDefinition: false,
        DTButton: component.definition.objectDef,
        availableVariables: this.getPresentVariableIds(),
        AV: mainPanel.getAdvancedView(),
        processNode: activityNode.parentNode,
        activityNode: activityNode,
        variableSetId: variableSet.objectDef.varId,
        validateIdFunction: function( buttonId ) {
          var dtButtons = variableSet.objectDef.DTButtons;

          for ( var i = 0; i < dtButtons.length; i++ ) {
            var dtButton = dtButtons[i];

            if ( dtButton.buttonId == buttonId ) {
              return false;
            }
          }

          return true;
        },
        validateIdScope: this,
        updateFunction: function( oldButtonId, dtBtnObj ) {
          var dtButtons = variableSet.objectDef.DTButtons;

          for ( var i = 0; i < dtButtons.length; i++ ) {
            var dtButton = dtButtons[i];

            if ( dtButton.buttonId == oldButtonId ) {
              dtButtons[i] = dtBtnObj;
              break;
            }
          }

          component.definition.objectDef = dtBtnObj;
          var button = component.items.first();
          var iconCls = this.getDtButtonCls( dtBtnObj );
          if ( !Ext.isEmpty( dtBtnObj.icon ) ) {
            iconCls += ' ';
            iconCls += Ext.ux.suncode.UtilService.resolveIconCls( dtBtnObj.icon );
          }
          button.setIconClass( iconCls );
          button.setText( dtBtnObj.name );
          button.setTooltip( dtBtnObj.tooltip );
          button.setDisabled( dtBtnObj.disabled );

          this.analyzeVariablesMissingInIntegrationComponents( component );
          this.analyzeFormActionsOverlay( component );
          this.analyzeEventActionsOverlay( component );
        },
        updateScope: this
      } );
      win.show();
    },
    onRemoveDtButton: function( component ) {
      var toolbar = component.ownerCt;
      var variableSet = toolbar.ownerCt;
      var buttonId = component.definition.objectDef.buttonId;
      var dtButtons = variableSet.objectDef.DTButtons;

      for ( var i = 0; i < dtButtons.length; i++ ) {
        var dtButton = dtButtons[i];

        if ( dtButton.buttonId == buttonId ) {
          dtButtons.splice( i, 1 );

          toolbar.remove( component );
          toolbar.doLayout();

          this.showPreviewOutOfDateMessage();
          this.storeParentWindowAsUnsaved();
          break;
        }
      }
    },
    getDtButtonCls: function( dtBtnObj ) {
      if ( !Ext.isEmpty( dtBtnObj.name ) && !Ext.isEmpty( dtBtnObj.icon ) ) {
        return 'x-btn-text-icon';
      } else if ( !Ext.isEmpty( dtBtnObj.name ) ) {
        return 'x-btn-text';
      } else {
        return 'x-btn-icon';
      }
    },
    isEventOnOverlay: function( e ) {
      var formActionsOverlay = e.getTarget( 'div[class*=x-Module-formActionsOverlay]' );
      var eventActionsOverlay = e.getTarget( 'div[class*=x-Module-eventActionsOverlay]' );
      var errorOverlay = e.getTarget( 'div[class*=x-Module-errorOverlay]' );

      return ( !Ext.isEmpty( formActionsOverlay )
          || !Ext.isEmpty( eventActionsOverlay )
          || !Ext.isEmpty( errorOverlay ) );
    },
    isEventOnDtButton: function( e ) {
      var dtButtonContainer = e.getTarget( 'div[class*=x-Module-dtButton-container]' );

      return !Ext.isEmpty( dtButtonContainer );
    },
    onEditComponent: function( component ) {
        var win = new Ext.ux.suncode.FormObjectDefWindow( {
            activityNode: this.initialConfig.activityNode,
            component: component,
            availableVariables: this.getPresentVariableIds(),
            missingVariablesValidatorFunction: this.validateMissingVariablesInIntegrationComponentParameterValue,
            missingVariablesValidatorScope: this,
            validateIntegrationComponentFieldFunction: this.validateIntegrationComponentParameterValue,
            validateIntegrationComponentFieldScope: this,
            validateIntegrationComponentRowFunction: this.validateVariablesInIntegrationComponent,
            validateIntegrationComponentRowScope: this,
            pasteIntegrationComponentsValidation: {
              func: function( variableId ) {
                var presentVariableIds = this.getPresentVariableIds();

                return presentVariableIds.includes( variableId );
              },
              scope: this,
              invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
            },
            afterSaveFunction: this.afterEditComponent,
            afterSaveScope: this
        } );
        win.show();
    },
    afterEditComponent: function() {
    	this.showPreviewOutOfDateMessage();
    	this.storeParentWindowAsUnsaved();
    },
    onCopyComponents: function( components ) {
    	var objects = new Array();
    	
    	Ext.each( components, function( component, index, allComponents ) {
    		objects.push( {
    			item: this.getPanelItemConfig( component ),
    			objectDef: component.definition.objectDef
    		} );
    	}, this );
    	
    	Ext.ux.suncode.Clipboard.setActivityFormComponents( objects );
    },
    onPasteComponents: function( y, components ) {
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var presentComponentIds = this.collectPresentComponentIds();
      var addFileButtonDocumentClasses = this.collectAddFileButtonDocumentClasses();
      var exclusions = new Array();
      var duplicates = new Array();
      var insertIndex = this.getInsertIndex( y );
      var anyPasted = false;

      Ext.each( components, function( component, outerIndex, allComponents ) {
        var objectDef = component.objectDef;
        var shouldPaste = true;

        switch ( objectDef.genre ) {
          case 'VARIABLE':
            if ( presentComponentIds.indexOf( objectDef.varId ) != -1 ) {
              shouldPaste = false;
              duplicates.push( {
                itemName: getTranslation( 'Pole' ),
                itemId: objectDef.varId,
                component: component
              } );
            }

            var variable = processNode.findVariable( objectDef.varId );
            if ( Ext.isEmpty( variable ) ) {
              shouldPaste = false;
              exclusions.push( {
                itemName: getTranslation( 'Zmienna procesu' ),
                itemId: objectDef.varId,
                reason: getTranslation( 'zmienna procesu nie istnieje w procesie' )
              } );
            }
            break;
          case 'VARIABLE_SET':
            var table = processNode.findTable( objectDef.varId );

            if ( Ext.isEmpty( table ) ) {
              shouldPaste = false;

              exclusions.push( {
                itemName: getTranslation( 'Tabela dynamiczna' ),
                itemId: objectDef.varId,
                reason: getTranslation( 'lokalna tabela nie może być kopiowana' )
              } );
            } else {
              if ( presentComponentIds.indexOf( objectDef.varId ) != -1 ) {
                shouldPaste = false;

                exclusions.push( {
                  itemName: getTranslation( 'Tabela dynamiczna' ),
                  itemId: objectDef.varId,
                  reason: getTranslation( 'globalna tabela o tym identyfikatorze została już dodana do zadania' )
                } );
              } else {
                var columns = objectDef.columns;

                for ( var k = 0; k < columns.length; k++ ) {
                  var column = columns[k];

                  if ( presentComponentIds.indexOf( column.varId ) != -1 ) {
                    shouldPaste = false;

                    exclusions.push( {
                      itemName: getTranslation( 'Tabela dynamiczna' ),
                      itemId: objectDef.varId,
                      subitemName: getTranslation( 'Kolumna' ),
                      subitemId: column.varId,
                      reason: getTranslation( 'globalna tabela zawiera zmienną dodaną juz do zadania' )
                    } );
                    break;
                  }

                  var variable = processNode.findVariable( column.varId );
                  if ( Ext.isEmpty( variable ) ) {
                    shouldPaste = false;

                    exclusions.push( {
                      itemName: getTranslation( 'Zmienna procesu' ),
                      itemId: objectDef.varId,
                      reason: getTranslation( 'zmienna procesu nie istnieje w procesie' )
                    } );
                    break;
                  }
                }

                var dtButtons = objectDef.DTButtons;

                for ( var k = 0; k < dtButtons.length; k++ ) {
                  var dtButton = dtButtons[k];

                  if ( presentComponentIds.indexOf( dtButton.buttonId ) != -1 ) {
                    shouldPaste = false;

                    exclusions.push( {
                      itemName: getTranslation( 'Tabela dynamiczna' ),
                      itemId: objectDef.varId,
                      subitemName: getTranslation( 'Przycisk' ),
                      subitemId: dtButton.buttonId,
                      reason: getTranslation( 'globalna tabela zawiera przycisk dodany juz do zadania' )
                    } );
                    break;
                  }
                }
              }
            }
            break;
          case 'LABEL':
            if ( presentComponentIds.indexOf( objectDef.id ) != -1 ) {
              shouldPaste = false;
              duplicates.push( {
                itemName: getTranslation( 'Etykieta' ),
                itemId: objectDef.id,
                component: component
              } );
            }
            break;
          case 'HTTP_LINK':
          case 'ACTION_ACCEPT_BUTTON':
          case 'GENERATE_PDF_BUTTON':
          case 'BARCODE_PRINT':
            if ( presentComponentIds.indexOf( objectDef.actionName + '_button' ) != -1 ) {
              shouldPaste = false;
              duplicates.push( {
                itemName: getTranslation( 'Przycisk' ),
                itemId: objectDef.actionName,
                component: component
              } );
            } else if ( objectDef.genre == 'ACTION_ACCEPT_BUTTON') {
              objectDef.forwardTo = '';
              clearArray( objectDef.acceptedNextActivities );
            }
            break;
          case 'ADD_FILE_BUTTON':
            if ( addFileButtonDocumentClasses.indexOf( objectDef.docClassName ) != -1 ) {
              shouldPaste = false;
              exclusions.push( {
                itemName: getTranslation( 'Przycisk' ),
                itemId: objectDef.actionName,
                reason: getTranslation( 'istnieje już przycisk dodający plik do tej samej klasy dokumentów' )
              } );
            } else if ( presentComponentIds.indexOf( objectDef.actionName + '_button' ) != -1 ) {
              shouldPaste = false;
              duplicates.push( {
                itemName: getTranslation( 'Przycisk' ),
                itemId: objectDef.actionName,
                component: component
              } );
            }
            break;
          default:
            break;
        }

        if ( shouldPaste ) {
          this.pasteComponent( component, insertIndex );

          insertIndex++;
          anyPasted = true;
        }
      }, this );

      if ( anyPasted ) {
        this.doLayout();
        this.ownerCt.doLayout();
        this.analyzeOverlays();
        this.showPreviewOutOfDateMessage();
        this.storeParentWindowAsUnsaved();
      }

      if ( !( Ext.isEmpty( exclusions ) && Ext.isEmpty( duplicates ) ) ) {
        var warnMsg = '';

        if ( !Ext.isEmpty( exclusions ) ) {
          warnMsg += this.buildPasteComponentsWarningMessage(
              getTranslation( 'Komponenty wykluczone podczas wklejania' ), exclusions );

          if ( !Ext.isEmpty( duplicates ) ) {
            warnMsg += '<br><br>';
          }
        }

        if ( !Ext.isEmpty( duplicates ) ) {
          warnMsg += this.buildPasteComponentsWarningMessage(
              getTranslation( 'Duplikaty pominięte podczas wklejania' ), duplicates );
          warnMsg += '<br><br>';
          warnMsg += getTranslation('Czy chcesz stworzyć kopie duplikatów?');
        }

        if ( Ext.isEmpty( duplicates ) ) {
          showWarn( warnMsg );
        } else {
          Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
              yes: getTranslation( 'Tak' ),
              no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
              if ( buttonId == 'yes' ) {
                this.createAndPasteDuplicates( duplicates, insertIndex );
              }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
          } );
        }
      }
    },
    collectAddFileButtonDocumentClasses: function() {
      var documentClasses = new Array();

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( subitem, j, internalSize ) {
          var definition = subitem.definition;
          var objectDef = definition.objectDef;

          switch ( objectDef.genre ) {
            case 'ADD_FILE_BUTTON':
              if ( subitem.idAssigned ) {
                documentClasses.push( objectDef.docClassName );
              }
              break;
            default:
              break;
          }
        } );
      } );

      return documentClasses;
    },
    getInsertIndex: function( y ) {
    	var insertIndex = this.items.items.length;
        var matrix = this.getPanelsMatrix();

        for ( var i = 0; i < matrix.length; i++ ) {
            var elY = matrix[i].y;
            var elHeight = matrix[i].h;

            if ( y >= elY && y < elY + elHeight ) {
            	insertIndex = i;
                break;
            }
        }
        
        return insertIndex;
    },
    buildPasteComponentsWarningMessage: function( description, components ) {
      var msg = '';
      msg += description;
      msg += ':';

      Ext.each( components, function( component, index, allComponents ) {
        msg += '<br>- ';
        msg += component.itemName.toLowerCase();
        msg += ': ';
        msg += component.itemId;

        if ( !Ext.isEmpty( component.subitemName ) && !Ext.isEmpty( component.subitemId ) ) {
          msg += ' (';
          msg += component.subitemName.toLowerCase();
          msg += ': ';
          msg += component.subitemId;
          msg += ')';
        }

        if ( !Ext.isEmpty( component.reason ) ) {
          msg += ' (';
          msg += getTranslation( 'powód' );
          msg += ': ';
          msg += component.reason;
          msg += ')';
        }
      } );

      return msg;
    },
    pasteComponent: function( component, insertIndex ) {
    	var activityNode = this.initialConfig.activityNode;
    	var activityDefId = activityNode.attributes.activityDefId;
    	var showLines = activityNode.attributes.formStyles.showLines;
    	var processNode = activityNode.parentNode;
        var processVariablesCopy = [].concat( processNode.attributes.variables );
    	var columnPanelItems = new Array();
		var item = component.item;
		var objectDef = component.objectDef;
        var comp = {
        	processVariables: processVariablesCopy,
            item: item
        };
        
        if ( !Ext.isEmpty( objectDef.translations ) ) {
        	Ext.iterate( objectDef.translations, function( key, translations, allTranslations ) {
        		objectDef.translations[key.replace( /ACTIVITY\(([^)]+)\)/, 'ACTIVITY(' + activityDefId + ')' )] = translations;
        		delete objectDef.translations[key];
        	} );
    	}
        
        columnPanelItems.push( this.createFormVariable( comp, false, false, false, true, objectDef, null, null, activityNode ) );
       	this.insert( insertIndex, this.executeCreateFormVariableWrapper( columnPanelItems, 'start', showLines ) );
       	
       	if ( objectDef.genre == 'VARIABLE_SET' ) {
            var columns = objectDef.columns;

            Ext.each( columns, function( column, innerIndex, allColumns ) {
            	var variable = processNode.findVariable( column.varId );
            	this.getVariablesTree().markAsUsed( variable );
            }, this );
        } else if ( objectDef.genre == 'VARIABLE' ) {
        	var variable = processNode.findVariable( objectDef.varId );
        	this.getVariablesTree().markAsUsed( variable );
        } else if ( objectDef.genre == 'LABEL' ) {
        	var label = processNode.findLabel( objectDef.id );
        	this.getLabelsTree().markAsUsed( label );
        }
    },
    createAndPasteDuplicates: function( duplicates, insertIndex) {
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;

      Ext.each( duplicates, function( duplicate, index, allDuplicates ) {
        var component = deepObjectCopy( duplicate.component );
        var objectDef = component.objectDef;

        switch ( objectDef.genre ) {
          case 'VARIABLE':
            var variableCopy = processNode.copyVariable( objectDef.varId );

            if ( !Ext.isEmpty( variableCopy ) ) {
              Ext.apply( objectDef, {
                varId: variableCopy.id,
                name: variableCopy.name
              } );
              Ext.apply( component.item, {
                id: variableCopy.id
              } );
            }
            break;
          case 'VARIABLE_SET':
            if ( duplicate.changeVariableSetId ) {
              Ext.apply( objectDef, {
                varId: this.generateUniqueId( objectDef.varId )
              } );
            }

            var dataChoosers = new Array();
            var copyFromTo = new HashMap();

            Ext.each( objectDef.columns, function( column, columnsIndex, columns ) {
              if ( this.checkDuplication( column.varId ) ) {
                var variableCopy = processNode.copyVariable( column.varId );

                if ( !Ext.isEmpty( variableCopy ) ) {
                  if ( variableCopy.type == 'DATA_CHOOSER' ) {
                    dataChoosers.push( variableCopy );
                  }

                  copyFromTo.put( column.varId, variableCopy.id );

                  Ext.apply( column, {
                    varId: variableCopy.id
                  } );
                }
              }
            }, this );

            Ext.each( dataChoosers, function( dataChooser, dataChooserIndex, allDataChoosers ) {
              if ( !Ext.isEmpty( dataChooser.mappings ) ) {
                for ( var i = 0; i < dataChooser.mappings.length; i++ ) {
                  var mapping = dataChooser.mappings[i];
                  var changedId = copyFromTo.get( mapping.varId );

                  if ( !Ext.isEmpty( changedId ) ) {
                    mapping.varId = changedId;
                  }
                }
              } else if ( !Ext.isEmpty( dataChooser.definition.mappings ) ) {
                Ext.iterate( dataChooser.definition.mappings, function( key, mapping, allMappings ) {
                  var changedId = copyFromTo.get( mapping.variable );

                  if ( !Ext.isEmpty( changedId ) ) {
                    mapping.variable = changedId;
                  }
                } );
              }
            } );

            Ext.each( objectDef.DTButtons, function( dtButton, dtButtonsIndex, dtButtons ) {
              if ( this.checkDuplication( dtButton.buttonId ) ) {
                Ext.apply( dtButton, {
                  buttonId: this.generateUniqueId( dtButton.buttonId )
                } );
              }
            }, this );
            break;
          case 'LABEL':
            var labelCopy = processNode.copyLabel( objectDef.id );

            Ext.apply( objectDef, {
              id: labelCopy.id,
              text: labelCopy.name
            } );
            break;
          case 'HTTP_LINK':
            var newButtonName = this.generateUniqueName( objectDef.buttonName );

            Ext.apply( objectDef, {
              actionName: generateId( newButtonName ),
              buttonName: newButtonName
            } );
            break;
          case 'ACTION_ACCEPT_BUTTON':
          case 'GENERATE_PDF_BUTTON':
          case 'BARCODE_PRINT':
            Ext.apply( objectDef, {
              actionName: this.generateUniqueId( objectDef.actionName )
            } );
            break;
          default:
            break;
        }

        this.pasteComponent( component, insertIndex );

        insertIndex++
      }, this );

      this.doLayout();
      this.analyzeOverlays();
      this.showPreviewOutOfDateMessage();
      this.storeParentWindowAsUnsaved();
    },
    generateUniqueId: function( initialId ) {
    	var counter = 2;
        var id = initialId + '_' + counter;

        while ( this.checkDuplication( id ) ) {
            counter++;
            id = initialId + '_' + counter;
        }
        
        return id;
    },
    generateUniqueName: function( initialName ) {
        var counter = 2;
        var name = initialName + ' ' + counter;

        while ( this.checkDuplication( generateId( name ) ) ) {
            counter++;
            name = initialName + ' ' + counter;
        }

        return name;
    },
    onRemoveComponent: function( component ) {
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;

      if ( component.isVariable ) {
        var varId = component.definition.objectDef.varId;

        if ( !this.validateComponentRemoval( varId, varId ) ) {
          return;
        }

        var variable = processNode.findVariable( varId );
        this.getVariablesTree().markAsUnused( variable );
        Ext.ux.suncode.DocumentationService.deleteFormVariableSpecification( activityNode, varId );
      } else if ( component.isLabel ) {
        var labelId = component.definition.objectDef.id;
        var label = processNode.findLabel( labelId );
        if ( !Ext.isEmpty( label ) ) {
          this.getLabelsTree().markAsUnused( label );
        }
      } else if ( component.type == 'VARIABLE_SET' ) {
        var varId = component.definition.objectDef.varId;
        var columns = component.definition.objectDef.columns;

        for ( var i = 0; i < columns.length; i++ ) {
          var columnId = columns[i].varId;

          if ( !this.validateComponentRemoval( columnId, varId ) ) {
            return false;
          }
        }

        var DTButtons = component.definition.objectDef.DTButtons;

        if ( !Ext.isEmpty( DTButtons ) ) {
          Ext.each( DTButtons, function( button, index, buttons ) {
            Ext.ux.suncode.DocumentationService.deleteDtButtonSpecification( activityNode, button.buttonId );
          } );
        }

        var table = processNode.findTable( varId );
        if ( !Ext.isEmpty( table ) ) {
          this.getTablesTree().markAsUnused( table );
        }

        for ( var i = 0; i < columns.length; i++ ) {
          var columnId = columns[i].varId;

          var variable = processNode.findVariable( columnId );
          this.getVariablesTree().markAsUnused( variable );
        }

        Ext.ux.suncode.DocumentationService.deleteFormVariableSpecification( activityNode, varId );
      } else if ( component.type == 'ACTION_ACCEPT_BUTTON' || component.type == 'HTTP_LINK' ) {
        var actionName = component.definition.objectDef.actionName;
        Ext.ux.suncode.DocumentationService.deleteButtonSpecification( activityNode, actionName );
      }

      var panel = component.ownerCt;
      panel.remove( component );
      panel.doLayout();

      if ( panel.items.length == 0 ) {
        this.remove( panel );
        this.doLayout();
      }

      this.showPreviewOutOfDateMessage();
      this.storeParentWindowAsUnsaved();
    },
    validateComponentRemoval: function( variableId, objectId ) {
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var componentsUsingVariable = this.getFormActionsUsingVariable( processNode, variableId, objectId );
        componentsUsingVariable = componentsUsingVariable.concat( this.getEventActionsUsingVariable( processNode, variableId, objectId ) );
        
        if ( !Ext.isEmpty( componentsUsingVariable ) ) {
          var variable = processNode.findVariable( variableId );
        	var varName = variable.name;
        	var warning = getTranslation( 'Zmienna' ) + ' <b>' + varName + '</b> '
				    + getTranslation( 'jest wykorzystywana w komponentach' ) + '.';
        	var title = getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + varName;
        	Ext.ux.suncode.IntegrationComponentService.showComponentsUsingVariableWarning( warning, {
				      windowTitle: title,
            	utilization: componentsUsingVariable,
            	showCustomDescription: true,
              showModificationDate: true,
              showVariableUtilizationActions: true,
              enableRemoveAll: true,
            	preventSave: true,
            	processNode: processNode,
            	variableId: variableId,
              afterRemoveComponentFunction: this.afterRemoveComponent,
              afterRemoveComponentScope: this
            } );
        	return false;
        } else {
        	return true;
        }
    },
    afterRemoveComponent: function() {
      this.analyzeVariablesMissingInIntegrationComponents( this );
      this.updateFormActionsOverlay( this );

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( subitem, j, internalSize ) {
          if ( subitem.definition.objectDef.genre == 'VARIABLE_SET' ) {
            var variableSet = subitem.items.first();
            var toolbar = variableSet.getBottomToolbar();
            toolbar.items.each( function( button ) {
              if ( !Ext.isEmpty( button.definition ) ) {
                this.analyzeVariablesMissingInIntegrationComponents( button );
                this.analyzeFormActionsOverlay( button );
                this.analyzeEventActionsOverlay( button );
              }
            }, this );
          }

          this.analyzeVariablesMissingInIntegrationComponents( subitem );
          this.analyzeFormActionsOverlay( subitem );
          this.analyzeEventActionsOverlay( subitem );
        }, this );
      }, this );

      this.showPreviewOutOfDateMessage();
      this.storeParentWindowAsUnsaved();
    },
    onShowComponentUtilization: function( component ) {
      var variableId = component.definition.objectDef.varId;
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var variable = processNode.findVariable( variableId );
      var componentsUsingVariable = this.getFormActionsUsingVariable( processNode, variableId, variableId );
      componentsUsingVariable = componentsUsingVariable.concat( this.getEventActionsUsingVariable( processNode, variableId, variableId ) );

      if ( !Ext.isEmpty( componentsUsingVariable ) ) {
        var win = new Ext.ux.suncode.VariableUtilizationWindow( {
          title: getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + variable.name,
          utilization: componentsUsingVariable,
          showCustomDescription: true,
          showModificationDate: true,
          showVariableUtilizationActions: true,
          enableRemoveAll: true,
          preventSave: true,
          processNode: processNode,
          variableId: variableId,
          afterRemoveComponentFunction: this.afterRemoveComponent,
          afterRemoveComponentScope: this
        } );
        win.show();
      } else {
        Ext.Msg.show( {
          msg: getTranslation( 'Brak komponentów wykorzystujących zmienną' ) + ': ' + variable.name,
          buttons: Ext.Msg.OK,
          icon: Ext.Msg.INFO
        } );
      }
    },
    getPresentVariableIds: function() {
      return this.presentVariableIds;
    },
    addToPresentVariableIds: function ( varId ) {
        this.presentVariableIds.push( varId );
    },
    removeFromPresentVariableIds: function ( varId ) {
        var ids = this.presentVariableIds;

        for ( var i = 0; i < ids.length; i++ ) {
          if ( ids[i] == varId ) {
            ids.splice( i, 1 );
            break;
          }
        }
    },
    getFormActionsUsingVariable: function( processNode, variableId, objectId ) {
      var components = new Array();
      var mainPanel = Ext.getCmp( 'main_panel' );
      var componentsMap = Ext.ux.suncode.IntegrationComponentService.convertCategoriesToMap(
          mainPanel.getFormActionsIntegrationComponentCategories() );
      components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
          this.definition.objectDef.formActions, variableId, getTranslation( 'Globalna akcja formularza' ),
          null, getTranslation( 'Globalna akcja formularza' ),
          Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( subitem, j, internalSize ) {
          if ( subitem.idAssigned ) {
            var definition = subitem.definition;
            var objectDef = definition.objectDef;

            switch ( objectDef.genre ) {
              case 'VARIABLE':
                if ( objectDef.varId !== objectId ) {
                  var variable = processNode.findVariable( objectDef.varId );
                  components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                      objectDef.formActions, variableId,
                      getTranslation( 'Akcja formularza na zmiennej formularza' ) + ': ' + variable.name,
                      getTranslation( 'Zmienna' ) + ' (' + variable.name + ')',  getTranslation( 'Akcja formularza' ),
                      Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );
                }
                break;
              case 'VARIABLE_SET':
                if ( objectDef.varId !== objectId ) {
                  components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                      objectDef.formActions, variableId,
                      getTranslation( 'Akcja formularza na tabeli dynamicznej' ) + ': ' + objectDef.name,
                      getTranslation( 'Tabela dynamiczna' ) + ' (' + objectDef.name + ')', getTranslation( 'Akcja formularza' ),
                      Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );

                  if ( !Ext.isEmpty( objectDef.DTButtons ) ) {
                    Ext.each( objectDef.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                      components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                          dtButton.formActions, variableId,
                          getTranslation( 'Akcja formularza na przycisku tabeli dynamicznej' )
                          + ': ' + dtButton.name,
                          getTranslation( 'Przycisk tabeli dynamicznej' ) + ' (' + dtButton.name + ')',
                          getTranslation( 'Akcja formularza' ),
                          Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );
                    }, this );
                  }
                }
                break;
              case 'LABEL':
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    objectDef.formActions, variableId,
                    getTranslation( 'Akcja formularza na etykiecie' ) + ': ' + objectDef.text,
                    getTranslation( 'Etykieta' ) + ' (' + objectDef.text + ')', getTranslation( 'Akcja formularza' ),
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );
                break;
              case 'HTTP_LINK':
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    objectDef.formActions, variableId,
                    getTranslation( 'Akcja formularza na przycisku' ) + ': ' + objectDef.buttonName,
                    getTranslation( 'Przycisk' ) + ' (' + objectDef.buttonName + ')', getTranslation( 'Akcja formularza' ),
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );
                break;
              case 'ACTION_ACCEPT_BUTTON':
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    objectDef.formActions, variableId,
                    getTranslation( 'Akcja formularza na przycisku' ) + ': ' + objectDef.buttonName,
                    getTranslation( 'Przycisk' ) + ' (' + objectDef.buttonName + ')', getTranslation( 'Akcja formularza' ),
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION, componentsMap ) );
                break;
              default:
                break;
            }
          }
        }, this );
      }, this );

      return components;
    },
    getEventActionsUsingVariable: function( processNode, variableId, objectId ) {
      var components = new Array();
      var mainPanel = Ext.getCmp( 'main_panel' );
      var componentsMap = Ext.ux.suncode.IntegrationComponentService.convertCategoriesToMap(
          mainPanel.getEventActionsCategories() );
      components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
          this.definition.objectDef.eventActions, variableId, getTranslation( 'Globalne zdarzenie formularza' ),
          null, getTranslation( 'Globalne zdarzenie formularza' ),
          Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION, componentsMap ) );

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( subitem, j, internalSize ) {
          if ( subitem.idAssigned ) {
            var definition = subitem.definition;
            var objectDef = definition.objectDef;

            switch ( objectDef.genre ) {
              case 'VARIABLE':
                if ( objectDef.varId !== objectId ) {
                  var variable = processNode.findVariable( objectDef.varId );
                  components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                      objectDef.eventActions, variableId,
                      getTranslation( 'Zdarzenie na zmiennej formularza' ) + ': ' + variable.name,
                      getTranslation( 'Zmienna' ) + ' (' + variable.name + ')',  getTranslation( 'Zdarzenie' ),
                      Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION, componentsMap ) );
                }
                break;
              case 'VARIABLE_SET':
                if ( objectDef.varId !== objectId ) {
                  components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                      objectDef.eventActions, variableId,
                      getTranslation( 'Zdarzenie na tabeli dynamicznej' ) + ': ' + objectDef.name,
                      getTranslation( 'Tabela dynamiczna' ) + ' (' + objectDef.name + ')', getTranslation( 'Zdarzenie' ),
                      Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION, componentsMap ) );

                  if ( !Ext.isEmpty( objectDef.DTButtons ) ) {
                    Ext.each( objectDef.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                      components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                          dtButton.eventActions, variableId,
                          getTranslation( 'Zdarzenie na przycisku tabeli dynamicznej' )
                          + ': ' + dtButton.name,
                          getTranslation( 'Przycisk tabeli dynamicznej' ) + ' (' + dtButton.name + ')',
                          getTranslation( 'Zdarzenie' ),
                          Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION, componentsMap ) );
                    }, this );
                  }
                }
                break;
              case 'HTTP_LINK':
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    objectDef.eventActions, variableId,
                    getTranslation( 'Zdarzenie na przycisku' ) + ': ' + objectDef.buttonName,
                    getTranslation( 'Przycisk' ) + ' (' + objectDef.buttonName + ')', getTranslation( 'Zdarzenie' ),
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION, componentsMap ) );
                break;
              case 'ACTION_ACCEPT_BUTTON':
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    objectDef.eventActions, variableId,
                    getTranslation( 'Zdarzenie na przycisku' ) + ': ' + objectDef.buttonName,
                    getTranslation( 'Przycisk' ) + ' (' + objectDef.buttonName + ')', getTranslation( 'Zdarzenie' ),
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION, componentsMap ) );
                break;
              default:
                break;
            }
          }
        }, this );
      }, this );

      return components;
    },
    getObjectIntegrationComponentsUsingVariable: function( integrationComponents,
        varId, object, objectOwner, objectName, componentType, componentsMap ) {
      var components = new Array();

      if ( !Ext.isEmpty( integrationComponents ) ) {
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;

        Ext.each( integrationComponents, function( integrationComponent, index, allIntegrationComponent ) {
          if ( Ext.ux.suncode.IntegrationComponentService.doesComponentUseVariable( integrationComponent, varId ) ) {
            var componentInfo = componentsMap.get( integrationComponent.id );
            components.push( {
              processDefId: processNode.attributes.processDefId,
              activityDefId: activityNode.attributes.activityDefId,
              object: object,
              objectOwner: objectOwner,
              objectName: componentInfo ? objectName + ' (' + componentInfo.name + ')' : objectName,
              objectType: componentType,
              component: integrationComponent,
              componentId: integrationComponent.id,
              customDescription: integrationComponent.customDescription,
              modificationDate: integrationComponent.modificationDate,
              objectContainer: integrationComponents
            } );
          }
        }, this );
      }

      return components;
    },
    onChangeLayoutPack: function( row, pack ) {
        if ( this.shouldChangeLayoutPack( row ) ) {
            row.layoutPack = pack;
            this.recalculateLayoutPack( row );
            this.showPreviewOutOfDateMessage();
            this.storeParentWindowAsUnsaved();
        }
    },
    shouldChangeLayoutPack: function( row ) {
        var isOk = true;

        row.items.each( function( item ) {
            if ( item.type == 'VARIABLE_SET' ) {
                showWarn( getTranslation( 'Nie można zmienić położenia, gdy na panelu znajduje się tabela dynamiczna.' ) );
                isOk = false;
                return false;
            }
        } );

        return isOk;
    },
    recalculateLayoutPack: function( row ) {
        var drawingPanel = this;

        window.setTimeout( function() {
            drawingPanel.executeRecalculateLayoutPack( row );
        } );
    },
    executeRecalculateLayoutPack: function( row ) {
        switch ( row.layoutPack ) {
            case 'start':
                this.recalculateStartLayoutPack( row );
                break;
            case 'center':
                this.recalculateCenterLayoutPack( row );
                break;
            case 'end':
                this.recalculateEndLayoutPack( row );
                break;
            default:
                break;
        }
    },
    recalculateStartLayoutPack: function( row ) {
        var rowItems = row.items.items;
        var offset = 0;

        for ( var i = 0; i < rowItems.length; i++ ) {
            if ( i > 0 ) {
                offset += rowItems[i - 1].getWidth();
            }

            var rowItem = rowItems[i];
            var offsets = [ offset, 0 ];

            rowItem.getEl().alignTo( row.getId(), 'l-l', offsets );
        }
    },
    recalculateCenterLayoutPack: function( row ) {
        var rowItems = row.items.items;
        var offset = 0;

        for ( var i = 0; i < rowItems.length; i++ ) {
            offset -= rowItems[i].getWidth() / 2;
        }

        for ( var i = 0; i < rowItems.length; i++ ) {
            if ( i > 0 ) {
                offset += rowItems[i - 1].getWidth();
            }

            var rowItem = rowItems[i];
            var offsets = [ offset, 0 ];

            rowItem.getEl().alignTo( row.getId(), 'l-c', offsets );
        }
    },
    recalculateEndLayoutPack: function( row ) {
        var rowItems = row.items.items;
        var offset = 0;

        for ( var i = rowItems.length - 1; i >= 0; i-- ) {
            if ( i < rowItems.length - 1 ) {
                offset += rowItems[i + 1].getWidth();
            }

            var rowItem = rowItems[i];
            var offsets = [ ( -1 ) * offset, 0 ];

            rowItem.getEl().alignTo( row.getId(), 'r-r', offsets );
        }
    },
    onComponentClick: function( e, t, o ) {
      var formActionsOverlay = e.getTarget( 'div[class*=x-Module-formActionsOverlay]' );
      if ( !Ext.isEmpty( formActionsOverlay ) ) {
        return;
      }

      if ( this.isCopyModeActive() ) {
        var component = o.component;

        if ( e.ctrlKey ) {
          if ( component.marked ) {
            this.unmarkComponent( component );
          } else {
            this.markComponent( component );
          }
        } else {
          this.unmarkOtherComponents( component );

          if ( !component.marked ) {
            this.markComponent( component );
          }
        }
      }
    },
    markComponent: function( component ) {
    	var el = component.getEl();
    	var mask = el.mask();
    	mask.addClass( 'x-Module-elementMarkedMask' );
    	Ext.apply( component, {
    		marked: true,
    		markedMask: mask
    	} );
    	this.updateMarkedComponentMask( component );
    },
    unmarkComponent: function( component ) {
    	var el = component.getEl();
    	el.unmask();
        delete component.marked;
        delete component.markedMask;
    },
    unmarkAllComponents: function() {
    	this.items.each( function( panel ) {
            panel.items.each( function( item ) {
            	if ( item.marked ) {
    				this.unmarkComponent( item );
    	        }
            }, this );
        }, this );
    },
    unmarkOtherComponents: function( component ) {
    	this.items.each( function( panel ) {
            panel.items.each( function( item ) {
            	if ( item.marked && component.getId() != item.getId() ) {
    				this.unmarkComponent( item );
    	        }
            }, this );
        }, this );
    },
    updateMarkedComponentMask: function( component ) {
    	var mask = component.markedMask;
      var margin = 0;

    	if ( component.hasError ) {
        margin += this.getMarginForError();
      }
    	
    	if ( this.areIntegrationComponentsVisible() && this.hasFormActions( component ) ) {
        margin += this.getMarginForIntegrationComponents( component, 'formActions' );
    	}

    	if ( margin > 0 ) {
        var el = component.getEl();
        mask.setWidth( el.getWidth() - margin );
      } else {
        mask.setWidth( '100%' );
      }
    },
    getComponentsToCopy: function() {
    	var components = new Array();
    	
    	this.items.each( function( panel ) {
            panel.items.each( function( item ) {
            	if ( item.idAssigned && item.marked ) {
            		components.push( item );
    	        }
            }, this );
        }, this );
    	
    	return components;
    },
    resolveComboboxTriggerClass: function( variable ) {
        if ( !Ext.isEmpty( variable.sort ) && variable.sort == 'window' ) {
            return 'dvnt-icon-modules';
        } else {
            return 'x-Module-combobox-field-trigger';
        }
    },
    onVariableSetColumnMove: function( oldIndex, newIndex ) {
        changePlacementInTab( this.objectDef.columns, oldIndex - 1, newIndex - 1 );
    },
    onFormActionStartDrag: function( data ) {
    	var component = data.component;
        var formDestination = Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                        Ext.ux.suncode.IntegrationComponentService.FORM_DESTINATION );
        var formMask = null;

        if ( formDestination ) {
            var el = this.getEl();
            formMask = el.mask();
            formMask.addClass( 'x-Module-elementFormMask' );
            formMask.addClass( 'x-Module-elementSelectedMask' );
            this.initializeFormActionDropTarget( formMask );
            this.supplyMaskForFormActionDrop( formMask, this, formDestination );
        }
        
        this.items.each( function( panel ) {
            panel.items.each( function( item ) {
                var el = item.getEl();
                var mask = el.mask();
                mask.addClass( 'x-Module-elementComponentMask' );
                mask = Ext.apply( mask, {
                	formMask: formMask
                } );
                this.initializeFormActionDropTarget( mask );
                var destination = this.getFormActionDestination( item.type, component );

                if ( this.shouldAcceptFormActionDrop( item, component, destination ) ) {
                	mask.addClass( 'x-Module-elementSelectedMask' );
                    this.supplyMaskForFormActionDrop( mask, item, destination );
                } else {
                    mask.addClass( 'x-Module-elementDeclinedMask' );
                }
                
                if ( item.type == 'VARIABLE_SET' ) {
                  var tableId = item.definition.objectDef.varId;
                	var dtDestination = this.getFormActionDestination( 'DT_BUTTON', component );
                	var toolbar = item.items.first().getBottomToolbar();
                	toolbar.items.each( function( toolbarItem ) {
                		if ( toolbarItem.buttonWrapper ) {
                			var buttonWrapperEl = toolbarItem.getEl();
                            var buttonWrapperMask = buttonWrapperEl.mask();
                            buttonWrapperMask.addClass( 'x-Module-elementDtButtonMask' );
                            buttonWrapperMask = Ext.apply( buttonWrapperMask, {
                            	formMask: formMask,
                            	variableSetMask: mask,
                            	variableSetPanelItemId: item.getId(),
                              tableId: tableId,
                            	dtButtonId: toolbarItem.definition.objectDef.buttonId
                            } );
                            this.initializeFormActionDropTarget( buttonWrapperMask );
                            
                            if ( !Ext.isEmpty( dtDestination ) ) {
                            	buttonWrapperMask.addClass( 'x-Module-elementSelectedMask' );
                                this.supplyMaskForFormActionDrop( buttonWrapperMask, toolbarItem, dtDestination );
                            } else {
                            	buttonWrapperMask.addClass( 'x-Module-elementDeclinedMask' );
                            }
                		}
                	}, this );

                  mask = Ext.apply( mask, {
                    tableId: tableId
                  } );
                }
            }, this );
        }, this );
    },
    getFormActionDestination: function( itemType, component ) {
        switch ( itemType ) {
            case 'VARIABLE_SET':
                var variableSetDestination = Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                    Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION );

                if ( !Ext.isEmpty( variableSetDestination ) ) {
                  return variableSetDestination;
                } else {
                  return Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                      Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION );
                }
            case 'HTTP_LINK':
            case 'ACTION_ACCEPT_BUTTON':
                return Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                                Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION );
            case 'LABEL':
            	return Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                        Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION );
            case 'DT_BUTTON':
            	return Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                        Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION );
            case 'GENERATE_PDF_BUTTON':
            case 'ADD_FILE_BUTTON':
            case 'BARCODE_PRINT':
                return null;
            default:
                return Ext.ux.suncode.IntegrationComponentService.getDestination( component,
                                Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION );
        }
    },
    shouldAcceptFormActionDrop: function( item, component, destination ) {
        if ( !Ext.isEmpty( destination ) && ( Ext.isEmpty( destination.bindTo ) || item.idAssigned ) ) {
        	if ( item.type == 'ACTION_ACCEPT_BUTTON' ) {
        		return destination.acceptButtonAllowed !== false;
        	} else if ( item.type == 'VARIABLE_SET'
        		&& destination.type === Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION ) {
        		return Ext.ux.suncode.IntegrationComponentService.hasAnyValidDtButton( component );
        	} else {
        		return true;
        	}
        } else {
            return false;
        }
    },
    supplyMaskForFormActionDrop: function( mask, item, destination ) {
        mask = Ext.apply( mask, {
            panelItemId: item.getId(),
            bindTo: {
                id: destination.bindTo,
                value: Ext.isEmpty( destination.bindTo ) ? '' : this.getFormActionBindToValue( item )
            },
            destinationType: destination.type
        } );
    },
    getFormActionBindToValue: function( item ) {
        if ( Ext.isEmpty( item.type ) ) {
            return null;
        }

        switch ( item.type ) {
            case 'VARIABLE_SET':
                return item.definition.objectDef.varId;
            case 'HTTP_LINK':
            case 'ACTION_ACCEPT_BUTTON':
                return item.definition.objectDef.actionName;
            case 'LABEL':
            case 'GENERATE_PDF_BUTTON':
            case 'ADD_FILE_BUTTON':
            case 'BARCODE_PRINT':
                return null;
            default:
                return item.definition.objectDef.varId;
        }
    },
    initializeFormActionDropTarget: function( mask ) {
        var dropTarget = new Ext.dd.DropTarget( mask, {
            ddGroup: 'dd_form_action',
            copy: false,
            notifyOver: this.onFormActionOver.createDelegate( this ),
            notifyDrop: this.onFormActionDrop.createDelegate( this )
        } );
        mask = Ext.apply( mask, {
        	dropTarget: dropTarget
        } );
    },
    onFormActionEndDrag: function( data, e ) {
        var el = this.getEl();

        if ( el.isMasked() ) {
            el.unmask();
        }
        
        this.items.each( function( panel ) {
            panel.items.each( function( item ) {
                var itemEl = item.getEl();
                
                if ( itemEl.isMasked() ) {
                    itemEl.unmask();
                }
                
                if ( item.type == 'VARIABLE_SET' ) {
                	var toolbar = item.items.first().getBottomToolbar();
                	toolbar.items.each( function( toolbarItem ) {
                		if ( toolbarItem.buttonWrapper ) {
                			var toolbarItemEl = toolbarItem.getEl();
                			
                			if ( toolbarItemEl.isMasked() ) {
                				toolbarItemEl.unmask();
                			}
                		}
                	} );
                }
            } );
        } );
    },
    onFormActionBeforeDragEnter: function( target, e, id ) {
    	var mask = Ext.get( id );
    	if ( !mask.hasClass( 'x-Module-elementDeclinedMask' ) ) {
    		this.markFormActionMaskAsAccepted( mask );
    	}
        var variableSetMask = mask.variableSetMask;
        if ( !Ext.isEmpty( variableSetMask ) ) {
        	this.markFormActionMaskAsSelected( variableSetMask );
        	if ( !Ext.isEmpty( variableSetMask.dropTarget ) ) {
        		variableSetMask.dropTarget.lock();
        	}
        } else {
        	var formMask = mask.formMask;
            if ( !Ext.isEmpty( formMask ) ) {
            	this.markFormActionMaskAsSelected( formMask );
            	if ( !Ext.isEmpty( formMask.dropTarget ) ) {
            		formMask.dropTarget.lock();
            	}
            }
        }
        return true;
    },
    onFormActionBeforeDragOut: function( target, e, id ) {
    	var mask = Ext.get( id );
    	if ( !mask.hasClass( 'x-Module-elementDeclinedMask' ) ) {
    		this.markFormActionMaskAsSelected( mask );
    	}
        var variableSetMask = mask.variableSetMask;
        if ( !Ext.isEmpty( variableSetMask ) ) {
        	this.markFormActionMaskAsAccepted( variableSetMask );
        	if ( !Ext.isEmpty( variableSetMask.dropTarget ) ) {
        		variableSetMask.dropTarget.unlock();
        	}
        } else {
        	var formMask = mask.formMask;
            if ( !Ext.isEmpty( formMask ) ) {
            	this.markFormActionMaskAsAccepted( formMask );
            	if ( !Ext.isEmpty( formMask.dropTarget ) ) {
            		formMask.dropTarget.unlock();
            	}
            }
        }
        return true;
    },
    markFormActionMaskAsSelected: function( mask ) {
    	mask.removeClass( 'x-Module-elementAcceptedMask' );
        mask.addClass( 'x-Module-elementSelectedMask' );
    },
    markFormActionMaskAsAccepted: function( mask ) {
    	mask.removeClass( 'x-Module-elementSelectedMask' );
        mask.addClass( 'x-Module-elementAcceptedMask' );
    },
    onFormActionOver: function( dd, e, data ) {
    	var mask = e.getTarget( null, null, true );
        if ( mask.hasClass( 'x-Module-elementDeclinedMask' ) ) {
        	return this.dropNotAllowedCls;
        } else {
        	return this.dropAllowedCls;
        }
    },
    onFormActionDrop: function( dd, e, data ) {
        var mask = e.getTarget( null, null, true );
        if ( mask.hasClass( 'x-Module-elementDeclinedMask' ) ) {
        	return true;
        }

        var component = data.component;
        var panelItemId = mask.panelItemId;
        var item = Ext.getCmp( panelItemId );

        if ( item.definition.objectDef.genre == 'DT_BUTTON' ) {
          var dtButton = this.getDtButton( mask.variableSetPanelItemId, mask.dtButtonId );

          if ( !Ext.isEmpty( dtButton ) && !Ext.isEmpty( dtButton.handler ) ) {
            var warnMsg = getTranslation( 'Dodanie akcji formularza spowoduje zmianę typu przycisku.' );
            warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

            Ext.Msg.show( {
              title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
              msg: getTranslation( warnMsg ),
              buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
              },
              fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                  this.showFormActionParametersWindow( component, mask );
                }
              },
              icon: Ext.Msg.QUESTION,
              scope: this
            } );
          } else {
            this.showFormActionParametersWindow( component, mask );
          }
        } else {
          this.showFormActionParametersWindow( component, mask );
        }

        return true;
    },
    getDtButton: function( variableSetPanelItemId, dtButtonId ) {
      var dtButton = null;
      var variableSetPanelItem = Ext.getCmp( variableSetPanelItemId );

      Ext.each( variableSetPanelItem.definition.objectDef.DTButtons, function( button, index, buttons ) {
        if ( button.buttonId === dtButtonId ) {
          dtButton = button;
          return false;
        }
      } );

      return dtButton;
    },
    showFormActionParametersWindow: function( component, mask ) {
      var destinationType = mask.destinationType;
      var panelItemId = mask.panelItemId;
      var item = Ext.getCmp( panelItemId );

      var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
        title: getTranslation( 'Parametry akcji formularza' ) + ': ' + component.name,
        component: component,
        processNode: this.initialConfig.activityNode.parentNode,
        conditionalExecutionEnabled: true,
        inactiveEnabled: true,
        bindTo: mask.bindTo,
        destinationType: destinationType,
        acceptButton: item.definition.objectDef.genre == 'ACTION_ACCEPT_BUTTON',
        availableVariables: this.getPresentVariableIds(),
        missingVariablesValidatorFunction: this.validateMissingVariablesInIntegrationComponentParameterValue,
        missingVariablesValidatorScope: this,
        systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
        validateFieldFunction: this.validateIntegrationComponentParameterValue,
        validateFieldScope: this,
        tableId: ( destinationType === Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION
            || destinationType === Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION )
            ? mask.tableId : null,
        buttonId: this.getButtonIdForComponent( item ),
        dtButtons: ( item.definition.objectDef.genre == 'VARIABLE_SET'
            && destinationType === Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION )
            ? Ext.ux.suncode.IntegrationComponentService.getValidDtButtons( component ) : null,
        validateFunction: function( condition, values, extraConfig ) {
          var valid = true;

          if ( item.definition.objectDef.genre == 'VARIABLE_SET'
              && destinationType === Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION ) {
            var dtButtons = extraConfig.dtButtons;

            if ( !Ext.isEmpty( dtButtons ) ) {
              Ext.each( dtButtons, function( dtButton, index, allDtButtons ) {
                if ( this.checkDuplication( dtButton.id ) ) {
                  showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
                  valid = false;
                }
              }, this );
            }
          }

          return valid;
        },
        validateScope: this,
        saveFunction: function( condition, values, extraConfig ) {
          if ( item.definition.objectDef.genre == 'DT_BUTTON' ) {
            var dtButton = this.getDtButton( mask.variableSetPanelItemId, mask.dtButtonId );

            if ( !Ext.isEmpty( dtButton ) ) {
              dtButton.formActions.push( {
                id: component.id,
                customDescription: extraConfig.customDescription,
                condition: condition,
                inactive: extraConfig.inactive,
                creationDate: extraConfig.creationDate,
                modificationDate: extraConfig.modificationDate,
                parameters: values
              } );
              dtButton.handler = '';
              return false;
            }
          } else if ( item.definition.objectDef.genre == 'VARIABLE_SET'
              && destinationType === Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION ) {
            var dtButtons = extraConfig.dtButtons;

            if ( !Ext.isEmpty( dtButtons ) ) {
              var toolbar = item.items.first().getBottomToolbar();

              Ext.each( dtButtons, function( dtButton, index, allDtButtons ) {
                var nameTranslations = new Object();
                var tooltipTranslations = new Object();
                var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();

                if ( !Ext.isEmpty( supportedLanguages ) ) {
                  Ext.each( supportedLanguages, function( language, index, languages ) {
                    nameTranslations[language] = dtButton.name;
                    tooltipTranslations[language] = dtButton.tooltip;
                  } );
                }

                var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
                var packageId = packageNode.attributes.packageId;
                var activityNode = this.initialConfig.activityNode;
                var processNode = activityNode.parentNode;
                var processDefId = processNode.attributes.processDefId;
                var activityDefId = activityNode.attributes.activityDefId;
                var variableSetId = item.definition.objectDef.varId;
                var nameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
                    + ')_VARIABLESET(' + variableSetId + ')_DTBUTTON(' + dtButton.id + ')';
                var tooltipTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
                    + ')_VARIABLESET(' + variableSetId + ')_DTBUTTON(' + dtButton.id + ')_DESC';
                var translations = new Object();
                translations[nameTranslationKey] = nameTranslations;
                translations[tooltipTranslationKey] = tooltipTranslations;

                var dtButtonDef = new Object();
                dtButtonDef = Ext.apply( dtButtonDef, {
                  buttonId: dtButton.id,
                  name: dtButton.name,
                  icon: dtButton.icon,
                  color: dtButton.color,
                  tooltip: dtButton.tooltip,
                  handler: '',
                  disabled: dtButton.disabled,
                  translations: translations,
                  formActions: [ {
                    id: component.id,
                    customDescription: extraConfig.customDescription,
                    condition: condition,
                    inactive: extraConfig.inactive,
                    creationDate: extraConfig.creationDate,
                    modificationDate: extraConfig.modificationDate,
                    parameters: values
                  } ]
                } );
                item.definition.objectDef.DTButtons.push( dtButtonDef );

                var dtButtonNameTranslation = getXpdlVariableSetDtButtonNameTranslation(
                    packageId, processDefId, activityDefId, variableSetId, dtButton.id, dtButton.name );
                var addedButton = toolbar.addButton( this.createDtButton( dtButtonDef, dtButtonNameTranslation ) );
                toolbar.doLayout();

                this.analyzeVariablesMissingInIntegrationComponents( addedButton );

                if ( this.areIntegrationComponentsVisible() ) {
                  this.updateFormActionsOverlay( addedButton );
                }
              }, this );
            }
          } else {
            item.definition.objectDef.formActions.push( {
              id: component.id,
              customDescription: extraConfig.customDescription,
              condition: condition,
              inactive: extraConfig.inactive,
              creationDate: extraConfig.creationDate,
              modificationDate: extraConfig.modificationDate,
              parameters: values
            } );
          }

          if ( item.definition.objectDef.genre == 'HTTP_LINK' ) {
            item.definition.objectDef.type = 'Actions';
          }

          this.analyzeVariablesMissingInIntegrationComponents( item );

          if ( this.areIntegrationComponentsVisible() ) {
            this.updateFormActionsOverlay( item );
          }

          this.showPreviewOutOfDateMessage();
          this.storeParentWindowAsUnsaved();
        },
        saveScope: this,
        getComponentRegistrationFunction: function( id ) {
          return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
        },
        getComponentRegistrationScope: this
      } );
      win.show();
    },
    validateIntegrationComponentParameterValue: function( fieldConfig, value ) {
      var missingVariables = Ext.ux.suncode.IntegrationComponentService.getVariablesMissingInValue(
          '', value, this.getPresentVariableIds() );

      if ( !Ext.isEmpty( missingVariables ) ) {
        return {
          valid: false,
          preventGlobalMarkError: true,
          errorMessage: this.buildVariablesMissingInIntegrationComponentParameterValueMessage( fieldConfig.name, missingVariables )
        };
      } else {
        return {
          valid: true
        };
      }
    },
    buildVariablesMissingInIntegrationComponentParameterValueMessage: function( fieldName, missingVariables ) {
      var msg = getTranslation( 'Parametr' );
      msg += ' <b>';
      msg += fieldName;
      msg += '</b> ';
      msg += getTranslation( 'zawiera zmienne nieistniejące na formularzu' );
      msg += ': ';

      Ext.each( missingVariables, function( variable, index, variables ) {
        msg += '<br>- ';
        msg += variable.variableId;
      } );

      return msg;
    },
    onCopyForm: function( choosenActivityNode ) {
      var activityNode = this.initialConfig.activityNode;
      var currentActivityDefId = activityNode.attributes.activityDefId;
      var choosenActivityDefId = choosenActivityNode.attributes.activityDefId;
      var processNode = choosenActivityNode.parentNode;
      var processDefId = processNode.attributes.processDefId;
      var packageNode = processNode.parentNode;
      var packageId = packageNode.attributes.packageId;
      var exclusions = new Array();
      var variablesToCopy = new Array();
      var newFormTemplate = deepObjectCopy( choosenActivityNode.attributes.form.template );

      Ext.each( choosenActivityNode.attributes.form.variables, function( variable, index, variables ) {
        if ( variable.genre == 'VARIABLE_SET' ) {
          var table = processNode.findTable( variable.varId );

          if ( Ext.isEmpty( table ) ) {
            exclusions.push( {
              itemName: getTranslation( 'Tabela dynamiczna' ),
              itemId: variable.varId,
              reason: getTranslation( 'lokalna tabela nie może być kopiowana' )
            } );
          } else {
            variablesToCopy.push( variable );
          }
        } else {
          variablesToCopy.push( variable );
        }
      } );

      Ext.each( exclusions, function( exclusion, index, allExclusions ) {
        var found = false;

        for ( var i = 0; i < newFormTemplate.rows.length; i++ ) {
          var row = newFormTemplate.rows[i];

          for ( var j = 0; j < row.items.length; j++ ) {
            var item = row.items[j];

            if ( item.id == exclusion.itemId ) {
              row.items.splice( j, 1 );
              found = true;
              return;
            }
          }

          if ( found ) {
            return;
          }
        }
      } );

      Ext.each( choosenActivityNode.attributes.form.variables, function( variable, index, variables ) {
        if ( variable.genre == 'VARIABLE_SET' ) {
          Ext.each( variable.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
            var varId = variable.varId;
            var buttonId = dtButton.buttonId;
            var currentNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + choosenActivityDefId
                + ')_VARIABLESET(' + varId + ')_DTBUTTON(' + buttonId + ')';
            var newNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
                + ')_VARIABLESET(' + varId + ')_DTBUTTON(' + buttonId + ')';
            var currentTooltipTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + choosenActivityDefId
                + ')_VARIABLESET(' + varId + ')_DTBUTTON(' + buttonId + ')_DESC';
            var newTooltipTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
                + ')_VARIABLESET(' + varId + ')_DTBUTTON(' + buttonId + ')_DESC';

            var nameTranslations = Ext.ux.suncode.I18NService.getPackageTranslations( currentNameTranslationKey );
            Ext.ux.suncode.I18NService.savePackageTranslations( newNameTranslationKey, nameTranslations );

            var tooltipTranslations = Ext.ux.suncode.I18NService.getPackageTranslations( currentTooltipTranslationKey );
            Ext.ux.suncode.I18NService.savePackageTranslations( newTooltipTranslationKey, tooltipTranslations );
          } );
        }
      } );

      Ext.each( choosenActivityNode.attributes.form.buttons, function( button, i, buttons ) {
        switch( button.genre ) {
          case 'ACTION_ACCEPT_BUTTON':
            var currentNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + choosenActivityDefId
                + ')_ACTIONBUTTON(' + button.actionName + ')';
            var newNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
                + ')_ACTIONBUTTON(' + button.actionName + ')';
            var currentTooltipTranslationKey = currentNameTranslationKey + '_DESC';
            var newTooltipTranslationKey = newNameTranslationKey + '_DESC';

            var nameTranslations = Ext.ux.suncode.I18NService.getPackageTranslations( currentNameTranslationKey );
            Ext.ux.suncode.I18NService.savePackageTranslations( newNameTranslationKey, nameTranslations );
            var tooltipTranslations = Ext.ux.suncode.I18NService.getPackageTranslations( currentTooltipTranslationKey );
            Ext.ux.suncode.I18NService.savePackageTranslations( newTooltipTranslationKey, tooltipTranslations );
            break;
          case 'GENERATE_PDF_BUTTON':
            var currentNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + choosenActivityDefId
                + ')_PDFBUTTON(' + button.actionName + ')';
            var newNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
                + ')_PDFBUTTON(' + button.actionName + ')';

            var translations = Ext.ux.suncode.I18NService.getPackageTranslations( currentNameTranslationKey );
            Ext.ux.suncode.I18NService.savePackageTranslations( newNameTranslationKey, translations );
            break;
          case 'ADD_FILE_BUTTON':
            var replacedButtonName = Ext.ux.suncode.I18NService.replaceAddFileButtonId( button.docClassName )
            var currentNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + choosenActivityDefId
                + ')_ADDFILEBUTTON(' + replacedButtonName + ')';
            var newNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
                + ')_ADDFILEBUTTON(' + replacedButtonName + ')';

            var translations = Ext.ux.suncode.I18NService.getPackageTranslations( currentNameTranslationKey );
            Ext.ux.suncode.I18NService.savePackageTranslations( newNameTranslationKey, translations );
            break;
          default:
            brreak;
        }
      } );

      Ext.each( choosenActivityNode.attributes.form.httpLinks, function( httpLink, i, httpLinks ) {
        var replacedButtonName = Ext.ux.suncode.I18NService.replaceHttpLinkId( httpLink.buttonName );
        var currentNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + choosenActivityDefId
            + ')_HTTPLINK(' + replacedButtonName + ')';
        var newNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
            + ')_HTTPLINK(' + replacedButtonName + ')';
        var currentTooltipTranslationKey = currentNameTranslationKey + '_DESC';
        var newTooltipTranslationKey = newNameTranslationKey + '_DESC';

        var nameTranslations = Ext.ux.suncode.I18NService.getPackageTranslations( currentNameTranslationKey );
        Ext.ux.suncode.I18NService.savePackageTranslations( newNameTranslationKey, nameTranslations );
        var tooltipTranslations = Ext.ux.suncode.I18NService.getPackageTranslations( currentTooltipTranslationKey );
        Ext.ux.suncode.I18NService.savePackageTranslations( newTooltipTranslationKey, tooltipTranslations );
      } );

      var mock = new Ext.ux.suncode.ActivityNode( choosenActivityNode.attributes );
      mock.loadFormTemplate( newFormTemplate );
      mock.loadFormVariables( variablesToCopy );
      mock.loadFormButtons( choosenActivityNode.attributes.form.buttons );
      mock.loadHttpLinks( choosenActivityNode.attributes.form.httpLinks );
      mock.loadLabelActions( choosenActivityNode.attributes.form.labelActions );
      mock.loadFormFormActions( choosenActivityNode.attributes.form.actions );
      mock.loadFormEventActions( choosenActivityNode.attributes.form.events );
      mock = Ext.apply( mock, {
        parentNode: processNode
      } );

    	this.removeAll();
      clearArray( this.presentVariableIds );
    	this.presentVariableIds = mock.getVariableIdsOnForm();
    	this.add( this.buildItems( mock ) );
    	this.doLayout();
    	this.copyFormActions( mock );

    	if ( !Ext.isEmpty( exclusions ) ) {
        var warnMsg = this.buildPasteComponentsWarningMessage(
            getTranslation( 'Komponenty wykluczone podczas kopiowania' ), exclusions );

        showWarn( warnMsg );
      }
    },
    showAllIntegrationComponentsOnForm: function() {
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var components = new Array();
      components = components.concat( this.collectFormElementIntegrationComponents(
          this.definition.objectDef, getTranslation( 'Globalna akcja formularza' ), getTranslation( 'Globalne zdarzenie formularza' ), true ) );

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( subitem, j, internalSize ) {
          if ( subitem.idAssigned ) {
            var definition = subitem.definition;
            var objectDef = definition.objectDef;

            switch ( objectDef.genre ) {
              case 'VARIABLE':
                var variable = processNode.findVariable( objectDef.varId );
                var variableName = variable.name;
                components = components.concat( this.collectFormElementIntegrationComponents(
                    objectDef, getTranslation( 'Akcja formularza na zmiennej formularza' ) + ': ' + variableName,
                    getTranslation( 'Zdarzenie na zmiennej formularza' ) + ': ' + variableName, false ) );
                break;
              case 'VARIABLE_SET':
                var variableSetTitle = objectDef.name;
                components = components.concat( this.collectFormElementIntegrationComponents(
                    objectDef, getTranslation( 'Akcja formularza na tabeli dynamicznej' ) + ': ' + variableSetTitle,
                    getTranslation( 'Zdarzenie na tabeli dynamicznej' ) + ': ' + variableSetTitle, false ) );

                if ( !Ext.isEmpty( objectDef.DTButtons ) ) {
                  Ext.each( objectDef.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                    var dtButtonName = dtButton.name;
                    components = components.concat( this.collectFormElementIntegrationComponents(
                        dtButton, getTranslation( 'Akcja formularza na przycisku tabeli dynamicznej' ) + ': ' + dtButtonName,
                        getTranslation( 'Zdarzenie na przycisku tabeli dynamicznej' ) + ': ' + dtButtonName, false ) );
                  }, this );
                }
                break;
              case 'LABEL':
                var labelText = objectDef.text;
                components = components.concat( this.collectFormElementIntegrationComponents(
                    objectDef, getTranslation( 'Akcja formularza na etykiecie' ) + ': ' + labelText,
                    getTranslation( 'Zdarzenie na etykiecie' ) + ': ' + labelText, false ) );
                break;
              case 'HTTP_LINK':
                var buttonName = objectDef.buttonName;
                components = components.concat( this.collectFormElementIntegrationComponents(
                    objectDef, getTranslation( 'Akcja formularza na przycisku' ) + ': ' + buttonName,
                    getTranslation( 'Zdarzenie na przycisku' ) + ': ' + buttonName, false ) );
                break;
              case 'ACTION_ACCEPT_BUTTON':
                var buttonName = objectDef.buttonName;
                components = components.concat( this.collectFormElementIntegrationComponents(
                    objectDef, getTranslation( 'Akcja formularza na przycisku' ) + ': ' + buttonName,
                    getTranslation( 'Zdarzenie na przycisku' ) + ': ' + buttonName, false ) );
                break;
              default:
                break;
            }
          }
        }, this );
      }, this );

      var win = new Ext.ux.suncode.VariableUtilizationWindow( {
        windowTitle: getTranslation( 'Komponenty integracyjne na formularzu' ),
        utilization: components,
        showCustomDescription: true,
        showModificationDate: true,
        showVariableUtilizationActions: true,
        showObjectNameAsColumn: true,
        enableRemoveAll: true,
        showLocationFilter: true,
        showObjectNameFilter: true,
        showCustomDescriptionFilter: true,
        preventSave: true,
        processNode: processNode,
        afterRemoveComponentFunction: function() {
          this.analyzeVariablesMissingInIntegrationComponents( this );
          this.updateFormActionsOverlay( this );

          this.items.each( function( item, i, externalSize ) {
            item.items.each( function( subitem, j, internalSize ) {
              if ( subitem.definition.objectDef.genre == 'VARIABLE_SET' ) {
                var variableSet = subitem.items.first();
                var toolbar = variableSet.getBottomToolbar();
                toolbar.items.each( function( button ) {
                  if ( !Ext.isEmpty( button.definition ) ) {
                    this.analyzeVariablesMissingInIntegrationComponents( button );
                    this.analyzeFormActionsOverlay( button );
                    this.analyzeEventActionsOverlay( button );
                  }
                }, this );
              }

              this.analyzeVariablesMissingInIntegrationComponents( subitem );
              this.analyzeFormActionsOverlay( subitem );
              this.analyzeEventActionsOverlay( subitem );
            }, this );
          }, this );

          this.showPreviewOutOfDateMessage();
          this.storeParentWindowAsUnsaved();
        },
        afterRemoveComponentScope: this
      } );
      win.show();
    },
    collectFormElementIntegrationComponents: function( objectDef, formActionsObjectOwner, eventActionsObjectOwner, skipObjectOwnerPrefix ) {
      var components = new Array();
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var mainPanel = Ext.getCmp( 'main_panel' );
      var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();
      var eventActionsCategories = mainPanel.getEventActionsCategories();

      Ext.each( objectDef.formActions, function( formAction, index, formActions ) {
        var componentId = formAction.id;
        var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( formActionsCategories, componentId );

        if ( !skipObjectOwnerPrefix ) {
          if ( !Ext.isEmpty( formAction.globalId ) ) {
            formActionsObjectOwner = getTranslation( 'Globalna' ) + ' ' + lowerFirstLetter( formActionsObjectOwner );
          } else {
            formActionsObjectOwner = getTranslation( 'Lokalna' ) + ' ' + lowerFirstLetter( formActionsObjectOwner );
          }
        }

        components.push( {
          processDefId: processNode.attributes.processDefId,
          activityDefId: activityNode.attributes.activityDefId,
          objectOwner: formActionsObjectOwner,
          objectName: componentDef.name,
          objectType: Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION,
          component: formAction,
          componentId: componentId,
          customDescription: formAction.customDescription,
          modificationDate: formAction.modificationDate,
          objectContainer: formActions
        } );
      }, this );

      Ext.each( objectDef.eventActions, function( eventAction, index, eventActions ) {
        var componentId = eventAction.id;
        var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( eventActionsCategories, componentId );

        if ( !skipObjectOwnerPrefix ) {
          if (!Ext.isEmpty(eventAction.globalId)) {
            eventActionsObjectOwner = getTranslation('Globalne') + ' ' + lowerFirstLetter(eventActionsObjectOwner);
          } else {
            eventActionsObjectOwner = getTranslation('Lokalne') + ' ' + lowerFirstLetter(eventActionsObjectOwner);
          }
        }

        components.push( {
          processDefId: processNode.attributes.processDefId,
          activityDefId: activityNode.attributes.activityDefId,
          objectOwner: eventActionsObjectOwner,
          objectName: componentDef.name,
          objectType: Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION,
          component: eventAction,
          componentId: componentId,
          customDescription: eventAction.customDescription,
          modificationDate: eventAction.modificationDate,
          objectContainer: eventActions
        } );
      }, this );

      return components;
    },
    copyFormActions: function( choosenActivityNode ) {
    	clearArray( this.definition.objectDef.formActions );
    	this.definition.objectDef.formActions = deepObjectCopy( choosenActivityNode.attributes.form.actions );
    	
    	if ( this.areIntegrationComponentsVisible() ) {
    	  this.updateFormActionsOverlay( this );
    	}
    	
    	this.showPreviewOutOfDateMessage();
    	this.storeParentWindowAsUnsaved();
    },
    saveForm: function() {
    	var formElements = this.getFormElements();
    	if ( !formElements ) {
    		return;
    	}
    	
    	var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var processDefId = processNode.attributes.processDefId;
        var activityDefId = activityNode.attributes.activityDefId;
    	Ext.ux.suncode.I18NService.onActivityFormClear( processDefId, activityDefId );
        this.addTranslationsFromElements( formElements.formVariables );
        this.addTranslationsFromElements( formElements.httpLinks );
        this.addTranslationsFromElements( formElements.formButtons );
        
        Ext.each( formElements.formVariables, function( formVariable, index, formVariables ) {
    		if ( formVariable.genre == 'VARIABLE_SET' ) {
          var table = processNode.findTable( formVariable.varId );

          if ( Ext.isEmpty( table ) ) {
            var dtButtonTranslationRegex = Ext.ux.suncode.I18NService.buildProcessDefIdPlaceholder( processDefId );
            dtButtonTranslationRegex += '_';
            dtButtonTranslationRegex += Ext.ux.suncode.I18NService.buildActivityDefIdPlaceholder( activityDefId );
            dtButtonTranslationRegex += '_';
            dtButtonTranslationRegex += Ext.ux.suncode.I18NService.buildVariableSetIdPlaceholder( formVariable.varId );
            dtButtonTranslationRegex += '_';
            dtButtonTranslationRegex += Ext.ux.suncode.I18NService.DT_BUTTON_ID_PLACEHOLDER_PREFIX;

            Ext.ux.suncode.I18NService.removeByPackageTranslationsKeyContains( dtButtonTranslationRegex );
            this.addTranslationsFromElements( formVariable.DTButtons );
          } else {
            var localDtButtons = new Array();

            Ext.each( formVariable.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
              if ( Ext.isEmpty( dtButton.globalId ) ) {
                localDtButtons.push( dtButton );
              }
            } );

            this.addTranslationsFromElements( localDtButtons );
          }
    		}
    	}, this );
    	
        activityNode.loadFormTemplate( formElements.formTemplate );
        activityNode.loadFormVariables( formElements.formVariables );
        activityNode.loadFormButtons( formElements.formButtons );
        activityNode.loadHttpLinks( formElements.httpLinks );
        activityNode.loadLabelActions( formElements.labelActions );
        activityNode.loadFormFormActions( formElements.formFormActions );
        activityNode.loadFormEventActions( formElements.formEventActions );
        activityNode.loadValidatorsTemplates( formElements.validatorsTemplates );
        activityNode.loadVariablesSettersTemplates( formElements.variablesSettersTemplates );

        if ( !Ext.isEmpty( formElements.formButtons ) ) {
            Ext.each( formElements.formButtons, function( formButton, index, formButtons ) {
                if ( formButton.genre == 'ACTION_ACCEPT_BUTTON'  ) {
                    if ( !Ext.isEmpty( formButton.forwardTo ) && formButton.forwardToChanged && !Ext.isEmpty( processNode.findFormalParam( 'Action' ) ) ) {
                        var actionName = formButton.actionName;
                        var transitionId = formButton.forwardTo;
                        var currentCond = activityNode.getCondTransitionCondition( transitionId );
                        var newCond = 'Action==\'' + actionName + '\'';

                        if ( Ext.isEmpty( currentCond ) ) {
                            currentCond = newCond;
                        } else if ( currentCond.indexOf( newCond ) == -1 ) {
                            if ( currentCond.indexOf( '&&' ) != -1 ) {
                                currentCond = '(' + currentCond + ') || ' + newCond;
                            } else {
                                currentCond += ' || ' + newCond;
                            }
                        }

                        if ( !Ext.isEmpty( formButton.previousForwardTo ) ) {
                            activityNode.resetForwardToCondTransitionConditions( actionName, formButton.previousForwardTo );
                        }

                        activityNode.updateCondTransitionCondition( {
                            id: transitionId,
                            condition: currentCond
                        } );
                    } else if ( formButton.forwardToReset ) {
                        var actionName = formButton.actionName;

                        activityNode.resetForwardToCondTransitionConditions( actionName, formButton.previousForwardTo );
                    }

                    delete formButton.forwardToChanged
                    delete formButton.forwardToReset;
                }
            } );
        }

        if ( !Ext.isEmpty( formElements.toDuplicate ) ) {
            var processNode = activityNode.parentNode;
            var activityDefId = activityNode.attributes.activityDefId;

            Ext.each( formElements.toDuplicate, function( def, index, allToDuplicate ) {
                processNode.addOrUpdateVariableInAllActivities( def.varDef, def.item, def.location, def.specification, activityDefId );
            } );
        }
        
        var propertiesFormPanel = Ext.getCmp( 'activity_properties_form_panel' );
        if ( !Ext.isEmpty( propertiesFormPanel ) ) {
            propertiesFormPanel.reloadFormGrids();
        }

        Ext.getCmp( 'main_panel' ).setSaved( false );
        this.ownerCt.closeWindow();
    },
    getFormElements: function() {
        var activityNode = this.initialConfig.activityNode;
        var activityType = activityNode.attributes.activityType;
    	  var anyVariableAdded = false;
        var formTemplate = new Object();
        var rows = new Array();
        var formVariables = new Array();
        var formButtons = new Array();
        var httpLinks = new Array();
        var labelActions = new Array();
        var formFormActions = this.definition.objectDef.formActions;
        var formEventActions = this.definition.objectDef.eventActions;
        var validatorsTemplates = new Array();
        var variablesSettersTemplates = new Array();
        var toDuplicate = new Array();
        var formItems = this.items.items;
        var previousElementId = null;

        if ( Ext.isEmpty( formItems ) && activityType == Ext.ux.suncode.Constants.ACTIVITY ) {
            showWarn( getTranslation( 'Dodaj przynajmniej jedną zmienną formularza.' ) );
            return null;
        }

        for ( var i = 0; i < formItems.length; i++ ) {
            var item = formItems[i];
            var components = item.items.items;
            var row = new Object();
            var items = new Array();

            for ( var j = 0; j < components.length; j++ ) {
                var component = components[j];
                var objectDef = component.definition.objectDef;

                if ( component.idAssigned ) {
                    switch ( objectDef.genre ) {
                        case 'VARIABLE':
                            anyVariableAdded = true;
                            formVariables.push( objectDef );

                            var lastToDuplicate = toDuplicate[toDuplicate.length - 1];
                            if ( !Ext.isEmpty( lastToDuplicate ) && Ext.isEmpty( lastToDuplicate.nextElementId ) ) {
                              lastToDuplicate.location = Ext.apply( {
                                nextElementId: objectDef.varId
                              }, lastToDuplicate.location );
                            }

                            if ( objectDef.duplicateVariable ) {
                                var itemToDuplicate = new Object();
                                itemToDuplicate = Ext.apply( {
                                    id: objectDef.varId,
                                    type: component.type,
                                    labelAlign: objectDef.labelAlign,
                                    labelWidth: objectDef.labelWidth,
                                    labelSeparator: objectDef.labelSeparator,
                                    labelFontSize: objectDef.labelFontSize,
                                    labelColor: objectDef.labelColor,
                                    textDecoration: objectDef.textDecoration,
                                    hideLabel: objectDef.hideLabel,
                                    marginTop: objectDef.marginTop,
                                    marginRight: objectDef.marginRight,
                                    marginBottom: objectDef.marginBottom,
                                    marginLeft: objectDef.marginLeft,
                                    width: objectDef.width
                                }, itemToDuplicate );

                                if ( !Ext.isEmpty( objectDef.height ) ) {
                                    itemToDuplicate = Ext.apply( {
                                        height: objectDef.height
                                    }, itemToDuplicate );
                                }

                                toDuplicate.push( {
                                    varDef: objectDef,
                                    item: itemToDuplicate,
                                    location: {
                                      previousElementId: previousElementId
                                    },
                                    specification: objectDef.specification
                                } );
                            }

                            previousElementId = objectDef.varId;
                            delete objectDef.duplicateVariable;
                            delete objectDef.specification;
                            break;
                        case 'VARIABLE_SET':
                            anyVariableAdded = true;
                            formVariables.push( objectDef );

                            var lastToDuplicate = toDuplicate[toDuplicate.length - 1];
                            if ( !Ext.isEmpty( lastToDuplicate ) && Ext.isEmpty( lastToDuplicate.nextElementId ) ) {
                              lastToDuplicate.location = Ext.apply( {
                                nextElementId: objectDef.varId
                              }, lastToDuplicate.location );
                            }

                            if ( objectDef.duplicateVariable ) {
                                var itemToDuplicate = new Object();
                                itemToDuplicate = Ext.apply( {
                                    id: objectDef.varId,
                                    type: component.type,
                                    headerFontSize: objectDef.headerFontSize,
                                    cellFontSize: objectDef.cellFontSize
                                }, itemToDuplicate );

                                toDuplicate.push( {
                                    varDef: objectDef,
                                    item: itemToDuplicate,
                                    location: {
                                      previousElementId: previousElementId
                                    },
                                    specification: objectDef.specification
                                } );
                            }

                            previousElementId = objectDef.varId;
                            delete objectDef.duplicateVariable;
                            break;
                        case 'HTTP_LINK':
                            httpLinks.push( objectDef );
                            break;
                        case 'ACTION_ACCEPT_BUTTON':
                        	formButtons.push( objectDef );
                        	if ( !Ext.isEmpty( objectDef.validatorsTemplates ) ) {
                        		Ext.each( objectDef.validatorsTemplates, function( template, index, templates ) {
                        			validatorsTemplates.push( {
                        				id: template.id,
                        				action: objectDef.actionName,
                        				components: template.components
                        			} );
                        		} );
                        	}
                        	if ( !Ext.isEmpty( objectDef.variablesSettersTemplates ) ) {
                        		Ext.each( objectDef.variablesSettersTemplates, function( template, index, templates ) {
                        			variablesSettersTemplates.push( {
                        				id: template.id,
                        				action: objectDef.actionName,
                        				components: template.components
                        			} );
                        		} );
                        	}
                        	break;
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            formButtons.push( objectDef );
                            break;
                        case 'LABEL':
                        	labelActions.push( {
                        		labelId: objectDef.id,
                        		formActions: objectDef.formActions
                        	} );
                          previousElementId = objectDef.id;
                          var lastToDuplicate = toDuplicate[toDuplicate.length - 1];
                          if ( !Ext.isEmpty( lastToDuplicate ) && Ext.isEmpty( lastToDuplicate.nextElementId ) ) {
                            lastToDuplicate.location = Ext.apply( {
                              nextElementId: objectDef.varId
                            }, lastToDuplicate.location );
                          }
                        	break;
                        default:
                            break;
                    }

                    items.push( this.getPanelItemConfig( component ) );
                } else {
                    switch ( objectDef.genre ) {
                        case 'VARIABLE':
                            showWarn( getTranslation( 'Zdefiniuj wszystkie zmienne formularza.' ) );
                            return null;
                        case 'VARIABLE_SET':
                            showWarn( getTranslation( 'Zdefiniuj wszystkie tabele dynamiczne.' ) );
                            return null;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            showWarn( getTranslation( 'Zdefiniuj wszystkie przyciski.' ) );
                            return null;
                        case 'LABEL':
                            showWarn( getTranslation( 'Zdefiniuj wszystkie etykiety.' ) );
                            return null;
                        default:
                            showWarn( getTranslation( 'Zdefiniuj wszystkie zmienne formularza.' ) );
                            return null;
                    }
                }
            }

            row = Ext.apply( {
                layoutPack: item.layoutPack,
                items: items
            }, row );

            rows.push( row );
        }

        if ( !anyVariableAdded && activityType == Ext.ux.suncode.Constants.ACTIVITY ) {
            showWarn( getTranslation( 'Dodaj przynajmniej jedną zmienną formularza.' ) );
            return null;
        }

        formTemplate = Ext.apply( {
            rows: rows
        }, formTemplate );
        
    	return {
    		formTemplate: formTemplate,
    		formVariables: formVariables,
    		formButtons: formButtons,
    		httpLinks: httpLinks,
    		labelActions: labelActions,
    		formFormActions: formFormActions,
        formEventActions: formEventActions,
    		validatorsTemplates: validatorsTemplates,
    		variablesSettersTemplates: variablesSettersTemplates,
    		toDuplicate: toDuplicate
    	};
    },
    getPanelItemConfig: function( component ) {
        var definition = component.definition;
        var objectDef = definition.objectDef;
        var panelItem = new Object();
        panelItem = Ext.apply( {
            type: component.type
        }, panelItem );

        switch ( objectDef.genre ) {
            case 'VARIABLE':
                panelItem = Ext.apply( {
                    id: objectDef.varId,
                    width: definition.width,
                    labelAlign: definition.labelAlign,
                    labelWidth: definition.labelWidth,
                    labelSeparator: definition.labelSeparator,
                    labelFontSize: definition.labelFontSize,
                    labelColor: definition.labelColor,
                    textDecoration: definition.textDecoration,
                    hideLabel: definition.hideLabel,
                    marginTop: definition.marginTop,
                    marginRight: definition.marginRight,
                    marginBottom: definition.marginBottom,
                    marginLeft: definition.marginLeft
                }, panelItem );

                if ( !Ext.isEmpty( definition.height ) ) {
                    panelItem = Ext.apply( {
                        height: definition.height
                    }, panelItem );
                }
                break;
            case 'VARIABLE_SET':
                panelItem = Ext.apply( {
                    id: objectDef.varId,
                    headerFontSize: objectDef.headerFontSize,
                	cellFontSize: objectDef.cellFontSize
                }, panelItem );
                break;
            case 'HTTP_LINK':
            case 'ACTION_ACCEPT_BUTTON':
            case 'ADD_FILE_BUTTON':
                panelItem = Ext.apply( {
                    id: objectDef.actionName,
                    icon: objectDef.icon,
                    color: objectDef.color
                }, panelItem );
                break;
            case 'GENERATE_PDF_BUTTON':
            case 'BARCODE_PRINT':
                panelItem = Ext.apply( {
                    id: objectDef.actionName,
                    color: objectDef.color
                }, panelItem );
                break;
            case 'LABEL':
                panelItem = Ext.apply( {
                    id: objectDef.id,
                    text: objectDef.text,
                    fontSize: objectDef.fontSize,
                    color: objectDef.color,
                    marginTop: objectDef.marginTop,
                    marginRight: objectDef.marginRight,
                    marginBottom: objectDef.marginBottom,
                    marginLeft: objectDef.marginLeft
                }, panelItem );
                break;
            default:
                break;
        }

        return panelItem;
    },
    addTranslationsFromElements: function( elements ) {
    	Ext.each( elements, function( element, index, allElements ) {
    		if ( !Ext.isEmpty( element.translations ) ) {
    			Ext.iterate( element.translations, function( key, translations, allTranslations ) {
    				Ext.ux.suncode.I18NService.savePackageTranslations( key, translations );
    	    	} );

    			if ( Ext.isEmpty( element.globalId ) ) {
            delete element.translations;
          }
    		}
    	} );
    },
    updateFormDesignerConfig: function() {
    	var mainPanel = Ext.getCmp( 'main_panel' );
    	mainPanel.setFormDesignerConfig( this.getFormDesignerConfig() );
    },
    getFormDesignerConfig: function() {
    	return {
    		gridActive: this.gridActive,
    		copyModeActive: this.copyModeActive,
        integrationComponentsVisible: this.integrationComponentsVisible
    	};
    },
    isGridActive: function() {
        return this.gridActive;
    },
    activateGrid: function() {
        this.toggleGrid( true );
    },
    deactivateGrid: function() {
        this.toggleGrid( false );
    },
    toggleGrid: function( activate ) {
        var gridCssClass = 'x-Module-drawingPanel-grid';

        this.items.each( function( item, i, externalSize ) {
            item.items.each( function( component, j, internalSize ) {
                var componentEl = component.getEl();

                if ( activate ) {
                    componentEl.addClass( gridCssClass );
                } else {
                    componentEl.removeClass( gridCssClass );
                }
            } );
        } );

        this.gridActive = activate;
    },
    isCopyModeActive: function() {
        return this.copyModeActive;
    },
    activateCopyMode: function() {
        this.toggleCopyMode( true );
    },
    deactivateCopyMode: function() {
        this.toggleCopyMode( false );
    },
    toggleCopyMode: function( activate ) {
    	if ( !activate ) {
    		this.unmarkAllComponents();
    	}
    	
        this.copyModeActive = activate;
    },
    areIntegrationComponentsVisible: function() {
        return this.integrationComponentsVisible;
    },
    showIntegrationComponents: function() {
        this.toggleIntegrationComponentsVisibility( true );
    },
    hideIntegrationComponents: function() {
        this.toggleIntegrationComponentsVisibility( false );
    },
    toggleIntegrationComponentsVisibility: function( visible ) {
      this.integrationComponentsVisible = visible;

      this.items.each( function( item, i, externalSize ) {
        item.items.each( function( component, j, internalSize ) {
          this.toggleComponentIntegrationComponentsVisibility( component, visible );

          if ( component.definition.objectDef.genre == 'VARIABLE_SET' ) {
            var variableSet = component.items.first();
            var toolbar = variableSet.getBottomToolbar();
            toolbar.items.each( function( button ) {
              if ( !Ext.isEmpty( button.definition ) ) {
                this.toggleComponentIntegrationComponentsVisibility( button, visible );
              }
            }, this );
          }
        }, this );
      }, this );

      if ( visible ) {
        this.addFormActionsOverlay( this );
        this.addEventActionsOverlay( this );
      } else {
        this.removeFormActionsOverlay( this );
        this.removeEventActionsOverlay( this );
      }
    },
    toggleComponentIntegrationComponentsVisibility: function( component, visible ) {
      if ( this.hasFormActions( component ) ) {
        if ( visible ) {
          this.addFormActionsOverlay( component );
        } else {
          this.removeFormActionsOverlay( component );
          this.removeComponentOverlayClasses( component )
          component.addClass( this.getComponentClsForOverlays( component ) );
        }
      }

      if ( this.hasEventActions( component ) ) {
        if ( visible ) {
          this.addEventActionsOverlay( component );
        } else {
          this.removeEventActionsOverlay( component );
          this.removeComponentOverlayClasses( component )
          component.addClass( this.getComponentClsForOverlays( component ) );
        }
      }
    },
    hasFormActions: function( component ) {
      return !Ext.isEmpty( component.definition.objectDef.formActions );
    },
    hasEventActions: function( component ) {
      return !Ext.isEmpty( component.definition.objectDef.eventActions );
    },
    removeComponentOverlayClasses: function( component ) {
        var classes = this.getComponentOverlayClasses( component );

        Ext.each( classes, function( cls, index, allClasses ) {
          component.removeClass( cls );
        } );
    },
    getComponentOverlayClasses: function( component ) {
        return component.definition.objectDef.genre == 'DT_BUTTON' ?
            [ 'x-Module-dtButton-overlay-0', 'x-Module-dtButton-overlay-14',
              'x-Module-dtButton-overlay-17', 'x-Module-dtButton-overlay-23',
              'x-Module-dtButton-overlay-36', 'x-Module-dtButton-overlay-39',
              'x-Module-dtButton-overlay-42', 'x-Module-dtButton-overlay-45',
              'x-Module-dtButton-overlay-51', 'x-Module-dtButton-overlay-64',
              'x-Module-dtButton-overlay-70'] :
            [ 'x-Module-component-overlay-5', 'x-Module-component-overlay-24',
              'x-Module-component-overlay-27', 'x-Module-component-overlay-33',
              'x-Module-component-overlay-46', 'x-Module-component-overlay-49',
              'x-Module-component-overlay-52', 'x-Module-component-overlay-55',
              'x-Module-component-overlay-61', 'x-Module-component-overlay-74',
              'x-Module-component-overlay-80']
    },
    getComponentClsForOverlays: function( component ) {
        var size = 5;

        if ( component.hasError ) {
          size += 19;
        }

        if ( this.areIntegrationComponentsVisible() ) {
          if ( !Ext.isEmpty( component.definition.objectDef.formActions ) ) {
            size += 22;

            if ( component.definition.objectDef.formActions.length > 9 ) {
              size += 6;
            }
          }
          if ( !Ext.isEmpty( component.definition.objectDef.eventActions ) ) {
            size += 22;

            if ( component.definition.objectDef.eventActions.length > 9 ) {
              size += 6;
            }
          }
        }

        if ( component.definition.objectDef.genre == 'DT_BUTTON' ) {
          size -= 10;

          if ( size < 0 ) {
            size = 0;
          }

          return 'x-Module-dtButton-overlay-' + size;
        } else {
          return 'x-Module-component-overlay-' + size;
        }
    },
    getMarginForIntegrationComponents: function( component, componentType ) {
        var integrationComponents = component.definition.objectDef[componentType];

        if ( !Ext.isEmpty( integrationComponents ) && integrationComponents.length > 9 ) {
            return this.integrationComponentsLargeMargin;
        } else {
            return this.integrationComponentsMargin;
        }
    },
    getMarginForError: function() {
        return this.errorMargin;
    },
    showPreviewOutOfDateMessage: function() {
    	var wins = Ext.ux.suncode.Clipboard.getActivityFormPreviews();
    	
    	if ( !Ext.isEmpty( wins ) ) {
    		Ext.each( wins, function( win, index, allWins ) {
    			if ( !win.closed ) {
    				win.Ext.Msg.show( {
    			        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
    			        msg: getTranslation( 'Podgląd może być nieaktualny.' ),
    			        buttons: Ext.Msg.OK,
    			        icon: Ext.Msg.WARNING,
    			        width: 250    			        
    			    } );
    			}
    		} );
    	}
    }
} );

Ext.ux.suncode.FormObjectDefWindow = function( config ) {
    var component = config.component;
    var availableVariables = config.availableVariables;
    var validateIntegrationComponentFieldFunction = config.validateIntegrationComponentFieldFunction;
    var validateIntegrationComponentFieldScope = config.validateIntegrationComponentFieldScope;
    var objectDef = component.definition.objectDef;
    var viewSize = Ext.getBody().getViewSize();
    var viewWidth = viewSize.width;
    var viewHeight = viewSize.height;
    var windowWidth = 0;
    var panelHeight = 0;
    var winTitle = '';
    var items = new Array();
    var mainPanel = Ext.getCmp( 'main_panel' );
    var AV = mainPanel.getAdvancedView();
    var activityNode = config.activityNode;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId;

    switch ( component.type ) {
        case 'STRING':
        case 'INTEGER':
        case 'FLOAT':
        case 'AMOUNT':
        case 'DATE':
        case 'DATETIME':
        case 'TEXTAREA':
        case 'RADIOBUTTON':
        case 'CHECKBOX':
        case 'BOOLEAN':
        case 'LISTBOX':
        case 'LISTBOX_EDIT':
        case 'LISTBOX_NO_FILTER':
        case 'LISTBOX_EDIT_NO_FILTER':
        case 'LISTBOX_NO_LAZY':
        case 'LISTBOX_NO_FILTER_NO_LAZY':
        case 'USERLISTLISTBOX':
        case 'DATA_CHOOSER':
        case 'ROLEUSERS':
        case 'ROLEUSERS_NO_FILTER':
        case 'USERLIST':
            windowWidth = viewWidth * 0.5;
            panelHeight = viewHeight * 0.8;
            winTitle = getTranslation( 'Zmienna procesu' );
            if ( component.isVariable ) {
                winTitle += ' ' + component.definition.fieldLabel;
            }
            items.push( new Ext.ux.suncode.FormVariableDefPanel( {
                activityNode: activityNode,
                component: component,
                availableVariables: availableVariables,
                validateIntegrationComponentFieldFunction: validateIntegrationComponentFieldFunction,
                validateIntegrationComponentFieldScope: validateIntegrationComponentFieldScope,
                panelHeight: panelHeight,
                AV: AV
            } ) );
            break;
        case 'VARIABLE_SET':
            windowWidth = viewWidth * 0.95;
            winTitle = getTranslation( 'Tabela dynamiczna' );
            if ( !Ext.isEmpty( objectDef.name ) ) {
                winTitle += ' ' + getXpdlVariableSetTitleTranslation( packageId, processDefId, activityDefId, objectDef.varId, objectDef.name );
            }
            items.push( new Ext.ux.suncode.GridDefPanel( {
                globalDefinition: false,
                activityNode: activityNode,
                component: component,
                availableVariables: availableVariables,
                validateIntegrationComponentFieldFunction: validateIntegrationComponentFieldFunction,
                validateIntegrationComponentFieldScope: validateIntegrationComponentFieldScope,
                validateIntegrationComponentRowFunction: config.validateIntegrationComponentRowFunction,
                validateIntegrationComponentRowScope: config.validateIntegrationComponentRowScope,
                pasteIntegrationComponentsValidation: config.pasteIntegrationComponentsValidation,
                AV: AV
            } ) );
            break;
        case 'HTTP_LINK':
            windowWidth = viewWidth * 0.5;
            winTitle = getTranslation( 'Definicja przycisku formularza' );
            if ( !Ext.isEmpty( objectDef.buttonName ) ) {
                winTitle += ' ' + objectDef.buttonName;
            }
            items.push( new Ext.ux.suncode.FormHttpLinkDefPanel( {
                activityNode: activityNode,
                component: component,
                availableVariables: availableVariables,
                validateIntegrationComponentFieldFunction: validateIntegrationComponentFieldFunction,
                validateIntegrationComponentFieldScope: validateIntegrationComponentFieldScope,
                AV: AV
            } ) );
            break;
        case 'ACTION_ACCEPT_BUTTON':
            windowWidth = viewWidth * 0.5;
            panelHeight = viewHeight * 0.8;
            winTitle = getTranslation( 'Definicja przycisku akceptacji zadania' );
            if ( !Ext.isEmpty( objectDef.buttonName ) ) {
                winTitle += ' ' + objectDef.buttonName;
            }
            items.push( new Ext.ux.suncode.ActionAcceptButtonDefPanel( {
                activityNode: activityNode,
                component: component,
                availableVariables: availableVariables,
                validateIntegrationComponentFieldFunction: validateIntegrationComponentFieldFunction,
                validateIntegrationComponentFieldScope: validateIntegrationComponentFieldScope,
                panelHeight: panelHeight,
                AV: AV
            } ) );
            break;
        case 'GENERATE_PDF_BUTTON':
            windowWidth = viewWidth * 0.5;
            winTitle = getTranslation( 'Definicja przycisku generowania PDF' );
            if ( !Ext.isEmpty( objectDef.buttonName ) ) {
                winTitle += ' ' + objectDef.buttonName;
            }
            items.push( new Ext.ux.suncode.GeneratePdfButtonDefPanel( {
                activityNode: activityNode,
                component: component,
                AV: AV
            } ) );
            break;
        case 'ADD_FILE_BUTTON':
            windowWidth = viewWidth * 0.5;
            winTitle = getTranslation( 'Definicja przycisku podłączania pliku' );
            if ( !Ext.isEmpty( objectDef.buttonName ) ) {
                winTitle += ' ' + objectDef.buttonName;
            }
            items.push( new Ext.ux.suncode.AddFileButtonDefPanel( {
                activityNode: activityNode,
                component: component,
                AV: AV
            } ) );
            break;
        case 'BARCODE_PRINT':
            windowWidth = viewWidth * 0.5;
            winTitle = getTranslation( 'Definicja przycisku drukowania kodu kreskowego' );
            items.push( new Ext.ux.suncode.BarcodePrintButtonDefPanel( {
                activityNode: activityNode,
                component: component,
                AV: AV
            } ) );
            break;
        case 'LABEL':
            windowWidth = viewWidth * 0.5;
            winTitle = getTranslation( 'Definicja etykiety' );
            items.push( new Ext.ux.suncode.LabelDefPanel( {
                activityNode: activityNode,
                component: component,
                availableVariables: availableVariables,
                validateIntegrationComponentFieldFunction: validateIntegrationComponentFieldFunction,
                validateIntegrationComponentFieldScope: validateIntegrationComponentFieldScope,
                AV: AV
            } ) );
            break;
        default:
            break;
    }

    config = Ext.apply( {
        modal: true,
        shadow: false,
        hideBorders: true,
        width: windowWidth,
        autoHeight: true,
        title: winTitle,
        items: items,
        closable: true,
        AV: AV,
        tbar: new Ext.ux.suncode.FormObjectWindowToolbar( {
            activityNode: config.activityNode,
            component: component,
            afterSaveFunction: config.afterSaveFunction,
            afterSaveScope: config.afterSaveScope,
            win: this
        } )
    }, config );

    Ext.ux.suncode.FormObjectDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormObjectDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.FormObjectDefWindow.superclass.initComponent.call( this );

        var componentType = this.initialConfig.component.type;
        if ( componentType == 'ACTION_ACCEPT_BUTTON' ) {
            this.on( 'show', windowUp, this );
        }
    },
    closeDefWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.FormObjectWindowToolbar = function( config ) {
    var win = config.win;
    var component = config.component;
    var buttons = new Array();
    buttons.push( {
      cls: 'x-btn-icon',
      icon: getPluginImgPath( 'save' ),
      tooltip: getTranslation( 'Zapisz' ),
      ref: 'saveBtn'
    } );

    if ( component.type == 'VARIABLE_SET' ) {
      var activityNode = config.activityNode;
      var processNode = activityNode.parentNode;
      var objectDef = component.definition.objectDef;
      var varId = objectDef.varId;
      var table = processNode.findTable( varId );

      if ( Ext.isEmpty( table ) ) {
        buttons.push( {
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'global' ),
          tooltip: getTranslation( 'Przetransformuj w tabelę globalną' ),
          ref: 'transformToGlobalBtn'
        } );
      }
    }

    buttons.push( {
      cls: 'x-btn-icon',
      icon: getPluginImgPath( 'close' ),
      tooltip: getTranslation( 'Zamknij' ),
      ref: 'closeBtn',
      handler: win.closeDefWindow,
      scope: win
    } );

    config = Ext.apply( {
        buttons: buttons
    }, config );

    Ext.ux.suncode.FormObjectWindowToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormObjectWindowToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.FormObjectWindowToolbar.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var component = this.initialConfig.component;
        var saveHandler = null;
        var scope = null;
        var afterSaveFunction = this.initialConfig.afterSaveFunction;
        var afterSaveScope = this.initialConfig.afterSaveScope;

        switch ( component.type ) {
            case 'STRING':
            case 'INTEGER':
            case 'FLOAT':
            case 'AMOUNT':
            case 'DATE':
            case 'DATETIME':
            case 'TEXTAREA':
            case 'RADIOBUTTON':
            case 'CHECKBOX':
            case 'BOOLEAN':
            case 'LISTBOX':
            case 'LISTBOX_EDIT':
            case 'LISTBOX_NO_FILTER':
            case 'LISTBOX_EDIT_NO_FILTER':
            case 'LISTBOX_NO_LAZY':
            case 'LISTBOX_NO_FILTER_NO_LAZY':
            case 'USERLISTLISTBOX':
            case 'DATA_CHOOSER':
            case 'ROLEUSERS':
            case 'ROLEUSERS_NO_FILTER':
            case 'USERLIST':
                scope = this.ownerCt.variableDefPanel;
                saveHandler = scope.editFormVariable;
                break;
            case 'VARIABLE_SET':
                scope = this.ownerCt.gridDefPanel;
                saveHandler = scope.editGridVariable;
                var transformToGlobalHandler = scope.transformToGlobal;

                if ( !Ext.isEmpty( this.transformToGlobalBtn ) ) {
                  this.transformToGlobalBtn.setHandler( function() {
                    transformToGlobalHandler.apply( this, [] );

                    if ( Ext.isFunction( afterSaveFunction ) ) {
                      afterSaveScope = !Ext.isEmpty( afterSaveScope ) ? afterSaveScope : window;
                      afterSaveFunction.apply( afterSaveScope, [] );
                    }
                  } );
                  this.transformToGlobalBtn.scope = scope;
                }
                break;
            case 'HTTP_LINK':
                scope = this.ownerCt.httpLinkDefPanel;
                saveHandler = scope.editHttpLink;
                break;
            case 'ACTION_ACCEPT_BUTTON':
            case 'GENERATE_PDF_BUTTON':
            case 'ADD_FILE_BUTTON':
            case 'BARCODE_PRINT':
                scope = this.ownerCt.buttonDefPanel;
                saveHandler = scope.editFormButton;
                break;
            case 'LABEL':
                scope = this.ownerCt.labelPanel;
                saveHandler = scope.editLabel;
                break;
            default:
                break;
        }

        this.saveBtn.setHandler( function() {
        	saveHandler.apply( this, [] );
        	
        	if ( Ext.isFunction( afterSaveFunction ) ) {
            afterSaveScope = !Ext.isEmpty( afterSaveScope ) ? afterSaveScope : window;
            afterSaveFunction.apply( afterSaveScope, [] );
          }
        } );
        this.saveBtn.scope = scope;
    }
} );