Ext.ux.suncode.AutoUpdateWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var autoUpdate = config.autoUpdate;
    var winTitle = autoUpdate ? getTranslation( 'Definicja akcji' ) + ' ' + autoUpdate.taskName : getTranslation( 'Kreator akcji' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: [ new Ext.ux.suncode.AutoUpdatePanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                scope: this,
                handler: this.saveForm
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.AutoUpdateWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AutoUpdateWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.AutoUpdateWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.autoUpdatePanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.AutoUpdatePanel = function( config ) {
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var autoUpdate = config.autoUpdate;
    var dataSources = new Array();
    var destinations = new Array();
    var specification = new Object();

    if ( autoUpdate ) {
        dataSources = autoUpdate.dataSources;
        destinations = autoUpdate.destinations;
        var formVariableId = config.formVariableId;
        specification = Ext.ux.suncode.DocumentationService.getAutoUpdateSpecification( activityNode, formVariableId, autoUpdate.id );
        var standardAutoUpdate = Ext.getCmp( 'main_panel' ).getStandardAutoUpdateByTaskName( autoUpdate.taskName );

        if ( !Ext.isEmpty( standardAutoUpdate ) && !Ext.isEmpty( dataSources ) && !Ext.isEmpty( standardAutoUpdate.dataSources ) ) {
            Ext.each( dataSources, function( dataSrc, index, dataSrcs ) {
                var defDataSrc = standardAutoUpdate.dataSources[index];

                if ( !Ext.isEmpty( defDataSrc ) ) {
                    Ext.apply( dataSrc, {
                        description: defDataSrc.description
                    } );
                }
            } );
        }

        if ( !Ext.isEmpty( standardAutoUpdate ) && !Ext.isEmpty( destinations ) && !Ext.isEmpty( standardAutoUpdate.destinations ) ) {
            Ext.each( destinations, function( dest, index, dests ) {
                var defDest = standardAutoUpdate.destinations[index];

                if ( !Ext.isEmpty( defDest ) ) {
                    Ext.apply( dest, {
                        description: defDest.description
                    } );
                }
            } );
        }
    }

    var dataSourcesStore = new Ext.data.Store( {
        data: dataSources,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            } ] )
        } )
    } );

    var destinationsStore = new Ext.data.Store( {
        data: destinations,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            } ] )
        } )
    } );

    var editableFormVariablesChooser = new Ext.ux.suncode.FormVariableChooser( {
        forceSelection: false
    } );
    var formVariablesChooser = new Ext.ux.suncode.FormVariableChooser( {
        forceSelection: true
    } );

    config = Ext.apply( {
        ref: 'autoUpdatePanel',
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        layoutConfig: {
            trackLabels: true
        },
        items: [ new Ext.ux.suncode.AutoUpdateTypesChooser( {
            value: autoUpdate ? autoUpdate.taskNameType : '',
            listeners: {
                scope: this,
                select: function( combo, record, index ) {
                    var eventTypeItem = this.eventTypeItem;
                    var buttonNameItem = this.buttonNameItem;
                    var value = combo.getValue();

                    if ( value == 'Applet' ) {
                        eventTypeItem.setValue( 'applet' );
                        eventTypeItem.disable();
                        buttonNameItem.show();
                    } else {
                        eventTypeItem.enable();
                        buttonNameItem.hide();
                    }
                }
            }
        } ), new Ext.ux.suncode.AutoUpdateClasspath( {
            taskName: autoUpdate ? autoUpdate.taskName : '',
            saveTo: this
        } ), new Ext.ux.suncode.AutoUpdateEventTypesChooser( {
            disabled: ( autoUpdate && autoUpdate.taskNameType == 'Applet' ),
            value: autoUpdate ? autoUpdate.eventType : ''
        } ), {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa przycisku' ),
            anchor: '100%',
            ref: 'buttonNameItem',
            hidden: ( !autoUpdate || autoUpdate.taskNameType != 'Applet' ),
            value: autoUpdate ? autoUpdate.buttonName : ''
        }, {
            xtype: 'editorgrid',
            anchor: '100%',
            title: getTranslation( 'Źródła danych' ),
            store: dataSourcesStore,
            height: 180,
            enableColumnResize: false,
            columnLines: true,
            autoScroll: true,
            frame: false,
            cls: 'x-Module-small-header',
            style: 'margin-bottom: 5px;',
            ref: 'dataSourcesGrid',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: true,
                    menuDisabled: true
                },
                columns: [ new Ext.grid.RowNumberer(), {
                    id: 'varId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'varId',
                    align: 'left',
                    editor: editableFormVariablesChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( editableFormVariablesChooser )
                }, {
                    id: 'description',
                    header: getTranslation( 'Opis' ),
                    dataIndex: 'description',
                    align: 'left'
                } ]
            } ),
            viewConfig: new Ext.grid.GridView( {
                forceFit: true
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var v = store.recordType;
                        var rec = new v( {
                            varId: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.startEditing( store.getCount() - 1, 1 );
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz źródło danych do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                    }
                } ]
            } ),
            listeners: {
                afteredit: function( e ) {
                    e.grid.getStore().commitChanges();
                }
            }
        }, {
            xtype: 'editorgrid',
            anchor: '100%',
            title: getTranslation( 'Zmienne wynikowe' ),
            store: destinationsStore,
            height: 180,
            enableColumnResize: false,
            columnLines: true,
            autoScroll: true,
            frame: false,
            cls: 'x-Module-small-header',
            ref: 'destinationsGrid',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: true,
                    menuDisabled: true
                },
                columns: [ new Ext.grid.RowNumberer(), {
                    id: 'varId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'varId',
                    align: 'left',
                    editor: formVariablesChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( formVariablesChooser )
                }, {
                    id: 'description',
                    header: getTranslation( 'Opis' ),
                    dataIndex: 'description',
                    align: 'left'
                } ]
            } ),
            viewConfig: new Ext.grid.GridView( {
                forceFit: true
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var v = store.recordType;
                        var rec = new v( {
                            varId: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.startEditing( store.getCount() - 1, 1 );
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz zmienną wynikową do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                    }
                } ]
            } ),
            listeners: {
                afteredit: function( e ) {
                    e.grid.getStore().commitChanges();
                }
            }
        }, new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            description: specification.description
        } ) ]
    }, config );

    Ext.ux.suncode.AutoUpdatePanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AutoUpdatePanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.AutoUpdatePanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var autoUpdate = this.initialConfig.autoUpdate;
        var def = {
            id: '',
            taskNameType: this.taskNameTypeItem.getValue(),
            taskName: this.taskNameItem.items.first().getValue(),
            eventType: this.eventTypeItem.getValue(),
            buttonName: this.buttonNameItem.getValue(),
            dataSources: this.readDataSourcesGrid(),
            destinations: this.readDestinationsGrid()
        };

        if ( Ext.isEmpty( def.taskNameType ) ) {
            showWarn( getTranslation( 'Wybierz typ akcji.' ) );
            return;
        } else if ( Ext.isEmpty( def.taskName ) ) {
            showWarn( getTranslation( 'Podaj nazwę akcji.' ) );
            return;
        } else if ( Ext.isEmpty( def.eventType ) ) {
            showWarn( getTranslation( 'Wybierz typ zdarzenia.' ) );
            return;
        } else if ( def.eventType == 'applet' && def.taskNameType != 'Applet' ) {
            showWarn( getTranslation( 'Zmień typ zdarzenia.' ) );
            return;
        } else if ( def.eventType == 'applet' && Ext.isEmpty( def.buttonName ) ) {
            showWarn( getTranslation( 'Podaj nazwę przycisku.' ) );
            return;
        } else if ( def.dataSources == null ) {
            showWarn( getTranslation( 'Uzupełnij poprawnie źródło danych.' ) );
            return;
        } else if ( def.dataSources.length == 0 ) {
            showWarn( getTranslation( 'Dodaj przynajmniej jedno źródło danych.' ) );
            return;
        } else if ( def.destinations == null ) {
            showWarn( getTranslation( 'Uzupełnij poprawnie zmienne wynikowe.' ) );
            return;
        } else if ( def.destinations.length == 0 ) {
            showWarn( getTranslation( 'Dodaj przynajmniej jedną zmienną wynikową.' ) );
            return;
        }

        def.id = generateAutoUpdateId( def );

        if ( !autoUpdate && saveToObj.getAutoUpdate( def.id ) ) {
            showWarn( getTranslation( 'Akcja o podanej nazwie i parametrach już istnieje.' ) );
            return;
        } else if ( autoUpdate && autoUpdate.id != def.id && saveToObj.getAutoUpdate( def.id ) ) {
            showWarn( getTranslation( 'Akcja o podanej nazwie i parametrach już istnieje.' ) );
            return;
        }

        if ( saveToObj && varRecord ) {
            if ( autoUpdate ) {
                varRecord.set( 'taskNameType', def.taskNameType );
                varRecord.set( 'taskName', def.taskName );
                varRecord.set( 'eventType', def.eventType );
                varRecord.set( 'id', def.id );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    taskNameType: def.taskNameType,
                    taskName: def.taskName,
                    eventType: def.eventType,
                    id: def.id
                } ) );
                store.commitChanges();
            }
        }

        var activityNode = this.initialConfig.activityNode;
        var formVariableId = this.initialConfig.formVariableId;
        var specification = this.readSpecification();

        if ( autoUpdate ) {
            saveToObj.editAutoUpdate( autoUpdate, def );
            Ext.ux.suncode.DocumentationService.editAutoUpdateSpecification( activityNode, formVariableId, autoUpdate.id, def.id, specification );
        } else {
            saveToObj.addAutoUpdate( def );
            Ext.ux.suncode.DocumentationService.addAutoUpdateSpecification( activityNode, formVariableId, def.id, specification );
        }

        this.ownerCt.closeWindow();
    },
    readDataSourcesGrid: function() {
        var dataSources = new Array();
        var store = this.dataSourcesGrid.getStore();
        var isOk = true;

        store.each( function( rec ) {
            var varId = rec.get( 'varId' );

            if ( Ext.isEmpty( varId ) ) {
                isOk = false;
                return false;
            }

            dataSources.push( {
                varId: varId
            } );
        } );

        if ( !isOk ) {
            return null;
        }

        return dataSources;
    },
    readDestinationsGrid: function() {
        var destinations = new Array();
        var store = this.destinationsGrid.getStore();
        var isOk = true;

        store.each( function( rec ) {
            var varId = rec.get( 'varId' );

            if ( Ext.isEmpty( varId ) ) {
                isOk = false;
                return false;
            }

            destinations.push( {
                varId: varId
            } );
        } );

        if ( !isOk ) {
            return null;
        }

        return destinations;
    },
    onChooseStandardAutoUpdate: function( id ) {
        var autoUpdate = Ext.getCmp( 'main_panel' ).getStandardAutoUpdate( id );
        this.taskNameItem.items.first().setValue( autoUpdate.definition.taskName );
        this.taskNameTypeItem.setValue( autoUpdate.definition.type );
        this.fillAutoUpdateGrid( this.dataSourcesGrid, autoUpdate.dataSources );
        this.fillAutoUpdateGrid( this.destinationsGrid, autoUpdate.destinations );
        this.specificationDescriptionItem.setSpecificationDescription( autoUpdate.definition.description );
    },
    fillAutoUpdateGrid: function( item, records ) {
        if ( !Ext.isEmpty( records ) ) {
            var store = item.getStore();
            store.loadData( records );
            store.commitChanges();
        }
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.AutoUpdateClasspath = function( config ) {
    config = Ext.apply( {
        fieldLabel: getTranslation( 'Nazwa akcji' ),
        anchor: '100%',
        ref: 'taskNameItem',
        additional: true,
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            ref: '../classpathItem',
            flex: 1,
            value: config.taskName
        }, {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'config' ),
            tooltip: getTranslation( 'Pokaż systemowe akcje formularza' ),
            handler: this.showStandardAutoUpdates,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.AutoUpdateClasspath.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AutoUpdateClasspath, Ext.form.CompositeField, {
    initComponent: function() {
        Ext.ux.suncode.AutoUpdateClasspath.superclass.initComponent.call( this );
    },
    showStandardAutoUpdates: function() {
        var win = new Ext.ux.suncode.StandardAutoUpdatesWindow( {
            type: this.ownerCt.taskNameTypeItem.getValue(),
            saveTo: this.initialConfig.saveTo
        } );
        win.show();
    }
} );

Ext.ux.suncode.StandardAutoUpdatesWindow = function( config ) {
    config = Ext.apply( {
        modal: true,
        width: Ext.getBody().getViewSize().width * 0.8,
        autoHeight: true,
        resizable: false,
        title: getTranslation( 'Systemowe akcje formularza' ),
        items: new Ext.ux.suncode.StandardAutoUpdatesGrid( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Wybierz' ),
                scope: this,
                handler: this.chooseStandardAutoUpdate
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.StandardAutoUpdatesWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StandardAutoUpdatesWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.StandardAutoUpdatesWindow.superclass.initComponent.call( this );
    },
    chooseStandardAutoUpdate: function() {
        this.autoUpdateGrid.onChooseStandardAutoUpdate();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.StandardAutoUpdatesGrid = function( config ) {
    var autoUpdates = Ext.getCmp( 'main_panel' ).getStandardAutoUpdates();

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'type',
                type: 'string'
            }, {
                name: 'taskName',
                type: 'string'
            }, {
                name: 'id',
                type: 'int'
            } ] )
        } )
    } );

    if ( autoUpdates.length > 0 ) {
        Ext.each( autoUpdates, function( autoUpdate, index, allAutoUpdates ) {
            if ( Ext.isEmpty( config.type ) || config.type == autoUpdate.definition.type ) {
                store.loadData( autoUpdate.definition, true );
            }
        } );

        store.sort( 'name', 'ASC' );
        store.commitChanges();
    }

    config = Ext.apply( {
        height: Ext.getBody().getViewSize().height * 0.8,
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        ref: 'autoUpdateGrid',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                width: 50
            }, {
                id: 'taskName',
                header: getTranslation( 'Nazwa akcji' ),
                dataIndex: 'taskName',
                align: 'left'
            }, {
                id: 'id',
                header: 'id',
                dataIndex: 'id',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: ''
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
            scope: this,
            rowdblclick: function() {
                this.onChooseStandardAutoUpdate();
            }
        }
    }, config );

    Ext.ux.suncode.StandardAutoUpdatesGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StandardAutoUpdatesGrid, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.StandardAutoUpdatesGrid.superclass.initComponent.call( this );
    },
    onChooseStandardAutoUpdate: function() {
        var autoUpdate = this.getSelectionModel().getSelected();

        if ( !Ext.isEmpty( autoUpdate ) ) {
            this.ownerCt.closeWindow();
            this.initialConfig.saveTo.onChooseStandardAutoUpdate( autoUpdate.get( 'id' ) );
        } else {
            showWarn( getTranslation( 'Wskaż systemową akcję formularza.' ) );
        }
    }
} );